/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval.ibatis;

import com.ibatis.sqlmap.client.event.RowHandler;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.alfresco.ibatis.RollupRowHandler;
import org.alfresco.repo.domain.propval.AbstractPropertyValueDAOImpl;
import org.alfresco.repo.domain.propval.PropertyClassEntity;
import org.alfresco.repo.domain.propval.PropertyDateValueEntity;
import org.alfresco.repo.domain.propval.PropertyDoubleValueEntity;
import org.alfresco.repo.domain.propval.PropertyIdQueryParameter;
import org.alfresco.repo.domain.propval.PropertyIdQueryResult;
import org.alfresco.repo.domain.propval.PropertyIdSearchRow;
import org.alfresco.repo.domain.propval.PropertyLinkEntity;
import org.alfresco.repo.domain.propval.PropertyRootEntity;
import org.alfresco.repo.domain.propval.PropertySerializableValueEntity;
import org.alfresco.repo.domain.propval.PropertyStringQueryEntity;
import org.alfresco.repo.domain.propval.PropertyStringValueEntity;
import org.alfresco.repo.domain.propval.PropertyUniqueContextEntity;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.repo.domain.propval.PropertyValueEntity;
import org.alfresco.util.Pair;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyValueDAOImpl
extends AbstractPropertyValueDAOImpl {
    private static final String SELECT_PROPERTY_CLASS_BY_ID = "alfresco.propval.select_PropertyClassByID";
    private static final String SELECT_PROPERTY_CLASS_BY_NAME = "alfresco.propval.select_PropertyClassByName";
    private static final String INSERT_PROPERTY_CLASS = "alfresco.propval.insert_PropertyClass";
    private static final String SELECT_PROPERTY_DATE_VALUE_BY_ID = "alfresco.propval.select_PropertyDateValueByID";
    private static final String SELECT_PROPERTY_DATE_VALUE_BY_VALUE = "alfresco.propval.select_PropertyDateValueByValue";
    private static final String INSERT_PROPERTY_DATE_VALUE = "alfresco.propval.insert_PropertyDateValue";
    private static final String SELECT_PROPERTY_STRING_VALUE_BY_ID = "alfresco.propval.select_PropertyStringValueByID";
    private static final String SELECT_PROPERTY_STRING_VALUE_BY_VALUE = "alfresco.propval.select_PropertyStringValueByValue";
    private static final String INSERT_PROPERTY_STRING_VALUE = "alfresco.propval.insert_PropertyStringValue";
    private static final String SELECT_PROPERTY_DOUBLE_VALUE_BY_ID = "alfresco.propval.select_PropertyDoubleValueByID";
    private static final String SELECT_PROPERTY_DOUBLE_VALUE_BY_VALUE = "alfresco.propval.select_PropertyDoubleValueByValue";
    private static final String INSERT_PROPERTY_DOUBLE_VALUE = "alfresco.propval.insert_PropertyDoubleValue";
    private static final String SELECT_PROPERTY_SERIALIZABLE_VALUE_BY_ID = "alfresco.propval.select_PropertySerializableValueByID";
    private static final String INSERT_PROPERTY_SERIALIZABLE_VALUE = "alfresco.propval.insert_PropertySerializableValue";
    private static final String SELECT_PROPERTY_VALUE_BY_ID = "alfresco.propval.select_PropertyValueById";
    private static final String SELECT_PROPERTY_VALUE_BY_LOCAL_VALUE = "alfresco.propval.select_PropertyValueByLocalValue";
    private static final String SELECT_PROPERTY_VALUE_BY_DOUBLE_VALUE = "alfresco.propval.select_PropertyValueByDoubleValue";
    private static final String SELECT_PROPERTY_VALUE_BY_STRING_VALUE = "alfresco.propval.select_PropertyValueByStringValue";
    private static final String INSERT_PROPERTY_VALUE = "alfresco.propval.insert_PropertyValue";
    private static final String SELECT_PROPERTY_BY_ID = "alfresco.propval.select_PropertyById";
    private static final String SELECT_PROPERTIES_BY_IDS = "alfresco.propval.select_PropertiesByIds";
    private static final String SELECT_PROPERTY_ROOT_BY_ID = "alfresco.propval.select_PropertyRootById";
    private static final String INSERT_PROPERTY_ROOT = "alfresco.propval.insert_PropertyRoot";
    private static final String UPDATE_PROPERTY_ROOT = "alfresco.propval.update_PropertyRoot";
    private static final String DELETE_PROPERTY_ROOT_BY_ID = "alfresco.propval.delete_PropertyRootById";
    private static final String SELECT_PROPERTY_UNIQUE_CTX_BY_ID = "alfresco.propval.select_PropertyUniqueContextById";
    private static final String SELECT_PROPERTY_UNIQUE_CTX_BY_VALUES = "alfresco.propval.select_PropertyUniqueContextByValues";
    private static final String INSERT_PROPERTY_UNIQUE_CTX = "alfresco.propval.insert_PropertyUniqueContext";
    private static final String UPDATE_PROPERTY_UNIQUE_CTX = "alfresco.propval.update_PropertyUniqueContext";
    private static final String DELETE_PROPERTY_UNIQUE_CTX_BY_ID = "alfresco.propval.delete_PropertyUniqueContextById";
    private static final String DELETE_PROPERTY_UNIQUE_CTX_BY_VALUES = "alfresco.propval.delete_PropertyUniqueContextByValues";
    private static final String INSERT_PROPERTY_LINK = "alfresco.propval.insert_PropertyLink";
    private static final String DELETE_PROPERTY_LINKS_BY_ROOT_ID = "alfresco.propval.delete_PropertyLinksByRootId";
    private SqlMapClientTemplate template;
    private static final String[] KEY_COLUMNS_FINDBYIDS = new String[]{"propId"};

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.template = sqlMapClientTemplate;
    }

    @Override
    protected PropertyClassEntity findClassById(Long id) {
        PropertyClassEntity entity = new PropertyClassEntity();
        entity.setId(id);
        entity = (PropertyClassEntity)this.template.queryForObject(SELECT_PROPERTY_CLASS_BY_ID, (Object)entity);
        return entity;
    }

    @Override
    protected PropertyClassEntity findClassByValue(Class<?> value) {
        PropertyClassEntity entity = new PropertyClassEntity();
        entity.setJavaClass(value);
        entity = (PropertyClassEntity)this.template.queryForObject(SELECT_PROPERTY_CLASS_BY_NAME, (Object)entity);
        return entity;
    }

    @Override
    protected PropertyClassEntity createClass(Class<?> value) {
        PropertyClassEntity entity = new PropertyClassEntity();
        entity.setJavaClass(value);
        Long id = (Long)this.template.insert(INSERT_PROPERTY_CLASS, (Object)entity);
        entity.setId(id);
        return entity;
    }

    @Override
    protected PropertyDateValueEntity findDateValueById(Long id) {
        PropertyDateValueEntity entity = (PropertyDateValueEntity)this.template.queryForObject(SELECT_PROPERTY_DATE_VALUE_BY_ID, (Object)id);
        return entity;
    }

    @Override
    protected PropertyDateValueEntity findDateValueByValue(Date value) {
        PropertyDateValueEntity result = (PropertyDateValueEntity)this.template.queryForObject(SELECT_PROPERTY_DATE_VALUE_BY_VALUE, (Object)new Long(value.getTime()));
        return result;
    }

    @Override
    protected PropertyDateValueEntity createDateValue(Date value) {
        PropertyDateValueEntity entity = new PropertyDateValueEntity();
        entity.setValue(value);
        this.template.insert(INSERT_PROPERTY_DATE_VALUE, (Object)entity);
        return entity;
    }

    @Override
    protected String findStringValueById(Long id) {
        PropertyStringValueEntity entity = new PropertyStringValueEntity();
        entity.setId(id);
        String value = (String)this.template.queryForObject(SELECT_PROPERTY_STRING_VALUE_BY_ID, (Object)entity);
        return value;
    }

    @Override
    protected Long findStringValueByValue(String value) {
        PropertyStringValueEntity entity = new PropertyStringValueEntity();
        entity.setValue(value);
        List rows = this.template.queryForList(SELECT_PROPERTY_STRING_VALUE_BY_VALUE, (Object)entity, 0, 1);
        if (rows.size() > 0) {
            return (Long)rows.get(0);
        }
        return null;
    }

    @Override
    protected Long createStringValue(String value) {
        PropertyStringValueEntity entity = new PropertyStringValueEntity();
        entity.setValue(value);
        Long id = (Long)this.template.insert(INSERT_PROPERTY_STRING_VALUE, (Object)entity);
        return id;
    }

    @Override
    protected PropertyDoubleValueEntity findDoubleValueById(Long id) {
        PropertyDoubleValueEntity entity = new PropertyDoubleValueEntity();
        entity.setId(id);
        entity = (PropertyDoubleValueEntity)this.template.queryForObject(SELECT_PROPERTY_DOUBLE_VALUE_BY_ID, (Object)entity);
        return entity;
    }

    @Override
    protected PropertyDoubleValueEntity findDoubleValueByValue(Double value) {
        PropertyDoubleValueEntity entity = new PropertyDoubleValueEntity();
        entity.setDoubleValue(value);
        List results = this.template.queryForList(SELECT_PROPERTY_DOUBLE_VALUE_BY_VALUE, (Object)entity, 0, 1);
        if (results.size() > 0) {
            return (PropertyDoubleValueEntity)results.get(0);
        }
        return null;
    }

    @Override
    protected PropertyDoubleValueEntity createDoubleValue(Double value) {
        PropertyDoubleValueEntity entity = new PropertyDoubleValueEntity();
        entity.setDoubleValue(value);
        Long id = (Long)this.template.insert(INSERT_PROPERTY_DOUBLE_VALUE, (Object)entity);
        entity.setId(id);
        return entity;
    }

    @Override
    protected PropertySerializableValueEntity findSerializableValueById(Long id) {
        PropertySerializableValueEntity entity = new PropertySerializableValueEntity();
        entity.setId(id);
        entity = (PropertySerializableValueEntity)this.template.queryForObject(SELECT_PROPERTY_SERIALIZABLE_VALUE_BY_ID, (Object)entity);
        return entity;
    }

    @Override
    protected PropertySerializableValueEntity createSerializableValue(Serializable value) {
        PropertySerializableValueEntity entity = new PropertySerializableValueEntity();
        entity.setSerializableValue(value);
        Long id = (Long)this.template.insert(INSERT_PROPERTY_SERIALIZABLE_VALUE, (Object)entity);
        entity.setId(id);
        return entity;
    }

    @Override
    protected PropertyValueEntity findPropertyValueById(Long id) {
        PropertyValueEntity entity = new PropertyValueEntity();
        entity.setId(id);
        List results = this.template.queryForList(SELECT_PROPERTY_VALUE_BY_ID, (Object)entity);
        int size = results.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return (PropertyValueEntity)results.get(0);
        }
        this.logger.error((Object)("Found property value linked to multiple raw types: " + results));
        return (PropertyValueEntity)results.get(0);
    }

    @Override
    protected PropertyValueEntity findPropertyValueByValue(Serializable value) {
        Class clazz = value == null ? Object.class : value.getClass();
        Pair<Long, Class<?>> clazzPair = this.getPropertyClass(clazz);
        if (clazzPair == null) {
            return null;
        }
        Long actualTypeId = (Long)clazzPair.getFirst();
        PropertyValueEntity queryEntity = new PropertyValueEntity();
        queryEntity.setValue(value, this.converter);
        queryEntity.setActualTypeId(actualTypeId);
        PropertyValueEntity.PersistedType persistedType = queryEntity.getPersistedTypeEnum();
        Short persistedTypeId = queryEntity.getPersistedType();
        String query = null;
        Object queryObject = queryEntity;
        switch (persistedType) {
            case NULL: 
            case LONG: {
                query = SELECT_PROPERTY_VALUE_BY_LOCAL_VALUE;
                break;
            }
            case DOUBLE: {
                query = SELECT_PROPERTY_VALUE_BY_DOUBLE_VALUE;
                break;
            }
            case CONSTRUCTABLE: 
            case ENUM: 
            case STRING: {
                query = SELECT_PROPERTY_VALUE_BY_STRING_VALUE;
                queryObject = new PropertyStringQueryEntity(persistedTypeId, actualTypeId, queryEntity.getStringValue());
                break;
            }
            case SERIALIZABLE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled PersistedType value: " + (Object)((Object)persistedType));
            }
        }
        PropertyValueEntity result = null;
        if (query != null) {
            result = (PropertyValueEntity)this.template.queryForObject(query, queryObject);
        }
        return result;
    }

    @Override
    protected PropertyValueEntity createPropertyValue(Serializable value) {
        Class clazz = value == null ? Object.class : value.getClass();
        Pair<Long, Class<?>> clazzPair = this.getOrCreatePropertyClass(clazz);
        Long actualTypeId = (Long)clazzPair.getFirst();
        PropertyValueEntity insertEntity = new PropertyValueEntity();
        insertEntity.setValue(value, this.converter);
        insertEntity.setActualTypeId(actualTypeId);
        switch (insertEntity.getPersistedTypeEnum()) {
            case DOUBLE: {
                Double doubleValue = insertEntity.getDoubleValue();
                Pair<Long, Double> insertDoublePair = this.getOrCreatePropertyDoubleValue(doubleValue);
                insertEntity.setLongValue((Long)insertDoublePair.getFirst());
                break;
            }
            case CONSTRUCTABLE: 
            case ENUM: 
            case STRING: {
                String stringValue = insertEntity.getStringValue();
                Pair<Long, String> insertStringPair = this.getOrCreatePropertyStringValue(stringValue);
                insertEntity.setLongValue((Long)insertStringPair.getFirst());
                break;
            }
            case SERIALIZABLE: {
                Pair<Long, Serializable> insertSerializablePair = this.createPropertySerializableValue(value);
                insertEntity.setLongValue((Long)insertSerializablePair.getFirst());
                break;
            }
            case NULL: 
            case LONG: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown PersistedType enum: " + (Object)((Object)insertEntity.getPersistedTypeEnum()));
            }
        }
        Long id = (Long)this.template.insert(INSERT_PROPERTY_VALUE, (Object)insertEntity);
        insertEntity.setId(id);
        return insertEntity;
    }

    @Override
    protected List<PropertyIdSearchRow> findPropertyById(Long id) {
        PropertyValueEntity entity = new PropertyValueEntity();
        entity.setId(id);
        List results = this.template.queryForList(SELECT_PROPERTY_BY_ID, (Object)entity);
        return results;
    }

    @Override
    protected void findPropertiesByIds(List<Long> ids, final PropertyValueDAO.PropertyFinderCallback callback) {
        RowHandler valueRowHandler = new RowHandler(){

            public void handleRow(Object valueObject) {
                PropertyIdQueryResult result = (PropertyIdQueryResult)valueObject;
                Long id = result.getPropId();
                List<PropertyIdSearchRow> rows = result.getPropValues();
                Serializable value = PropertyValueDAOImpl.this.convertPropertyIdSearchRows(rows);
                callback.handleProperty(id, value);
            }
        };
        RollupRowHandler rollupRowHandler = new RollupRowHandler(KEY_COLUMNS_FINDBYIDS, "propValues", valueRowHandler);
        PropertyIdQueryParameter params = new PropertyIdQueryParameter();
        params.setRootPropIds(ids);
        this.template.queryWithRowHandler(SELECT_PROPERTIES_BY_IDS, (Object)params, (RowHandler)rollupRowHandler);
        rollupRowHandler.processLastResults();
    }

    @Override
    protected Long createPropertyRoot() {
        PropertyRootEntity rootEntity = new PropertyRootEntity();
        rootEntity.setVersion((short)0);
        return (Long)this.template.insert(INSERT_PROPERTY_ROOT, (Object)rootEntity);
    }

    @Override
    protected PropertyRootEntity getPropertyRoot(Long id) {
        PropertyRootEntity entity = new PropertyRootEntity();
        entity.setId(id);
        return (PropertyRootEntity)this.template.queryForObject(SELECT_PROPERTY_ROOT_BY_ID, (Object)entity);
    }

    @Override
    protected PropertyRootEntity updatePropertyRoot(PropertyRootEntity entity) {
        entity.incrementVersion();
        this.template.update(UPDATE_PROPERTY_ROOT, (Object)entity, 1);
        return entity;
    }

    @Override
    protected void deletePropertyRoot(Long id) {
        PropertyRootEntity entity = new PropertyRootEntity();
        entity.setId(id);
        this.template.delete(DELETE_PROPERTY_ROOT_BY_ID, (Object)entity);
    }

    @Override
    protected PropertyUniqueContextEntity createPropertyUniqueContext(Long valueId1, Long valueId2, Long valueId3, Long propertyId) {
        PropertyUniqueContextEntity entity = new PropertyUniqueContextEntity();
        entity.setValue1PropId(valueId1);
        entity.setValue2PropId(valueId2);
        entity.setValue3PropId(valueId3);
        entity.setPropertyId(propertyId);
        Long id = (Long)this.template.insert(INSERT_PROPERTY_UNIQUE_CTX, (Object)entity);
        entity.setId(id);
        return entity;
    }

    @Override
    protected PropertyUniqueContextEntity getPropertyUniqueContextById(Long id) {
        PropertyUniqueContextEntity entity = new PropertyUniqueContextEntity();
        entity.setId(id);
        entity = (PropertyUniqueContextEntity)this.template.queryForObject(SELECT_PROPERTY_UNIQUE_CTX_BY_ID, (Object)entity);
        return entity;
    }

    @Override
    protected PropertyUniqueContextEntity getPropertyUniqueContextByValues(Long valueId1, Long valueId2, Long valueId3) {
        PropertyUniqueContextEntity entity = new PropertyUniqueContextEntity();
        entity.setValue1PropId(valueId1);
        entity.setValue2PropId(valueId2);
        entity.setValue3PropId(valueId3);
        entity = (PropertyUniqueContextEntity)this.template.queryForObject(SELECT_PROPERTY_UNIQUE_CTX_BY_VALUES, (Object)entity);
        return entity;
    }

    @Override
    protected void getPropertyUniqueContextByValues(final PropertyValueDAO.PropertyUniqueContextCallback callback, Long ... valueIds) {
        PropertyUniqueContextEntity entity = new PropertyUniqueContextEntity();
        block5: for (int i = 0; i < valueIds.length; ++i) {
            switch (i) {
                case 0: {
                    entity.setValue1PropId(valueIds[i]);
                    continue block5;
                }
                case 1: {
                    entity.setValue2PropId(valueIds[i]);
                    continue block5;
                }
                case 2: {
                    entity.setValue3PropId(valueIds[i]);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Only 3 ids allowed");
                }
            }
        }
        RowHandler valueRowHandler = new RowHandler(){

            public void handleRow(Object valueObject) {
                PropertyUniqueContextEntity result = (PropertyUniqueContextEntity)valueObject;
                Long id = result.getId();
                Long propId = result.getPropertyId();
                Serializable[] keys = new Serializable[]{result.getValue1PropId(), result.getValue2PropId(), result.getValue3PropId()};
                callback.handle(id, propId, keys);
            }
        };
        this.template.queryWithRowHandler(SELECT_PROPERTY_UNIQUE_CTX_BY_VALUES, (Object)entity, valueRowHandler);
    }

    @Override
    protected PropertyUniqueContextEntity updatePropertyUniqueContext(PropertyUniqueContextEntity entity) {
        entity.incrementVersion();
        this.template.update(UPDATE_PROPERTY_UNIQUE_CTX, (Object)entity, 1);
        return entity;
    }

    @Override
    public void deletePropertyUniqueContext(Long id) {
        PropertyUniqueContextEntity entity = new PropertyUniqueContextEntity();
        entity.setId(id);
        this.template.delete(DELETE_PROPERTY_UNIQUE_CTX_BY_ID, (Object)entity);
    }

    @Override
    protected int deletePropertyUniqueContexts(Long ... valueIds) {
        PropertyUniqueContextEntity entity = new PropertyUniqueContextEntity();
        block5: for (int i = 0; i < valueIds.length; ++i) {
            switch (i) {
                case 0: {
                    entity.setValue1PropId(valueIds[i]);
                    continue block5;
                }
                case 1: {
                    entity.setValue2PropId(valueIds[i]);
                    continue block5;
                }
                case 2: {
                    entity.setValue3PropId(valueIds[i]);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Only 3 ids allowed");
                }
            }
        }
        return this.template.delete(DELETE_PROPERTY_UNIQUE_CTX_BY_VALUES, (Object)entity);
    }

    @Override
    protected void createPropertyLink(Long rootPropId, Long propIndex, Long containedIn, Long keyPropId, Long valuePropId) {
        PropertyLinkEntity insertEntity = new PropertyLinkEntity();
        insertEntity.setRootPropId(rootPropId);
        insertEntity.setPropIndex(propIndex);
        insertEntity.setContainedIn(containedIn);
        insertEntity.setKeyPropId(keyPropId);
        insertEntity.setValuePropId(valuePropId);
        this.template.insert(INSERT_PROPERTY_LINK, (Object)insertEntity);
    }

    @Override
    protected int deletePropertyLinks(Long rootPropId) {
        PropertyRootEntity entity = new PropertyRootEntity();
        entity.setId(rootPropId);
        return this.template.delete(DELETE_PROPERTY_LINKS_BY_ROOT_ID, (Object)entity);
    }
}

