/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.qname.ibatis;

import org.alfresco.repo.domain.qname.AbstractQNameDAOImpl;
import org.alfresco.repo.domain.qname.NamespaceEntity;
import org.alfresco.repo.domain.qname.QNameEntity;
import org.springframework.orm.ibatis.SqlMapClientTemplate;

public class QNameDAOImpl
extends AbstractQNameDAOImpl {
    private static final String SELECT_NS_BY_ID = "alfresco.qname.select_NamespaceById";
    private static final String SELECT_NS_BY_URI = "alfresco.qname.select_NamespaceByUri";
    private static final String INSERT_NS = "alfresco.qname.insert_Namespace";
    private static final String UPDATE_NS = "alfresco.qname.update_Namespace";
    private static final String SELECT_QNAME_BY_ID = "alfresco.qname.select_QNameById";
    private static final String SELECT_QNAME_BY_NS_AND_LOCALNAME = "alfresco.qname.select_QNameByNsAndLocalName";
    private static final String INSERT_QNAME = "alfresco.qname.insert_QName";
    private static final String UPDATE_QNAME = "alfresco.qname.update_QName";
    private SqlMapClientTemplate template;

    public void setSqlMapClientTemplate(SqlMapClientTemplate sqlMapClientTemplate) {
        this.template = sqlMapClientTemplate;
    }

    protected NamespaceEntity findNamespaceEntityById(Long id) {
        NamespaceEntity entity = new NamespaceEntity();
        entity.setId(id);
        entity = (NamespaceEntity)this.template.queryForObject(SELECT_NS_BY_ID, (Object)entity);
        return entity;
    }

    protected NamespaceEntity findNamespaceEntityByUri(String uri) {
        NamespaceEntity entity = new NamespaceEntity();
        entity.setUriSafe(uri);
        entity = (NamespaceEntity)this.template.queryForObject(SELECT_NS_BY_URI, (Object)entity);
        return entity;
    }

    protected NamespaceEntity createNamespaceEntity(String uri) {
        NamespaceEntity entity = new NamespaceEntity();
        entity.setVersion(NamespaceEntity.CONST_LONG_ZERO);
        entity.setUriSafe(uri);
        this.template.insert(INSERT_NS, (Object)entity);
        return entity;
    }

    protected int updateNamespaceEntity(NamespaceEntity entity, String uri) {
        entity.setUriSafe(uri);
        entity.incrementVersion();
        return this.template.update(UPDATE_NS, (Object)entity);
    }

    protected QNameEntity findQNameEntityById(Long id) {
        QNameEntity entity = new QNameEntity();
        entity.setId(id);
        entity = (QNameEntity)this.template.queryForObject(SELECT_QNAME_BY_ID, (Object)entity);
        return entity;
    }

    protected QNameEntity findQNameEntityByNamespaceAndLocalName(Long nsId, String localName) {
        QNameEntity entity = new QNameEntity();
        entity.setNamespaceId(nsId);
        entity.setLocalNameSafe(localName);
        entity = (QNameEntity)this.template.queryForObject(SELECT_QNAME_BY_NS_AND_LOCALNAME, (Object)entity);
        return entity;
    }

    protected QNameEntity createQNameEntity(Long nsId, String localName) {
        QNameEntity entity = new QNameEntity();
        entity.setVersion(QNameEntity.CONST_LONG_ZERO);
        entity.setNamespaceId(nsId);
        entity.setLocalNameSafe(localName);
        this.template.insert(INSERT_QNAME, (Object)entity);
        return entity;
    }

    protected int updateQNameEntity(QNameEntity entity, Long nsId, String localName) {
        entity.setNamespaceId(nsId);
        entity.setLocalNameSafe(localName);
        entity.incrementVersion();
        return this.template.update(UPDATE_QNAME, (Object)entity);
    }
}

