/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.extensions.webscripts.servlet.FormData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormData
implements Iterable<FieldData> {
    protected Map<String, FieldData> data = new LinkedHashMap<String, FieldData>(8);

    public boolean hasFieldData(String fieldName) {
        return this.data.containsKey(fieldName);
    }

    public FieldData getFieldData(String fieldName) {
        return this.data.get(fieldName);
    }

    public void addFieldData(String fieldName, Object fieldValue) {
        this.addFieldData(fieldName, fieldValue, false);
    }

    public void addFieldData(FormData.FormField field) {
        FieldData fieldData = new FieldData(field);
        this.data.put(fieldData.getName(), fieldData);
    }

    public void addFieldData(String fieldName, Object fieldValue, boolean overwrite) {
        if (this.data.containsKey(fieldName)) {
            if (overwrite) {
                this.data.put(fieldName, new FieldData(fieldName, fieldValue, false));
            } else {
                ArrayList<Object> currentValues = null;
                Object currentValue = this.data.get(fieldName).getValue();
                if (currentValue instanceof List) {
                    currentValues = (ArrayList<Object>)currentValue;
                } else {
                    currentValues = new ArrayList<Object>(4);
                    currentValues.add(currentValue);
                    this.data.put(fieldName, new FieldData(fieldName, currentValues, false));
                }
                currentValues.add(fieldValue);
            }
        } else {
            this.data.put(fieldName, new FieldData(fieldName, fieldValue, false));
        }
    }

    public void removeFieldData(String fieldName) {
        this.data.remove(fieldName);
    }

    public Set<String> getFieldNames() {
        return this.data.keySet();
    }

    public int getNumberOfFields() {
        return this.data.size();
    }

    @Override
    public Iterator<FieldData> iterator() {
        return this.data.values().iterator();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        buffer.append(" (");
        buffer.append("data=").append(this.data);
        buffer.append(")");
        return buffer.toString();
    }

    public class FieldData {
        protected String name;
        protected Object value;
        protected boolean isFile = false;
        protected InputStream is;

        public FieldData(String name, Object value, boolean isFile) {
            this.name = name;
            this.value = value;
            this.isFile = isFile;
        }

        public FieldData(FormData.FormField field) {
            this.name = field.getName();
            this.value = field.getValue();
            this.isFile = field.getIsFile();
            if (this.isFile) {
                this.is = field.getInputStream();
            }
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isFile() {
            return this.isFile;
        }

        public InputStream getInputStream() {
            return this.is;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(super.toString());
            buffer.append(" (");
            buffer.append("name=").append(this.name);
            buffer.append(", value=").append(this.value);
            buffer.append(", isFile=").append(this.isFile);
            buffer.append(")");
            return buffer.toString();
        }
    }
}

