/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.processor.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.repo.forms.FieldDefinition;
import org.alfresco.repo.forms.Form;
import org.alfresco.repo.forms.FormData;
import org.alfresco.repo.forms.FormNotFoundException;
import org.alfresco.repo.forms.Item;
import org.alfresco.repo.forms.processor.node.DefaultFieldProcessor;
import org.alfresco.repo.forms.processor.node.MockClassAttributeDefinition;
import org.alfresco.repo.forms.processor.node.MockFieldProcessorRegistry;
import org.alfresco.repo.forms.processor.workflow.WorkflowFormProcessor;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.NamespaceServiceMemoryImpl;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowFormProcessorTest
extends TestCase {
    private static final String TASK_DEF_NAME = "TaskDef";
    private static final String WF_DEF_NAME = "foo$wf:bar";
    private static final QName PRIORITY_NAME = WorkflowModel.PROP_WORKFLOW_PRIORITY;
    private static final QName DESC_NAME = WorkflowModel.PROP_DESCRIPTION;
    private static final QName STATUS_NAME = WorkflowModel.PROP_STATUS;
    private static final QName PROP_WITH_ = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"some_prop");
    private static final QName ACTORS_NAME = WorkflowModel.ASSOC_POOLED_ACTORS;
    private static final QName ASSIGNEE_NAME = WorkflowModel.ASSOC_ASSIGNEE;
    private static final QName ASSOC_WITH_ = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"some_assoc");
    private static final NodeRef FAKE_NODE = new NodeRef("http://www.alfresco.org/model/bpm/1.0/FakeNode");
    private static final NodeRef FAKE_NODE2 = new NodeRef("http://www.alfresco.org/model/bpm/1.0/FakeNode2");
    private static final NodeRef FAKE_NODE3 = new NodeRef("http://www.alfresco.org/model/bpm/1.0/FakeNode3");
    private static final NodeRef PCKG_NODE = new NodeRef("http://www.alfresco.org/model/bpm/1.0/FakePackage");
    private static final Item item = new Item("workflow", "foo$wf:bar");
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private WorkflowService workflowService;
    private WorkflowFormProcessor processor;
    private WorkflowInstance newInstance;
    private WorkflowDefinition definition;
    private Map<QName, Serializable> actualProperties = null;

    public void testGetTypedItem() throws Exception {
        try {
            this.processor.getTypedItem(null);
            WorkflowFormProcessorTest.fail((String)"Should have thrown an Exception here!");
        }
        catch (FormNotFoundException e) {
            // empty catch block
        }
        try {
            this.processor.getTypedItem(new Item("task", "bad id"));
            WorkflowFormProcessorTest.fail((String)"Should have thrown an Exception here!");
        }
        catch (FormNotFoundException e) {
            // empty catch block
        }
        WorkflowDefinition result = (WorkflowDefinition)this.processor.getTypedItem(item);
        WorkflowFormProcessorTest.assertNotNull((Object)result);
        WorkflowFormProcessorTest.assertEquals((String)WF_DEF_NAME, (String)result.getName());
        Item itemWith_ = new Item("workflow", WF_DEF_NAME.replace('$', '_'));
        result = (WorkflowDefinition)this.processor.getTypedItem(itemWith_);
        WorkflowFormProcessorTest.assertNotNull((Object)result);
        WorkflowFormProcessorTest.assertEquals((String)WF_DEF_NAME, (String)result.getName());
    }

    public void testGenerateSetsItemAndUrl() throws Exception {
        Form form = this.processor.generate(item, null, null, null);
        Item formItem = form.getItem();
        WorkflowFormProcessorTest.assertEquals((String)item.getId(), (String)formItem.getId());
        WorkflowFormProcessorTest.assertEquals((String)item.getKind(), (String)formItem.getKind());
        WorkflowFormProcessorTest.assertEquals((String)WF_DEF_NAME, (String)formItem.getType());
        WorkflowFormProcessorTest.assertEquals((String)("api/workflow-definitions/" + this.definition.getId()), (String)formItem.getUrl());
    }

    public void testGenerateSingleProperty() {
        String fieldName = PRIORITY_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        List<String> fields = Arrays.asList(fieldName);
        Form form = this.processForm(fields);
        this.checkSingleProperty(form, fieldName, (Serializable)((Object)"2"));
        String fullPropertyName = "prop:" + fieldName;
        fields = Arrays.asList(fullPropertyName);
        form = this.processForm(fields);
        this.checkSingleProperty(form, fieldName, (Serializable)((Object)"2"));
        this.checkPackageActionGroups(form.getFormData());
    }

    public void testGenerateSingleAssociation() {
        Serializable values = (Serializable)((Object)Collections.emptyList());
        String fieldName = ASSIGNEE_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        List<String> fields = Arrays.asList(fieldName);
        Form form = this.processForm(fields);
        this.checkSingleAssociation(form, fieldName, values);
        String fullAssociationName = "assoc:" + fieldName;
        fields = Arrays.asList(fullAssociationName);
        form = this.processForm(fields);
        this.checkSingleAssociation(form, fieldName, values);
        this.checkPackageActionGroups(form.getFormData());
    }

    public void testIgnoresUnknownFields() throws Exception {
        String fakeFieldName = "bpm:Fake Field";
        String priorityField = PRIORITY_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        List<String> fields = Arrays.asList(fakeFieldName, priorityField);
        Form form = this.processForm(fields);
        this.checkSingleProperty(form, priorityField, (Serializable)((Object)"2"));
        this.checkPackageActionGroups(form.getFormData());
    }

    public void testGenerateDefaultForm() throws Exception {
        Form form = this.processForm(new String[0]);
        List<String> fieldDefs = form.getFieldDefinitionNames();
        WorkflowFormProcessorTest.assertTrue((boolean)fieldDefs.contains(ASSIGNEE_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertTrue((boolean)fieldDefs.contains(PRIORITY_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertTrue((boolean)fieldDefs.contains("packageItems"));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(ACTORS_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_PACKAGE_ACTION_GROUP.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_DESCRIPTION.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_DUE_DATE.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_PRIORITY.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        WorkflowFormProcessorTest.assertFalse((boolean)fieldDefs.contains(WorkflowModel.PROP_TASK_ID.toPrefixString((NamespacePrefixResolver)this.namespaceService)));
        Serializable fieldData = (Serializable)((Object)Collections.emptyList());
        FormData formData = form.getFormData();
        WorkflowFormProcessorTest.assertEquals((Object)fieldData, (Object)formData.getFieldData("assoc_bpm_assignee").getValue());
        this.checkPackageActionGroups(formData);
        WorkflowFormProcessorTest.assertEquals((Object)"2", (Object)formData.getFieldData("prop_bpm_workflowPriority").getValue());
    }

    public void testGeneratePackageItems() throws Exception {
        String fieldName = "packageItems";
        Form form = this.processForm(fieldName);
        Serializable packageItems = (Serializable)((Object)Collections.emptyList());
        this.checkSingleAssociation(form, fieldName, packageItems);
    }

    public void testPersistPropertyChanged() throws Exception {
        String fieldName = DESC_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName);
        String value = "New Description";
        this.processPersist(dataKey, value);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)this.actualProperties.size());
        WorkflowFormProcessorTest.assertEquals((Object)value, (Object)this.actualProperties.get(DESC_NAME));
        WorkflowFormProcessorTest.assertEquals((Object)PCKG_NODE, (Object)this.actualProperties.get(WorkflowModel.ASSOC_PACKAGE));
    }

    public void testPersistPropertyWith_() throws Exception {
        String fieldName = PROP_WITH_.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName);
        String value = "New _ Value";
        this.processPersist(dataKey, value);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)this.actualProperties.size());
        WorkflowFormProcessorTest.assertEquals((Object)value, (Object)this.actualProperties.get(PROP_WITH_));
    }

    public void testPersistAssociationAdded() throws Exception {
        String fieldName = ACTORS_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName, true);
        String value = FAKE_NODE + ", " + FAKE_NODE2;
        this.processPersist(dataKey, value);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)this.actualProperties.size());
        List nodeRefs = (List)((Object)this.actualProperties.get(ACTORS_NAME));
        WorkflowFormProcessorTest.assertNotNull((Object)nodeRefs);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)nodeRefs.size());
        WorkflowFormProcessorTest.assertTrue((boolean)nodeRefs.contains(FAKE_NODE));
        WorkflowFormProcessorTest.assertTrue((boolean)nodeRefs.contains(FAKE_NODE2));
    }

    public void testIgnoreAssociationsRemoved() throws Exception {
        String fieldName = ASSIGNEE_NAME.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName, false);
        String value = FAKE_NODE.toString();
        this.processPersist(dataKey, value);
        WorkflowFormProcessorTest.assertEquals((int)1, (int)this.actualProperties.size());
        Serializable nodeRefs = this.actualProperties.get(ASSIGNEE_NAME);
        WorkflowFormProcessorTest.assertNull((Object)nodeRefs);
    }

    public void testPersistAssociationAddedWith_() throws Exception {
        String fieldName = ASSOC_WITH_.toPrefixString((NamespacePrefixResolver)this.namespaceService);
        String dataKey = this.makeDataKeyName(fieldName, true);
        String value = FAKE_NODE + ", " + FAKE_NODE2;
        this.processPersist(dataKey, value);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)this.actualProperties.size());
        List nodeRefs = (List)((Object)this.actualProperties.get(ASSOC_WITH_));
        WorkflowFormProcessorTest.assertNotNull((Object)nodeRefs);
        WorkflowFormProcessorTest.assertEquals((int)2, (int)nodeRefs.size());
        WorkflowFormProcessorTest.assertTrue((boolean)nodeRefs.contains(FAKE_NODE));
        WorkflowFormProcessorTest.assertTrue((boolean)nodeRefs.contains(FAKE_NODE2));
    }

    public void testPersistPackageItemsAdded() throws Exception {
        this.mockPackageItems(FAKE_NODE3);
        String dataKey = this.makeDataKeyName("packageItems", true);
        String value = FAKE_NODE + ", " + FAKE_NODE2;
        this.processPersist(dataKey, value);
        this.checkAddPackageItem(FAKE_NODE, true);
        this.checkAddPackageItem(FAKE_NODE2, true);
        this.checkAddPackageItem(FAKE_NODE3, false);
    }

    public void testPersistPackageItemsRemovedIgnored() throws Exception {
        this.mockPackageItems(FAKE_NODE, FAKE_NODE2);
        String dataKey = this.makeDataKeyName("packageItems", false);
        String value = FAKE_NODE + ", " + FAKE_NODE2 + "," + FAKE_NODE3;
        this.processPersist(dataKey, value);
        this.checkRemovedPackageItem(FAKE_NODE, false);
        this.checkRemovedPackageItem(FAKE_NODE2, false);
        this.checkRemovedPackageItem(FAKE_NODE3, false);
    }

    private void mockPackageItems(NodeRef ... children) {
        ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(children.length);
        for (NodeRef nodeRef : children) {
            ChildAssociationRef child = new ChildAssociationRef(WorkflowModel.ASSOC_PACKAGE_CONTAINS, PCKG_NODE, null, nodeRef);
            results.add(child);
        }
        Mockito.when((Object)this.nodeService.getChildAssocs((NodeRef)Matchers.eq((Object)PCKG_NODE), (QNamePattern)Matchers.any(), (QNamePattern)Matchers.any())).thenReturn(results);
    }

    private void checkRemovedPackageItem(NodeRef child, boolean wasCalled) {
        int times = wasCalled ? 1 : 0;
        ((NodeService)Mockito.verify((Object)this.nodeService, (VerificationMode)Mockito.times((int)times))).removeChild(PCKG_NODE, child);
    }

    private void checkAddPackageItem(NodeRef child, boolean wasCalled) {
        int times = wasCalled ? 1 : 0;
        ((NodeService)Mockito.verify((Object)this.nodeService, (VerificationMode)Mockito.times((int)times))).addChild((NodeRef)Matchers.eq((Object)PCKG_NODE), (NodeRef)Matchers.eq((Object)child), (QName)Matchers.eq((Object)WorkflowModel.ASSOC_PACKAGE_CONTAINS), (QName)Matchers.any());
    }

    private void processPersist(String dataKey, String value) {
        FormData data = new FormData();
        data.addFieldData(dataKey, value);
        WorkflowInstance persistedItem = (WorkflowInstance)this.processor.persist(item, data);
        WorkflowFormProcessorTest.assertEquals((Object)this.newInstance, (Object)persistedItem);
    }

    private Form processForm(String ... fields) {
        return this.processForm(Arrays.asList(fields));
    }

    private Form processForm(List<String> fields) {
        return this.processor.generate(item, fields, null, null);
    }

    private void checkPackageActionGroups(FormData formData) {
        FormData.FieldData pckgActionData = formData.getFieldData("prop_bpm_packageActionGroup");
        WorkflowFormProcessorTest.assertNotNull((Object)pckgActionData);
        WorkflowFormProcessorTest.assertEquals((Object)"add_package_item_actions", (Object)pckgActionData.getValue());
        FormData.FieldData pckgItemActionData = formData.getFieldData("prop_bpm_packageItemActionGroup");
        WorkflowFormProcessorTest.assertNotNull((Object)pckgItemActionData);
        WorkflowFormProcessorTest.assertEquals((Object)"start_package_item_actions", (Object)pckgItemActionData.getValue());
    }

    private void checkSingleProperty(Form form, String fieldName, Serializable fieldData) {
        String expDataKey = this.makeDataKeyName(fieldName);
        this.checkSingleField(form, fieldName, fieldData, expDataKey);
    }

    private void checkSingleAssociation(Form form, String fieldName, Serializable fieldData) {
        String expDataKey = this.makeAssociationDataKey(fieldName);
        this.checkSingleField(form, fieldName, fieldData, expDataKey);
    }

    private void checkSingleField(Form form, String fieldName, Serializable fieldData, String expDataKey) {
        List<FieldDefinition> fieldDefs = form.getFieldDefinitions();
        WorkflowFormProcessorTest.assertEquals((int)1, (int)fieldDefs.size());
        FieldDefinition fieldDef = fieldDefs.get(0);
        WorkflowFormProcessorTest.assertEquals((String)fieldName, (String)fieldDef.getName());
        String dataKey = fieldDef.getDataKeyName();
        WorkflowFormProcessorTest.assertEquals((String)expDataKey, (String)dataKey);
        FormData.FieldData data = form.getFormData().getFieldData(dataKey);
        WorkflowFormProcessorTest.assertEquals((Object)fieldData, (Object)data.getValue());
    }

    private String makeDataKeyName(String fieldName) {
        return "prop_" + fieldName.replace(":", "_");
    }

    private String makeDataKeyName(String fieldName, boolean added) {
        String assocDataKey = this.makeAssociationDataKey(fieldName);
        String suffix = added ? "_added" : "_removed";
        return assocDataKey + suffix;
    }

    private String makeAssociationDataKey(String fieldName) {
        return "assoc_" + fieldName.replace(":", "_");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.definition = this.makeWorkflowDefinition();
        this.workflowService = this.makeWorkflowService();
        this.nodeService = this.makeNodeService();
        DictionaryService dictionaryService = this.makeDictionaryService();
        this.namespaceService = this.makeNamespaceService();
        MockFieldProcessorRegistry fieldProcessorRegistry = new MockFieldProcessorRegistry(this.namespaceService, dictionaryService);
        DefaultFieldProcessor defaultProcessor = this.makeDefaultFieldProcessor(dictionaryService);
        this.processor = this.makeTaskFormProcessor(dictionaryService, fieldProcessorRegistry, defaultProcessor);
    }

    private WorkflowFormProcessor makeTaskFormProcessor(DictionaryService dictionaryService, MockFieldProcessorRegistry fieldProcessorRegistry, DefaultFieldProcessor defaultProcessor) {
        WorkflowFormProcessor processor1 = new WorkflowFormProcessor();
        processor1.setWorkflowService(this.workflowService);
        processor1.setNodeService(this.nodeService);
        processor1.setNamespaceService(this.namespaceService);
        processor1.setDictionaryService(dictionaryService);
        processor1.setFieldProcessorRegistry(fieldProcessorRegistry);
        return processor1;
    }

    private DefaultFieldProcessor makeDefaultFieldProcessor(DictionaryService dictionaryService) throws Exception {
        DefaultFieldProcessor defaultProcessor = new DefaultFieldProcessor();
        defaultProcessor.setDictionaryService(dictionaryService);
        defaultProcessor.setNamespaceService(this.namespaceService);
        defaultProcessor.afterPropertiesSet();
        return defaultProcessor;
    }

    private WorkflowDefinition makeWorkflowDefinition() {
        String id = "foo$workflowDefId";
        String name = WF_DEF_NAME;
        String version = "1.0";
        String title = "Foo Bar Title";
        String description = "Foo Bar Description";
        WorkflowTaskDefinition startTaskDefinition = this.makeTaskDefinition();
        return new WorkflowDefinition(id, name, version, title, description, startTaskDefinition);
    }

    private WorkflowTaskDefinition makeTaskDefinition() {
        WorkflowTaskDefinition taskDef = new WorkflowTaskDefinition();
        taskDef.id = "foo$startTaskDefId";
        taskDef.metadata = this.makeTypeDef();
        taskDef.node = new WorkflowNode();
        return taskDef;
    }

    private TypeDefinition makeTypeDef() {
        TypeDefinition typeDef = (TypeDefinition)Mockito.mock(TypeDefinition.class);
        QName name = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)TASK_DEF_NAME);
        Mockito.when((Object)typeDef.getName()).thenReturn((Object)name);
        Map<QName, PropertyDefinition> propertyDefs = this.makeTaskPropertyDefs();
        Mockito.when((Object)typeDef.getProperties()).thenReturn(propertyDefs);
        Map<QName, AssociationDefinition> associationDefs = this.makeTaskAssociationDefs();
        Mockito.when((Object)typeDef.getAssociations()).thenReturn(associationDefs);
        return typeDef;
    }

    private Map<QName, PropertyDefinition> makeTaskPropertyDefs() {
        HashMap<QName, PropertyDefinition> properties = new HashMap<QName, PropertyDefinition>();
        QName intType = DataTypeDefinition.INT;
        MockClassAttributeDefinition priorityDef = MockClassAttributeDefinition.mockPropertyDefinition(PRIORITY_NAME, intType, "2");
        properties.put(PRIORITY_NAME, priorityDef);
        QName textType = DataTypeDefinition.TEXT;
        MockClassAttributeDefinition descValue = MockClassAttributeDefinition.mockPropertyDefinition(DESC_NAME, textType);
        properties.put(DESC_NAME, descValue);
        MockClassAttributeDefinition titleValue = MockClassAttributeDefinition.mockPropertyDefinition(STATUS_NAME, textType);
        properties.put(STATUS_NAME, titleValue);
        MockClassAttributeDefinition with_ = MockClassAttributeDefinition.mockPropertyDefinition(PROP_WITH_, textType);
        properties.put(PROP_WITH_, with_);
        QName pckgActionGroup = WorkflowModel.PROP_PACKAGE_ACTION_GROUP;
        MockClassAttributeDefinition pckgAction = MockClassAttributeDefinition.mockPropertyDefinition(pckgActionGroup, textType, "add_package_item_actions");
        properties.put(pckgActionGroup, pckgAction);
        QName pckgItemActionGroup = WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP;
        MockClassAttributeDefinition pckgItemAction = MockClassAttributeDefinition.mockPropertyDefinition(pckgItemActionGroup, textType, "start_package_item_actions");
        properties.put(pckgItemActionGroup, pckgItemAction);
        return properties;
    }

    private Map<QName, AssociationDefinition> makeTaskAssociationDefs() {
        HashMap<QName, AssociationDefinition> associations = new HashMap<QName, AssociationDefinition>();
        QName actorName = QName.createQName((String)"http://www.alfresco.org/model/bpm/1.0", (String)"Actor");
        MockClassAttributeDefinition assigneeDef = MockClassAttributeDefinition.mockAssociationDefinition(ASSIGNEE_NAME, actorName);
        associations.put(ASSIGNEE_NAME, assigneeDef);
        MockClassAttributeDefinition actorsDef = MockClassAttributeDefinition.mockAssociationDefinition(ACTORS_NAME, actorName);
        associations.put(ACTORS_NAME, actorsDef);
        MockClassAttributeDefinition with_ = MockClassAttributeDefinition.mockAssociationDefinition(ASSOC_WITH_, actorName);
        associations.put(ASSOC_WITH_, with_);
        return associations;
    }

    private NamespaceService makeNamespaceService() {
        NamespaceServiceMemoryImpl nsService = new NamespaceServiceMemoryImpl();
        nsService.registerNamespace("bpm", "http://www.alfresco.org/model/bpm/1.0");
        nsService.registerNamespace("wf", "http://www.alfresco.org/model/workflow/1.0");
        return nsService;
    }

    private DictionaryService makeDictionaryService() {
        DictionaryService mock = (DictionaryService)Mockito.mock(DictionaryService.class);
        TypeDefinition taskTypeDef = this.definition.getStartTaskDefinition().getMetadata();
        Mockito.when((Object)mock.getAnonymousType((QName)Matchers.any(), (Collection)Matchers.any())).thenReturn((Object)taskTypeDef);
        return mock;
    }

    private WorkflowService makeWorkflowService() {
        WorkflowService service = (WorkflowService)Mockito.mock(WorkflowService.class);
        Mockito.when((Object)service.getDefinitionByName(WF_DEF_NAME)).thenReturn((Object)this.definition);
        this.newInstance = new WorkflowInstance();
        this.newInstance.id = "foo$instanceId";
        WorkflowTask startTask = new WorkflowTask();
        startTask.id = "foo$taskId";
        final WorkflowPath path = new WorkflowPath();
        path.id = "foo$pathId";
        path.instance = this.newInstance;
        Mockito.when((Object)service.startWorkflow((String)Matchers.eq((Object)this.definition.getId()), Matchers.anyMap())).thenAnswer((Answer)new Answer<WorkflowPath>(){

            public WorkflowPath answer(InvocationOnMock invocation) throws Throwable {
                Object[] arguments = invocation.getArguments();
                WorkflowFormProcessorTest.this.actualProperties = (Map)arguments[1];
                return path;
            }
        });
        Mockito.when(service.getTasksForWorkflowPath(path.getId())).thenReturn(Collections.singletonList(startTask));
        Mockito.when((Object)service.createPackage(null)).thenReturn((Object)PCKG_NODE);
        return service;
    }

    private NodeService makeNodeService() {
        NodeService service = (NodeService)Mockito.mock(NodeService.class);
        Mockito.when((Object)service.hasAspect(PCKG_NODE, WorkflowModel.ASPECT_WORKFLOW_PACKAGE)).thenReturn((Object)true);
        return service;
    }
}

