/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.importer.ImportTimerProgress;
import org.alfresco.repo.security.authentication.AuthenticationContext;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.cmr.view.ImporterProgress;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.util.FileCopyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImporterBootstrap
extends AbstractLifecycleBean {
    public static final String VIEW_PATH_PROPERTY = "path";
    public static final String VIEW_CHILDASSOCTYPE_PROPERTY = "childAssocType";
    public static final String VIEW_MESSAGES_PROPERTY = "messages";
    public static final String VIEW_LOCATION_VIEW = "location";
    public static final String VIEW_ENCODING = "encoding";
    public static final String VIEW_UUID_BINDING = "uuidBinding";
    private static final Log logger = LogFactory.getLog(ImporterBootstrap.class);
    private boolean allowWrite = true;
    private boolean useExistingStore = false;
    private ImporterBinding.UUID_BINDING uuidBinding = null;
    private TransactionService transactionService;
    private RetryingTransactionHelper retryingTransactionHelper;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private ImporterService importerService;
    private List<Properties> bootstrapViews;
    private List<Properties> extensionBootstrapViews;
    private StoreRef storeRef = null;
    private List<String> mustNotExistStoreUrls = null;
    private Properties configuration = null;
    private String strLocale = null;
    private Locale locale = null;
    private AuthenticationContext authenticationContext;
    private boolean bootstrapPerformed = false;

    public void setAllowWrite(boolean write) {
        this.allowWrite = write;
    }

    public void setUseExistingStore(boolean useExistingStore) {
        this.useExistingStore = useExistingStore;
    }

    public void setUuidBinding(ImporterBinding.UUID_BINDING uuidBinding) {
        this.uuidBinding = uuidBinding;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setImporterService(ImporterService importerService) {
        this.importerService = importerService;
    }

    public void setAuthenticationContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void setBootstrapViews(List<Properties> bootstrapViews) {
        this.bootstrapViews = bootstrapViews;
    }

    public void addBootstrapViews(List<Properties> bootstrapViews) {
        if (this.extensionBootstrapViews == null) {
            this.extensionBootstrapViews = new ArrayList<Properties>();
        }
        this.extensionBootstrapViews.addAll(bootstrapViews);
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    public void setMustNotExistStoreUrls(List<String> storeUrls) {
        this.mustNotExistStoreUrls = storeUrls;
    }

    public StoreRef getStoreRef() {
        return this.storeRef;
    }

    public void setConfiguration(Properties configuration) {
        this.configuration = configuration;
    }

    public Properties getConfiguration() {
        return this.configuration;
    }

    public void setLocale(String locale) {
        this.locale = I18NUtil.parseLocale((String)locale);
        this.strLocale = locale;
    }

    public String getLocale() {
        return this.strLocale;
    }

    public void setLog(boolean logEnabled) {
    }

    public boolean hasPerformedBootstrap() {
        return this.bootstrapPerformed;
    }

    public void bootstrap() {
        PropertyCheck.mandatory((Object)((Object)this), (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"retryingTransactionHelper", (Object)this.retryingTransactionHelper);
        PropertyCheck.mandatory((Object)((Object)this), (String)"namespaceService", (Object)this.namespaceService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"importerService", (Object)this.importerService);
        if (this.storeRef == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No Store URL - bootstrap import ignored");
            }
            return;
        }
        try {
            AuthenticationUtil.RunAsWork<Object> importRunAs = new AuthenticationUtil.RunAsWork<Object>(){

                public Object doWork() throws Exception {
                    RetryingTransactionHelper.RetryingTransactionCallback<Object> doImportCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() throws Throwable {
                            ImporterBootstrap.this.doImport();
                            return null;
                        }
                    };
                    return ImporterBootstrap.this.retryingTransactionHelper.doInTransaction(doImportCallback, ImporterBootstrap.this.transactionService.isReadOnly(), false);
                }
            };
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)importRunAs, (String)this.authenticationContext.getSystemUserName());
        }
        catch (Throwable e) {
            throw new AlfrescoRuntimeException("Bootstrap failed", e);
        }
    }

    private void doImport() throws Throwable {
        if (!this.performBootstrap()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Store exists - bootstrap ignored: " + this.storeRef));
            }
        } else if (!this.allowWrite) {
            logger.warn((Object)("Store does not exist, but mode is read-only: " + this.storeRef));
        } else {
            if (!this.nodeService.exists(this.storeRef)) {
                this.storeRef = this.nodeService.createStore(this.storeRef.getProtocol(), this.storeRef.getIdentifier());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created store: " + this.storeRef));
                }
            }
            if (this.bootstrapViews != null) {
                if (this.extensionBootstrapViews != null) {
                    this.bootstrapViews.addAll(this.extensionBootstrapViews);
                }
                for (Properties bootstrapView : this.bootstrapViews) {
                    String viewUuidBinding;
                    String childAssocType;
                    String view = bootstrapView.getProperty(VIEW_LOCATION_VIEW);
                    if (view == null || view.length() == 0) {
                        throw new ImporterException("View file location must be provided");
                    }
                    String encoding = bootstrapView.getProperty(VIEW_ENCODING);
                    Reader viewReader = null;
                    ACPImportPackageHandler acpHandler = null;
                    if (view.endsWith(".acp")) {
                        File viewFile = this.getFile(view);
                        acpHandler = new ACPImportPackageHandler(viewFile, encoding);
                    } else {
                        viewReader = this.getReader(view, encoding);
                    }
                    Location importLocation = new Location(this.storeRef);
                    String path = bootstrapView.getProperty(VIEW_PATH_PROPERTY);
                    if (path != null && path.length() > 0) {
                        importLocation.setPath(path);
                    }
                    if ((childAssocType = bootstrapView.getProperty(VIEW_CHILDASSOCTYPE_PROPERTY)) != null && childAssocType.length() > 0) {
                        importLocation.setChildAssocType(QName.createQName((String)childAssocType, (NamespacePrefixResolver)this.namespaceService));
                    }
                    BootstrapBinding binding = new BootstrapBinding();
                    binding.setConfiguration(this.configuration);
                    binding.setLocation(importLocation);
                    String messages = bootstrapView.getProperty(VIEW_MESSAGES_PROPERTY);
                    if (messages != null && messages.length() > 0) {
                        Locale bindingLocale = this.locale == null ? I18NUtil.getLocale() : this.locale;
                        ResourceBundle bundle = ResourceBundle.getBundle(messages, bindingLocale);
                        binding.setResourceBundle(bundle);
                    }
                    if ((viewUuidBinding = bootstrapView.getProperty(VIEW_UUID_BINDING)) != null && viewUuidBinding.length() > 0) {
                        try {
                            binding.setUUIDBinding(ImporterBinding.UUID_BINDING.valueOf(ImporterBinding.UUID_BINDING.class, viewUuidBinding));
                        }
                        catch (IllegalArgumentException e) {
                            throw new ImporterException("The value " + viewUuidBinding + " is an invalid uuidBinding");
                        }
                    }
                    if (this.uuidBinding != null) {
                        binding.setUUIDBinding(this.uuidBinding);
                    }
                    ImportTimerProgress importProgress = null;
                    if (logger.isDebugEnabled()) {
                        importProgress = new ImportTimerProgress(logger);
                        logger.debug((Object)("Importing " + view));
                    }
                    if (viewReader != null) {
                        this.importerService.importView(viewReader, importLocation, (ImporterBinding)binding, (ImporterProgress)importProgress);
                        continue;
                    }
                    this.importerService.importView(acpHandler, importLocation, (ImporterBinding)binding, (ImporterProgress)importProgress);
                }
            }
            this.bootstrapPerformed = !this.useExistingStore;
        }
    }

    private Reader getReader(String view, String encoding) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(((Object)((Object)this)).getClass().getClassLoader());
        Resource viewResource = resourceLoader.getResource(view);
        if (viewResource == null) {
            throw new ImporterException("Could not find view file " + view);
        }
        try {
            InputStream viewStream = viewResource.getInputStream();
            InputStreamReader inputReader = encoding == null ? new InputStreamReader(viewStream) : new InputStreamReader(viewStream, encoding);
            BufferedReader reader = new BufferedReader(inputReader);
            return reader;
        }
        catch (UnsupportedEncodingException e) {
            throw new ImporterException("Could not create reader for view " + view + " as encoding " + encoding + " is not supported");
        }
        catch (IOException e) {
            throw new ImporterException("Could not open resource for view " + view);
        }
    }

    private File getFile(String view) {
        File file = new File(view);
        if (file != null && file.exists()) {
            return file;
        }
        InputStream viewStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(view);
        if (viewStream == null) {
            throw new ImporterException("Could not find view file " + view);
        }
        File tempFile = TempFileProvider.createTempFile((String)"acpImport", (String)".tmp");
        try {
            FileOutputStream os = new FileOutputStream(tempFile);
            FileCopyUtils.copy((InputStream)viewStream, (OutputStream)os);
        }
        catch (FileNotFoundException e) {
            throw new ImporterException("Could not import view " + view, e);
        }
        catch (IOException e) {
            throw new ImporterException("Could not import view " + view, e);
        }
        return tempFile;
    }

    private boolean performBootstrap() {
        if (this.useExistingStore) {
            return true;
        }
        if (this.nodeService.exists(this.storeRef)) {
            return false;
        }
        if (this.mustNotExistStoreUrls != null) {
            for (String storeUrl : this.mustNotExistStoreUrls) {
                StoreRef storeRef = new StoreRef(storeUrl);
                if (!this.nodeService.exists(storeRef)) continue;
                return false;
            }
        }
        return true;
    }

    protected void onBootstrap(ApplicationEvent event) {
        this.bootstrap();
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    private static class BootstrapBinding
    implements ImporterBinding {
        private Properties configuration = null;
        private ResourceBundle resourceBundle = null;
        private Location bootstrapLocation = null;
        private ImporterBinding.UUID_BINDING uuidBinding = ImporterBinding.UUID_BINDING.CREATE_NEW_WITH_UUID;
        private static final String IMPORT_LOCATION_UUID = "bootstrap.location.uuid";
        private static final String IMPORT_LOCATION_NODEREF = "bootstrap.location.noderef";
        private static final String IMPORT_LOCATION_PATH = "bootstrap.location.path";

        private BootstrapBinding() {
        }

        public void setConfiguration(Properties configuration) {
            this.configuration = configuration;
        }

        public Properties getConfiguration() {
            return this.configuration;
        }

        public void setResourceBundle(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        public void setLocation(Location location) {
            this.bootstrapLocation = location;
        }

        public String getValue(String key) {
            String value = null;
            if (this.configuration != null) {
                value = this.configuration.getProperty(key);
            }
            if (value == null && this.resourceBundle != null) {
                value = this.resourceBundle.getString(key);
            }
            if (value == null && this.bootstrapLocation != null) {
                if (key.equals(IMPORT_LOCATION_UUID)) {
                    value = this.bootstrapLocation.getNodeRef().getId();
                } else if (key.equals(IMPORT_LOCATION_NODEREF)) {
                    value = this.bootstrapLocation.getNodeRef().toString();
                } else if (key.equals(IMPORT_LOCATION_PATH)) {
                    value = this.bootstrapLocation.getPath();
                }
            }
            return value;
        }

        public ImporterBinding.UUID_BINDING getUUIDBinding() {
            return this.uuidBinding;
        }

        private void setUUIDBinding(ImporterBinding.UUID_BINDING uuidBinding) {
            this.uuidBinding = uuidBinding;
        }

        public boolean allowReferenceWithinTransaction() {
            return true;
        }

        public QName[] getExcludedClasses() {
            return new QName[0];
        }
    }
}

