/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.support.DefaultPointcutAdvisor;

public class SubsystemProxyFactory
extends ProxyFactoryBean {
    private static final long serialVersionUID = -4186421942840611218L;
    private ApplicationContextFactory sourceApplicationContextFactory;
    private String sourceBeanName;

    public SubsystemProxyFactory() {
        this.addAdvisor((Advisor)new DefaultPointcutAdvisor((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation mi) throws Throwable {
                Method method = mi.getMethod();
                try {
                    if (SubsystemProxyFactory.this.sourceBeanName == null) {
                        Map beans = SubsystemProxyFactory.this.sourceApplicationContextFactory.getApplicationContext().getBeansOfType(method.getDeclaringClass());
                        if (beans.size() != 1) {
                            throw new RuntimeException("Don't know where to route call to method " + method);
                        }
                        return method.invoke(beans.values().iterator().next(), mi.getArguments());
                    }
                    Object bean = SubsystemProxyFactory.this.sourceApplicationContextFactory.getApplicationContext().getBean(SubsystemProxyFactory.this.sourceBeanName);
                    return method.invoke(bean, mi.getArguments());
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        }));
    }

    public void setInterfaces(Class[] interfaces) {
        super.setInterfaces(interfaces);
        this.setTargetClass(this.getObjectType());
    }

    public void setSourceApplicationContextFactory(ApplicationContextFactory sourceApplicationContextFactory) {
        this.sourceApplicationContextFactory = sourceApplicationContextFactory;
    }

    public void setSourceBeanName(String sourceBeanName) {
        this.sourceBeanName = sourceBeanName;
    }
}

