/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder.loader;

import java.util.List;
import org.alfresco.repo.model.filefolder.loader.AbstractLoaderThread;
import org.alfresco.repo.model.filefolder.loader.LoaderServerProxy;
import org.alfresco.repo.model.filefolder.loader.LoaderSession;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;

public class LoaderListFoldersThread
extends AbstractLoaderThread {
    public LoaderListFoldersThread(LoaderSession session, String loaderName, long testPeriod, long testTotal, long testLoadDepth, boolean verbose) {
        super(session, loaderName, testPeriod, testTotal, testLoadDepth, verbose);
    }

    protected String doLoading(LoaderServerProxy serverProxy, NodeRef workingRootNodeRef) throws Exception {
        int count = this.listFoldersRecursive(serverProxy, workingRootNodeRef, 0);
        String msg = String.format("Found %d folders below node %s", count, workingRootNodeRef.toString());
        return msg;
    }

    private int listFoldersRecursive(LoaderServerProxy serverProxy, NodeRef parentNodeRef, int count) {
        List<FileInfo> fileInfos = serverProxy.fileFolderRemote.listFolders(serverProxy.ticket, parentNodeRef);
        for (FileInfo info : fileInfos) {
            if (!info.isFolder()) continue;
            count += this.listFoldersRecursive(serverProxy, info.getNodeRef(), count);
        }
        return count;
    }
}

