/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml.tools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.ml.tools.AbstractMultilingualTestCases;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionType;

public class EditionServiceImplTest
extends AbstractMultilingualTestCases {
    private static String FRENCH_CONTENT = "FRENCH_CONTENT";
    private static String CHINESE_CONTENT = "CHINESE_CONTENT";
    private static String JAPANESE_CONTENT = "JAPANESE_CONTENT";

    public void testAutoEdition() throws Exception {
        this.checkFirstVersion(this.createMLContainerWithContent());
    }

    public void testEditionLabels() {
        NodeRef mlContainerNodeRef = this.createMLContainerWithContent();
        HashMap<String, Serializable> versionProperties = null;
        ArrayList<Version> editions = null;
        NodeRef pivot = this.multilingualContentService.getPivotTranslation(mlContainerNodeRef);
        this.checkFirstVersion(mlContainerNodeRef);
        Version rootEdition = this.editionService.getEditions(mlContainerNodeRef).getAllVersions().iterator().next();
        EditionServiceImplTest.assertTrue((String)("The edition label would be 1.0 and not " + rootEdition.getVersionLabel()), (boolean)rootEdition.getVersionLabel().equals("1.0"));
        pivot = this.editionService.createEdition(pivot, versionProperties);
        editions = new ArrayList<Version>(this.editionService.getEditions(mlContainerNodeRef).getAllVersions());
        Version firstEdition = (Version)editions.get(0);
        EditionServiceImplTest.assertTrue((String)("The edition label would be 1.1 and not " + firstEdition.getVersionLabel()), (boolean)firstEdition.getVersionLabel().equals("1.1"));
        versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("versionType", (Serializable)((Object)VersionType.MAJOR));
        pivot = this.editionService.createEdition(pivot, versionProperties);
        editions = new ArrayList<Version>(this.editionService.getEditions(mlContainerNodeRef).getAllVersions());
        Version secondEdition = (Version)editions.get(0);
        EditionServiceImplTest.assertTrue((String)("The edition label would be 2.0 and not " + secondEdition.getVersionLabel()), (boolean)secondEdition.getVersionLabel().equals("2.0"));
        versionProperties = new HashMap();
        versionProperties.put("versionType", (Serializable)((Object)VersionType.MINOR));
        pivot = this.editionService.createEdition(pivot, versionProperties);
        editions = new ArrayList<Version>(this.editionService.getEditions(mlContainerNodeRef).getAllVersions());
        Version thirdEdition = (Version)editions.get(0);
        EditionServiceImplTest.assertTrue((String)("The edition label would be 2.1 and not " + thirdEdition.getVersionLabel()), (boolean)thirdEdition.getVersionLabel().equals("2.1"));
    }

    public void testCreateEdition() throws Exception {
        NodeRef mlContainerNodeRef = this.createMLContainerWithContent();
        NodeRef frenchContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.FRENCH);
        this.checkFirstVersion(mlContainerNodeRef);
        NodeRef newStartingPoint = this.editionService.createEdition(frenchContentNodeRef, null);
        VersionHistory editionHistory = this.editionService.getEditions(mlContainerNodeRef);
        EditionServiceImplTest.assertTrue((String)"The edition history must contain two versions", (editionHistory.getAllVersions().size() == 2 ? 1 : 0) != 0);
        EditionServiceImplTest.assertTrue((String)"The locale of the conatiner should be changed", (boolean)this.nodeService.getProperty(mlContainerNodeRef, ContentModel.PROP_LOCALE).equals(Locale.FRENCH));
        Version rootEdition = editionHistory.getVersion("1.0");
        Version actualEdition = editionHistory.getVersion("1.1");
        List<VersionHistory> rootVersionTranslations = this.editionService.getVersionedTranslations(rootEdition);
        EditionServiceImplTest.assertNotNull((String)"The root edition can't be null", (Object)rootEdition);
        EditionServiceImplTest.assertNotNull((String)"The actual edition can't be null", (Object)actualEdition);
        EditionServiceImplTest.assertNotNull((String)"The translations list of the root edition can't be null", rootVersionTranslations);
        EditionServiceImplTest.assertFalse((String)"The created starting document must be different that the starting document of the edition", (boolean)frenchContentNodeRef.equals((Object)newStartingPoint));
        EditionServiceImplTest.assertTrue((String)"The new pivot must be equal to the created starting document", (boolean)newStartingPoint.equals((Object)this.multilingualContentService.getPivotTranslation(mlContainerNodeRef)));
        int numberOfTranslations = this.multilingualContentService.getTranslations(mlContainerNodeRef).size();
        EditionServiceImplTest.assertEquals((String)("The number of translations must be 1 and not " + numberOfTranslations), (int)1, (int)numberOfTranslations);
        numberOfTranslations = this.editionService.getVersionedTranslations(actualEdition).size();
        EditionServiceImplTest.assertEquals((String)("The number of translations must be 0 and not " + numberOfTranslations), (int)0, (int)numberOfTranslations);
        numberOfTranslations = rootVersionTranslations.size();
        EditionServiceImplTest.assertEquals((String)("The number of translations must be 3 and not " + numberOfTranslations), (int)3, (int)numberOfTranslations);
    }

    public void testReadVersionedContent() throws Exception {
    }

    public void testReadVersionedProperties() throws Exception {
    }

    private void checkFirstVersion(NodeRef mlContainerNodeRef) {
        VersionHistory editionHistory = this.editionService.getEditions(mlContainerNodeRef);
        EditionServiceImplTest.assertNotNull((String)"The edition history can't be null", (Object)editionHistory);
        EditionServiceImplTest.assertTrue((String)"The edition history must contain only one edition", (editionHistory.getAllVersions().size() == 1 ? 1 : 0) != 0);
        Version currentEdition = editionHistory.getAllVersions().iterator().next();
        EditionServiceImplTest.assertTrue((String)"The versioned mlContainer noderef of the editon must be the noderef of the created mlContainer", (boolean)currentEdition.getVersionedNodeRef().equals((Object)mlContainerNodeRef));
        List<VersionHistory> translations = this.editionService.getVersionedTranslations(currentEdition);
        EditionServiceImplTest.assertNotNull((String)"The translations list of the current edition can't be null", translations);
        EditionServiceImplTest.assertTrue((String)"The translations list of the current edition would be empty", (translations.size() == 0 ? 1 : 0) != 0);
    }

    private NodeRef createMLContainerWithContent() {
        NodeRef chineseContentNodeRef = this.createContent(CHINESE_CONTENT + "_1.0");
        NodeRef frenchContentNodeRef = this.createContent(FRENCH_CONTENT + "_1.0");
        NodeRef japaneseContentNodeRef = this.createContent(JAPANESE_CONTENT + "_1.0");
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
        this.multilingualContentService.addTranslation(japaneseContentNodeRef, chineseContentNodeRef, Locale.JAPANESE);
        return this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
    }
}

