/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.node.index.IndexRecovery;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReindexComponent
implements IndexRecovery {
    private static Log logger = LogFactory.getLog(AbstractReindexComponent.class);
    private static Log loggerOnThread = LogFactory.getLog((String)(AbstractReindexComponent.class.getName() + ".threads"));
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener("IndexRecovery");
    protected TransactionServiceImpl transactionService;
    protected Indexer indexer;
    protected FullTextSearchIndexer ftsIndexer;
    protected SearchService searcher;
    protected NodeService nodeService;
    protected NodeDAO nodeDAO;
    private ThreadPoolExecutor threadPoolExecutor;
    private TenantService tenantService;
    private Set<String> storeProtocolsToIgnore = new HashSet<String>(7);
    private Set<StoreRef> storesToIgnore = new HashSet<StoreRef>(7);
    private volatile boolean shutdown = false;
    private final ReentrantReadWriteLock.WriteLock indexerWriteLock;
    private static final String KEY_STORE_REFS = "StoreRefCacheMethodInterceptor.StoreRefs";
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();
    private LinkedBlockingQueue<ReindexWorkerRunnable> reindexThreadQueue = new LinkedBlockingQueue();
    private ReentrantReadWriteLock reindexThreadLock = new ReentrantReadWriteLock(true);

    public AbstractReindexComponent() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.indexerWriteLock = readWriteLock.writeLock();
    }

    protected ReentrantReadWriteLock.WriteLock getIndexerWriteLock() {
        return this.indexerWriteLock;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    protected boolean isShuttingDown() {
        return this.shutdown || vmShutdownListener.isVmShuttingDown();
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        logger.warn((Object)"Bean property 'authenticationComponent' is no longer required on 'AbstractReindexComponent'.");
    }

    public void setTransactionService(TransactionServiceImpl transactionService) {
        this.transactionService = transactionService;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public void setFtsIndexer(FullTextSearchIndexer ftsIndexer) {
        this.ftsIndexer = ftsIndexer;
    }

    public void setSearcher(SearchService searcher) {
        this.searcher = searcher;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setStoreProtocolsToIgnore(List<String> storeProtocolsToIgnore) {
        for (String storeProtocolToIgnore : storeProtocolsToIgnore) {
            this.storeProtocolsToIgnore.add(storeProtocolToIgnore);
        }
    }

    public void setStoresToIgnore(List<String> storesToIgnore) {
        for (String storeToIgnore : storesToIgnore) {
            StoreRef storeRef = new StoreRef(storeToIgnore);
            this.storesToIgnore.add(storeRef);
        }
    }

    public boolean isIgnorableStore(StoreRef storeRef) {
        return this.storesToIgnore.contains(storeRef = this.tenantService.getBaseName(storeRef)) || this.storeProtocolsToIgnore.contains(storeRef.getProtocol());
    }

    protected boolean requireTransaction() {
        return true;
    }

    protected abstract void reindexImpl();

    @Override
    public final void reindex() {
        PropertyCheck.mandatory((Object)this, (String)"ftsIndexer", (Object)this.ftsIndexer);
        PropertyCheck.mandatory((Object)this, (String)"indexer", (Object)this.indexer);
        PropertyCheck.mandatory((Object)this, (String)"searcher", (Object)this.searcher);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"nodeDaoService", (Object)this.nodeDAO);
        PropertyCheck.mandatory((Object)this, (String)"transactionComponent", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"storesToIgnore", this.storesToIgnore);
        PropertyCheck.mandatory((Object)this, (String)"storeProtocolsToIgnore", this.storeProtocolsToIgnore);
        if (this.indexerWriteLock.tryLock()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reindex work started: " + this));
                }
                AuthenticationUtil.pushAuthentication();
                AuthenticationUtil.setRunAsUserSystem();
                RetryingTransactionHelper.RetryingTransactionCallback<Object> reindexWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    @Override
                    public Object execute() throws Exception {
                        AbstractReindexComponent.this.reindexImpl();
                        return null;
                    }
                };
                if (this.requireTransaction()) {
                    this.transactionService.getRetryingTransactionHelper().doInTransaction(reindexWork, true);
                } else {
                    reindexWork.execute();
                }
            }
            catch (Throwable e) {
                throw new AlfrescoRuntimeException("Reindex failure for " + this.getClass().getName(), e);
            }
            finally {
                try {
                    this.indexerWriteLock.unlock();
                }
                catch (Throwable e) {}
                AuthenticationUtil.popAuthentication();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Reindex work completed: " + this));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bypassed reindex work - already busy: " + this));
        }
    }

    private List<StoreRef> getAdmStoreRefs() {
        StoreRef storeRef;
        List storeRefs = (List)AlfrescoTransactionSupport.getResource(KEY_STORE_REFS);
        if (storeRefs != null) {
            return storeRefs;
        }
        storeRefs = this.nodeService.getStores();
        Iterator storeRefsIterator = storeRefs.iterator();
        while (storeRefsIterator.hasNext()) {
            storeRef = (StoreRef)storeRefsIterator.next();
            if (!storeRef.getProtocol().equals("avm")) continue;
            storeRefsIterator.remove();
        }
        storeRefsIterator = storeRefs.iterator();
        while (storeRefsIterator.hasNext()) {
            storeRef = (StoreRef)storeRefsIterator.next();
            if (!this.isIgnorableStore(storeRef)) continue;
            storeRefsIterator.remove();
        }
        if (storeRefs.contains(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE)) {
            storeRefs.remove(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE);
            storeRefs.add(0, StoreRef.STORE_REF_ARCHIVE_SPACESSTORE);
        }
        if (storeRefs.contains(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE)) {
            storeRefs.remove(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            storeRefs.add(0, StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        }
        AlfrescoTransactionSupport.bindResource(KEY_STORE_REFS, storeRefs);
        return storeRefs;
    }

    public InIndex isTxnPresentInIndex(Transaction txn) {
        if (txn == null) {
            return InIndex.YES;
        }
        Long txnId = txn.getId();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Checking for transaction in index: " + txnId));
        }
        boolean foundInIndex = false;
        List<StoreRef> storeRefs = this.getAdmStoreRefs();
        for (StoreRef storeRef : storeRefs) {
            boolean inStore = this.isTxnIdPresentInIndex(storeRef, txn);
            if (!inStore) continue;
            foundInIndex = true;
            break;
        }
        InIndex result = InIndex.NO;
        if (!foundInIndex) {
            int updateCount = this.nodeDAO.getTxnUpdateCount(txnId);
            if (updateCount > 0 && !this.allUpdatedNodesCanBeIgnored(txnId)) {
                result = InIndex.NO;
            } else {
                int deleteCount = this.nodeDAO.getTxnDeleteCount(txnId);
                if (deleteCount == 0) {
                    result = InIndex.INDETERMINATE;
                } else {
                    result = InIndex.INDETERMINATE;
                    for (StoreRef storeRef : storeRefs) {
                        if (this.haveNodesBeenRemovedFromIndex(storeRef, txn)) continue;
                        result = InIndex.NO;
                        break;
                    }
                }
            }
        } else {
            result = InIndex.YES;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Transaction " + txnId + " present in indexes: " + (Object)((Object)result)));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTxnIdPresentInIndex(StoreRef storeRef, Transaction txn) {
        long txnId = txn.getId();
        String changeTxnId = txn.getChangeTxnId();
        ResultSet results = null;
        try {
            SearchParameters sp = new SearchParameters();
            sp.addStore(storeRef);
            sp.setLanguage("lucene");
            sp.setQuery("TX:" + LuceneQueryParser.escape((String)changeTxnId));
            sp.setLimit(1);
            results = this.searcher.query(sp);
            if (results.length() > 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Index has results for txn " + txnId + " for store " + storeRef));
                }
                boolean bl = true;
                return bl;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Transaction " + txnId + " not in index for store " + storeRef + ".  Possibly out of date."));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    protected boolean allUpdatedNodesCanBeIgnored(Long txnId) {
        ParameterCheck.mandatory((String)"txnId", (Object)txnId);
        boolean allUpdatedNodesCanBeIgnored = false;
        List<NodeRef.Status> nodeStatuses = this.nodeDAO.getTxnChanges(txnId);
        allUpdatedNodesCanBeIgnored = true;
        for (NodeRef.Status nodeStatus : nodeStatuses) {
            StoreRef storeRef;
            NodeRef nodeRef = nodeStatus.getNodeRef();
            if (nodeStatus.isDeleted() || this.isIgnorableStore(storeRef = nodeRef.getStoreRef())) continue;
            allUpdatedNodesCanBeIgnored = false;
            break;
        }
        return allUpdatedNodesCanBeIgnored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean haveNodesBeenRemovedFromIndex(StoreRef storeRef, Transaction txn) {
        Long txnId = txn.getId();
        List<NodeRef.Status> nodeStatuses = this.nodeDAO.getTxnChangesForStore(storeRef, txnId);
        boolean foundNodeRef = false;
        for (NodeRef.Status nodeStatus : nodeStatuses) {
            NodeRef nodeRef = nodeStatus.getNodeRef();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Searching for node in index: \n   node: " + nodeRef + "\n" + "   txn: " + txnId));
            }
            ResultSet results = null;
            try {
                SearchParameters sp = new SearchParameters();
                sp.addStore(storeRef);
                sp.setLanguage("lucene");
                sp.setQuery("ID:" + LuceneQueryParser.escape((String)nodeRef.toString()));
                sp.setLimit(1);
                results = this.searcher.query(sp);
                if (results.length() <= 0) continue;
                foundNodeRef = true;
                break;
            }
            finally {
                if (results == null) continue;
                results.close();
            }
        }
        if (foundNodeRef) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" --> Node found (Index out of date)");
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)" --> Node not found (OK)");
        }
        return !foundNodeRef;
    }

    protected void reindexTransaction(Long txnId) {
        this.reindexTransaction(txnId, null);
    }

    protected void reindexTransaction(long txnId, ReindexNodeCallback callback) {
        ParameterCheck.mandatory((String)"txnId", (Object)txnId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Reindexing transaction: " + txnId));
        }
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_READ_ONLY) {
            throw new AlfrescoRuntimeException("Reindex work must be done in the context of a read-only transaction");
        }
        List<NodeRef.Status> nodeStatuses = this.nodeDAO.getTxnChanges(txnId);
        int nodeCount = 0;
        for (NodeRef.Status nodeStatus : nodeStatuses) {
            NodeRef nodeRef = nodeStatus.getNodeRef();
            if (nodeStatus == null) continue;
            if (nodeStatus.isDeleted()) {
                ChildAssociationRef assocRef = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, null, null, nodeRef);
                this.indexer.deleteNode(assocRef);
            } else {
                this.indexer.updateNode(nodeRef);
            }
            if (callback != null) {
                callback.reindexedNode(nodeRef);
            }
            if (++nodeCount % 100 != 0 || !this.isShuttingDown()) continue;
            logger.info((Object)("Reindexing of transaction " + txnId + " terminated by VM shutdown."));
            throw new ReindexTerminatedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReindexWorkerRunnable peekHeadReindexWorker() {
        try {
            this.reindexThreadLock.readLock().lock();
            ReindexWorkerRunnable reindexWorkerRunnable = this.reindexThreadQueue.peek();
            return reindexWorkerRunnable;
        }
        finally {
            this.reindexThreadLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reindexTransactionAsynchronously(final List<Long> txnIds) {
        if (this.threadPoolExecutor == null || this.threadPoolExecutor.getMaximumPoolSize() < 2) {
            if (loggerOnThread.isDebugEnabled()) {
                String msg = String.format("Reindexing inline: %s.", txnIds.toString());
                loggerOnThread.debug((Object)msg);
            }
            RetryingTransactionHelper.RetryingTransactionCallback<Object> reindexCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    for (Long txnId : txnIds) {
                        if (loggerOnThread.isDebugEnabled()) {
                            String msg = String.format("Reindex %10d.", (long)txnId);
                            loggerOnThread.debug((Object)msg);
                        }
                        AbstractReindexComponent.this.reindexTransaction(txnId, null);
                    }
                    return null;
                }
            };
            this.transactionService.getRetryingTransactionHelper().doInTransaction(reindexCallback, true, true);
            return;
        }
        ReindexWorkerRunnable runnable = new ReindexWorkerRunnable(txnIds);
        try {
            this.reindexThreadLock.writeLock().lock();
            this.reindexThreadQueue.add(runnable);
        }
        finally {
            this.reindexThreadLock.writeLock().unlock();
        }
        this.threadPoolExecutor.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void waitForAsynchronousReindexing() {
        ReindexWorkerRunnable lastRunnable = null;
        long lastTimestamp = Long.MAX_VALUE;
        ReindexWorkerRunnable currentRunnable = this.peekHeadReindexWorker();
        while (currentRunnable != null && !this.isShuttingDown()) {
            currentRunnable.setAtHeadOfQueue();
            AbstractReindexComponent abstractReindexComponent = this;
            synchronized (abstractReindexComponent) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            long currentTimestamp = currentRunnable.getLastIndexedTimestamp();
            if (lastRunnable == currentRunnable) {
                if ((double)(currentTimestamp - lastTimestamp) > 6.0E11) {
                    try {
                        this.reindexThreadLock.writeLock().lock();
                        ReindexWorkerRunnable checkCurrentRunnable = this.reindexThreadQueue.peek();
                        if (lastRunnable == checkCurrentRunnable) {
                            loggerOnThread.warn((Object)("Detected reindex thread inactivity: " + currentRunnable));
                        }
                        lastRunnable = null;
                        lastTimestamp = Long.MAX_VALUE;
                        currentRunnable = this.reindexThreadQueue.peek();
                        continue;
                    }
                    finally {
                        this.reindexThreadLock.writeLock().unlock();
                        continue;
                    }
                }
                lastRunnable = currentRunnable;
                lastTimestamp = currentTimestamp;
            } else {
                lastRunnable = currentRunnable;
                lastTimestamp = currentTimestamp;
            }
            currentRunnable = this.peekHeadReindexWorker();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReindexWorkerRunnable
    extends TransactionListenerAdapter
    implements Runnable,
    ReindexNodeCallback {
        private final int id = AbstractReindexComponent.access$000().addAndGet(1);
        private final int uidHashCode;
        private final List<Long> txnIds;
        private long lastIndexedTimestamp;
        private boolean atHeadOfQueue;

        private ReindexWorkerRunnable(List<Long> txnIds) {
            if (ID_GENERATOR.get() > 1000) {
                ID_GENERATOR.set(0);
            }
            this.uidHashCode = this.id * 13 + 11;
            this.txnIds = txnIds;
            this.atHeadOfQueue = false;
            this.recordTimestamp();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ReindexWorkerRunnable").append("[id=").append(this.id).append("[txnIds=").append(this.txnIds).append("]");
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReindexWorkerRunnable)) {
                return false;
            }
            ReindexWorkerRunnable that = (ReindexWorkerRunnable)obj;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.uidHashCode;
        }

        public synchronized long getLastIndexedTimestamp() {
            return this.lastIndexedTimestamp;
        }

        private synchronized void recordTimestamp() {
            this.lastIndexedTimestamp = System.nanoTime();
        }

        private synchronized boolean isAtHeadOfQueue() {
            return this.atHeadOfQueue;
        }

        private synchronized void waitForHeadOfQueue() {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public synchronized void setAtHeadOfQueue() {
            this.notifyAll();
            this.atHeadOfQueue = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RetryingTransactionHelper.RetryingTransactionCallback<Object> reindexCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                @Override
                public Object execute() throws Throwable {
                    AlfrescoTransactionSupport.bindListener(ReindexWorkerRunnable.this);
                    for (Long txnId : ReindexWorkerRunnable.this.txnIds) {
                        if (loggerOnThread.isDebugEnabled()) {
                            String msg = String.format("   -> Reindexer %5d reindexing %10d", ReindexWorkerRunnable.this.id, (long)txnId);
                            loggerOnThread.debug((Object)msg);
                        }
                        AbstractReindexComponent.this.reindexTransaction(txnId, ReindexWorkerRunnable.this);
                    }
                    return null;
                }
            };
            this.recordTimestamp();
            try {
                if (loggerOnThread.isDebugEnabled()) {
                    int txnIdsSize = this.txnIds.size();
                    String msg = String.format("Reindexer %5d starting [%10d, %10d] on %s.", this.id, txnIdsSize == 0 ? -1L : this.txnIds.get(0), txnIdsSize == 0 ? -1L : this.txnIds.get(txnIdsSize - 1), Thread.currentThread().getName());
                    loggerOnThread.debug((Object)msg);
                }
                AbstractReindexComponent.this.transactionService.getRetryingTransactionHelper().doInTransaction(reindexCallback, true, true);
            }
            catch (ReindexTerminatedException e) {
                String msg = String.format("Reindexer %5d terminated: %s.", this.id, e.getMessage());
                loggerOnThread.warn((Object)msg);
                loggerOnThread.warn((Object)this.getStackTrace(e));
            }
            catch (Throwable e) {
                String msg = String.format("Reindexer %5d failed with error: %s.", this.id, e.getMessage());
                loggerOnThread.error((Object)msg);
                loggerOnThread.warn((Object)this.getStackTrace(e));
            }
            finally {
                this.removeFromQueueAndProdHead();
            }
        }

        public String getStackTrace(Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            t.printStackTrace(pw);
            pw.flush();
            sw.flush();
            return sw.toString();
        }

        @Override
        public synchronized void reindexedNode(NodeRef nodeRef) {
            this.recordTimestamp();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromQueueAndProdHead() {
            try {
                AbstractReindexComponent.this.reindexThreadLock.writeLock().lock();
                AbstractReindexComponent.this.reindexThreadQueue.remove(this);
            }
            finally {
                AbstractReindexComponent.this.reindexThreadLock.writeLock().unlock();
            }
            ReindexWorkerRunnable newPeek = AbstractReindexComponent.this.peekHeadReindexWorker();
            if (newPeek != null) {
                newPeek.setAtHeadOfQueue();
            }
            if (loggerOnThread.isDebugEnabled()) {
                String msg = String.format("Reindexer %5d removed from queue.  Current HEAD is %s.", this.id, newPeek);
                loggerOnThread.debug((Object)msg);
            }
        }

        @Override
        public void afterCommit() {
            this.handleQueue();
        }

        @Override
        public void afterRollback() {
            this.handleQueue();
        }

        private void handleQueue() {
            while (true) {
                ReindexWorkerRunnable peek;
                if ((peek = AbstractReindexComponent.this.peekHeadReindexWorker()) != null) {
                    peek.setAtHeadOfQueue();
                }
                if (peek == null || this.isAtHeadOfQueue()) break;
                this.waitForHeadOfQueue();
            }
            this.recordTimestamp();
        }
    }

    protected static interface ReindexNodeCallback {
        public void reindexedNode(NodeRef var1);
    }

    public static class ReindexTerminatedException
    extends RuntimeException {
        private static final long serialVersionUID = -7928720932368892814L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InIndex {
        YES,
        NO,
        INDETERMINATE;

    }
}

