/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rating;

import org.alfresco.repo.rating.RatingSchemeRegistry;
import org.alfresco.service.cmr.rating.RatingScheme;
import org.alfresco.service.cmr.rating.RatingServiceException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public class RatingSchemeImpl
implements RatingScheme,
BeanNameAware,
InitializingBean {
    private final RatingSchemeRegistry ratingSchemeRegistry;
    private String name;
    private float minRating;
    private float maxRating;

    public RatingSchemeImpl(RatingSchemeRegistry registry) {
        this.ratingSchemeRegistry = registry;
    }

    public void init() {
        this.ratingSchemeRegistry.register(this.name, this);
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setMinRating(float minRating) {
        this.minRating = minRating;
    }

    public void setMaxRating(float maxRating) {
        this.maxRating = maxRating;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.minRating > this.maxRating) {
            StringBuilder msg = new StringBuilder();
            msg.append("Illegal rating limits for ").append(this.name).append(". Min > Max. ").append(this.minRating).append(" > ").append(this.maxRating);
            throw new RatingServiceException(msg.toString());
        }
    }

    public float getMaxRating() {
        return this.maxRating;
    }

    public float getMinRating() {
        return this.minRating;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.getClass().getSimpleName()).append(" ").append(this.name).append(" [").append(this.minRating).append("..").append(this.maxRating).append("]");
        return msg.toString();
    }
}

