/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.rendition.CompositeRenditionDefinitionImpl;
import org.alfresco.repo.rendition.RenditionDefinitionImpl;
import org.alfresco.repo.rendition.RenditionDefinitionPersister;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenditionDefinitionPersisterImpl
implements RenditionDefinitionPersister {
    private static final StoreRef SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    protected static final NodeRef RENDERING_ACTION_ROOT_NODE_REF = new NodeRef(SPACES_STORE, "rendering_actions_space");
    private NodeService nodeService;
    private RuntimeActionService runtimeActionService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    @Override
    public List<RenditionDefinition> loadRenditionDefinitions() {
        this.checkRenderingActionRootNodeExists();
        HashSet<QName> actionTypes = new HashSet<QName>();
        actionTypes.add(ActionModel.TYPE_ACTION);
        List childAssocs = this.nodeService.getChildAssocs(RENDERING_ACTION_ROOT_NODE_REF, actionTypes);
        ArrayList<RenditionDefinition> renderingActions = new ArrayList<RenditionDefinition>(childAssocs.size());
        for (ChildAssociationRef actionAssoc : childAssocs) {
            Action nextAction = this.runtimeActionService.createAction(actionAssoc.getChildRef());
            renderingActions.add(new RenditionDefinitionImpl(nextAction));
        }
        return renderingActions;
    }

    @Override
    public List<RenditionDefinition> loadRenditionDefinitions(String renditionEngineName) {
        if (renditionEngineName == null) {
            throw new NullPointerException("Unexpected null renditionEngineName");
        }
        List<RenditionDefinition> allRenditionDefinitions = this.loadRenditionDefinitions();
        ArrayList<RenditionDefinition> filteredRenditionDefinitions = new ArrayList<RenditionDefinition>();
        for (RenditionDefinition renderAction : allRenditionDefinitions) {
            if (!renditionEngineName.equals(renderAction.getActionDefinitionName())) continue;
            filteredRenditionDefinitions.add(renderAction);
        }
        return filteredRenditionDefinitions;
    }

    @Override
    public RenditionDefinition loadRenditionDefinition(QName renditionDefinitionName) {
        NodeRef actionNode = this.findActionNode(renditionDefinitionName);
        if (actionNode != null) {
            Action action = this.runtimeActionService.createAction(actionNode);
            if (action instanceof CompositeAction) {
                CompositeAction compAction = (CompositeAction)action;
                return new CompositeRenditionDefinitionImpl(compAction);
            }
            return new RenditionDefinitionImpl(action);
        }
        return null;
    }

    @Override
    public void saveRenditionDefinition(RenditionDefinition renderingAction) {
        NodeRef actionNodeRef = this.findOrCreateActionNode(renderingAction);
        this.runtimeActionService.saveActionImpl(actionNodeRef, renderingAction);
    }

    public void deleteRenditionDefinition(RenditionDefinition renderingAction) {
        NodeRef actionNodeRef = this.findOrCreateActionNode(renderingAction);
        if (actionNodeRef != null) {
            this.nodeService.deleteNode(actionNodeRef);
        }
    }

    private NodeRef findActionNode(QName renditionDefinitionName) {
        this.checkRenderingActionRootNodeExists();
        List childAssocs = this.nodeService.getChildAssocs(RENDERING_ACTION_ROOT_NODE_REF, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)renditionDefinitionName);
        if (childAssocs.isEmpty()) {
            return null;
        }
        if (childAssocs.size() > 1) {
            throw new RenditionServiceException("Multiple rendition definitions with the name: " + renditionDefinitionName + " exist!");
        }
        return ((ChildAssociationRef)childAssocs.get(0)).getChildRef();
    }

    private NodeRef findOrCreateActionNode(RenditionDefinition renderingAction) {
        QName actionName = renderingAction.getRenditionName();
        NodeRef actionNode = this.findActionNode(actionName);
        if (actionNode == null) {
            actionNode = this.runtimeActionService.createActionNodeRef(renderingAction, RENDERING_ACTION_ROOT_NODE_REF, ContentModel.ASSOC_CONTAINS, actionName);
        }
        return actionNode;
    }

    private void checkRenderingActionRootNodeExists() {
        if (!this.nodeService.exists(RENDERING_ACTION_ROOT_NODE_REF)) {
            throw new RenditionServiceException("Unable to find rendering action root node.");
        }
    }
}

