/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTemplateRenderingEngine
extends AbstractRenderingEngine {
    private static final Log log = LogFactory.getLog(BaseTemplateRenderingEngine.class);
    public static final String PARAM_MODEL = "model";
    public static final String PARAM_TEMPLATE = "template_string";
    public static final String PARAM_TEMPLATE_NODE = "template_node";
    public static final String PARAM_TEMPLATE_PATH = "template_path";
    private TemplateService templateService;
    private SearchService searchService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void render(AbstractRenderingEngine.RenderingContext context) {
        NodeRef templateNode = this.getTemplateNode(context);
        Writer writer = null;
        Object model = this.buildModel(context);
        ContentWriter contentWriter = context.makeContentWriter();
        writer = new OutputStreamWriter(contentWriter.getContentOutputStream());
        this.processTemplate(context, templateNode, model, writer);
        Object var7_8 = null;
        if (writer == null) return;
        try {
            writer.flush();
            writer.close();
            return;
        }
        catch (IOException ex2) {
            log.warn((Object)"Failed to correctly close content writer.", (Throwable)ex2);
        }
        return;
        {
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.warn((Object)"Unexpected error while rendering through XSLT rendering engine.", (Throwable)ex);
                Object var7_9 = null;
                if (writer == null) return;
                try {
                    writer.flush();
                    writer.close();
                    return;
                }
                catch (IOException ex2) {
                    log.warn((Object)"Failed to correctly close content writer.", (Throwable)ex2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (writer == null) throw throwable;
            try {
                writer.flush();
                writer.close();
                throw throwable;
            }
            catch (IOException ex2) {
                log.warn((Object)"Failed to correctly close content writer.", (Throwable)ex2);
            }
            throw throwable;
        }
    }

    private void processTemplate(AbstractRenderingEngine.RenderingContext context, NodeRef templateNode, Object model, Writer out) {
        String templateType = this.getTemplateType();
        String template = context.getCheckedParam(PARAM_TEMPLATE, String.class);
        if (template != null) {
            this.templateService.processTemplateString(templateType, template, model, out);
        } else if (templateNode != null) {
            this.templateService.processTemplate(templateType, templateNode.toString(), model, out);
        } else {
            this.throwTemplateParamsNotFoundException();
        }
    }

    private void throwTemplateParamsNotFoundException() {
        StringBuilder msg = new StringBuilder("This action requires that either the ");
        msg.append(PARAM_TEMPLATE);
        msg.append(" parameter or the ");
        msg.append(PARAM_TEMPLATE_NODE);
        msg.append(" parameter be specified. ");
        throw new RenditionServiceException(msg.toString());
    }

    protected NodeRef getTemplateNode(AbstractRenderingEngine.RenderingContext context) {
        String path;
        NodeRef node = context.getCheckedParam(PARAM_TEMPLATE_NODE, NodeRef.class);
        if (node == null && (path = context.getCheckedParam(PARAM_TEMPLATE_PATH, String.class)) != null && path.length() > 0) {
            StoreRef storeRef = context.getDestinationNode().getStoreRef();
            ResultSet result = this.searchService.query(storeRef, "xpath", path);
            if (result.length() != 1) {
                throw new RenditionServiceException("Could not find template node for path: " + path);
            }
            node = result.getNodeRef(0);
        }
        return node;
    }

    protected abstract Object buildModel(AbstractRenderingEngine.RenderingContext var1);

    protected abstract String getTemplateType();

    @Override
    protected String getParamDisplayLabel(String paramName) {
        String commonPropertiesPrefix = "baseTemplateRenderingAction";
        String message = I18NUtil.getMessage((String)("baseTemplateRenderingAction." + paramName + "." + "display-label"));
        if (message == null) {
            message = super.getParamDisplayLabel(paramName);
        }
        return message;
    }

    @Override
    protected Collection<ParameterDefinition> getParameterDefinitions() {
        Collection<ParameterDefinition> paramList = super.getParameterDefinitions();
        ParameterDefinitionImpl modelParamDef = new ParameterDefinitionImpl(PARAM_MODEL, DataTypeDefinition.ANY, false, this.getParamDisplayLabel(PARAM_MODEL));
        ParameterDefinitionImpl templateParamDef = new ParameterDefinitionImpl(PARAM_TEMPLATE, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_TEMPLATE));
        ParameterDefinitionImpl templateNodeParamDef = new ParameterDefinitionImpl(PARAM_TEMPLATE_NODE, DataTypeDefinition.NODE_REF, false, this.getParamDisplayLabel(PARAM_TEMPLATE_NODE));
        ParameterDefinitionImpl templatePathParamDef = new ParameterDefinitionImpl(PARAM_TEMPLATE_PATH, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_TEMPLATE_PATH));
        paramList.add(modelParamDef);
        paramList.add(templateParamDef);
        paramList.add(templateNodeParamDef);
        paramList.add(templatePathParamDef);
        return paramList;
    }

    public void setTemplateService(TemplateService templateService) {
        this.templateService = templateService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public TemplateService getTemplateService() {
        return this.templateService;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }
}

