/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.RuntimeActionService;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.rule.RuleTransactionListener;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListener;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.alfresco.service.cmr.rule.RuleType;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleServiceImpl
implements RuleService,
RuntimeRuleService,
NodeServicePolicies.BeforeCreateChildAssociationPolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnUpdateNodePolicy,
NodeServicePolicies.OnAddAspectPolicy {
    private static final String KEY_RULES_PENDING = "RuleServiceImpl.PendingRules";
    private static final String KEY_RULES_EXECUTED = "RuleServiceImpl.ExecutedRules";
    private String ASSOC_NAME_RULES_PREFIX = "rules";
    private RegexQNamePattern ASSOC_NAME_RULES_REGEX = new RegexQNamePattern("http://www.alfresco.org/model/rule/1.0", "^" + this.ASSOC_NAME_RULES_PREFIX + ".*");
    private static Log logger = LogFactory.getLog(RuleServiceImpl.class);
    private NodeService nodeService;
    private NodeService runtimeNodeService;
    private ActionService actionService;
    private DictionaryService dictionaryService;
    private PolicyComponent policyComponent;
    private PermissionService permissionService;
    private RuntimeActionService runtimeActionService;
    private SimpleCache<NodeRef, List<Rule>> nodeRulesCache;
    private Set<NodeRef> disabledNodeRefs = new HashSet<NodeRef>(5);
    private Set<Rule> disabledRules = new HashSet<Rule>(5);
    private Map<String, RuleType> ruleTypes = new HashMap<String, RuleType>();
    private TransactionListener ruleTransactionListener = new RuleTransactionListener(this);
    private ThreadLocal<Boolean> rulesDisabled = new ThreadLocal();
    private boolean globalRulesDisabled = false;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRuntimeNodeService(NodeService runtimeNodeService) {
        this.runtimeNodeService = runtimeNodeService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setRuntimeActionService(RuntimeActionService runtimeActionService) {
        this.runtimeActionService = runtimeActionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setNodeRulesCache(SimpleCache<NodeRef, List<Rule>> nodeRulesCache) {
        this.nodeRulesCache = nodeRulesCache;
    }

    public void setRulesDisabled(boolean rulesDisabled) {
        this.globalRulesDisabled = rulesDisabled;
    }

    public void init() {
        this.policyComponent.bindAssociationBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeCreateChildAssociation"), RuleModel.ASPECT_RULES, RuleModel.ASSOC_RULE_FOLDER, new JavaBehaviour(this, "beforeCreateChildAssociation"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), RuleModel.ASPECT_RULES, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateNode"), RuleModel.ASPECT_RULES, (Behaviour)new JavaBehaviour(this, "onUpdateNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), RuleModel.TYPE_RULE, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateNode"), RuleModel.TYPE_RULE, (Behaviour)new JavaBehaviour(this, "onUpdateNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), ActionModel.TYPE_ACTION_BASE, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateNode"), ActionModel.TYPE_ACTION_BASE, (Behaviour)new JavaBehaviour(this, "onUpdateNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCreateNode"), ActionModel.TYPE_ACTION_PARAMETER, (Behaviour)new JavaBehaviour(this, "onCreateNode"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateNode"), ActionModel.TYPE_ACTION_PARAMETER, (Behaviour)new JavaBehaviour(this, "onUpdateNode"));
    }

    @Override
    public void beforeCreateChildAssociation(NodeRef parentNodeRef, NodeRef childNodeRef, QName assocTypeQName, QName assocQName, boolean isNewNode) {
        this.nodeRulesCache.clear();
    }

    @Override
    public void onUpdateNode(NodeRef nodeRef) {
        this.nodeRulesCache.clear();
    }

    @Override
    public void onCreateNode(ChildAssociationRef childAssocRef) {
        this.nodeRulesCache.clear();
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.nodeRulesCache.clear();
    }

    protected NodeRef getSavedRuleFolderRef(NodeRef nodeRef) {
        NodeRef result = null;
        ChildAssociationRef assoc = this.getSavedRuleFolderAssoc(nodeRef);
        if (assoc != null) {
            result = assoc.getChildRef();
        }
        return result;
    }

    @Override
    public ChildAssociationRef getSavedRuleFolderAssoc(NodeRef nodeRef) {
        ChildAssociationRef result = null;
        List assocs = this.runtimeNodeService.getChildAssocs(nodeRef, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER);
        if (assocs.size() > 1) {
            throw new ActionServiceException("There is more than one rule folder, which is invalid.");
        }
        if (assocs.size() == 1) {
            result = (ChildAssociationRef)assocs.get(0);
        }
        return result;
    }

    @Override
    public List<RuleType> getRuleTypes() {
        return new ArrayList<RuleType>(this.ruleTypes.values());
    }

    @Override
    public RuleType getRuleType(String name) {
        return this.ruleTypes.get(name);
    }

    @Override
    public void enableRules() {
        this.rulesDisabled.remove();
    }

    @Override
    public void disableRules() {
        this.rulesDisabled.set(Boolean.TRUE);
    }

    @Override
    public boolean isEnabled() {
        return !this.globalRulesDisabled && this.rulesDisabled.get() == null;
    }

    @Override
    public boolean rulesEnabled(NodeRef nodeRef) {
        return !this.disabledNodeRefs.contains(nodeRef);
    }

    @Override
    public void disableRules(NodeRef nodeRef) {
        this.disabledNodeRefs.add(nodeRef);
    }

    @Override
    public void enableRules(NodeRef nodeRef) {
        this.disabledNodeRefs.remove(nodeRef);
    }

    @Override
    public void disableRule(Rule rule) {
        this.disabledRules.add(rule);
    }

    @Override
    public void enableRule(Rule rule) {
        this.disabledRules.remove(rule);
    }

    @Override
    public boolean hasRules(NodeRef nodeRef) {
        return this.getRules(nodeRef).size() != 0;
    }

    @Override
    public List<Rule> getRules(NodeRef nodeRef) {
        return this.getRules(nodeRef, true, null);
    }

    @Override
    public List<Rule> getRules(NodeRef nodeRef, boolean includeInherited) {
        return this.getRules(nodeRef, includeInherited, null);
    }

    @Override
    public List<Rule> getRules(NodeRef nodeRef, boolean includeInherited, String ruleTypeName) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (!this.runtimeNodeService.exists(nodeRef) || !this.checkNodeType(nodeRef)) {
            return rules;
        }
        if (includeInherited && !this.runtimeNodeService.hasAspect(nodeRef, RuleModel.ASPECT_IGNORE_INHERITED_RULES)) {
            for (Rule rule : this.getInheritedRules(nodeRef, ruleTypeName, null)) {
                if (rules.contains(rule)) continue;
                rules.add(rule);
            }
        }
        List<Rule> nodeRules = this.getRulesForNode(nodeRef);
        for (Rule rule : nodeRules) {
            if (rules.contains(rule) || ruleTypeName != null && !rule.getRuleTypes().contains(ruleTypeName)) continue;
            rules.add(rule);
        }
        return rules;
    }

    private List<Rule> getRulesForNode(NodeRef nodeRef) {
        if (!this.runtimeNodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES) || this.permissionService.hasPermission(nodeRef, "Read") != AccessStatus.ALLOWED) {
            return Collections.emptyList();
        }
        ArrayList<Rule> nodeRules = (ArrayList<Rule>)this.nodeRulesCache.get((Serializable)nodeRef);
        if (nodeRules != null) {
            return nodeRules;
        }
        nodeRules = new ArrayList<Rule>();
        NodeRef ruleFolder = this.getSavedRuleFolderRef(nodeRef);
        if (ruleFolder != null) {
            List ruleChildAssocRefs = this.runtimeNodeService.getChildAssocs(ruleFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.ASSOC_NAME_RULES_REGEX);
            for (ChildAssociationRef ruleChildAssocRef : ruleChildAssocRefs) {
                NodeRef ruleNodeRef = ruleChildAssocRef.getChildRef();
                Rule rule = this.getRule(ruleNodeRef);
                nodeRules.add(rule);
            }
        }
        this.nodeRulesCache.put((Serializable)nodeRef, nodeRules);
        return nodeRules;
    }

    @Override
    public int countRules(NodeRef nodeRef) {
        NodeRef ruleFolder;
        int ruleCount = 0;
        if (this.runtimeNodeService.exists(nodeRef) && this.checkNodeType(nodeRef) && this.runtimeNodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES) && (ruleFolder = this.getSavedRuleFolderRef(nodeRef)) != null) {
            List ruleChildAssocRefs = this.runtimeNodeService.getChildAssocs(ruleFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.ASSOC_NAME_RULES_REGEX);
            ruleCount = ruleChildAssocRefs.size();
        }
        return ruleCount;
    }

    private boolean checkNodeType(NodeRef nodeRef) {
        boolean result = true;
        QName nodeType = this.runtimeNodeService.getType(nodeRef);
        if (this.dictionaryService.isSubClass(nodeType, ContentModel.TYPE_SYSTEM_FOLDER) || this.dictionaryService.isSubClass(nodeType, ActionModel.TYPE_ACTION) || this.dictionaryService.isSubClass(nodeType, ActionModel.TYPE_ACTION_CONDITION) || this.dictionaryService.isSubClass(nodeType, ActionModel.TYPE_ACTION_PARAMETER)) {
            result = false;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("A node of type " + nodeType.toString() + " was checked and can not have rules."));
            }
        }
        return result;
    }

    private List<Rule> getInheritedRules(NodeRef nodeRef, String ruleTypeName, Set<NodeRef> visitedNodeRefs) {
        ArrayList<Rule> inheritedRules = new ArrayList<Rule>();
        if (!this.runtimeNodeService.hasAspect(nodeRef, RuleModel.ASPECT_IGNORE_INHERITED_RULES)) {
            if (visitedNodeRefs == null) {
                visitedNodeRefs = new HashSet<NodeRef>();
            }
            if (!visitedNodeRefs.contains(nodeRef)) {
                visitedNodeRefs.add(nodeRef);
                ArrayList<Rule> allInheritedRules = new ArrayList<Rule>();
                List parents = this.runtimeNodeService.getParentAssocs(nodeRef);
                for (ChildAssociationRef parent : parents) {
                    for (Rule rule : this.getInheritedRules(parent.getParentRef(), ruleTypeName, visitedNodeRefs)) {
                        if (allInheritedRules.contains(rule)) continue;
                        allInheritedRules.add(rule);
                    }
                    List<Rule> rules = this.getRules(parent.getParentRef(), false);
                    for (Rule rule : rules) {
                        if (!rule.isAppliedToChildren() || allInheritedRules.contains(rule)) continue;
                        allInheritedRules.add(rule);
                    }
                }
                if (ruleTypeName == null) {
                    inheritedRules = allInheritedRules;
                } else {
                    for (Rule rule : allInheritedRules) {
                        if (!rule.getRuleTypes().contains(ruleTypeName)) continue;
                        inheritedRules.add(rule);
                    }
                }
            }
        }
        return inheritedRules;
    }

    @Override
    public Rule getRule(NodeRef ruleNodeRef) {
        Map props = this.runtimeNodeService.getProperties(ruleNodeRef);
        Rule rule = new Rule(ruleNodeRef);
        String title = (String)DefaultTypeConverter.INSTANCE.convert(String.class, props.get(ContentModel.PROP_TITLE));
        String description = (String)DefaultTypeConverter.INSTANCE.convert(String.class, props.get(ContentModel.PROP_DESCRIPTION));
        rule.setTitle(title);
        rule.setDescription(description);
        rule.setRuleTypes((List)props.get(RuleModel.PROP_RULE_TYPE));
        boolean isAppliedToChildren = false;
        Boolean value = (Boolean)props.get(RuleModel.PROP_APPLY_TO_CHILDREN);
        if (value != null) {
            isAppliedToChildren = value;
        }
        rule.applyToChildren(isAppliedToChildren);
        boolean executeAsync = false;
        Boolean value2 = (Boolean)props.get(RuleModel.PROP_EXECUTE_ASYNC);
        if (value2 != null) {
            executeAsync = value2;
        }
        rule.setExecuteAsynchronously(executeAsync);
        boolean ruleDisabled = false;
        Boolean value3 = (Boolean)props.get(RuleModel.PROP_DISABLED);
        if (value3 != null) {
            ruleDisabled = value3;
        }
        rule.setRuleDisabled(ruleDisabled);
        List actions = this.nodeService.getChildAssocs(ruleNodeRef, (QNamePattern)RuleModel.ASSOC_ACTION, (QNamePattern)RuleModel.ASSOC_ACTION);
        if (actions.size() == 0) {
            throw new RuleServiceException("Rule exists without a specified action");
        }
        if (actions.size() > 1) {
            throw new RuleServiceException("Rule exists with more than one specified action");
        }
        NodeRef actionNodeRef = ((ChildAssociationRef)actions.get(0)).getChildRef();
        Action action = this.runtimeActionService.createAction(actionNodeRef);
        rule.setAction(action);
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveRule(NodeRef nodeRef, Rule rule) {
        this.checkForLinkedRules(nodeRef);
        if (this.permissionService.hasPermission(nodeRef, "ChangePermissions") == AccessStatus.ALLOWED) {
            this.disableRules();
            try {
                if (!this.nodeService.exists(nodeRef)) {
                    throw new RuleServiceException("The node does not exist.");
                }
                NodeRef ruleNodeRef = rule.getNodeRef();
                if (ruleNodeRef == null) {
                    if (!this.nodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES)) {
                        this.nodeService.addAspect(nodeRef, RuleModel.ASPECT_RULES, null);
                    }
                    ruleNodeRef = this.nodeService.createNode(this.getSavedRuleFolderRef(nodeRef), ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/rule/1.0", (String)(this.ASSOC_NAME_RULES_PREFIX + GUID.generate())), RuleModel.TYPE_RULE).getChildRef();
                    rule.setNodeRef(ruleNodeRef);
                }
                this.nodeService.setProperty(ruleNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)rule.getTitle()));
                this.nodeService.setProperty(ruleNodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)rule.getDescription()));
                this.nodeService.setProperty(ruleNodeRef, RuleModel.PROP_RULE_TYPE, (Serializable)((Object)rule.getRuleTypes()));
                this.nodeService.setProperty(ruleNodeRef, RuleModel.PROP_APPLY_TO_CHILDREN, (Serializable)Boolean.valueOf(rule.isAppliedToChildren()));
                this.nodeService.setProperty(ruleNodeRef, RuleModel.PROP_EXECUTE_ASYNC, (Serializable)Boolean.valueOf(rule.getExecuteAsynchronously()));
                this.nodeService.setProperty(ruleNodeRef, RuleModel.PROP_DISABLED, (Serializable)Boolean.valueOf(rule.getRuleDisabled()));
                this.saveAction(ruleNodeRef, rule);
            }
            finally {
                this.enableRules();
                this.nodeRulesCache.remove((Serializable)nodeRef);
            }
        } else {
            throw new RuleServiceException("Insufficient permissions to save a rule.");
        }
    }

    @Override
    public void saveRule(NodeRef nodeRef, Rule rule, int index) {
        this.saveRule(nodeRef, rule);
        this.setRulePosition(nodeRef, rule.getNodeRef(), index);
    }

    @Override
    public void setRulePosition(NodeRef nodeRef, NodeRef ruleNodeRef, int index) {
        NodeRef ruleFolder = this.getSavedRuleFolderRef(nodeRef);
        if (ruleFolder != null) {
            List assocs = this.runtimeNodeService.getChildAssocs(ruleFolder, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.ASSOC_NAME_RULES_REGEX);
            ArrayList<ChildAssociationRef> orderedAssocs = new ArrayList<ChildAssociationRef>(assocs.size());
            ChildAssociationRef movedAssoc = null;
            for (ChildAssociationRef assoc : assocs) {
                NodeRef childNodeRef = assoc.getChildRef();
                if (childNodeRef.equals((Object)ruleNodeRef)) {
                    movedAssoc = assoc;
                    continue;
                }
                orderedAssocs.add(assoc);
            }
            if (movedAssoc != null) {
                orderedAssocs.add(index, movedAssoc);
            }
            index = 0;
            for (ChildAssociationRef orderedAssoc : orderedAssocs) {
                this.nodeService.setChildAssociationIndex(orderedAssoc, index);
                ++index;
            }
        }
    }

    @Override
    public void setRulePosition(NodeRef nodeRef, Rule rule, int index) {
        this.setRulePosition(nodeRef, rule.getNodeRef(), index);
    }

    private void saveAction(NodeRef ruleNodeRef, Rule rule) {
        Action action = rule.getAction();
        if (action == null) {
            throw new RuleServiceException("An action must be specified when defining a rule.");
        }
        NodeRef actionNodeRef = null;
        List actions = this.nodeService.getChildAssocs(ruleNodeRef, (QNamePattern)RuleModel.ASSOC_ACTION, (QNamePattern)RuleModel.ASSOC_ACTION);
        if (actions.size() == 1) {
            actionNodeRef = ((ChildAssociationRef)actions.get(0)).getChildRef();
            if (!actionNodeRef.getId().equals(action.getId())) {
                this.nodeService.deleteNode(actionNodeRef);
                actionNodeRef = null;
            }
        } else if (actions.size() > 1) {
            throw new RuleServiceException("The rule has become corrupt.  More than one action is associated with the rule.");
        }
        if (actionNodeRef == null) {
            actionNodeRef = this.runtimeActionService.createActionNodeRef(action, ruleNodeRef, RuleModel.ASSOC_ACTION, RuleModel.ASSOC_ACTION);
        }
        this.runtimeActionService.saveActionImpl(actionNodeRef, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeRule(NodeRef nodeRef, Rule rule) {
        this.checkForLinkedRules(nodeRef);
        if (this.permissionService.hasPermission(nodeRef, "ChangePermissions") != AccessStatus.ALLOWED) throw new RuleServiceException("Insufficient permissions to remove a rule.");
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES)) {
            this.disableRules(nodeRef);
            try {
                NodeRef ruleNodeRef = rule.getNodeRef();
                if (ruleNodeRef != null) {
                    this.nodeService.removeChild(this.getSavedRuleFolderRef(nodeRef), ruleNodeRef);
                }
            }
            finally {
                this.enableRules(nodeRef);
            }
        }
        this.nodeRulesCache.remove((Serializable)nodeRef);
    }

    private void checkForLinkedRules(NodeRef nodeRef) {
        if (this.isLinkedToRuleNode(nodeRef)) {
            throw new RuleServiceException("Can not edit rules as they are linked to another rule set.");
        }
    }

    @Override
    public void removeAllRules(NodeRef nodeRef) {
        this.checkForLinkedRules(nodeRef);
        if (this.permissionService.hasPermission(nodeRef, "ChangePermissions") == AccessStatus.ALLOWED) {
            NodeRef folder;
            if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES) && (folder = this.getSavedRuleFolderRef(nodeRef)) != null) {
                List ruleChildAssocs = this.nodeService.getChildAssocs(folder, RegexQNamePattern.MATCH_ALL, (QNamePattern)this.ASSOC_NAME_RULES_REGEX);
                for (ChildAssociationRef ruleChildAssoc : ruleChildAssocs) {
                    this.nodeService.removeChild(folder, ruleChildAssoc.getChildRef());
                }
            }
        } else {
            throw new RuleServiceException("Insufficient permissions to remove a rule.");
        }
        this.nodeRulesCache.remove((Serializable)nodeRef);
    }

    @Override
    public void addRulePendingExecution(NodeRef actionableNodeRef, NodeRef actionedUponNodeRef, Rule rule) {
        this.addRulePendingExecution(actionableNodeRef, actionedUponNodeRef, rule, false);
    }

    @Override
    public void removeRulePendingExecution(NodeRef actionedUponNodeRef) {
        ParameterCheck.mandatory((String)"actionedUponNodeRef", (Object)actionedUponNodeRef);
        List pendingRules = (List)AlfrescoTransactionSupport.getResource(KEY_RULES_PENDING);
        if (pendingRules != null) {
            boolean listUpdated = false;
            ArrayList temp = new ArrayList(pendingRules);
            for (PendingRuleData pendingRuleData : temp) {
                if (!pendingRuleData.getActionedUponNodeRef().equals((Object)actionedUponNodeRef)) continue;
                pendingRules.remove(pendingRuleData);
                listUpdated = true;
            }
            if (listUpdated) {
                AlfrescoTransactionSupport.bindResource(KEY_RULES_PENDING, pendingRules);
                AlfrescoTransactionSupport.bindListener(this.ruleTransactionListener);
            }
        }
    }

    @Override
    public void addRulePendingExecution(NodeRef actionableNodeRef, NodeRef actionedUponNodeRef, Rule rule, boolean executeAtEnd) {
        ParameterCheck.mandatory((String)"actionableNodeRef", (Object)actionableNodeRef);
        ParameterCheck.mandatory((String)"actionedUponNodeRef", (Object)actionedUponNodeRef);
        if (this.isEnabled() && !this.disabledNodeRefs.contains(this.getOwningNodeRef(rule)) && !this.disabledRules.contains(rule)) {
            PendingRuleData pendingRuleData = new PendingRuleData(actionableNodeRef, actionedUponNodeRef, rule, executeAtEnd);
            ArrayList<PendingRuleData> pendingRules = (ArrayList<PendingRuleData>)AlfrescoTransactionSupport.getResource(KEY_RULES_PENDING);
            if (pendingRules == null) {
                pendingRules = new ArrayList<PendingRuleData>();
                AlfrescoTransactionSupport.bindResource(KEY_RULES_PENDING, pendingRules);
                AlfrescoTransactionSupport.bindListener(this.ruleTransactionListener);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Rule '" + rule.getTitle() + "' has been added pending execution to action upon node '" + actionedUponNodeRef.getId() + "'"));
                }
            }
            if (!pendingRules.contains(pendingRuleData)) {
                pendingRules.add(pendingRuleData);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("The rule '" + rule.getTitle() + "' or the node '" + this.getOwningNodeRef(rule).getId() + "' has been disabled."));
        }
    }

    @Override
    public void executePendingRules() {
        if (AlfrescoTransactionSupport.getResource(KEY_RULES_EXECUTED) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Creating the executed rules list");
            }
            AlfrescoTransactionSupport.bindResource(KEY_RULES_EXECUTED, new HashSet());
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"Executed rules list already exists");
        }
        ArrayList<PendingRuleData> executeAtEndRules = new ArrayList<PendingRuleData>();
        this.executePendingRulesImpl(executeAtEndRules);
        for (PendingRuleData data : executeAtEndRules) {
            this.executePendingRule(data);
        }
    }

    private void executePendingRulesImpl(List<PendingRuleData> executeAtEndRules) {
        List pendingRules = (List)AlfrescoTransactionSupport.getResource(KEY_RULES_PENDING);
        if (pendingRules != null && !pendingRules.isEmpty()) {
            PendingRuleData[] pendingRulesArr = pendingRules.toArray(new PendingRuleData[0]);
            AlfrescoTransactionSupport.unbindResource(KEY_RULES_PENDING);
            for (PendingRuleData pendingRule : pendingRulesArr) {
                if (!pendingRule.getExecuteAtEnd()) {
                    this.executePendingRule(pendingRule);
                    continue;
                }
                executeAtEndRules.add(pendingRule);
            }
            this.executePendingRulesImpl(executeAtEndRules);
        }
    }

    private void executePendingRule(PendingRuleData pendingRule) {
        NodeRef newRuleNodeRef;
        Set executedRules = (Set)AlfrescoTransactionSupport.getResource(KEY_RULES_EXECUTED);
        NodeRef actionedUponNodeRef = pendingRule.getActionedUponNodeRef();
        Rule rule = pendingRule.getRule();
        NodeRef ruleNodeRef = rule.getNodeRef();
        if (!ruleNodeRef.getStoreRef().equals((Object)actionedUponNodeRef.getStoreRef()) && !this.nodeService.exists(ruleNodeRef) && this.nodeService.exists(newRuleNodeRef = new NodeRef(actionedUponNodeRef.getStoreRef(), ruleNodeRef.getId()))) {
            ruleNodeRef = newRuleNodeRef;
        }
        rule = this.getRule(ruleNodeRef);
        if (executedRules == null || this.canExecuteRule(executedRules, actionedUponNodeRef, rule)) {
            this.executeRule(rule, actionedUponNodeRef, executedRules);
        }
    }

    @Override
    public void executeRule(Rule rule, NodeRef actionedUponNodeRef, Set<ExecutedRuleData> executedRules) {
        Action action = rule.getAction();
        if (action == null) {
            throw new RuleServiceException("Attempting to execute a rule that does not have a rule specified.");
        }
        if (this.actionService.evaluateAction(action, actionedUponNodeRef)) {
            if (executedRules != null) {
                executedRules.add(new ExecutedRuleData(actionedUponNodeRef, rule));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" ... Adding rule (" + rule.getTitle() + ") and nodeRef (" + actionedUponNodeRef.getId() + ") to executed list"));
                }
            }
            boolean executeAsync = rule.getExecuteAsynchronously();
            this.actionService.executeAction(action, actionedUponNodeRef, true, executeAsync);
        }
    }

    private boolean canExecuteRule(Set<ExecutedRuleData> executedRules, NodeRef actionedUponNodeRef, Rule rule) {
        boolean result = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" >> Current executed items count = " + executedRules.size()));
        }
        if (executedRules != null) {
            if (executedRules.contains(new ExecutedRuleData(actionedUponNodeRef, rule))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" >> Already executed this rule (" + rule.getTitle() + ") on this nodeRef (" + actionedUponNodeRef.getId() + ")"));
                }
                result = false;
            } else {
                result = this.checkForCopy(executedRules, actionedUponNodeRef, rule);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)(" >> Executed this rule (" + rule.getTitle() + ") on (" + actionedUponNodeRef.getId() + ") executed rule is null"));
        }
        return result;
    }

    private boolean checkForCopy(Set<ExecutedRuleData> executedRules, NodeRef actionedUponNodeRef, Rule rule) {
        boolean result = true;
        if (this.nodeService.exists(actionedUponNodeRef) && this.permissionService.hasPermission(actionedUponNodeRef, "Read").equals((Object)AccessStatus.ALLOWED) && this.nodeService.hasAspect(actionedUponNodeRef, ContentModel.ASPECT_COPIEDFROM)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" >> Has the copied from aspect (" + actionedUponNodeRef.getId() + ")"));
            }
            NodeRef copiedFrom = (NodeRef)this.nodeService.getProperty(actionedUponNodeRef, ContentModel.PROP_COPY_REFERENCE);
            if (logger.isDebugEnabled() && copiedFrom != null) {
                logger.debug((Object)(" >> Got the copedFrom nodeRef (" + copiedFrom.getId() + ")"));
            }
            if (copiedFrom != null) {
                if (executedRules.contains(new ExecutedRuleData(copiedFrom, rule))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(" >> Already executed this rule (" + rule.getTitle() + ") on this the copied from nodeRef (" + copiedFrom.getId() + ")"));
                    }
                    return false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(" >> Executed this rule (" + rule.getTitle() + ") on (" + actionedUponNodeRef.getId() + ") copiedFrom is not is list"));
                    logger.debug((Object)"  > Checking copy");
                }
                result = this.checkForCopy(executedRules, copiedFrom, rule);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)(" >> Executed this rule (" + rule.getTitle() + ") on (" + actionedUponNodeRef.getId() + ") no copied from aspect"));
        }
        return result;
    }

    @Override
    public void registerRuleType(RuleType ruleType) {
        this.ruleTypes.put(ruleType.getName(), ruleType);
    }

    @Override
    public NodeRef getOwningNodeRef(Rule rule) {
        NodeRef result = null;
        NodeRef ruleNodeRef = rule.getNodeRef();
        if (ruleNodeRef != null) {
            result = this.getOwningNodeRefRuleImpl(ruleNodeRef);
        }
        return result;
    }

    private NodeRef getOwningNodeRefRuleImpl(NodeRef ruleNodeRef) {
        NodeRef systemFolder = this.nodeService.getPrimaryParent(ruleNodeRef).getParentRef();
        return this.nodeService.getPrimaryParent(systemFolder).getParentRef();
    }

    @Override
    public NodeRef getOwningNodeRef(Action action) {
        NodeRef result = null;
        NodeRef actionNodeRef = action.getNodeRef();
        if (actionNodeRef != null) {
            result = this.getOwningNodeRefActionImpl(actionNodeRef);
        }
        return result;
    }

    private NodeRef getOwningNodeRefActionImpl(NodeRef actionNodeRef) {
        NodeRef result = null;
        NodeRef parentNodeRef = this.nodeService.getPrimaryParent(actionNodeRef).getParentRef();
        if (parentNodeRef != null) {
            QName parentType = this.nodeService.getType(parentNodeRef);
            if (RuleModel.TYPE_RULE.equals((Object)parentType)) {
                result = this.getOwningNodeRefRuleImpl(parentNodeRef);
            } else if (ActionModel.TYPE_COMPOSITE_ACTION.equals((Object)parentType)) {
                result = this.getOwningNodeRefActionImpl(parentNodeRef);
            }
        }
        return result;
    }

    @Override
    public boolean isLinkedToRuleNode(NodeRef nodeRef) {
        return this.getLinkedToRuleNode(nodeRef) != null;
    }

    @Override
    public NodeRef getLinkedToRuleNode(NodeRef nodeRef) {
        ChildAssociationRef assoc;
        NodeRef result = null;
        if (this.nodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES) && !(assoc = this.getSavedRuleFolderAssoc(nodeRef)).isPrimary()) {
            result = this.nodeService.getPrimaryParent(assoc.getChildRef()).getParentRef();
        }
        return result;
    }

    @Override
    public List<NodeRef> getLinkedFromRuleNodes(NodeRef nodeRef) {
        ChildAssociationRef assoc;
        ArrayList<NodeRef> result = new ArrayList<NodeRef>();
        if (this.nodeService.hasAspect(nodeRef, RuleModel.ASPECT_RULES) && (assoc = this.getSavedRuleFolderAssoc(nodeRef)).isPrimary()) {
            List linkedAssocs = this.nodeService.getParentAssocs(assoc.getChildRef());
            for (ChildAssociationRef linkAssoc : linkedAssocs) {
                if (linkAssoc.isPrimary()) continue;
                result.add(linkAssoc.getParentRef());
            }
        }
        return result;
    }

    private class PendingRuleData
    extends ExecutedRuleData {
        private NodeRef actionedUponNodeRef;
        private boolean executeAtEnd;

        public PendingRuleData(NodeRef actionableNodeRef, NodeRef actionedUponNodeRef, Rule rule, boolean executeAtEnd) {
            super(actionableNodeRef, rule);
            this.executeAtEnd = false;
            this.actionedUponNodeRef = actionedUponNodeRef;
            this.executeAtEnd = executeAtEnd;
        }

        public NodeRef getActionedUponNodeRef() {
            return this.actionedUponNodeRef;
        }

        public boolean getExecuteAtEnd() {
            return this.executeAtEnd;
        }

        public int hashCode() {
            int i = super.hashCode();
            i = i * 37 + this.actionedUponNodeRef.hashCode();
            return i;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PendingRuleData) {
                PendingRuleData that = (PendingRuleData)obj;
                return this.actionableNodeRef.equals((Object)that.actionableNodeRef) && this.actionedUponNodeRef.equals((Object)that.actionedUponNodeRef) && this.rule.equals(that.rule);
            }
            return false;
        }
    }

    public class ExecutedRuleData {
        protected NodeRef actionableNodeRef;
        protected Rule rule;

        public ExecutedRuleData(NodeRef actionableNodeRef, Rule rule) {
            this.actionableNodeRef = actionableNodeRef;
            this.rule = rule;
        }

        public NodeRef getActionableNodeRef() {
            return this.actionableNodeRef;
        }

        public Rule getRule() {
            return this.rule;
        }

        public int hashCode() {
            int i = this.actionableNodeRef.hashCode();
            i = i * 37 + this.rule.hashCode();
            return i;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ExecutedRuleData) {
                ExecutedRuleData that = (ExecutedRuleData)obj;
                return this.actionableNodeRef.equals((Object)that.actionableNodeRef) && this.rule.equals(that.rule);
            }
            return false;
        }
    }
}

