/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule.ruletrigger;

import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.rule.ruletrigger.RuleTriggerAbstractBase;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnContentUpdateRuleTrigger
extends RuleTriggerAbstractBase
implements ContentServicePolicies.OnContentUpdatePolicy {
    private static Log logger = LogFactory.getLog(OnContentUpdateRuleTrigger.class);
    private boolean onNewContent = false;
    private boolean triggerParentRules = true;

    public void setOnNewContent(boolean onNewContent) {
        this.onNewContent = onNewContent;
    }

    public void setTriggerParentRules(boolean triggerParentRules) {
        this.triggerParentRules = triggerParentRules;
    }

    public void registerRuleTrigger() {
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onContentUpdate"));
    }

    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        boolean fail = false;
        if (newContent) {
            ContentReader contentReader;
            boolean editInline;
            Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"editInline"));
            if (value != null && (editInline = value.booleanValue())) {
                fail = true;
            }
            if (!(fail || (contentReader = this.contentService.getReader(nodeRef, ContentModel.PROP_CONTENT)) != null && contentReader.exists() && !this.isZeroLengthOfficeDoc(contentReader))) {
                fail = true;
            }
        }
        if (!fail && newContent == this.onNewContent) {
            if (this.triggerParentRules) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("OnContentUpdate rule triggered fired for content; nodeId=" + nodeRef.getId() + "; newContent=" + newContent));
                }
                List parentsAssocRefs = this.nodeService.getParentAssocs(nodeRef);
                for (ChildAssociationRef parentAssocRef : parentsAssocRefs) {
                    this.triggerRules(parentAssocRef.getParentRef(), nodeRef);
                }
            } else {
                this.triggerRules(nodeRef, nodeRef);
            }
        }
    }

    private boolean isZeroLengthOfficeDoc(ContentReader contentReader) {
        boolean result = false;
        if (contentReader.getSize() == 0L && ("application/msword".equals(contentReader.getMimetype()) || "application/vnd.ms-excel".equals(contentReader.getMimetype()) || "application/vnd.ms-powerpoint".equals(contentReader.getMimetype()))) {
            result = true;
        }
        return result;
    }
}

