/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.dictionary.DictionaryNamespaceComponent;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.NamespaceDAOImpl;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.node.NodeBulkLoader;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.search.QueryRegisterComponent;
import org.alfresco.repo.search.impl.lucene.ADMLuceneIndexerImpl;
import org.alfresco.repo.search.impl.lucene.ADMLuceneSearcherImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneIndexerAndSearcherFactory;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.analysis.DateTimeAnalyser;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.search.impl.querymodel.QueryEngine;
import org.alfresco.repo.search.results.ChildAssocRefResultSet;
import org.alfresco.repo.search.results.DetachedResultSet;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.Period;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.service.cmr.search.QueryParameter;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO9075;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ADMLuceneTest
extends TestCase
implements DictionaryListener {
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/lucenetest";
    private static final QName ASSOC_TYPE_QNAME = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"assoc");
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static Log logger = LogFactory.getLog(ADMLuceneTest.class);
    QName createdDate = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"createdDate");
    QName orderDouble = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderDouble");
    QName orderFloat = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderFloat");
    QName orderLong = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderLong");
    QName orderInt = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderInt");
    QName orderText = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderText");
    QName orderMLText = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"orderMLText");
    QName aspectWithChildren = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"aspectWithChildren");
    TransactionService transactionService;
    RetryingTransactionHelper retryingTransactionHelper;
    NodeService nodeService;
    DictionaryService dictionaryService;
    TenantService tenantService;
    private NodeRef rootNodeRef;
    private NodeRef n1;
    private NodeRef n2;
    private NodeRef n3;
    private NodeRef n4;
    private NodeRef n5;
    private NodeRef n6;
    private NodeRef n7;
    private NodeRef n8;
    private NodeRef n9;
    private NodeRef n10;
    private NodeRef n11;
    private NodeRef n12;
    private NodeRef n13;
    private NodeRef n14;
    private DictionaryDAO dictionaryDAO;
    private FullTextSearchIndexer luceneFTS;
    private QName testType = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"testType");
    private QName testSuperType = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"testSuperType");
    private QName testAspect = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"testAspect");
    private QName testSuperAspect = QName.createQName((String)"http://www.alfresco.org/test/lucenetest", (String)"testSuperAspect");
    private ContentService contentService;
    private QueryRegisterComponent queryRegisterComponent;
    private DictionaryNamespaceComponent namespacePrefixResolver;
    private LuceneIndexerAndSearcher indexerAndSearcher;
    private ServiceRegistry serviceRegistry;
    private UserTransaction testTX;
    private AuthenticationComponent authenticationComponent;
    private NodeRef[] documentOrder;
    private NamespaceDAOImpl namespaceDao;
    private Date testDate;
    private NodeBulkLoader nodeBulkLoader;
    private QueryEngine queryEngine;
    private NodeRef n15;
    private M2Model model;
    private Dialect dialect;
    private double orderDoubleCount = -0.11;
    private Date orderDate = new Date();
    private float orderFloatCount = -3.5556f;
    private long orderLongCount = -1999999999999999L;
    private int orderIntCount = -45764576;
    private int orderTextCount = 0;

    public ADMLuceneTest() {
    }

    public void afterDictionaryDestroy() {
    }

    public void afterDictionaryInit() {
    }

    public void onDictionaryInit() {
        this.dictionaryDAO.putModel(this.model);
        this.namespaceDao.addPrefix("test", TEST_NAMESPACE);
    }

    public void setUp() throws Exception {
        this.dialect = (Dialect)ctx.getBean("dialect");
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
        this.dictionaryService = (DictionaryService)ctx.getBean("dictionaryService");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        this.luceneFTS = (FullTextSearchIndexer)ctx.getBean("LuceneFullTextSearchIndexer");
        this.contentService = (ContentService)ctx.getBean("contentService");
        this.queryRegisterComponent = (QueryRegisterComponent)ctx.getBean("queryRegisterComponent");
        this.namespacePrefixResolver = (DictionaryNamespaceComponent)ctx.getBean("namespaceService");
        this.indexerAndSearcher = (LuceneIndexerAndSearcher)ctx.getBean("admLuceneIndexerAndSearcherFactory");
        ((AbstractLuceneIndexerAndSearcherFactory)this.indexerAndSearcher).setMaxAtomicTransformationTime(1000000L);
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.retryingTransactionHelper = (RetryingTransactionHelper)ctx.getBean("retryingTransactionHelper");
        this.tenantService = (TenantService)ctx.getBean("tenantService");
        this.queryEngine = (QueryEngine)ctx.getBean("adm.luceneQueryEngineImpl");
        this.nodeBulkLoader = (NodeBulkLoader)ctx.getBean("nodeDAO");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.namespaceDao = (NamespaceDAOImpl)ctx.getBean("namespaceDAO");
        I18NUtil.setLocale((Locale)Locale.UK);
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.queryRegisterComponent.loadQueryCollection("testQueryRegister.xml");
        ADMLuceneTest.assertEquals((boolean)true, (boolean)ctx.isSingleton("LuceneFullTextSearchIndexer"));
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("org/alfresco/repo/search/impl/lucene/LuceneTest_model.xml");
        ADMLuceneTest.assertNotNull((Object)modelStream);
        this.model = M2Model.createModel((InputStream)modelStream);
        this.dictionaryDAO.register((DictionaryListener)this);
        this.dictionaryDAO.reset();
        ADMLuceneTest.assertNotNull((Object)this.dictionaryDAO.getClass(this.testSuperType));
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}one"), this.testSuperType, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n1, QName.createQName((String)"{namespace}property-1"), (Serializable)((Object)"ValueOne"));
        this.n2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}two"), this.testSuperType, this.getOrderProperties()).getChildRef();
        this.nodeService.setProperty(this.n2, QName.createQName((String)"{namespace}property-1"), (Serializable)((Object)"valueone"));
        this.nodeService.setProperty(this.n2, QName.createQName((String)"{namespace}property-2"), (Serializable)((Object)"valuetwo"));
        this.n3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}three"), this.testSuperType, this.getOrderProperties()).getChildRef();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.n3);
            oos.close();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            Object o = ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        HashMap<QName, Object> testProperties = new HashMap<QName, Object>();
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic"), "TEXT THAT IS INDEXED STORED AND TOKENISED ATOMICALLY KEYONE");
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-unstored-tokenised-atomic"), "TEXT THAT IS INDEXED STORED AND TOKENISED ATOMICALLY KEYUNSTORED");
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-nonatomic"), "TEXT THAT IS INDEXED STORED AND TOKENISED BUT NOT ATOMICALLY KEYTWO");
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"int-ista"), 1);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"long-ista"), 2L);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"float-ista"), Float.valueOf(3.4f));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"double-ista"), 5.6);
        this.testDate = new Date(new Date().getTime() - 10000L);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"date-ista"), this.testDate);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista"), this.testDate);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"boolean-ista"), true);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"qname-ista"), QName.createQName((String)"{wibble}wobble"));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"category-ista"), new NodeRef(storeRef, "CategoryId"));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"noderef-ista"), this.n1);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"path-ista"), this.nodeService.getPath(this.n3));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"locale-ista"), Locale.UK);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"period-ista"), new Period("period|12"));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"null"), null);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"list"), new ArrayList());
        MLText mlText = new MLText();
        mlText.addValue(Locale.ENGLISH, "banana");
        mlText.addValue(Locale.FRENCH, "banane");
        mlText.addValue(Locale.CHINESE, "\u9999\u8549");
        mlText.addValue(new Locale("nl"), "banaan");
        mlText.addValue(Locale.GERMAN, "banane");
        mlText.addValue(new Locale("el"), "\u03bc\u03c0\u03b1\u03bd\u03ac\u03bd\u03b1");
        mlText.addValue(Locale.ITALIAN, "banana");
        mlText.addValue(new Locale("ja"), "\u30d0\u30ca\u30ca");
        mlText.addValue(new Locale("ko"), "\ubc14\ub098\ub098");
        mlText.addValue(new Locale("pt"), "banana");
        mlText.addValue(new Locale("ru"), "\u0431\u0430\u043d\u0430\u043d");
        mlText.addValue(new Locale("es"), "pl\u00e1tano");
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"ml"), mlText);
        ArrayList<Object> anyValues = new ArrayList<Object>();
        anyValues.add(100);
        anyValues.add("anyValueAsString");
        anyValues.add(new UnknownDataType());
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"any-many-ista"), anyValues);
        ArrayList<ContentData> contentValues = new ArrayList<ContentData>();
        contentValues.add(new ContentData(null, "text/plain", 0L, "UTF-16", Locale.UK));
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"content-many-ista"), contentValues);
        MLText mlText1 = new MLText();
        mlText1.addValue(Locale.ENGLISH, "cabbage");
        mlText1.addValue(Locale.FRENCH, "chou");
        MLText mlText2 = new MLText();
        mlText2.addValue(Locale.ENGLISH, "lemur");
        mlText2.addValue(new Locale("ru"), "\u043b\u0435\u043c\u0443\u0440");
        ArrayList<MLText> mlValues = new ArrayList<MLText>();
        mlValues.add(mlText1);
        mlValues.add(mlText2);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"mltext-many-ista"), mlValues);
        ArrayList<Object> testList = new ArrayList<Object>();
        testList.add(null);
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"nullist"), testList);
        ArrayList<String> testList2 = new ArrayList<String>();
        testList2.add("woof");
        testList2.add(null);
        this.n4 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}four"), this.testType, testProperties).getChildRef();
        ContentWriter multiWriter = this.contentService.getWriter(this.n4, QName.createQName((String)TEST_NAMESPACE, (String)"content-many-ista"), true);
        multiWriter.setEncoding("UTF-16");
        multiWriter.setMimetype("text/plain");
        multiWriter.putContent("multicontent");
        this.nodeService.getProperties(this.n1);
        this.nodeService.getProperties(this.n2);
        this.nodeService.getProperties(this.n3);
        this.nodeService.getProperties(this.n4);
        this.n5 = this.nodeService.createNode(this.n1, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}five"), this.testSuperType, this.getOrderProperties()).getChildRef();
        this.n6 = this.nodeService.createNode(this.n1, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}six"), this.testSuperType, this.getOrderProperties()).getChildRef();
        this.n7 = this.nodeService.createNode(this.n2, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}seven"), this.testSuperType, this.getOrderProperties()).getChildRef();
        this.n8 = this.nodeService.createNode(this.n2, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}eight-2"), this.testSuperType, this.getOrderProperties()).getChildRef();
        this.n9 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}nine"), this.testSuperType, this.getOrderProperties()).getChildRef();
        this.n10 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}ten"), this.testSuperType, this.getOrderProperties()).getChildRef();
        this.n11 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}eleven"), this.testSuperType, this.getOrderProperties()).getChildRef();
        this.n12 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}twelve"), this.testSuperType, this.getOrderProperties()).getChildRef();
        this.n13 = this.nodeService.createNode(this.n12, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}thirteen"), this.testSuperType, this.getOrderProperties()).getChildRef();
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        MLText desc1 = new MLText();
        desc1.addValue(Locale.ENGLISH, "Alfresco tutorial");
        desc1.addValue(Locale.US, "Alfresco tutorial");
        Date explicitCreatedDate = new Date();
        Thread.sleep(2000L);
        properties.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8", Locale.UK));
        properties.put(ContentModel.PROP_DESCRIPTION, desc1);
        properties.put(ContentModel.PROP_CREATED, explicitCreatedDate);
        this.n14 = this.nodeService.createNode(this.n13, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}fourteen"), ContentModel.TYPE_CONTENT, properties).getChildRef();
        ADMLuceneTest.assertEquals((Object)explicitCreatedDate, (Object)this.nodeService.getProperty(this.n14, ContentModel.PROP_CREATED));
        this.n15 = this.nodeService.createNode(this.n13, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}fifteen"), ContentModel.TYPE_THUMBNAIL, this.getOrderProperties()).getChildRef();
        ContentWriter writer = this.contentService.getWriter(this.n14, ContentModel.PROP_CONTENT, true);
        writer.setEncoding("UTF-8");
        writer.putContent("The quick brown fox jumped over the lazy dog and ate the Alfresco Tutorial, in pdf format, along with the following stop words;  a an and are as at be but by for if in into is it no not of on or such that the their then there these they this to was will with:  and random charcters \u00e0\u00ea\u00ee\u00f0\u00f1\u00f6\u00fb\u00ff");
        this.nodeService.addChild(this.rootNodeRef, this.n8, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}eight-0"));
        this.nodeService.addChild(this.n1, this.n8, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}eight-1"));
        this.nodeService.addChild(this.n2, this.n13, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}link"));
        this.nodeService.addChild(this.n1, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n2, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n5, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n6, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n12, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
        this.nodeService.addChild(this.n13, this.n14, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}common"));
        this.documentOrder = new NodeRef[]{this.rootNodeRef, this.n4, this.n5, this.n6, this.n7, this.n8, this.n9, this.n10, this.n11, this.n12, this.n13, this.n14, this.n15, this.n3, this.n1, this.n2};
    }

    public Map<QName, Serializable> getOrderProperties() {
        HashMap<QName, Serializable> testProperties = new HashMap<QName, Serializable>();
        testProperties.put(this.createdDate, this.orderDate);
        testProperties.put(this.orderDouble, Double.valueOf(this.orderDoubleCount));
        testProperties.put(this.orderFloat, Float.valueOf(this.orderFloatCount));
        testProperties.put(this.orderLong, Long.valueOf(this.orderLongCount));
        testProperties.put(this.orderInt, Integer.valueOf(this.orderIntCount));
        testProperties.put(this.orderText, (Serializable)((Object)(new String(new char[]{(char)(97 + this.orderTextCount)}) + " cabbage")));
        MLText mlText = new MLText();
        mlText.addValue(Locale.ENGLISH, new String(new char[]{(char)(97 + this.orderTextCount)}) + " banana");
        mlText.addValue(Locale.FRENCH, new String(new char[]{(char)(90 - this.orderTextCount)}) + " banane");
        mlText.addValue(Locale.CHINESE, new String(new char[]{(char)(39321 + this.orderTextCount)}) + " \u9999\u8549");
        testProperties.put(this.orderMLText, (Serializable)mlText);
        this.orderDate = Duration.subtract((Date)this.orderDate, (Duration)new Duration("P1D"));
        this.orderDoubleCount += 0.1;
        this.orderFloatCount += 0.82f;
        this.orderLongCount += 299999999999999L;
        this.orderIntCount += 8576457;
        ++this.orderTextCount;
        return testProperties;
    }

    protected void tearDown() throws Exception {
        if (this.testTX.getStatus() == 0) {
            this.testTX.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    public ADMLuceneTest(String arg0) {
        super(arg0);
    }

    public void doNotTestIndexBackAllowsReadOperations() throws Exception {
        this.testTX.commit();
        QueryDuringBackupThread queryThread = new QueryDuringBackupThread("Query", "PATH:\"//*\"", 120000L);
        queryThread.start();
        CreateDuringBackupThread createThread = new CreateDuringBackupThread("Create");
        createThread.start();
        try {
            queryThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void restManyReaders() throws Exception {
        QName propQName = QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic");
        NodeRef base = this.rootNodeRef;
        for (int i = 0; i < 10; ++i) {
            NodeRef dir = this.nodeService.createNode(base, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}d-" + i)), this.testSuperType, null).getChildRef();
            for (int j = 0; j < 100; ++j) {
                HashMap<QName, String> properties = new HashMap<QName, String>();
                properties.put(propQName, "lemon");
                NodeRef file = this.nodeService.createNode(dir, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}meep"), this.testSuperType, properties).getChildRef();
            }
        }
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        searcher.setTenantService(this.tenantService);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//meep\"");
        int count = results.length();
        ADMLuceneTest.assertTrue((count > 0 ? 1 : 0) != 0);
        results.close();
        this.testTX.commit();
        Thread runner = null;
        this.testQuery(searcher, runner, "PATH:\"//*\"");
    }

    private void testQuery(ADMLuceneSearcherImpl searcher, Thread runner, String query) {
        for (int i = 0; i < 1; ++i) {
            runner = new QueryThread("Concurrent-" + i, runner, searcher, query);
        }
        long start = System.nanoTime();
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        long end = System.nanoTime();
        System.out.println(query + "\t" + (float)(end - start) / 1.0E9f);
    }

    public void testQuoting() throws Exception {
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"te\\\"thing\\\"st\"");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.excludeDataInTheCurrentTransaction(true);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        results.close();
    }

    public void testPublicServiceSearchServicePaging() throws Exception {
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        ArrayList<NodeRef> expected = new ArrayList<NodeRef>(15);
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("fts-alfresco");
        sp.setQuery("PATH:\"//.\"");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.excludeDataInTheCurrentTransaction(true);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        ResultSetMetaData md = results.getResultSetMetaData();
        for (ResultSetRow row : results) {
            expected.add(row.getNodeRef());
        }
        results.close();
        for (int skip = 0; skip < 20; ++skip) {
            for (int max = 0; max < 20; ++max) {
                this.doPage(expected, skip, max, sp, this.serviceRegistry.getSearchService());
            }
        }
        this.authenticationComponent.setCurrentUser("admin");
        sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.excludeDataInTheCurrentTransaction(true);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        sp.setMaxPermissionChecks(2);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        sp.setLanguage("fts-alfresco");
        sp.setMaxPermissionChecks(2);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
    }

    private void doPage(List<NodeRef> expected, int skip, int max, SearchParameters sp, SearchService searcher) {
        sp.setSkipCount(skip);
        sp.setMaxItems(max);
        ResultSet results = searcher.query(sp);
        ADMLuceneTest.assertEquals((String)("Skip = " + skip + " max  = " + max), (int)(skip + max > 16 ? 16 - skip : max), (int)results.length());
        ADMLuceneTest.assertEquals((String)("Skip = " + skip + " max  = " + max), (skip + max < 16 ? 1 : 0) != 0, (boolean)results.hasMore());
        ADMLuceneTest.assertEquals((String)("Skip = " + skip + " max  = " + max), (int)skip, (int)results.getStart());
        int actualPosition = skip;
        for (ResultSetRow row : results) {
            NodeRef nodeRef = row.getNodeRef();
            ADMLuceneTest.assertEquals((String)("Skip = " + skip + " max  = " + max + " actual = " + actualPosition), (Object)expected.get(actualPosition), (Object)nodeRef);
            ++actualPosition;
        }
        results.close();
    }

    public void testNonPublicSearchServicePaging() throws InterruptedException {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        searcher.setQueryLanguages(((AbstractLuceneIndexerAndSearcherFactory)this.indexerAndSearcher).queryLanguages);
        ArrayList<NodeRef> expected = new ArrayList<NodeRef>(15);
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("fts-alfresco");
        sp.setQuery("PATH:\"//.\"");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.excludeDataInTheCurrentTransaction(true);
        ResultSet results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        ResultSetMetaData md = results.getResultSetMetaData();
        for (ResultSetRow row : results) {
            expected.add(row.getNodeRef());
        }
        results.close();
        for (int skip = 0; skip < 20; ++skip) {
            for (int max = 0; max < 20; ++max) {
                this.doPage((List<NodeRef>)expected, skip, max, sp, searcher);
            }
        }
    }

    private void doPage(List<NodeRef> expected, int skip, int max, SearchParameters sp, ADMLuceneSearcherImpl searcher) {
        sp.setSkipCount(skip);
        sp.setMaxItems(max);
        ResultSet results = searcher.query(sp);
        ADMLuceneTest.assertEquals((String)("Skip = " + skip + " max  = " + max), (int)(skip + max > 16 ? 16 - skip : max), (int)results.length());
        ADMLuceneTest.assertEquals((String)("Skip = " + skip + " max  = " + max), (skip + max < 16 ? 1 : 0) != 0, (boolean)results.hasMore());
        ADMLuceneTest.assertEquals((String)("Skip = " + skip + " max  = " + max), (int)skip, (int)results.getStart());
        int actualPosition = skip;
        for (ResultSetRow row : results) {
            NodeRef nodeRef = row.getNodeRef();
            ADMLuceneTest.assertEquals((String)("Skip = " + skip + " max  = " + max + " actual = " + actualPosition), (Object)expected.get(actualPosition), (Object)nodeRef);
            ++actualPosition;
        }
        results.close();
    }

    public void testAlfrescoSql() throws InterruptedException {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        searcher.setQueryLanguages(((AbstractLuceneIndexerAndSearcherFactory)this.indexerAndSearcher).queryLanguages);
        this.alfrescoSqlQueryWithCount(searcher, "SELECT * FROM CMIS:DOCUMENT", 1);
        this.alfrescoSqlQueryWithCount(searcher, "SELECT * FROM CMIS:DOCUMENT D JOIN CM:OWNABLE O ON D.CMIS:OBJECTID = O.CMIS:OBJECTID", 0);
    }

    public void alfrescoSqlQueryWithCount(ADMLuceneSearcherImpl searcher, String query, int count) {
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "cmis-alfresco", query, null);
        ADMLuceneTest.assertEquals((int)count, (int)results.length());
        results.getResultSetMetaData();
        results.close();
    }

    public void testCmisSql() throws InterruptedException {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        searcher.setQueryLanguages(((AbstractLuceneIndexerAndSearcherFactory)this.indexerAndSearcher).queryLanguages);
        this.sqlQueryWithCount(searcher, "SELECT * FROM CMIS:DOCUMENT", 1);
        this.sqlQueryWithCount(searcher, "SELECT * FROM CMIS:DOCUMENT D WHERE CONTAINS(D,'lazy')", 1);
    }

    public void sqlQueryWithCount(ADMLuceneSearcherImpl searcher, String query, int count) {
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "cmis-strict", query, null);
        ADMLuceneTest.assertEquals((int)count, (int)results.length());
        results.getResultSetMetaData();
        results.close();
    }

    public void testFtsSort() throws Throwable {
        String currentBun;
        this.luceneFTS.pause();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        searcher.setQueryLanguages(((AbstractLuceneIndexerAndSearcherFactory)this.indexerAndSearcher).queryLanguages);
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("fts-alfresco");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setQuery("-eager or -dog");
        sp.addQueryTemplate("ANDY", "%cm:content");
        sp.setNamespace("http://www.alfresco.org/model/content/1.0");
        sp.excludeDataInTheCurrentTransaction(true);
        sp.addSort(ContentModel.PROP_NODE_UUID.toString(), true);
        ResultSet results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        String f = null;
        for (ResultSetRow row : results) {
            currentBun = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_NODE_UUID));
            if (f != null) {
                ADMLuceneTest.assertTrue((f.compareTo(currentBun) <= 0 ? 1 : 0) != 0);
            }
            f = currentBun;
        }
        results.close();
        sp = new SearchParameters();
        sp.setLanguage("fts-alfresco");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setQuery("-eager or -dog");
        sp.addQueryTemplate("ANDY", "%cm:content");
        sp.setNamespace("http://www.alfresco.org/model/content/1.0");
        sp.excludeDataInTheCurrentTransaction(true);
        sp.addSort(ContentModel.PROP_NODE_UUID.toString(), false);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        f = null;
        for (ResultSetRow row : results) {
            currentBun = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_NODE_UUID));
            if (f != null) {
                ADMLuceneTest.assertTrue((f.compareTo(currentBun) >= 0 ? 1 : 0) != 0);
            }
            f = currentBun;
        }
        results.close();
        sp = new SearchParameters();
        sp.setLanguage("fts-alfresco");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setQuery("-eager or -dog");
        sp.addQueryTemplate("ANDY", "%cm:content");
        sp.setNamespace("http://www.alfresco.org/model/content/1.0");
        sp.excludeDataInTheCurrentTransaction(true);
        sp.addSort("@" + ContentModel.PROP_NODE_UUID.toString(), false);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        f = null;
        for (ResultSetRow row : results) {
            currentBun = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_NODE_UUID));
            if (f != null) {
                ADMLuceneTest.assertTrue((f.compareTo(currentBun) >= 0 ? 1 : 0) != 0);
            }
            f = currentBun;
        }
        results.close();
        sp = new SearchParameters();
        sp.setLanguage("fts-alfresco");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setQuery("-eager or -dog");
        sp.addQueryTemplate("ANDY", "%cm:content");
        sp.setNamespace("http://www.alfresco.org/model/content/1.0");
        sp.excludeDataInTheCurrentTransaction(true);
        sp.addSort("cm:name", false);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        f = null;
        for (ResultSetRow row : results) {
            currentBun = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_NODE_UUID));
            if (f != null) {
                ADMLuceneTest.assertTrue((f.compareTo(currentBun) >= 0 ? 1 : 0) != 0);
            }
            f = currentBun;
        }
        results.close();
        sp = new SearchParameters();
        sp.setLanguage("fts-alfresco");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setQuery("-eager or -dog");
        sp.addQueryTemplate("ANDY", "%cm:content");
        sp.setNamespace("http://www.alfresco.org/model/content/1.0");
        sp.excludeDataInTheCurrentTransaction(true);
        sp.addSort("test:neverIndexed", false);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
    }

    public void testFTS() throws InterruptedException {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        searcher.setQueryLanguages(((AbstractLuceneIndexerAndSearcherFactory)this.indexerAndSearcher).queryLanguages);
        this.ftsQueryWithCount(searcher, "\"lazy\"", 1);
        this.ftsQueryWithCount(searcher, "lazy and dog", 1);
        this.ftsQueryWithCount(searcher, "-lazy and -dog", 15);
        this.ftsQueryWithCount(searcher, "-lazy and dog", 0);
        this.ftsQueryWithCount(searcher, "lazy and -dog", 0);
        this.ftsQueryWithCount(searcher, "|lazy and |dog", 1);
        this.ftsQueryWithCount(searcher, "|eager and |dog", 1);
        this.ftsQueryWithCount(searcher, "|lazy and |wolf", 1);
        this.ftsQueryWithCount(searcher, "|eager and |wolf", 0);
        this.ftsQueryWithCount(searcher, "-lazy or -dog", 15);
        this.ftsQueryWithCount(searcher, "-eager or -dog", 16);
        this.ftsQueryWithCount(searcher, "-lazy or -wolf", 16);
        this.ftsQueryWithCount(searcher, "-eager or -wolf", 16);
        this.ftsQueryWithCount(searcher, "lazy dog", 1);
        this.ftsQueryWithCount(searcher, "lazy and not dog", 0);
        this.ftsQueryWithCount(searcher, "lazy not dog", 16);
        this.ftsQueryWithCount(searcher, "lazy and !dog", 0);
        this.ftsQueryWithCount(searcher, "lazy !dog", 16);
        this.ftsQueryWithCount(searcher, "lazy and -dog", 0);
        this.ftsQueryWithCount(searcher, "lazy -dog", 16);
        this.ftsQueryWithCount(searcher, "TEXT:\"lazy\"", 1);
        this.ftsQueryWithCount(searcher, "cm_content:\"lazy\"", 1);
        this.ftsQueryWithCount(searcher, "cm:content:big OR cm:content:lazy", 1);
        this.ftsQueryWithCount(searcher, "cm:content:big AND cm:content:lazy", 0);
        this.ftsQueryWithCount(searcher, "{http://www.alfresco.org/model/content/1.0}content:\"lazy\"", 1);
        this.ftsQueryWithCount(searcher, "=lazy", 1);
        this.ftsQueryWithCount(searcher, "@cm:content:big OR @cm:content:lazy", 1);
        this.ftsQueryWithCount(searcher, "@cm:content:big AND @cm:content:lazy", 0);
        this.ftsQueryWithCount(searcher, "@{http://www.alfresco.org/model/content/1.0}content:\"lazy\"", 1);
        this.ftsQueryWithCount(searcher, "~@cm:content:big OR ~@cm:content:lazy", 1);
        this.ftsQueryWithCount(searcher, "brown * quick", 0);
        this.ftsQueryWithCount(searcher, "brown * dog", 1);
        this.ftsQueryWithCount(searcher, "brown * dog", 1);
        this.ftsQueryWithCount(searcher, "brown *(0) dog", 0);
        this.ftsQueryWithCount(searcher, "brown *(1) dog", 0);
        this.ftsQueryWithCount(searcher, "brown *(2) dog", 0);
        this.ftsQueryWithCount(searcher, "brown *(3) dog", 0);
        this.ftsQueryWithCount(searcher, "brown *(4) dog", 1);
        this.ftsQueryWithCount(searcher, "brown *(5) dog", 1);
        this.ftsQueryWithCount(searcher, "brown *(6) dog", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(\"lazy\")", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(lazy and dog)", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(-lazy and -dog)", 15);
        this.ftsQueryWithCount(searcher, "TEXT:(-lazy and dog)", 0);
        this.ftsQueryWithCount(searcher, "TEXT:(lazy and -dog)", 0);
        this.ftsQueryWithCount(searcher, "TEXT:(|lazy and |dog)", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(|eager and |dog)", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(|lazy and |wolf)", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(|eager and |wolf)", 0);
        this.ftsQueryWithCount(searcher, "TEXT:(-lazy or -dog)", 15);
        this.ftsQueryWithCount(searcher, "TEXT:(-eager or -dog)", 16);
        this.ftsQueryWithCount(searcher, "TEXT:(-lazy or -wolf)", 16);
        this.ftsQueryWithCount(searcher, "TEXT:(-eager or -wolf)", 16);
        this.ftsQueryWithCount(searcher, "TEXT:(lazy dog)", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(lazy and not dog)", 0);
        this.ftsQueryWithCount(searcher, "TEXT:(lazy not dog)", 16);
        this.ftsQueryWithCount(searcher, "TEXT:(lazy and !dog)", 0);
        this.ftsQueryWithCount(searcher, "TEXT:(lazy !dog)", 16);
        this.ftsQueryWithCount(searcher, "TEXT:(lazy and -dog)", 0);
        this.ftsQueryWithCount(searcher, "TEXT:(lazy -dog)", 16);
        this.ftsQueryWithCount(searcher, "cm_content:(\"lazy\")", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(big OR lazy)", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(big AND lazy)", 0);
        this.ftsQueryWithCount(searcher, "{http://www.alfresco.org/model/content/1.0}content:(\"lazy\")", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(=lazy)", 1);
        this.ftsQueryWithCount(searcher, "@cm:content:(big) OR @cm:content:(lazy)", 1);
        this.ftsQueryWithCount(searcher, "@cm:content:(big) AND @cm:content:(lazy)", 0);
        this.ftsQueryWithCount(searcher, "@{http://www.alfresco.org/model/content/1.0}content:(\"lazy\")", 1);
        this.ftsQueryWithCount(searcher, "@cm:content:(~big OR ~lazy)", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(brown * quick)", 0);
        this.ftsQueryWithCount(searcher, "TEXT:(brown * dog)", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(brown * dog)", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(brown *(0) dog)", 0);
        this.ftsQueryWithCount(searcher, "TEXT:(brown *(1) dog)", 0);
        this.ftsQueryWithCount(searcher, "TEXT:(brown *(2) dog)", 0);
        this.ftsQueryWithCount(searcher, "TEXT:(brown *(3) dog)", 0);
        this.ftsQueryWithCount(searcher, "TEXT:(brown *(4) dog)", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(brown *(5) dog)", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(brown *(6) dog)", 1);
        this.ftsQueryWithCount(searcher, "cm:content.mimetype:\"text/plain\"", 1);
        this.ftsQueryWithCount(searcher, "cm_content.mimetype:\"text/plain\"", 1);
        this.ftsQueryWithCount(searcher, "@cm:content.mimetype:\"text/plain\"", 1);
        this.ftsQueryWithCount(searcher, "@cm_content.mimetype:\"text/plain\"", 1);
        this.ftsQueryWithCount(searcher, "content.mimetype:\"text/plain\"", 1);
        this.ftsQueryWithCount(searcher, "@{http://www.alfresco.org/model/content/1.0}content.mimetype:\"text/plain\"", 1);
        this.ftsQueryWithCount(searcher, "{http://www.alfresco.org/model/content/1.0}content.mimetype:\"text/plain\"", 1);
        try {
            this.ftsQueryWithCount(searcher, "brown..dog", 1);
            ADMLuceneTest.fail((String)"Range query should not be supported against type d:content");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            this.ftsQueryWithCount(searcher, "TEXT:brown..dog", 1);
            ADMLuceneTest.fail((String)"Range query should not be supported against type d:content");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        try {
            this.ftsQueryWithCount(searcher, "cm:content:brown..dog", 1);
            ADMLuceneTest.fail((String)"Range query should not be supported against type d:content");
        }
        catch (UnsupportedOperationException e) {
            // empty catch block
        }
        QName qname = QName.createQName((String)TEST_NAMESPACE, (String)"float\\-ista");
        this.ftsQueryWithCount(searcher, qname + ":3.40", 1);
        this.ftsQueryWithCount(searcher, qname + ":3..4", 1);
        this.ftsQueryWithCount(searcher, qname + ":3..3.39", 0);
        this.ftsQueryWithCount(searcher, qname + ":3..3.40", 1);
        this.ftsQueryWithCount(searcher, qname + ":3.41..3.9", 0);
        this.ftsQueryWithCount(searcher, qname + ":3.40..3.9", 1);
        this.ftsQueryWithCount(searcher, qname + ":[3 TO 4]", 1);
        this.ftsQueryWithCount(searcher, qname + ":[3 TO 3.39]", 0);
        this.ftsQueryWithCount(searcher, qname + ":[3 TO 3.4]", 1);
        this.ftsQueryWithCount(searcher, qname + ":[3.41 TO 4]", 0);
        this.ftsQueryWithCount(searcher, qname + ":[3.4 TO 4]", 1);
        this.ftsQueryWithCount(searcher, qname + ":[3 TO 3.4>", 0);
        this.ftsQueryWithCount(searcher, qname + ":<3.4 TO 4]", 0);
        this.ftsQueryWithCount(searcher, qname + ":<3.4 TO 3.4>", 0);
        this.ftsQueryWithCount(searcher, qname + ":(3.40)", 1);
        this.ftsQueryWithCount(searcher, qname + ":(3..4)", 1);
        this.ftsQueryWithCount(searcher, qname + ":(3..3.39)", 0);
        this.ftsQueryWithCount(searcher, qname + ":(3..3.40)", 1);
        this.ftsQueryWithCount(searcher, qname + ":(3.41..3.9)", 0);
        this.ftsQueryWithCount(searcher, qname + ":(3.40..3.9)", 1);
        this.ftsQueryWithCount(searcher, qname + ":([3 TO 4])", 1);
        this.ftsQueryWithCount(searcher, qname + ":([3 TO 3.39])", 0);
        this.ftsQueryWithCount(searcher, qname + ":([3 TO 3.4])", 1);
        this.ftsQueryWithCount(searcher, qname + ":([3.41 TO 4])", 0);
        this.ftsQueryWithCount(searcher, qname + ":([3.4 TO 4])", 1);
        this.ftsQueryWithCount(searcher, qname + ":([3 TO 3.4>)", 0);
        this.ftsQueryWithCount(searcher, qname + ":(<3.4 TO 4])", 0);
        this.ftsQueryWithCount(searcher, qname + ":(<3.4 TO 3.4>)", 0);
        this.ftsQueryWithCount(searcher, "test:float_x002D_ista:3.40", 1);
        this.ftsQueryWithCount(searcher, "lazy", 1);
        this.ftsQueryWithCount(searcher, "laz*", 1);
        this.ftsQueryWithCount(searcher, "l*y", 1);
        this.ftsQueryWithCount(searcher, "l??y", 1);
        this.ftsQueryWithCount(searcher, "?az?", 1);
        this.ftsQueryWithCount(searcher, "*zy", 1);
        this.ftsQueryWithCount(searcher, "\"lazy\"", 1);
        this.ftsQueryWithCount(searcher, "\"laz*\"", 1);
        this.ftsQueryWithCount(searcher, "\"l*y\"", 1);
        this.ftsQueryWithCount(searcher, "\"l??y\"", 1);
        this.ftsQueryWithCount(searcher, "\"?az?\"", 1);
        this.ftsQueryWithCount(searcher, "\"*zy\"", 1);
        this.ftsQueryWithCount(searcher, "cm:content:lazy", 1);
        this.ftsQueryWithCount(searcher, "cm:content:laz*", 1);
        this.ftsQueryWithCount(searcher, "cm:content:l*y", 1);
        this.ftsQueryWithCount(searcher, "cm:content:l??y", 1);
        this.ftsQueryWithCount(searcher, "cm:content:?az?", 1);
        this.ftsQueryWithCount(searcher, "cm:content:*zy", 1);
        this.ftsQueryWithCount(searcher, "cm:content:\"lazy\"", 1);
        this.ftsQueryWithCount(searcher, "cm:content:\"laz*\"", 1);
        this.ftsQueryWithCount(searcher, "cm:content:\"l*y\"", 1);
        this.ftsQueryWithCount(searcher, "cm:content:\"l??y\"", 1);
        this.ftsQueryWithCount(searcher, "cm:content:\"?az?\"", 1);
        this.ftsQueryWithCount(searcher, "cm:content:\"*zy\"", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(lazy)", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(laz*)", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(l*y)", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(l??y)", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(?az?)", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(*zy)", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(\"lazy\")", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(\"laz*\")", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(\"l*y\")", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(\"l??y\")", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(\"?az?\")", 1);
        this.ftsQueryWithCount(searcher, "cm:content:(\"*zy\")", 1);
        this.ftsQueryWithCount(searcher, "lazy^2 dog^4.2", 1);
        this.ftsQueryWithCount(searcher, "lazy~0.7", 1);
        this.ftsQueryWithCount(searcher, "cm:content:laxy~0.7", 1);
        this.ftsQueryWithCount(searcher, "laxy~0.7", 1);
        this.ftsQueryWithCount(searcher, "=laxy~0.7", 1);
        this.ftsQueryWithCount(searcher, "~laxy~0.7", 1);
        this.ftsQueryWithCount(searcher, "\"quick fox\"~0", 0);
        this.ftsQueryWithCount(searcher, "\"quick fox\"~1", 1);
        this.ftsQueryWithCount(searcher, "\"quick fox\"~2", 1);
        this.ftsQueryWithCount(searcher, "\"quick fox\"~3", 1);
        this.ftsQueryWithCount(searcher, "\"fox quick\"~0", 0);
        this.ftsQueryWithCount(searcher, "\"fox quick\"~1", 0);
        this.ftsQueryWithCount(searcher, "\"fox quick\"~2", 0);
        this.ftsQueryWithCount(searcher, "\"fox quick\"~3", 1);
        this.ftsQueryWithCount(searcher, "lazy", 1);
        this.ftsQueryWithCount(searcher, "-lazy", 15);
        this.ftsQueryWithCount(searcher, "lazy -lazy", 16, null, this.n14);
        this.ftsQueryWithCount(searcher, "lazy^20 -lazy", 16, this.n14, null);
        this.ftsQueryWithCount(searcher, "lazy^20 -lazy^20", 16, null, this.n14);
        this.ftsQueryWithCount(searcher, "cm:content:lazy", 1);
        this.ftsQueryWithCount(searcher, "ANDY:lazy", 1);
        this.ftsQueryWithCount(searcher, "content:lazy", 1);
        this.ftsQueryWithCount(searcher, "PATH:\"//.\"", 16);
        this.ftsQueryWithCount(searcher, "+PATH:\"/app:company_home/st:sites/cm:rmtestnew1/cm:documentLibrary//*\"", 0);
        this.ftsQueryWithCount(searcher, "+PATH:\"/app:company_home/st:sites/cm:rmtestnew1/cm:documentLibrary//*\" -TYPE:\"{http://www.alfresco.org/model/content/1.0}thumbnail\"", 15);
        this.ftsQueryWithCount(searcher, "+PATH:\"/app:company_home/st:sites/cm:rmtestnew1/cm:documentLibrary//*\" AND -TYPE:\"{http://www.alfresco.org/model/content/1.0}thumbnail\"", 0);
        this.ftsQueryWithCount(searcher, "(brown *(6) dog)", 1);
        this.ftsQueryWithCount(searcher, "TEXT:(brown *(6) dog)", 1);
        this.ftsQueryWithCount(searcher, "\"//.\"", 0);
        this.ftsQueryWithCount(searcher, "PATH", "\"//.\"", 16);
        this.ftsQueryWithCount(searcher, "cm:content:brown", 1);
        this.ftsQueryWithCount(searcher, "ANDY:brown", 1);
        this.ftsQueryWithCount(searcher, "ANDY", "brown", 1);
        this.ftsQueryWithCount(searcher, "modified:*", 2, Arrays.asList(this.n14, this.n15));
        this.ftsQueryWithCount(searcher, "modified:[MIN TO NOW]", 2, Arrays.asList(this.n14, this.n15));
    }

    private ADMLuceneSearcherImpl buildSearcher() {
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        searcher.setQueryLanguages(((AbstractLuceneIndexerAndSearcherFactory)this.indexerAndSearcher).queryLanguages);
        return searcher;
    }

    public void testFTSandSort() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = this.buildSearcher();
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("fts-alfresco");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setQuery("PATH:\"//.\"");
        sp.addQueryTemplate("ANDY", "%cm:content");
        sp.setNamespace("http://www.alfresco.org/model/content/1.0");
        sp.excludeDataInTheCurrentTransaction(true);
        sp.addSort("@" + ContentModel.PROP_CONTENT.toString() + ".size", true);
        ResultSet results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
    }

    public void ftsQueryWithCount(ADMLuceneSearcherImpl searcher, String query, int count) {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("fts-alfresco");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setQuery(query);
        sp.addQueryTemplate("ANDY", "%cm:content");
        sp.setNamespace("http://www.alfresco.org/model/content/1.0");
        sp.excludeDataInTheCurrentTransaction(true);
        ResultSet results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)count, (int)results.length());
        results.close();
    }

    public void ftsQueryWithCount(ADMLuceneSearcherImpl searcher, String defaultFieldName, String query, int count) {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("fts-alfresco");
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setQuery(query);
        sp.addQueryTemplate("ANDY", "%cm:content");
        sp.setNamespace("http://www.alfresco.org/model/content/1.0");
        sp.excludeDataInTheCurrentTransaction(true);
        sp.setDefaultFieldName(defaultFieldName);
        ResultSet results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)count, (int)results.length());
        results.close();
    }

    public void ftsQueryWithCount(ADMLuceneSearcherImpl searcher, String query, int count, NodeRef first, NodeRef last) {
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "fts-alfresco", query, null);
        for (ResultSetRow row : results) {
            System.out.println("" + row.getScore() + this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_NAME));
        }
        ADMLuceneTest.assertEquals((int)count, (int)results.length());
        if (first != null) {
            ADMLuceneTest.assertEquals((Object)first, (Object)results.getNodeRef(0));
        }
        if (last != null) {
            ADMLuceneTest.assertEquals((Object)last, (Object)results.getNodeRef(results.length() - 1));
        }
        results.close();
    }

    public void ftsQueryWithCount(ADMLuceneSearcherImpl searcher, String query, int count, List<NodeRef> expectedList) {
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "fts-alfresco", query, null);
        for (ResultSetRow row : results) {
            System.out.println("" + row.getScore() + this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_NAME));
        }
        ADMLuceneTest.assertEquals((int)count, (int)results.length());
        List actualList = results.getNodeRefs();
        for (NodeRef expected : expectedList) {
            ADMLuceneTest.assertTrue((String)("did not find " + expected), (boolean)actualList.contains(expected));
        }
        results.close();
    }

    public void testOverWritetoZeroSize() throws Exception {
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
        this.testTX.commit();
        for (int i = 0; i < 50; ++i) {
            this.testTX = this.transactionService.getUserTransaction();
            this.testTX.begin();
            this.runBaseTests();
            this.nodeService.setProperty(this.rootNodeRef, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n1, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n2, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n3, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n4, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n5, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n6, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n7, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.runBaseTests();
            this.testTX.commit();
            this.testTX = this.transactionService.getUserTransaction();
            this.testTX.begin();
            this.runBaseTests();
            this.nodeService.setProperty(this.n8, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n9, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n10, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n11, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n12, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n13, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.nodeService.setProperty(this.n14, QName.createQName((String)"{namespace}property-A"), (Serializable)((Object)"A"));
            this.runBaseTests();
            this.testTX.commit();
        }
    }

    public void testBulkResultSet1() throws Exception {
        this.doBulkTest(1);
    }

    public void testBulkResultSet10() throws Exception {
        this.doBulkTest(10);
    }

    public void testBulkResultSet100() throws Exception {
        this.doBulkTest(100);
    }

    public void testBulkResultSet1000() throws Exception {
        this.doBulkTest(1000);
    }

    public void xtestBulkResultSet10000() throws Exception {
        this.doBulkTest(10000);
    }

    private void doBulkTest(int n) throws Exception {
        HashMap<QName, String> testProperties = new HashMap<QName, String>();
        testProperties.put(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic"), "BULK");
        for (int i = 0; i < n; ++i) {
            this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}texas-" + i)), this.testSuperType, testProperties).getChildRef();
        }
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic")) + ":\"BULK\"");
        ResultSet results = searcher.query(sp);
        results.setBulkFetch(false);
        results.setBulkFetchSize(10);
        ADMLuceneTest.assertEquals((int)n, (int)results.length());
        results.close();
        this.getCold(searcher, n);
        this.getWarm(searcher, n);
        this.getCold(searcher, n);
        this.getCold10(searcher, n);
        this.getCold100(searcher, n);
        this.getCold1000(searcher, n);
        this.getCold10000(searcher, n);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
    }

    private void getCold(ADMLuceneSearcherImpl searcher, int n) {
        this.nodeBulkLoader.clear();
        long start = System.nanoTime();
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic")) + ":\"BULK\"");
        ResultSet results = searcher.query(sp);
        results.setBulkFetch(false);
        results.setBulkFetchSize(0);
        for (ResultSetRow row : results) {
            this.nodeService.getAspects(row.getNodeRef());
            this.nodeService.getProperties(row.getNodeRef());
        }
        results.close();
        long end = System.nanoTime();
        System.out.println(n + " Cold in " + (double)(end - start) / 1.0E10);
    }

    private void getWarm(ADMLuceneSearcherImpl searcher, int n) {
        long start = System.nanoTime();
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic")) + ":\"BULK\"");
        ResultSet results = searcher.query(sp);
        results.setBulkFetch(false);
        results.setBulkFetchSize(0);
        for (ResultSetRow row : results) {
            this.nodeService.getAspects(row.getNodeRef());
            this.nodeService.getProperties(row.getNodeRef());
        }
        results.close();
        long end = System.nanoTime();
        System.out.println(n + " Warm in " + (double)(end - start) / 1.0E10);
    }

    private void getCold10(ADMLuceneSearcherImpl searcher, int n) {
        this.nodeBulkLoader.clear();
        long start = System.nanoTime();
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic")) + ":\"BULK\"");
        ResultSet results = searcher.query(sp);
        results.setBulkFetch(true);
        results.setBulkFetchSize(10);
        for (ResultSetRow row : results) {
            this.nodeService.getAspects(row.getNodeRef());
            this.nodeService.getProperties(row.getNodeRef());
        }
        results.close();
        long end = System.nanoTime();
        System.out.println(n + " Prefetch 10 in " + (double)(end - start) / 1.0E10);
    }

    private void getCold100(ADMLuceneSearcherImpl searcher, int n) {
        this.nodeBulkLoader.clear();
        long start = System.nanoTime();
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic")) + ":\"BULK\"");
        ResultSet results = searcher.query(sp);
        results.setBulkFetch(true);
        results.setBulkFetchSize(100);
        for (ResultSetRow row : results) {
            this.nodeService.getAspects(row.getNodeRef());
            this.nodeService.getProperties(row.getNodeRef());
        }
        results.close();
        long end = System.nanoTime();
        System.out.println(n + " Prefetch 100 in " + (double)(end - start) / 1.0E10);
    }

    private void getCold1000(ADMLuceneSearcherImpl searcher, int n) {
        this.nodeBulkLoader.clear();
        long start = System.nanoTime();
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic")) + ":\"BULK\"");
        ResultSet results = searcher.query(sp);
        results.setBulkFetch(true);
        results.setBulkFetchSize(1000);
        for (ResultSetRow row : results) {
            this.nodeService.getAspects(row.getNodeRef());
            this.nodeService.getProperties(row.getNodeRef());
        }
        results.close();
        long end = System.nanoTime();
        System.out.println(n + " Prefetch 1000 in " + (double)(end - start) / 1.0E10);
    }

    private void getCold10000(ADMLuceneSearcherImpl searcher, int n) {
        this.nodeBulkLoader.clear();
        long start = System.nanoTime();
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic")) + ":\"BULK\"");
        ResultSet results = searcher.query(sp);
        results.setBulkFetch(true);
        results.setBulkFetchSize(10000);
        for (ResultSetRow row : results) {
            this.nodeService.getAspects(row.getNodeRef());
            this.nodeService.getProperties(row.getNodeRef());
        }
        results.close();
        long end = System.nanoTime();
        System.out.println(n + " Prefetch 10000 in " + (double)(end - start) / 1.0E10);
    }

    public void testSortIssue_AR_1515__AND__AR_1466() throws Exception {
        String id;
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runBaseTests();
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        sp.addSort("ID", true);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        String current = null;
        for (ResultSetRow row : results) {
            id = row.getNodeRef().getId();
            if (current != null && current.compareTo(id) > 0) {
                ADMLuceneTest.fail();
            }
            current = id;
        }
        results.close();
        ADMLuceneTest.assertEquals((int)5, (int)this.serviceRegistry.getNodeService().getChildAssocs(this.rootNodeRef).size());
        this.serviceRegistry.getNodeService().createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}texas"), this.testSuperType).getChildRef();
        ADMLuceneTest.assertEquals((int)6, (int)this.serviceRegistry.getNodeService().getChildAssocs(this.rootNodeRef).size());
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        sp.addSort("ID", true);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)17, (int)results.length());
        current = null;
        for (ResultSetRow row : results) {
            id = row.getNodeRef().getId();
            if (current != null && current.compareTo(id) > 0) {
                ADMLuceneTest.fail();
            }
            current = id;
        }
        results.close();
        ADMLuceneTest.assertEquals((int)6, (int)this.serviceRegistry.getNodeService().getChildAssocs(this.rootNodeRef).size());
        this.serviceRegistry.getNodeService().createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}texas"), this.testSuperType).getChildRef();
        ADMLuceneTest.assertEquals((int)7, (int)this.serviceRegistry.getNodeService().getChildAssocs(this.rootNodeRef).size());
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        sp.addSort("ID", true);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)18, (int)results.length());
        current = null;
        for (ResultSetRow row : results) {
            id = row.getNodeRef().getId();
            if (current != null && current.compareTo(id) > 0) {
                ADMLuceneTest.fail();
            }
            current = id;
        }
        results.close();
        this.testTX.rollback();
    }

    public void testAuxDataIsPresent() throws Exception {
        this.luceneFTS.pause();
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runBaseTests();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ID:\"" + this.n14 + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.nodeService.addAspect(this.n14, this.aspectWithChildren, null);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ID:\"" + this.n14 + "\"", null);
        ADMLuceneTest.assertEquals((int)10, (int)results.length());
        results.close();
    }

    public void testFirst() throws Exception {
        this.testReadAgainstDelta();
    }

    public void test0() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void testDeleteSecondaryAssocToContainer() throws Exception {
        this.luceneFTS.pause();
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runBaseTests();
        this.nodeService.removeChild(this.n2, this.n13);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:three\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:four\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:six\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:seven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:ten\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:eleven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:fourteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:link\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)24, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)23, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)23, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)23, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)23, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)23, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null);
        ADMLuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    public void testDeleteSecondaryAssocToLeaf() throws Exception {
        this.luceneFTS.pause();
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runBaseTests();
        this.nodeService.removeChild(this.n12, this.n14);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:three\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:four\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:six\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:seven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:ten\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:eleven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:fourteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:common\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)27, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)26, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)26, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)26, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)26, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)26, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)9, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null);
        ADMLuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    public void testDeleteIssue() throws Exception {
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        ChildAssociationRef testFind = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}testFind"), this.testSuperType);
        this.testTX.commit();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> createAndDeleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                for (int i = 0; i < 100; i += 10) {
                    HashSet<ChildAssociationRef> refs = new HashSet<ChildAssociationRef>();
                    for (int j = 0; j < i; ++j) {
                        ChildAssociationRef test = ADMLuceneTest.this.nodeService.createNode(ADMLuceneTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"), ADMLuceneTest.this.testSuperType);
                        refs.add(test);
                    }
                    for (ChildAssociationRef car : refs) {
                        ADMLuceneTest.this.nodeService.deleteNode(car.getChildRef());
                    }
                }
                return null;
            }
        };
        this.retryingTransactionHelper.doInTransaction(createAndDeleteCallback);
        UserTransaction tx3 = this.transactionService.getUserTransaction();
        tx3.begin();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        tx3.commit();
    }

    public void testMTDeleteIssue() throws Exception {
        this.luceneFTS.pause();
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        ChildAssociationRef testFind = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}testFind"), this.testSuperType);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.testTX.commit();
        Thread runner = null;
        for (int i = 0; i < 20; ++i) {
            runner = new Nester("Concurrent-" + i, runner);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.testTX.commit();
    }

    public void testDeltaIssue() throws Exception {
        this.luceneFTS.pause();
        final NodeService pns = (NodeService)ctx.getBean("NodeService");
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.testTX.commit();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    ADMLuceneTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                    UserTransaction tx = ADMLuceneTest.this.transactionService.getUserTransaction();
                    tx = ADMLuceneTest.this.transactionService.getUserTransaction();
                    tx.begin();
                    SearchParameters sp = new SearchParameters();
                    sp.addStore(ADMLuceneTest.this.rootNodeRef.getStoreRef());
                    sp.setLanguage("lucene");
                    sp.setQuery("PATH:\"//.\"");
                    sp.excludeDataInTheCurrentTransaction(false);
                    ResultSet results = ADMLuceneTest.this.serviceRegistry.getSearchService().query(sp);
                    for (ResultSetRow row : results) {
                        System.out.println("row = " + row.getQName());
                    }
                    Assert.assertEquals((int)15, (int)results.length());
                    results.close();
                    sp = new SearchParameters();
                    sp.addStore(ADMLuceneTest.this.rootNodeRef.getStoreRef());
                    sp.setLanguage("lucene");
                    sp.setQuery("PATH:\"//.\"");
                    sp.excludeDataInTheCurrentTransaction(false);
                    results = ADMLuceneTest.this.serviceRegistry.getSearchService().query(sp);
                    Assert.assertEquals((int)15, (int)results.length());
                    results.close();
                    HashMap<QName, String> props = new HashMap<QName, String>();
                    props.put(ContentModel.PROP_TITLE, "woof");
                    pns.addAspect(ADMLuceneTest.this.n1, ContentModel.ASPECT_TITLED, props);
                    sp = new SearchParameters();
                    sp.addStore(ADMLuceneTest.this.rootNodeRef.getStoreRef());
                    sp.setLanguage("lucene");
                    sp.setQuery("PATH:\"//.\"");
                    sp.excludeDataInTheCurrentTransaction(false);
                    results = ADMLuceneTest.this.serviceRegistry.getSearchService().query(sp);
                    Assert.assertEquals((int)15, (int)results.length());
                    results.close();
                    tx.rollback();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        thread.start();
        thread.join();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        this.runBaseTests();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_TITLE, "woof");
        pns.addAspect(this.n1, ContentModel.ASPECT_TITLED, props);
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        pns.setProperty(this.n1, ContentModel.PROP_TITLE, (Serializable)((Object)"cube"));
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        this.testTX.rollback();
    }

    public void testRepeatPerformance() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        String query = "ID:\"" + this.rootNodeRef + "\"";
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery(query);
        ResultSet results = searcher.query(sp);
        ADMLuceneTest.assertEquals((String)"No results found from query", (int)1, (int)results.length());
        long start = System.nanoTime();
        int count = 1000;
        for (int i = 0; i < count; ++i) {
            sp.setLanguage("lucene");
            sp.setQuery(query);
            results = searcher.query(sp);
        }
        long end = System.nanoTime();
        double duration = (double)(end - start) / 1000000.0;
        double average = duration / (double)count;
        System.out.println("Searched for identifier: \n   count: " + count + "\n" + "   average: " + average + " ms/search \n" + "   a million searches could take: " + 1000000.0 * average / 1000.0 / 60.0 + " minutes");
        if (average > 10.0) {
            logger.error((Object)("Search taking longer than 10ms: " + query));
        }
    }

    public void testSort() throws Exception {
        Locale[] testLocales;
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.addSort("ID", true);
        ResultSet results = searcher.query(sp);
        String current = null;
        for (ResultSetRow row : results) {
            String id = row.getNodeRef().getId();
            if (current != null && current.compareTo(id) > 0) {
                ADMLuceneTest.fail();
            }
            current = id;
        }
        results.close();
        SearchParameters sp2 = new SearchParameters();
        sp2.addStore(this.rootNodeRef.getStoreRef());
        sp2.setLanguage("lucene");
        sp2.setQuery("PATH:\"//.\"");
        sp2.addSort("ID", false);
        results = searcher.query(sp2);
        current = null;
        for (ResultSetRow row : results) {
            String id = row.getNodeRef().getId();
            if (current != null && current.compareTo(id) < 0) {
                ADMLuceneTest.fail();
            }
            current = id;
        }
        results.close();
        this.luceneFTS.resume();
        SearchParameters sp3 = new SearchParameters();
        sp3.addStore(this.rootNodeRef.getStoreRef());
        sp3.setLanguage("lucene");
        sp3.setQuery("PATH:\"//.\"");
        sp3.addSort(SearchParameters.SORT_IN_DOCUMENT_ORDER_ASCENDING);
        results = searcher.query(sp3);
        int count = 0;
        for (ResultSetRow row : results) {
            ADMLuceneTest.assertEquals((Object)this.documentOrder[count++], (Object)row.getNodeRef());
        }
        results.close();
        SearchParameters sp4 = new SearchParameters();
        sp4.addStore(this.rootNodeRef.getStoreRef());
        sp4.setLanguage("lucene");
        sp4.setQuery("PATH:\"//.\"");
        sp4.addSort(SearchParameters.SORT_IN_DOCUMENT_ORDER_DESCENDING);
        results = searcher.query(sp4);
        count = 1;
        for (ResultSetRow row : results) {
            ADMLuceneTest.assertEquals((Object)this.documentOrder[this.documentOrder.length - count++], (Object)row.getNodeRef());
        }
        results.close();
        SearchParameters sp5 = new SearchParameters();
        sp5.addStore(this.rootNodeRef.getStoreRef());
        sp5.setLanguage("lucene");
        sp5.setQuery("PATH:\"//.\"");
        sp5.addSort(SearchParameters.SORT_IN_SCORE_ORDER_ASCENDING);
        results = searcher.query(sp5);
        float score = 0.0f;
        for (ResultSetRow row : results) {
            ADMLuceneTest.assertTrue((score <= row.getScore() ? 1 : 0) != 0);
            score = row.getScore();
        }
        results.close();
        SearchParameters sp6 = new SearchParameters();
        sp6.addStore(this.rootNodeRef.getStoreRef());
        sp6.setLanguage("lucene");
        sp6.setQuery("PATH:\"//.\"");
        sp6.addSort(SearchParameters.SORT_IN_SCORE_ORDER_DESCENDING);
        results = searcher.query(sp6);
        score = 1.0f;
        for (ResultSetRow row : results) {
            ADMLuceneTest.assertTrue((score >= row.getScore() ? 1 : 0) != 0);
            score = row.getScore();
        }
        results.close();
        SearchParameters sp7 = new SearchParameters();
        sp7.addStore(this.rootNodeRef.getStoreRef());
        sp7.setLanguage("lucene");
        sp7.setQuery("PATH:\"//.\"");
        sp7.addSort("@" + this.createdDate.getPrefixedQName((NamespacePrefixResolver)this.namespacePrefixResolver), true);
        results = searcher.query(sp7);
        Date date = null;
        for (ResultSetRow row : results) {
            Date currentBun = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.createdDate));
            if (date != null) {
                ADMLuceneTest.assertTrue((date.compareTo(currentBun) <= 0 ? 1 : 0) != 0);
            }
            date = currentBun;
        }
        results.close();
        SearchParameters sp8 = new SearchParameters();
        sp8.addStore(this.rootNodeRef.getStoreRef());
        sp8.setLanguage("lucene");
        sp8.setQuery("PATH:\"//.\"");
        sp8.addSort("@" + this.createdDate, false);
        results = searcher.query(sp8);
        date = null;
        for (ResultSetRow row : results) {
            Date currentBun = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.createdDate));
            if (date != null && currentBun != null) {
                ADMLuceneTest.assertTrue((date.compareTo(currentBun) >= 0 ? 1 : 0) != 0);
            }
            date = currentBun;
        }
        results.close();
        SearchParameters sp_7 = new SearchParameters();
        sp_7.addStore(this.rootNodeRef.getStoreRef());
        sp_7.setLanguage("lucene");
        sp_7.setQuery("PATH:\"//.\"");
        sp_7.addSort("@" + ContentModel.PROP_MODIFIED, true);
        results = searcher.query(sp_7);
        date = null;
        for (ResultSetRow row : results) {
            Date currentBun = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_MODIFIED));
            if (currentBun != null) {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(currentBun);
                c.set(14, 0);
                c.set(13, 0);
                c.set(12, 0);
                c.set(11, 0);
                currentBun = c.getTime();
            }
            if (date != null && currentBun != null) {
                ADMLuceneTest.assertTrue((date.compareTo(currentBun) <= 0 ? 1 : 0) != 0);
            }
            date = currentBun;
        }
        results.close();
        SearchParameters sp_8 = new SearchParameters();
        sp_8.addStore(this.rootNodeRef.getStoreRef());
        sp_8.setLanguage("lucene");
        sp_8.setQuery("PATH:\"//.\"");
        sp_8.addSort("@" + ContentModel.PROP_MODIFIED, false);
        results = searcher.query(sp_8);
        date = null;
        for (ResultSetRow row : results) {
            Date currentBun = (Date)DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_MODIFIED));
            if (currentBun != null) {
                GregorianCalendar c = new GregorianCalendar();
                c.setTime(currentBun);
                c.set(14, 0);
                c.set(13, 0);
                c.set(12, 0);
                c.set(11, 0);
                currentBun = c.getTime();
            }
            if (date != null && currentBun != null) {
                ADMLuceneTest.assertTrue((date.compareTo(currentBun) >= 0 ? 1 : 0) != 0);
            }
            date = currentBun;
        }
        results.close();
        SearchParameters sp9 = new SearchParameters();
        sp9.addStore(this.rootNodeRef.getStoreRef());
        sp9.setLanguage("lucene");
        sp9.setQuery("PATH:\"//.\"");
        sp9.addSort("@" + this.orderDouble, true);
        results = searcher.query(sp9);
        Double d = null;
        for (ResultSetRow row : results) {
            Double currentBun = (Double)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderDouble));
            if (d != null) {
                ADMLuceneTest.assertTrue((d.compareTo(currentBun) <= 0 ? 1 : 0) != 0);
            }
            d = currentBun;
        }
        results.close();
        SearchParameters sp10 = new SearchParameters();
        sp10.addStore(this.rootNodeRef.getStoreRef());
        sp10.setLanguage("lucene");
        sp10.setQuery("PATH:\"//.\"");
        sp10.addSort("@" + this.orderDouble, false);
        results = searcher.query(sp10);
        d = null;
        for (ResultSetRow row : results) {
            Double currentBun = (Double)DefaultTypeConverter.INSTANCE.convert(Double.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderDouble));
            if (d != null && currentBun != null) {
                ADMLuceneTest.assertTrue((d.compareTo(currentBun) >= 0 ? 1 : 0) != 0);
            }
            d = currentBun;
        }
        results.close();
        SearchParameters sp11 = new SearchParameters();
        sp11.addStore(this.rootNodeRef.getStoreRef());
        sp11.setLanguage("lucene");
        sp11.setQuery("PATH:\"//.\"");
        sp11.addSort("@" + this.orderFloat, true);
        results = searcher.query(sp11);
        Float f = null;
        for (ResultSetRow row : results) {
            Float currentBun = (Float)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderFloat));
            if (f != null) {
                ADMLuceneTest.assertTrue((f.compareTo(currentBun) <= 0 ? 1 : 0) != 0);
            }
            f = currentBun;
        }
        results.close();
        SearchParameters sp12 = new SearchParameters();
        sp12.addStore(this.rootNodeRef.getStoreRef());
        sp12.setLanguage("lucene");
        sp12.setQuery("PATH:\"//.\"");
        sp12.addSort("@" + this.orderFloat, false);
        results = searcher.query(sp12);
        f = null;
        for (ResultSetRow row : results) {
            Float currentBun = (Float)DefaultTypeConverter.INSTANCE.convert(Float.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderFloat));
            if (f != null && currentBun != null) {
                ADMLuceneTest.assertTrue((f.compareTo(currentBun) >= 0 ? 1 : 0) != 0);
            }
            f = currentBun;
        }
        results.close();
        SearchParameters sp13 = new SearchParameters();
        sp13.addStore(this.rootNodeRef.getStoreRef());
        sp13.setLanguage("lucene");
        sp13.setQuery("PATH:\"//.\"");
        sp13.addSort("@" + this.orderLong, true);
        results = searcher.query(sp13);
        Long l = null;
        for (ResultSetRow row : results) {
            Long currentBun = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderLong));
            if (l != null) {
                ADMLuceneTest.assertTrue((l.compareTo(currentBun) <= 0 ? 1 : 0) != 0);
            }
            l = currentBun;
        }
        results.close();
        SearchParameters sp14 = new SearchParameters();
        sp14.addStore(this.rootNodeRef.getStoreRef());
        sp14.setLanguage("lucene");
        sp14.setQuery("PATH:\"//.\"");
        sp14.addSort("@" + this.orderLong, false);
        results = searcher.query(sp14);
        l = null;
        for (ResultSetRow row : results) {
            Long currentBun = (Long)DefaultTypeConverter.INSTANCE.convert(Long.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderLong));
            if (l != null && currentBun != null) {
                ADMLuceneTest.assertTrue((l.compareTo(currentBun) >= 0 ? 1 : 0) != 0);
            }
            l = currentBun;
        }
        results.close();
        SearchParameters sp15 = new SearchParameters();
        sp15.addStore(this.rootNodeRef.getStoreRef());
        sp15.setLanguage("lucene");
        sp15.setQuery("PATH:\"//.\"");
        sp15.addSort("@" + this.orderInt, true);
        results = searcher.query(sp15);
        Integer i = null;
        for (ResultSetRow row : results) {
            Integer currentBun = (Integer)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderInt));
            if (i != null) {
                ADMLuceneTest.assertTrue((i.compareTo(currentBun) <= 0 ? 1 : 0) != 0);
            }
            i = currentBun;
        }
        results.close();
        SearchParameters sp16 = new SearchParameters();
        sp16.addStore(this.rootNodeRef.getStoreRef());
        sp16.setLanguage("lucene");
        sp16.setQuery("PATH:\"//.\"");
        sp16.addSort("@" + this.orderInt, false);
        results = searcher.query(sp16);
        i = null;
        for (ResultSetRow row : results) {
            Integer currentBun = (Integer)DefaultTypeConverter.INSTANCE.convert(Integer.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderInt));
            if (i != null && currentBun != null) {
                ADMLuceneTest.assertTrue((i.compareTo(currentBun) >= 0 ? 1 : 0) != 0);
            }
            i = currentBun;
        }
        results.close();
        SearchParameters sp17 = new SearchParameters();
        sp17.addStore(this.rootNodeRef.getStoreRef());
        sp17.setLanguage("lucene");
        sp17.setQuery("PATH:\"//.\"");
        sp17.addSort("@" + this.orderText, true);
        results = searcher.query(sp17);
        String text = null;
        for (ResultSetRow row : results) {
            String currentBun = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderText));
            if (text != null && currentBun != null) {
                ADMLuceneTest.assertTrue((text.compareTo(currentBun) <= 0 ? 1 : 0) != 0);
            }
            text = currentBun;
        }
        results.close();
        SearchParameters sp18 = new SearchParameters();
        sp18.addStore(this.rootNodeRef.getStoreRef());
        sp18.setLanguage("lucene");
        sp18.setQuery("PATH:\"//.\"");
        sp18.addSort("@" + this.orderText, false);
        results = searcher.query(sp18);
        text = null;
        for (ResultSetRow row : results) {
            String currentBun = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderText));
            if (text != null && currentBun != null) {
                ADMLuceneTest.assertTrue((text.compareTo(currentBun) >= 0 ? 1 : 0) != 0);
            }
            text = currentBun;
        }
        results.close();
        for (Locale testLocale : testLocales = new Locale[]{I18NUtil.getLocale(), Locale.ENGLISH, Locale.FRENCH}) {
            SearchParameters sp19 = new SearchParameters();
            sp19.addStore(this.rootNodeRef.getStoreRef());
            sp19.setLanguage("lucene");
            sp19.setQuery("PATH:\"//.\"");
            sp19.addSort("@" + this.orderMLText, true);
            sp19.addLocale(testLocale);
            results = searcher.query(sp19);
            text = null;
            for (ResultSetRow row : results) {
                MLText mltext = (MLText)DefaultTypeConverter.INSTANCE.convert(MLText.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderMLText));
                if (mltext == null) continue;
                String currentBun = mltext.getValue(testLocale);
                if (text != null && currentBun != null) {
                    ADMLuceneTest.assertTrue((text.compareTo(currentBun) <= 0 ? 1 : 0) != 0);
                }
                text = currentBun;
            }
            results.close();
            SearchParameters sp20 = new SearchParameters();
            sp20.addStore(this.rootNodeRef.getStoreRef());
            sp20.setLanguage("lucene");
            sp20.setQuery("PATH:\"//.\"");
            sp20.addSort("@" + this.orderMLText, false);
            sp20.addLocale(testLocale);
            results = searcher.query(sp20);
            text = null;
            for (ResultSetRow row : results) {
                MLText mltext = (MLText)DefaultTypeConverter.INSTANCE.convert(MLText.class, (Object)this.nodeService.getProperty(row.getNodeRef(), this.orderMLText));
                if (mltext == null) continue;
                String currentBun = mltext.getValue(testLocale);
                if (text != null && currentBun != null) {
                    ADMLuceneTest.assertTrue((text.compareTo(currentBun) >= 0 ? 1 : 0) != 0);
                }
                text = currentBun;
            }
            results.close();
        }
        this.luceneFTS.resume();
        SearchParameters spN = new SearchParameters();
        spN.addStore(this.rootNodeRef.getStoreRef());
        spN.setLanguage("lucene");
        spN.setQuery("PATH:\"//.\"");
        spN.addSort("cabbage", false);
        results = searcher.query(spN);
        results.close();
        spN = new SearchParameters();
        spN.addStore(this.rootNodeRef.getStoreRef());
        spN.setLanguage("lucene");
        spN.setQuery("PATH:\"//.\"");
        spN.addSort("PARENT", false);
        results = searcher.query(spN);
        results.close();
        spN = new SearchParameters();
        spN.addStore(this.rootNodeRef.getStoreRef());
        spN.setLanguage("lucene");
        spN.setQuery("PATH:\"//.\"");
        spN.addSort("@PARENT:PARENT", false);
        results = searcher.query(spN);
        results.close();
        this.luceneFTS.resume();
        SearchParameters sp20 = new SearchParameters();
        sp20.addStore(this.rootNodeRef.getStoreRef());
        sp20.setLanguage("lucene");
        sp20.setQuery("PATH:\"//.\"");
        sp20.addSort("@" + ContentModel.PROP_CONTENT + ".size", false);
        results = searcher.query(sp20);
        Long size = null;
        for (ResultSetRow row : results) {
            ContentData currentBun = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_CONTENT));
            if (size != null && currentBun != null) {
                ADMLuceneTest.assertTrue((size.compareTo(currentBun.getSize()) >= 0 ? 1 : 0) != 0);
            }
            if (currentBun == null) continue;
            size = currentBun.getSize();
        }
        results.close();
        SearchParameters sp21 = new SearchParameters();
        sp21.addStore(this.rootNodeRef.getStoreRef());
        sp21.setLanguage("lucene");
        sp21.setQuery("PATH:\"//.\"");
        sp21.addSort("@" + ContentModel.PROP_CONTENT + ".mimetype", false);
        results = searcher.query(sp21);
        String mimetype = null;
        for (ResultSetRow row : results) {
            ContentData currentBun = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_CONTENT));
            if (mimetype != null && currentBun != null) {
                ADMLuceneTest.assertTrue((mimetype.compareTo(currentBun.getMimetype()) >= 0 ? 1 : 0) != 0);
            }
            if (currentBun == null) continue;
            mimetype = currentBun.getMimetype();
        }
        results.close();
    }

    public void test1() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void test2() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void test3() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void test4() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@\\{namespace\\}property\\-2:\"valuetwo\"", null);
        results.close();
        this.luceneFTS.resume();
    }

    public void test5() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void test6() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void testNoOp() throws Exception {
        this.luceneFTS.pause();
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_1", this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.prepare();
        indexer.commit();
        this.luceneFTS.resume();
    }

    public void testStandAloneIndexerCommit() throws Exception {
        this.luceneFTS.pause();
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_1", this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.createNode(new ChildAssociationRef(null, null, null, this.rootNodeRef));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}one"), this.n1));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}two"), this.n2));
        indexer.updateNode(this.n1);
        indexer.prepare();
        indexer.commit();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@\\{namespace\\}property\\-2:\"valuetwo\"", null);
        this.simpleResultSetTest(results);
        ChildAssocRefResultSet r2 = new ChildAssocRefResultSet(this.nodeService, results.getNodeRefs(), false);
        this.simpleResultSetTest(r2);
        ChildAssocRefResultSet r3 = new ChildAssocRefResultSet(this.nodeService, results.getNodeRefs(), true);
        this.simpleResultSetTest(r3);
        ChildAssocRefResultSet r4 = new ChildAssocRefResultSet(this.nodeService, results.getChildAssocRefs());
        this.simpleResultSetTest(r4);
        DetachedResultSet r5 = new DetachedResultSet(results);
        this.simpleResultSetTest(r5);
        DetachedResultSet r6 = new DetachedResultSet(r2);
        this.simpleResultSetTest(r6);
        DetachedResultSet r7 = new DetachedResultSet(r3);
        this.simpleResultSetTest(r7);
        DetachedResultSet r8 = new DetachedResultSet(r4);
        this.simpleResultSetTest(r8);
        DetachedResultSet r9 = new DetachedResultSet(r5);
        this.simpleResultSetTest(r9);
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@\\{namespace\\}property\\-1:\"valueone\"", null);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        ADMLuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        ADMLuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@namespace\\:property\\-1:\"valueone\"", null);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        ADMLuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        ADMLuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@namespace\\:property\\-1:\"valueone\"", null);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        ADMLuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        ADMLuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@namespace\\:property\\-1:\"Valueone\"", null);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        ADMLuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        ADMLuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@namespace\\:property\\-1:ValueOne", null);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        ADMLuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        ADMLuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@namespace\\:property\\-1:valueone", null);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        ADMLuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        ADMLuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        QName qname = QName.createQName((String)"", (String)"property-1");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ID:\"" + this.n1.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    private void simpleResultSetTest(ResultSet results) {
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        ADMLuceneTest.assertEquals((Object)this.n2, (Object)results.getNodeRef(0));
        ADMLuceneTest.assertEquals((Object)new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}two"), this.n2), (Object)results.getChildAssocRef(0));
        ADMLuceneTest.assertEquals((int)1, (int)results.getChildAssocRefs().size());
        ADMLuceneTest.assertNotNull((Object)results.getChildAssocRefs());
        ADMLuceneTest.assertEquals((int)0, (int)results.getRow(0).getIndex());
        ADMLuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getRow(0).getScore()));
        ADMLuceneTest.assertEquals((Object)new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}two"), this.n2), (Object)results.getRow(0).getChildAssocRef());
        ADMLuceneTest.assertEquals((Object)this.n2, (Object)results.getRow(0).getNodeRef());
        ADMLuceneTest.assertEquals((Object)QName.createQName((String)"{namespace}two"), (Object)results.getRow(0).getQName());
        ADMLuceneTest.assertEquals((Object)"valuetwo", (Object)results.getRow(0).getValue(QName.createQName((String)"{namespace}property-2")));
        for (ResultSetRow row : results) {
            ADMLuceneTest.assertNotNull((Object)row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStandAlonePathIndexer() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@\\{namespace\\}property-1:valueone", null);
        try {
            ADMLuceneTest.assertEquals((int)2, (int)results.length());
            ADMLuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(0).getId());
            ADMLuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(1).getId());
            QName qName = QName.createQName((String)"", (String)"property-1");
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            results.close();
            throw throwable;
        }
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "+ID:\"" + this.n1.toString() + "\"", null);
        try {
            ADMLuceneTest.assertEquals((int)2, (int)results.length());
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            results.close();
            throw throwable;
        }
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ID:\"" + this.rootNodeRef.toString() + "\"", null);
        try {
            ADMLuceneTest.assertEquals((int)1, (int)results.length());
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            results.close();
            throw throwable;
        }
        results.close();
        this.luceneFTS.resume();
    }

    private void buildBaseIndex() {
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_" + new Random().nextInt(), this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.createNode(new ChildAssociationRef(null, null, null, this.rootNodeRef));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}one"), this.n1));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}two"), this.n2));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}three"), this.n3));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName((String)"{namespace}four"), this.n4));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n1, QName.createQName((String)"{namespace}five"), this.n5));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n1, QName.createQName((String)"{namespace}six"), this.n6));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName((String)"{namespace}seven"), this.n7));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName((String)"{namespace}eight"), this.n8));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n5, QName.createQName((String)"{namespace}nine"), this.n9));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n5, QName.createQName((String)"{namespace}ten"), this.n10));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n5, QName.createQName((String)"{namespace}eleven"), this.n11));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n5, QName.createQName((String)"{namespace}twelve"), this.n12));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n12, QName.createQName((String)"{namespace}thirteen"), this.n13));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n13, QName.createQName((String)"{namespace}fourteen"), this.n14));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n13, QName.createQName((String)"{namespace}fifteen"), this.n15));
        indexer.updateNode(this.n3);
        indexer.updateNode(this.n1);
        indexer.updateNode(this.n2);
        indexer.prepare();
        indexer.commit();
    }

    public void testAllPathSearch() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    private void runBaseTests() throws LuceneIndexException, IOException {
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/.\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:three\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:four\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:six\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:seven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:ten\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:eleven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:fourteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)9, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*/*\"", null);
        ADMLuceneTest.assertEquals((int)9, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)28, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)27, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)27, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)27, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)27, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)27, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//common\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one//common\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null);
        ADMLuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//.\"", null);
        ADMLuceneTest.assertEquals((int)11, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen//.\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen//.//.\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PRIMARYASSOCTYPEQNAME:\"test:assoc\"", null);
        ADMLuceneTest.assertEquals((int)11, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ASSOCTYPEQNAME:\"test:assoc\"", null);
        ADMLuceneTest.assertEquals((int)11, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PRIMARYASSOCTYPEQNAME:\"sys:children\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ASSOCTYPEQNAME:\"sys:children\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        QName qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"1\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":1", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"01\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":01", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + this.escapeQName(qname) + ":\"001\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@test\\:int\\-ista:\"0001\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[A TO 2]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[0 TO 2]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[0 TO A]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{A TO 1}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{0 TO 1}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{0 TO A}", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{A TO 2}", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{1 TO 2}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{1 TO A}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"2\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"02\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"002\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"0002\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[A TO 2]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[0 TO 2]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[0 TO A]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{A TO 2}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{0 TO 2}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{0 TO A}", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{A TO 3}", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{2 TO 3}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{2 TO A}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"3.4\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[A TO 4]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[3 TO 4]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[3 TO A]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[A TO 3.4]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[3.3 TO 3.4]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[3.3 TO A]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{A TO 3.4}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[3.3 TO 3.4]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[3.3 TO A]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"3.40\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"03.4\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"03.40\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"double-ista")) + ":\"5.6\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"double-ista")) + ":\"05.6\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"double-ista")) + ":\"5.60\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"double-ista")) + ":\"05.60\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[A TO 5.7]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[5.5 TO 5.7]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[5.5 TO A]", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{A TO 5.6}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{5.5 TO 5.6}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{5.5 TO A}", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{A TO 5.7}", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{5.6 TO 5.7}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{5.6 TO A}", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        PropertyDefinition propertyDef = this.dictionaryService.getProperty(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista"));
        DataTypeDefinition dataType = propertyDef.getDataType();
        String analyserClassName = dataType.getAnalyserClassName();
        boolean usesDateTimeAnalyser = analyserClassName.equals(DateTimeAnalyser.class.getCanonicalName());
        Date date = new Date();
        for (SimpleDateFormat df : CachingDateFormat.getLenientFormatters()) {
            if (usesDateTimeAnalyser && df.format(date).length() < 22) continue;
            String sDate = df.format(date);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"DATE-ista")) + ":\"" + sDate + "\"", null);
            ADMLuceneTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista")) + ":\"" + sDate + "\"", null);
            ADMLuceneTest.assertEquals((int)(usesDateTimeAnalyser ? 0 : 1), (int)results.length());
            results.close();
            sDate = df.format(this.testDate);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"date-ista")) + ":\"" + sDate + "\"", null);
            ADMLuceneTest.assertEquals((int)1, (int)results.length());
            results.close();
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista")) + ":\"" + sDate + "\"", null);
            ADMLuceneTest.assertEquals((int)1, (int)results.length());
            results.close();
            sDate = df.format(date);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@cm\\:CrEaTeD:[MIN TO " + sDate + "]", null);
            ADMLuceneTest.assertTrue((String)"n14 not in results", (results.getNodeRef(0).equals((Object)this.n14) || results.getNodeRef(1).equals((Object)this.n14) ? 1 : 0) != 0);
            ADMLuceneTest.assertTrue((String)"n15 not in results", (results.getNodeRef(0).equals((Object)this.n15) || results.getNodeRef(1).equals((Object)this.n15) ? 1 : 0) != 0);
            ADMLuceneTest.assertEquals((int)2, (int)results.length());
            results.close();
            sDate = df.format(date);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@cm\\:created:[MIN TO NOW]", null);
            ADMLuceneTest.assertTrue((String)"n14 not in results", (results.getNodeRef(0).equals((Object)this.n14) || results.getNodeRef(1).equals((Object)this.n14) ? 1 : 0) != 0);
            ADMLuceneTest.assertTrue((String)"n15 not in results", (results.getNodeRef(0).equals((Object)this.n15) || results.getNodeRef(1).equals((Object)this.n15) ? 1 : 0) != 0);
            ADMLuceneTest.assertEquals((int)2, (int)results.length());
            results.close();
            sDate = df.format(date);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@cm\\:created:[MIN TO TODAY]", null);
            ADMLuceneTest.assertTrue((String)"n14 not in results", (results.getNodeRef(0).equals((Object)this.n14) || results.getNodeRef(1).equals((Object)this.n14) ? 1 : 0) != 0);
            ADMLuceneTest.assertTrue((String)"n15 not in results", (results.getNodeRef(0).equals((Object)this.n15) || results.getNodeRef(1).equals((Object)this.n15) ? 1 : 0) != 0);
            ADMLuceneTest.assertEquals((int)2, (int)results.length());
            results.close();
            sDate = df.format(date);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(ContentModel.PROP_CREATED) + ":[MIN TO " + sDate + "]", null);
            ADMLuceneTest.assertTrue((String)"n14 not in results", (results.getNodeRef(0).equals((Object)this.n14) || results.getNodeRef(1).equals((Object)this.n14) ? 1 : 0) != 0);
            ADMLuceneTest.assertTrue((String)"n15 not in results", (results.getNodeRef(0).equals((Object)this.n15) || results.getNodeRef(1).equals((Object)this.n15) ? 1 : 0) != 0);
            ADMLuceneTest.assertEquals((int)2, (int)results.length());
            results.close();
            sDate = df.format(date);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"date-ista")) + ":[" + sDate + " TO " + sDate + "]", null);
            ADMLuceneTest.assertEquals((int)1, (int)results.length());
            results.close();
            sDate = df.format(date);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"date-ista")) + ":[MIN  TO " + sDate + "]", null);
            ADMLuceneTest.assertEquals((int)1, (int)results.length());
            results.close();
            sDate = df.format(date);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"date-ista")) + ":[" + sDate + " TO MAX]", null);
            ADMLuceneTest.assertEquals((int)1, (int)results.length());
            results.close();
            sDate = CachingDateFormat.getDateFormat().format(date);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista")) + ":[" + sDate + " TO " + sDate + "]", null);
            ADMLuceneTest.assertEquals((int)(usesDateTimeAnalyser ? 0 : 1), (int)results.length());
            results.close();
            sDate = CachingDateFormat.getDateFormat().format(date);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista")) + ":[MIN TO " + sDate + "]", null);
            ADMLuceneTest.assertEquals((int)(usesDateTimeAnalyser ? 0 : 1), (int)results.length());
            results.close();
            sDate = CachingDateFormat.getDateFormat().format(date);
            results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista")) + ":[" + sDate + " TO MAX]", null);
            ADMLuceneTest.assertEquals((int)1, (int)results.length());
            results.close();
            if (!usesDateTimeAnalyser) continue;
            sDate = df.format(this.testDate);
            for (long i : new long[]{333L, 20000L, 1200000L, 28800000L, 864000000L, 1778065408L, 1802354688L}) {
                String startDate = df.format(new Date(this.testDate.getTime() - i));
                String endDate = df.format(new Date(this.testDate.getTime() + i));
                results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista")) + ":[" + startDate + " TO " + endDate + "]", null);
                ADMLuceneTest.assertEquals((int)1, (int)results.length());
                results.close();
                results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista")) + ":[" + sDate + " TO " + endDate + "]", null);
                ADMLuceneTest.assertEquals((int)1, (int)results.length());
                results.close();
                results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista")) + ":[" + startDate + " TO " + sDate + "]", null);
                ADMLuceneTest.assertEquals((int)1, (int)results.length());
                results.close();
                results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista")) + ":{" + sDate + " TO " + endDate + "}", null);
                ADMLuceneTest.assertEquals((int)0, (int)results.length());
                results.close();
                results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"datetime-ista")) + ":{" + startDate + " TO " + sDate + "}", null);
                ADMLuceneTest.assertEquals((int)0, (int)results.length());
                results.close();
            }
        }
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"boolean-ista")) + ":\"true\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"qname-ista")) + ":\"{wibble}wobble\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"category-ista")) + ":\"" + (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new NodeRef(this.rootNodeRef.getStoreRef(), "CategoryId")) + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"noderef-ista")) + ":\"" + this.n1 + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"path-ista")) + ":\"" + this.nodeService.getPath(this.n3) + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(QName.createQName((String)TEST_NAMESPACE, (String)"path-ista")));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"any-many-ista")) + ":\"100\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(QName.createQName((String)TEST_NAMESPACE, (String)"any-many-ista")));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"any-many-ista")) + ":\"anyValueAsString\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(QName.createQName((String)TEST_NAMESPACE, (String)"any-many-ista")));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"any-many-ista")) + ":\"nintc\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(QName.createQName((String)TEST_NAMESPACE, (String)"any-many-ista")));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"Tutorial Alfresco\"~0", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"Tutorial Alfresco\"~1", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"Tutorial Alfresco\"~2", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"Tutorial Alfresco\"~3", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Alfresco Tutorial\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Tutorial Alfresco\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Tutorial Alfresco\"~0", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Tutorial Alfresco\"~1", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Tutorial Alfresco\"~2", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Tutorial Alfresco\"~3", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        QName multimlQName = QName.createQName((String)TEST_NAMESPACE, (String)"mltext-many-ista");
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)multimlQName.toString()) + ":\u043b\u0435\u043c\u0443\u0440");
        sp.addLocale(new Locale("ru"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)multimlQName.toString()) + ":lemur");
        sp.addLocale(new Locale("en"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)multimlQName.toString()) + ":chou");
        sp.addLocale(new Locale("fr"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)multimlQName.toString()) + ":cabbage");
        sp.addLocale(new Locale("en"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)multimlQName.toString()) + ":cabba*");
        sp.addLocale(new Locale("en"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)multimlQName.toString()) + ":ca*ge");
        sp.addLocale(new Locale("en"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)multimlQName.toString()) + ":*bage");
        sp.addLocale(new Locale("en"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)multimlQName.toString()) + ":cabage~");
        sp.addLocale(new Locale("en"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)multimlQName.toString()) + ":*b?ag?");
        sp.addLocale(new Locale("en"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)multimlQName.toString()) + ":cho*");
        sp.setMlAnalaysisMode(MLAnalysisMode.LOCALE_AND_ALL_CONTAINED_LOCALES);
        sp.addLocale(new Locale("fr"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)QName.createQName((String)TEST_NAMESPACE, (String)"content-many-ista").toString()) + ":multicontent");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"locale-ista")) + ":\"en_GB_\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(QName.createQName((String)TEST_NAMESPACE, (String)"path-ista")));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"locale-ista")) + ":en_GB_", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(QName.createQName((String)TEST_NAMESPACE, (String)"path-ista")));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"locale-ista")) + ":en_*", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(QName.createQName((String)TEST_NAMESPACE, (String)"path-ista")));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"locale-ista")) + ":*_GB_*", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(QName.createQName((String)TEST_NAMESPACE, (String)"path-ista")));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"locale-ista")) + ":*_gb_*", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(QName.createQName((String)TEST_NAMESPACE, (String)"path-ista")));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"period-ista")) + ":\"period|12\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(QName.createQName((String)TEST_NAMESPACE, (String)"path-ista")));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"" + this.testType.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"" + this.testType.toPrefixString((NamespacePrefixResolver)this.namespacePrefixResolver) + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "EXACTTYPE:\"" + this.testType.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "EXACTTYPE:\"" + this.testType.toPrefixString((NamespacePrefixResolver)this.namespacePrefixResolver) + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"" + this.testSuperType.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"" + this.testSuperType.toPrefixString((NamespacePrefixResolver)this.namespacePrefixResolver) + "\"", null);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"" + ContentModel.TYPE_CONTENT.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"cm:content\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"cm:CONTENT\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"CM:CONTENT\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"CONTENT\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"content\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"" + ContentModel.TYPE_THUMBNAIL.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"" + ContentModel.TYPE_THUMBNAIL.toString() + "\" TYPE:\"" + ContentModel.TYPE_CONTENT.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "EXACTTYPE:\"" + this.testSuperType.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "EXACTTYPE:\"" + this.testSuperType.toPrefixString((NamespacePrefixResolver)this.namespacePrefixResolver) + "\"", null);
        ADMLuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ASPECT:\"" + this.testAspect.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ASPECT:\"" + this.testAspect.toPrefixString((NamespacePrefixResolver)this.namespacePrefixResolver) + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ASPECT:\"" + this.testAspect.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ASPECT:\"" + this.testAspect.toPrefixString((NamespacePrefixResolver)this.namespacePrefixResolver) + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:fox AND TYPE:\"" + ContentModel.PROP_CONTENT.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:fox cm\\:name:fox", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:fo AND TYPE:\"" + ContentModel.PROP_CONTENT.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"the\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"and\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"over the lazy\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"over a lazy\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:laz*", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:laz~", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:la?y", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:?a?y", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:*azy", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:*az*", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"\u00e0\u00ea\u00ee\u00f0\u00f1\u00f6\u00fb\u00ff\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"aeidnouy\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"fox\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ":\"fox\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ".mimetype:\"text/plain\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ".locale:\"en_GB\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ".locale:en_*", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ".locale:e*_GB", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ".size:\"298\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        QName queryQName = QName.createQName((String)"alf:test1", (NamespacePrefixResolver)this.namespacePrefixResolver);
        results = searcher.query(this.rootNodeRef.getStoreRef(), queryQName, null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ":\"fox\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"fox\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"fox\"");
        sp.addTextAttribute("@" + ContentModel.PROP_NAME.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        sp.addTextAttribute("@" + ContentModel.PROP_CONTENT.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"cabbage\"");
        sp.addTextAttribute("@" + this.orderText.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"cab*\"");
        sp.addTextAttribute("@" + this.orderText.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"*bage\"");
        sp.addTextAttribute("@" + this.orderText.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"*ba*\"");
        sp.addTextAttribute("@" + this.orderText.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:cabbage");
        sp.addTextAttribute("@" + this.orderText.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:*cab*");
        sp.addTextAttribute("@" + this.orderText.toString());
        sp.addLocale(Locale.ENGLISH);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:*bage");
        sp.addTextAttribute("@" + this.orderText.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:*ba*");
        sp.addTextAttribute("@" + this.orderText.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:dabbage~0.8");
        sp.addTextAttribute("@" + this.orderText.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alfresc?\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alfres??\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alfre???\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alfr????\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alf?????\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"al??????\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"a???????\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"a??re???\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alfresco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"?lfresco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"??fresco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"???resco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"???res?o\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"????e?co\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"????e?c?\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"???????o\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"???re???\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alfresc*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alfres*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alfre*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alfr*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alf*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"al*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"a*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"a****\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"*lfresco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"*fresco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"*resco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"*esco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"*sco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"*co\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"*o\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"****lf**sc***\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"*??*lf**sc***\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alfresc*tutorial\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"alf* tut*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:\"*co *al\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfresc?\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfres??\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfre???\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfr????\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alf?????\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"al??????\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"a???????\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"a??re???\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfresco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"?lfresco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"??fresco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"???resco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"???res?o\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"????e?co\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"????e?c?\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"???????o\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"???re???\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfresc*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfres*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfre*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alfr*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"alf*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"al*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"a*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"a****\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*lfresco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*fresco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*resco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*esco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*sco\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*co\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*o\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"****lf**sc***\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*??*lf**sc***\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Alfresc*tutorial\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"Alf* tut*\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)ContentModel.PROP_DESCRIPTION.toString()) + ":\"*co *al\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ALL:\"fox\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ALL:\"fox\"");
        sp.addAllAttribute("@" + ContentModel.PROP_NAME.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        sp.addAllAttribute("@" + ContentModel.PROP_CONTENT.toString());
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ALL:\"5.6\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("d\\:double:\"5.6\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("d\\:content:\"fox\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("d\\:content:\"fox\"");
        sp.addLocale(Locale.US);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        QName mlQName = QName.createQName((String)TEST_NAMESPACE, (String)"ml");
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setMlAnalaysisMode(MLAnalysisMode.ALL_ONLY);
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":and");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setMlAnalaysisMode(MLAnalysisMode.ALL_ONLY);
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\"and\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setMlAnalaysisMode(MLAnalysisMode.ALL_ONLY);
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana");
        sp.addLocale(Locale.UK);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana");
        sp.setMlAnalaysisMode(MLAnalysisMode.LOCALE_AND_ALL_CONTAINING_LOCALES);
        sp.addLocale(Locale.UK);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana");
        sp.addLocale(Locale.ENGLISH);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banane");
        sp.addLocale(Locale.FRENCH);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\u9999\u8549");
        sp.addLocale(Locale.CHINESE);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banaan");
        sp.addLocale(new Locale("nl"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banane");
        sp.addLocale(Locale.GERMAN);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\u03bc\u03c0\u03b1\u03bd\u03ac\u03bd\u03b1");
        sp.addLocale(new Locale("el"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana");
        sp.addLocale(Locale.ITALIAN);
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\u30d0\u30ca\u30ca");
        sp.addLocale(new Locale("ja"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\ubc14\ub098\ub098");
        sp.addLocale(new Locale("ko"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":banana");
        sp.addLocale(new Locale("pt"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":\u0431\u0430\u043d\u0430\u043d");
        sp.addLocale(new Locale("ru"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("@" + LuceneQueryParser.escape((String)mlQName.toString()) + ":pl\u00e1tano");
        sp.addLocale(new Locale("es"));
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ISUNSET:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"null").toString() + "\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ISNULL:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"null").toString() + "\"");
        results = searcher.query(sp);
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ISUNSET:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"path-ista").toString() + "\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ISNULL:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"path-ista").toString() + "\"");
        results = searcher.query(sp);
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ISNOTNULL:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"null").toString() + "\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ISNOTNULL:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"path-ista").toString() + "\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ISUNSET:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"aspectProperty").toString() + "\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ISNULL:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"aspectProperty").toString() + "\"");
        results = searcher.query(sp);
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("ISNOTNULL:\"" + QName.createQName((String)TEST_NAMESPACE, (String)"aspectProperty").toString() + "\"");
        results = searcher.query(sp);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:fox", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:fo*", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:f*x", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:*ox", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ":fox", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ":fo*", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ":f*x", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toString()) + ":*ox", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)this.namespacePrefixResolver)) + ":fox", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)this.namespacePrefixResolver)) + ":fo*", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)this.namespacePrefixResolver)) + ":f*x", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape((String)ContentModel.PROP_CONTENT.toPrefixString((NamespacePrefixResolver)this.namespacePrefixResolver)) + ":*ox", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        queryQName = QName.createQName((String)"alf:test2", (NamespacePrefixResolver)this.namespacePrefixResolver);
        results = searcher.query(this.rootNodeRef.getStoreRef(), queryQName, null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        queryQName = QName.createQName((String)"alf:test2", (NamespacePrefixResolver)this.namespacePrefixResolver);
        QueryParameter qp = new QueryParameter(QName.createQName((String)"alf:banana", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"woof"));
        results = searcher.query(this.rootNodeRef.getStoreRef(), queryQName, new QueryParameter[]{qp});
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        queryQName = QName.createQName((String)"alf:test3", (NamespacePrefixResolver)this.namespacePrefixResolver);
        qp = new QueryParameter(QName.createQName((String)"alf:banana", (NamespacePrefixResolver)this.namespacePrefixResolver), (Serializable)((Object)"/one/five//*"));
        results = searcher.query(this.rootNodeRef.getStoreRef(), queryQName, new QueryParameter[]{qp});
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        QueryParameterDefImpl paramDef = new QueryParameterDefImpl(QName.createQName((String)"alf:lemur", (NamespacePrefixResolver)this.namespacePrefixResolver), (DataTypeDefinition)null, true, "fox");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"${alf:lemur}\"", new QueryParameterDefinition[]{paramDef});
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        paramDef = new QueryParameterDefImpl(QName.createQName((String)"alf:intvalue", (NamespacePrefixResolver)this.namespacePrefixResolver), (DataTypeDefinition)null, true, "1");
        qname = QName.createQName((String)TEST_NAMESPACE, (String)"int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"${alf:intvalue}\"", new QueryParameterDefinition[]{paramDef});
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        ADMLuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName((String)"{namespace}property-1");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[v TO w]", null);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        qname = QName.createQName((String)"{namespace}property-1");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[v TO \uffff]", null);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        qname = QName.createQName((String)"{namespace}property-1");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[\u0000 TO w]", null);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
    }

    public void testPathSearch() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//common\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one//common\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null);
        ADMLuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//.\"", null);
        ADMLuceneTest.assertEquals((int)11, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    public void testXPathSearch() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "xpath", "//./*", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        this.luceneFTS.resume();
        QueryParameterDefImpl paramDef = new QueryParameterDefImpl(QName.createQName((String)"alf:query", (NamespacePrefixResolver)this.namespacePrefixResolver), (DataTypeDefinition)null, true, "//./*");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "xpath", "${alf:query}", new QueryParameterDefinition[]{paramDef});
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
    }

    public void testMissingIndex() throws Exception {
        this.luceneFTS.pause();
        StoreRef storeRef = new StoreRef("workspace", "_missing_");
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(storeRef, this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(storeRef, "xpath", "//./*", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        this.luceneFTS.resume();
    }

    public void testUpdateIndex() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.updateNode(this.rootNodeRef);
        indexer.updateNode(this.n1);
        indexer.updateNode(this.n2);
        indexer.updateNode(this.n3);
        indexer.updateNode(this.n4);
        indexer.updateNode(this.n5);
        indexer.updateNode(this.n6);
        indexer.updateNode(this.n7);
        indexer.updateNode(this.n8);
        indexer.updateNode(this.n9);
        indexer.updateNode(this.n10);
        indexer.updateNode(this.n11);
        indexer.updateNode(this.n12);
        indexer.updateNode(this.n13);
        indexer.updateNode(this.n14);
        indexer.commit();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void testDeleteLeaf() throws Exception {
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.nodeService.deleteNode(this.n14);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:three\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:four\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:six\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:seven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:ten\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:eleven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:fourteen\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*\"", null);
        ADMLuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five/*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)19, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)18, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)18, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)18, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)18, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)18, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    public void testAddEscapedChild() throws Exception {
        String COMPLEX_LOCAL_NAME = " `\u00ac\u00a6!\"\u00a3$%^&*()-_=+\t\n\\\u0000[]{};'#:@~,./<>?\\u007c_xT65A_";
        if (this.dialect instanceof PostgreSQLDialect) {
            COMPLEX_LOCAL_NAME = " `\u00ac\u00a6!\"\u00a3$%^&*()-_=+\t\n\\[]{};'#:@~,./<>?\\u007c_xT65A_";
        }
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        ChildAssociationRef car = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}" + COMPLEX_LOCAL_NAME)), this.testSuperType);
        indexer.createNode(car);
        indexer.commit();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:" + ISO9075.encode((String)COMPLEX_LOCAL_NAME) + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
    }

    public void testNumericInPath() throws Exception {
        String COMPLEX_LOCAL_NAME = "Woof12";
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        ChildAssociationRef car = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}" + COMPLEX_LOCAL_NAME)), this.testSuperType);
        indexer.createNode(car);
        indexer.commit();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:" + ISO9075.encode((String)COMPLEX_LOCAL_NAME) + "\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
    }

    public void testDeleteContainer() throws Exception {
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.testTX.commit();
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.nodeService.deleteNode(this.n13);
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:three\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:four\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:six\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:seven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:ten\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:eleven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:fourteen\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*/*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*\"", null);
        ADMLuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five/*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    public void testDeleteAndAddReference() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        this.nodeService.removeChild(this.n2, this.n13);
        indexer.deleteChildRelationship(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName((String)"{namespace}link"), this.n13));
        indexer.commit();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:three\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:four\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:one\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:two\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:six\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:seven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-2\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-1\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-0\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:ten\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:eleven\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:fourteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five/namespace:*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*/*\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five/*\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*/namespace:nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//.\"", null);
        ADMLuceneTest.assertEquals((int)24, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*\"", null);
        ADMLuceneTest.assertEquals((int)23, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/.\"", null);
        ADMLuceneTest.assertEquals((int)23, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/./.\"", null);
        ADMLuceneTest.assertEquals((int)23, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//./*\"", null);
        ADMLuceneTest.assertEquals((int)23, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//././*/././.\"", null);
        ADMLuceneTest.assertEquals((int)23, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//common\"", null);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one//common\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//*\"", null);
        ADMLuceneTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null);
        ADMLuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//.\"", null);
        ADMLuceneTest.assertEquals((int)11, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        this.nodeService.addChild(this.n2, this.n13, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}link"));
        indexer.createChildRelationship(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName((String)"{namespace}link"), this.n13));
        indexer.commit();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void testRenameReference() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//namespace:link//.\"", null);
        ADMLuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//namespace:link//.\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//namespace:renamed_link//.\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        this.nodeService.removeChild(this.n2, this.n13);
        this.nodeService.addChild(this.n2, this.n13, ASSOC_TYPE_QNAME, QName.createQName((String)"{namespace}renamed_link"));
        indexer.updateChildRelationship(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName((String)"namespace", (String)"link"), this.n13), new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName((String)"namespace", (String)"renamed_link"), this.n13));
        indexer.commit();
        this.runBaseTests();
        searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//namespace:link//.\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//namespace:renamed_link//.\"", null);
        ADMLuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//namespace:renamed_link//.\"", null);
        ADMLuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    public void testDelayIndex() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic")) + ":\"KEYONE\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-unstored-tokenised-atomic")) + ":\"KEYUNSTORED\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-nonatomic")) + ":\"KEYTWO\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_" + new Random().nextInt(), this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.updateFullTextSearch(1000);
        indexer.prepare();
        indexer.commit();
        searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic")) + ":\"keyone\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-nonatomic")) + ":\"keytwo\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-unstored-tokenised-atomic")) + ":\"keyunstored\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void testWaitForIndex() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic")) + ":\"KEYONE\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-unstored-tokenised-atomic")) + ":\"KEYUNSTORED\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-nonatomic")) + ":\"KEYTWO\"", null);
        ADMLuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-atomic")) + ":\"keyone\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_" + new Random().nextInt(), this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.updateFullTextSearch(1000);
        indexer.prepare();
        indexer.commit();
        this.luceneFTS.resume();
        Thread.sleep(35000L);
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-stored-tokenised-nonatomic")) + ":\"keytwo\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName((String)TEST_NAMESPACE, (String)"text-indexed-unstored-tokenised-atomic")) + ":\"KEYUNSTORED\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.runBaseTests();
    }

    private String escapeQName(QName qname) {
        return LuceneQueryParser.escape((String)qname.toString());
    }

    public void testForKev() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PARENT:\"" + this.rootNodeRef.toString() + "\"", null);
        ADMLuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "+PARENT:\"" + this.rootNodeRef.toString() + "\" +QNAME:\"one\"", null);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "( +TYPE:\"{http://www.alfresco.org/model/content/1.0}content\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}name:\"content woof\") OR  TEXT:\"content\"", null);
        this.luceneFTS.resume();
    }

    public void testIssueAR47() throws Exception {
        this.testTX.commit();
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        ChildAssociationRef testFind = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}testFind"), this.testSuperType);
        tx.commit();
        ADMLuceneSearcherImpl searcher = ADMLuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setTenantService(this.tenantService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixResolver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        for (int i = 0; i < 100; ++i) {
            UserTransaction tx1 = this.transactionService.getUserTransaction();
            tx1.begin();
            ChildAssociationRef test = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}test"), this.testSuperType);
            tx1.commit();
            UserTransaction tx2 = this.transactionService.getUserTransaction();
            tx2.begin();
            this.nodeService.deleteNode(test.getChildRef());
            tx2.commit();
        }
        UserTransaction tx3 = this.transactionService.getUserTransaction();
        tx3.begin();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        tx3.commit();
    }

    public void testReadAgainstDelta() throws Exception {
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runBaseTests();
        this.serviceRegistry.getNodeService().deleteNode(this.n1);
        ADMLuceneTest.assertFalse((boolean)this.serviceRegistry.getNodeService().exists(this.n13));
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(true);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        this.testTX.rollback();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.addSort("ID", true);
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        this.testTX.rollback();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runBaseTests();
        this.serviceRegistry.getNodeService().deleteNode(this.n2);
        ADMLuceneTest.assertTrue((boolean)this.serviceRegistry.getNodeService().exists(this.n13));
        ADMLuceneTest.assertFalse((boolean)this.serviceRegistry.getNodeService().exists(this.n7));
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(true);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        this.testTX.rollback();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.addSort("ID", true);
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        this.testTX.rollback();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runBaseTests();
        ADMLuceneTest.assertEquals((int)5, (int)this.serviceRegistry.getNodeService().getChildAssocs(this.rootNodeRef).size());
        this.serviceRegistry.getNodeService().createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}texas"), this.testSuperType).getChildRef();
        ADMLuceneTest.assertEquals((int)6, (int)this.serviceRegistry.getNodeService().getChildAssocs(this.rootNodeRef).size());
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)17, (int)results.length());
        results.close();
        this.testTX.rollback();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.addSort("ID", true);
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        this.testTX.rollback();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runBaseTests();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@\\{namespace\\}property\\-1:\"valueone\"");
        sp.addSort("ID", true);
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        this.nodeService.setProperty(this.n1, QName.createQName((String)"{namespace}property-1"), (Serializable)((Object)"Different"));
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@\\{namespace\\}property\\-1:\"valueone\"");
        sp.addSort("ID", true);
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.testTX.rollback();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@\\{namespace\\}property\\-1:\"valueone\"");
        sp.excludeDataInTheCurrentTransaction(false);
        sp.addSort("ID", true);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        this.testTX.rollback();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.runBaseTests();
        this.serviceRegistry.getNodeService().deleteNode(this.n1);
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(true);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        NodeRef created = this.serviceRegistry.getNodeService().createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}texas"), this.testSuperType).getChildRef();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(true);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        this.serviceRegistry.getNodeService().deleteNode(created);
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(true);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        this.testTX.rollback();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.addSort("ID", true);
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        ADMLuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
    }

    private void runPerformanceTest(double time, boolean clear) {
        ADMLuceneIndexerImpl indexer = ADMLuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_" + new Random().nextInt(), this.indexerAndSearcher);
        indexer.setMaxAtomicTransformationTime(1000000L);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setTenantService(this.tenantService);
        indexer.setFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        if (clear) {
            // empty if block
        }
        indexer.createNode(new ChildAssociationRef(null, null, null, this.rootNodeRef));
        long startTime = System.currentTimeMillis();
        int count = 0;
        for (int i = 0; i < 10000000; ++i) {
            if (i % 10 == 0 && (double)(System.currentTimeMillis() - startTime) > time) {
                count = i;
                break;
            }
            QName qname = QName.createQName((String)("{namespace}a_" + i));
            NodeRef ref = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME, qname, ContentModel.TYPE_CONTAINER).getChildRef();
            indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.rootNodeRef, qname, ref));
        }
        indexer.commit();
        float delta = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
    }

    private NamespacePrefixResolver getNamespacePrefixResolver(String defaultURI) {
        DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver(null);
        nspr.registerNamespace("alf", "http://www.alfresco.org");
        nspr.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        nspr.registerNamespace("d", "http://www.alfresco.org/model/dictionary/1.0");
        nspr.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
        nspr.registerNamespace("namespace", "namespace");
        nspr.registerNamespace("test", TEST_NAMESPACE);
        nspr.registerNamespace("", defaultURI);
        return nspr;
    }

    public static void main(String[] args) throws Exception {
        ADMLuceneTest test = new ADMLuceneTest();
        test.setUp();
        NodeRef targetNode = test.rootNodeRef;
        Path path = test.serviceRegistry.getNodeService().getPath(targetNode);
        SearchParameters sp = new SearchParameters();
        sp.addStore(test.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"" + path + "//." + "\"");
        ResultSet results = test.serviceRegistry.getSearchService().query(sp);
        results.close();
    }

    public static class UnknownDataType
    implements Serializable {
        private static final long serialVersionUID = -6729690518573349055L;
    }

    class Nester
    extends Thread {
        Thread waiter;

        Nester(String name, Thread waiter) {
            super(name);
            this.setDaemon(true);
            this.waiter = waiter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block7: {
                ADMLuceneTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                if (this.waiter != null) {
                    this.waiter.start();
                }
                try {
                    try {
                        System.out.println("Start " + this.getName());
                        RetryingTransactionHelper.RetryingTransactionCallback<Object> createAndDeleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            @Override
                            public Object execute() throws Throwable {
                                for (int i = 0; i < 20; ++i) {
                                    HashSet<ChildAssociationRef> refs = new HashSet<ChildAssociationRef>();
                                    for (int j = 0; j < i; ++j) {
                                        ChildAssociationRef test = ADMLuceneTest.this.nodeService.createNode(ADMLuceneTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}test_" + Nester.this.getName() + "_" + i + "_" + j)), ADMLuceneTest.this.testSuperType);
                                        refs.add(test);
                                    }
                                    for (ChildAssociationRef car : refs) {
                                        ADMLuceneTest.this.nodeService.deleteNode(car.getChildRef());
                                    }
                                }
                                return null;
                            }
                        };
                        ADMLuceneTest.this.retryingTransactionHelper.doInTransaction(createAndDeleteCallback);
                        System.out.println("End " + this.getName());
                    }
                    catch (Exception e) {
                        System.out.println("End " + this.getName() + " with error " + e.getMessage());
                        e.printStackTrace();
                        Object var3_5 = null;
                        ADMLuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
                        break block7;
                    }
                    Object var3_4 = null;
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    ADMLuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
                    throw throwable;
                }
                ADMLuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
            }
            if (this.waiter == null) return;
            try {
                this.waiter.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class QueryThread
    extends Thread {
        Thread waiter;
        ADMLuceneSearcherImpl searcher;
        String query;

        QueryThread(String name, Thread waiter, ADMLuceneSearcherImpl searcher, String query) {
            super(name);
            this.setDaemon(true);
            this.waiter = waiter;
            this.searcher = searcher;
            this.query = query;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block7: {
                ADMLuceneTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                if (this.waiter != null) {
                    this.waiter.start();
                }
                try {
                    try {
                        RetryingTransactionHelper.RetryingTransactionCallback<Object> createAndDeleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                            @Override
                            public Object execute() throws Throwable {
                                for (int i = 0; i < 100; ++i) {
                                    ResultSet results = QueryThread.this.searcher.query(ADMLuceneTest.this.rootNodeRef.getStoreRef(), "lucene", QueryThread.this.query);
                                    int count = results.length();
                                    for (ResultSetRow row : results) {
                                        NodeRef nr = row.getNodeRef();
                                    }
                                    results.close();
                                }
                                return null;
                            }
                        };
                        ADMLuceneTest.this.retryingTransactionHelper.doInTransaction(createAndDeleteCallback);
                    }
                    catch (Exception e) {
                        System.out.println("End " + this.getName() + " with error " + e.getMessage());
                        e.printStackTrace();
                        Object var3_5 = null;
                        ADMLuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
                        break block7;
                    }
                    Object var3_4 = null;
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    ADMLuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
                    throw throwable;
                }
                ADMLuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
            }
            if (this.waiter == null) return;
            try {
                this.waiter.join();
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class CreateDuringBackupThread
    extends Thread {
        CreateDuringBackupThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ADMLuceneTest.this.authenticationComponent.setSystemUserAsCurrentUser();
            try {
                try {
                    System.out.println("Start " + this.getName());
                    RetryingTransactionHelper.RetryingTransactionCallback<String> createAndDeleteCallback = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

                        @Override
                        public String execute() throws Throwable {
                            String guid = GUID.generate();
                            ChildAssociationRef test = ADMLuceneTest.this.nodeService.createNode(ADMLuceneTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)("{namespace}" + guid)), ADMLuceneTest.this.testSuperType);
                            return guid;
                        }
                    };
                    while (true) {
                        String guid = ADMLuceneTest.this.retryingTransactionHelper.doInTransaction(createAndDeleteCallback);
                        System.out.println("Created " + guid);
                    }
                }
                catch (Exception e) {
                    System.out.println("End " + this.getName() + " with error " + e.getMessage());
                    e.printStackTrace();
                    Object var4_4 = null;
                    ADMLuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                ADMLuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
                throw throwable;
            }
        }
    }

    class QueryDuringBackupThread
    extends Thread {
        String query;
        long period;

        QueryDuringBackupThread(String name, String query, long period) {
            super(name);
            this.setDaemon(true);
            this.query = query;
            this.period = period;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            long startTime = System.currentTimeMillis();
            long currentTime = System.currentTimeMillis();
            ADMLuceneTest.this.authenticationComponent.setSystemUserAsCurrentUser();
            try {
                try {
                    System.out.println("Start " + this.getName());
                    int i = 0;
                    int length = 0;
                    while (currentTime - startTime < this.period) {
                        RetryingTransactionHelper.RetryingTransactionCallback<Integer> queryCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                            @Override
                            public Integer execute() throws Throwable {
                                SearchParameters sp = new SearchParameters();
                                sp.addStore(ADMLuceneTest.this.rootNodeRef.getStoreRef());
                                sp.setLanguage("lucene");
                                sp.setQuery(QueryDuringBackupThread.this.query);
                                ResultSet results = ADMLuceneTest.this.serviceRegistry.getSearchService().query(sp);
                                int count = results.length();
                                results.close();
                                return count;
                            }
                        };
                        length = ADMLuceneTest.this.retryingTransactionHelper.doInTransaction(queryCallback);
                        if (++i % 1000 == 0) {
                            currentTime = System.currentTimeMillis();
                        }
                        System.out.println("Query " + i + " count = " + length);
                    }
                    System.out.println("End " + this.getName());
                }
                catch (Exception e) {
                    System.out.println("End " + this.getName() + " with error " + e.getMessage());
                    e.printStackTrace();
                    Object var9_8 = null;
                    ADMLuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
                    return;
                }
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                ADMLuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
                throw throwable;
            }
            ADMLuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
        }
    }
}

