/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.index;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransactionStatus {
    ACTIVE{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == null || previous == ACTIVE;
        }

        public int getStatus() {
            return 0;
        }
    }
    ,
    MARKED_ROLLBACK{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous.allowsRollbackOrMark(previous) || previous == MARKED_ROLLBACK;
        }

        public int getStatus() {
            return 1;
        }
    }
    ,
    PREPARED{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == PREPARING || previous == PREPARED;
        }

        public int getStatus() {
            return 2;
        }
    }
    ,
    COMMITTED{

        public boolean isCommitted() {
            return true;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == COMMITTING || previous == COMMITTED;
        }

        public int getStatus() {
            return 3;
        }
    }
    ,
    ROLLEDBACK{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == ROLLINGBACK || previous == ROLLEDBACK;
        }

        public int getStatus() {
            return 4;
        }
    }
    ,
    UNKNOWN{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == UNKNOWN;
        }

        public int getStatus() {
            return 5;
        }
    }
    ,
    NO_TRANSACTION{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == NO_TRANSACTION;
        }

        public int getStatus() {
            return 6;
        }
    }
    ,
    PREPARING{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == ACTIVE || previous == PREPARING;
        }

        public int getStatus() {
            return 7;
        }
    }
    ,
    COMMITTING{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == PREPARED || previous == COMMITTING;
        }

        public int getStatus() {
            return 8;
        }
    }
    ,
    ROLLINGBACK{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous.allowsRollbackOrMark(previous) || previous == ROLLINGBACK;
        }

        public int getStatus() {
            return 9;
        }
    }
    ,
    MERGE{

        public boolean isCommitted() {
            return true;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == MERGE;
        }

        public int getStatus() {
            return 3;
        }
    }
    ,
    MERGE_TARGET{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == MERGE_TARGET;
        }

        public int getStatus() {
            return 0;
        }
    }
    ,
    COMMITTED_DELETING{

        public boolean isCommitted() {
            return true;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == COMMITTED_DELETING;
        }

        public int getStatus() {
            return 3;
        }
    }
    ,
    DELETABLE{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return true;
        }

        public int getStatus() {
            return 5;
        }
    };


    public abstract boolean isCommitted();

    public abstract boolean isTransient();

    public abstract boolean canBeReordered();

    public abstract boolean follows(TransactionStatus var1);

    public abstract int getStatus();

    private boolean allowsRollbackOrMark(TransactionStatus previous) {
        switch (previous) {
            case ACTIVE: 
            case MARKED_ROLLBACK: 
            case PREPARED: 
            case PREPARING: 
            case COMMITTING: {
                return true;
            }
        }
        return false;
    }
}

