/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import java.io.IOException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPInitialDirContextFactoryImpl
implements LDAPInitialDirContextFactory,
InitializingBean {
    private static final Log logger = LogFactory.getLog(LDAPInitialDirContextFactoryImpl.class);
    private Map<String, String> defaultEnvironment = Collections.emptyMap();
    private Map<String, String> authenticatedEnvironment = Collections.emptyMap();

    @Override
    public void setInitialDirContextEnvironment(Map<String, String> initialDirContextEnvironment) {
        this.authenticatedEnvironment = initialDirContextEnvironment;
    }

    public Map<String, String> getInitialDirContextEnvironment() {
        return this.authenticatedEnvironment;
    }

    public void setDefaultIntialDirContextEnvironment(Map<String, String> defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    @Override
    public InitialDirContext getDefaultIntialDirContext() throws AuthenticationException {
        return this.getDefaultIntialDirContext(0);
    }

    @Override
    public InitialDirContext getDefaultIntialDirContext(int pageSize) throws AuthenticationException {
        Hashtable<String, String> env = new Hashtable<String, String>(this.defaultEnvironment.size());
        env.putAll(this.defaultEnvironment);
        return this.buildInitialDirContext(env, pageSize);
    }

    private InitialDirContext buildInitialDirContext(Hashtable<String, String> env, int pageSize) throws AuthenticationException {
        try {
            if (pageSize > 0) {
                InitialLdapContext ctx = new InitialLdapContext(env, null);
                ctx.setRequestControls(new Control[]{new PagedResultsControl(pageSize, true)});
                return ctx;
            }
            return new InitialDirContext(env);
        }
        catch (javax.naming.AuthenticationException ax) {
            throw new AuthenticationException("LDAP authentication failed.", (Throwable)ax);
        }
        catch (NamingException nx) {
            throw new AuthenticationException("Unable to connect to LDAP Server; check LDAP configuration", (Throwable)nx);
        }
        catch (IOException e) {
            throw new AuthenticationException("Unable to encode LDAP v3 request controls; check LDAP configuration", (Throwable)e);
        }
    }

    @Override
    public boolean hasNextPage(DirContext ctx, int pageSize) {
        if (pageSize > 0) {
            try {
                LdapContext ldapContext = (LdapContext)ctx;
                Control[] controls = ldapContext.getResponseControls();
                if (controls != null) {
                    for (Control control : controls) {
                        byte[] cookie;
                        if (!(control instanceof PagedResultsResponseControl) || (cookie = ((PagedResultsResponseControl)control).getCookie()) == null) continue;
                        ldapContext.setRequestControls(new Control[]{new PagedResultsControl(pageSize, cookie, true)});
                        return true;
                    }
                }
            }
            catch (NamingException nx) {
                throw new AuthenticationException("Unable to connect to LDAP Server; check LDAP configuration", (Throwable)nx);
            }
            catch (IOException e) {
                throw new AuthenticationException("Unable to encode LDAP v3 request controls; check LDAP configuration", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public InitialDirContext getInitialDirContext(String principal, String credentials) throws AuthenticationException {
        if (principal == null) {
            throw new AuthenticationException("Null user name provided.");
        }
        if (principal.length() == 0) {
            throw new AuthenticationException("Empty user name provided.");
        }
        if (credentials == null) {
            throw new AuthenticationException("No credentials provided.");
        }
        if (credentials.length() == 0) {
            throw new AuthenticationException("Empty credentials provided.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.credentials", credentials);
        return this.buildInitialDirContext(env, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        int userMembers = Integer.parseInt(args[3]);
        ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
        LDAPInitialDirContextFactory factory = (LDAPInitialDirContextFactory)applicationContext.getBean("ldapInitialDirContextFactory");
        InitialContext ctx = null;
        ctx = factory.getInitialDirContext("cn=" + args[0] + "," + args[2], args[1]);
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("top");
        objClasses.add("person");
        objClasses.add("organizationalPerson");
        objClasses.add("inetOrgPerson");
        for (int i = 0; i < userMembers; ++i) {
            BasicAttribute cn = new BasicAttribute("cn", "User" + i + " TestUser");
            BasicAttribute sn = new BasicAttribute("sn", "TestUser");
            BasicAttribute givenNames = new BasicAttribute("givenName", "User" + i);
            BasicAttribute telephoneNumber = new BasicAttribute("telephoneNumber", "123");
            BasicAttribute uid = new BasicAttribute("uid", "User" + i);
            BasicAttribute mail = new BasicAttribute("mail", "woof@woof");
            BasicAttribute o = new BasicAttribute("o", "Alfresco");
            BasicAttribute userPassword = new BasicAttribute("userPassword", "bobbins");
            String dn = "cn=User" + i + " TestUser," + args[2];
            BasicAttributes orig = new BasicAttributes();
            orig.put(objClasses);
            orig.put(cn);
            orig.put(sn);
            orig.put(givenNames);
            orig.put(telephoneNumber);
            orig.put(uid);
            orig.put(mail);
            orig.put(o);
            orig.put(userPassword);
            try {
                ctx.destroySubcontext(dn);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            ((InitialDirContext)ctx).createSubcontext(dn, orig);
        }
        Object var19_19 = null;
        if (ctx == null) return;
        try {
            ctx.close();
            return;
        }
        catch (NamingException e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (NamingException e) {
                e.printStackTrace();
                Object var19_20 = null;
                if (ctx == null) return;
                try {
                    ctx.close();
                    return;
                }
                catch (NamingException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (NamingException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.remove("java.naming.security.principal");
        env.remove("java.naming.security.credentials");
        try {
            new InitialDirContext(env);
            logger.warn((Object)("LDAP server supports anonymous bind " + (String)env.get("java.naming.provider.url")));
        }
        catch (javax.naming.AuthenticationException ax) {
        }
        catch (AuthenticationNotSupportedException e) {
        }
        catch (NamingException nx) {
            logger.error((Object)"Unable to connect to LDAP Server; check LDAP configuration", (Throwable)nx);
            return;
        }
        env = new Hashtable(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.put("java.naming.security.principal", "daftAsABrush");
        env.put("java.naming.security.credentials", "daftAsABrush");
        try {
            new InitialDirContext(env);
            throw new AuthenticationException("The ldap server at " + (String)env.get("java.naming.provider.url") + " falls back to use anonymous bind if invalid security credentials are presented. This is not supported.");
        }
        catch (javax.naming.AuthenticationException ax) {
            logger.info((Object)("LDAP server does not fall back to anonymous bind for a string uid and password at " + (String)env.get("java.naming.provider.url")));
        }
        catch (AuthenticationNotSupportedException e) {
            logger.info((Object)("LDAP server does not fall back to anonymous bind for a string uid and password at " + (String)env.get("java.naming.provider.url")));
        }
        catch (NamingException nx) {
            logger.info((Object)("LDAP server does not support simple string user ids and invalid credentials at " + (String)env.get("java.naming.provider.url")));
        }
        env = new Hashtable(this.authenticatedEnvironment.size());
        env.putAll(this.authenticatedEnvironment);
        env.put("java.naming.security.principal", "cn=daftAsABrush,dc=woof");
        env.put("java.naming.security.credentials", "daftAsABrush");
        try {
            new InitialDirContext(env);
            throw new AuthenticationException("The ldap server at " + (String)env.get("java.naming.provider.url") + " falls back to use anonymous bind if invalid security credentials are presented. This is not supported.");
        }
        catch (javax.naming.AuthenticationException ax) {
            logger.info((Object)("LDAP server does not fall back to anonymous bind for a simple dn and password at " + (String)env.get("java.naming.provider.url")));
        }
        catch (AuthenticationNotSupportedException e) {
            logger.info((Object)("LDAP server does not fall back to anonymous bind for a simple dn and password at " + (String)env.get("java.naming.provider.url")));
        }
        catch (NamingException nx) {
            logger.info((Object)("LDAP server does not support simple DN and invalid password at " + (String)env.get("java.naming.provider.url")));
        }
        String principal = this.defaultEnvironment.get("java.naming.security.principal");
        if (principal != null) {
            env = new Hashtable(this.authenticatedEnvironment.size());
            env.putAll(this.authenticatedEnvironment);
            env.put("java.naming.security.principal", principal);
            env.put("java.naming.security.credentials", "sdasdasdasdasd123123123");
            try {
                new InitialDirContext(env);
                throw new AuthenticationException("The ldap server at " + (String)env.get("java.naming.provider.url") + " falls back to use anonymous bind for a known principal if  invalid security credentials are presented. This is not supported.");
            }
            catch (javax.naming.AuthenticationException ax) {
                logger.info((Object)("LDAP server does not fall back to anonymous bind for known principal and invalid credentials at " + (String)env.get("java.naming.provider.url")));
            }
            catch (AuthenticationNotSupportedException e) {
                logger.info((Object)"LDAP server does not support the required authentication mechanism");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    static {
        System.setProperty("javax.security.auth.useSubjectCredentialsOnly", "false");
    }
}

