/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.shutdown;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class ShutdownBackstop
extends AbstractLifecycleBean {
    private int timeout = 10000;
    private boolean enabled = true;
    protected static final Log log = LogFactory.getLog(ShutdownBackstop.class);

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected void onBootstrap(ApplicationEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Shutdown backstop onBootstrap");
        }
    }

    protected void onShutdown(ApplicationEvent event) {
        if (this.isEnabled()) {
            log.info((Object)"Shutdown backstop timer started");
            ShutdownBackstopThread selfDestructThread = new ShutdownBackstopThread(this.timeout);
            selfDestructThread.start();
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private class ShutdownBackstopThread
    extends Thread {
        int timeout;

        public ShutdownBackstopThread(int timeout) {
            this.timeout = timeout;
            this.setDaemon(true);
            this.setName("Alfresco Shutdown Backstop Thread (Self Destruct)");
        }

        public void run() {
            try {
                ShutdownBackstopThread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                log.error((Object)"Alfresco terminating via Shutdown Backstop");
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmss");
                String timeStr = sf.format(new Date());
                File f = new File("alf-backstop-" + timeStr + ".dmp");
                f.createNewFile();
                BufferedWriter w = new BufferedWriter(new FileWriter(f));
                w.write("Alfresco Shutdown Backstop Dump, time:" + timeStr);
                w.newLine();
                this.listAllThreads(w);
                w.close();
            }
            catch (Throwable t) {
                System.out.println(t.toString());
                t.printStackTrace();
            }
            try {
                log.error((Object)"Alfresco terminated");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(1);
        }

        private void printThreadInfo(Thread t, String indent, BufferedWriter w) throws IOException {
            if (t == null) {
                return;
            }
            w.write(indent + "Thread: " + t.getName() + "  Priority: " + t.getPriority() + (t.isDaemon() ? " Daemon" : "") + (t.isAlive() ? "" : " Not Alive"));
            w.newLine();
        }

        private void printGroupInfo(ThreadGroup g, String indent, BufferedWriter w) throws IOException {
            int i;
            if (g == null) {
                return;
            }
            int numThreads = g.activeCount();
            int numGroups = g.activeGroupCount();
            Thread[] threads = new Thread[numThreads];
            ThreadGroup[] groups = new ThreadGroup[numGroups];
            g.enumerate(threads, false);
            g.enumerate(groups, false);
            w.append(indent + "Thread Group: " + g.getName() + "  Max Priority: " + g.getMaxPriority() + (g.isDaemon() ? " Daemon" : ""));
            w.newLine();
            for (i = 0; i < numThreads; ++i) {
                this.printThreadInfo(threads[i], indent + "    ", w);
            }
            for (i = 0; i < numGroups; ++i) {
                this.printGroupInfo(groups[i], indent + "    ", w);
            }
        }

        public void listAllThreads(BufferedWriter w) throws IOException {
            ThreadGroup currentThreadGroup;
            ThreadGroup rootThreadGroup = currentThreadGroup = Thread.currentThread().getThreadGroup();
            for (ThreadGroup parent = rootThreadGroup.getParent(); parent != null; parent = parent.getParent()) {
                rootThreadGroup = parent;
            }
            this.printGroupInfo(rootThreadGroup, "", w);
        }
    }
}

