/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.tagging;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.AsynchronousActionExecutionQueuePolicies;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tagging.UpdateTagScopesActionExecuter;
import org.alfresco.repo.tagging.UpdateTagScopesQuartzJob;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.tagging.TagDetails;
import org.alfresco.service.cmr.tagging.TagScope;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.springframework.context.ConfigurableApplicationContext;

public class TaggingServiceImplTest
extends TestCase {
    private static ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private TaggingService taggingService;
    private NodeService nodeService;
    private CopyService copyService;
    private CheckOutCheckInService checkOutCheckInService;
    private ScriptService scriptService;
    private AuditService auditService;
    private ActionService actionService;
    private ActionTrackingService actionTrackingService;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private AsyncOccurs asyncOccurs;
    private static StoreRef storeRef;
    private static NodeRef rootNode;
    private NodeRef folder;
    private NodeRef subFolder;
    private NodeRef document;
    private NodeRef subDocument;
    private static final String TAG_1 = "tag one";
    private static final String TAG_2 = "tag two";
    private static final String TAG_3 = "Tag Three";
    private static final String TAG_4 = "tag four";
    private static final String TAG_5 = "tag five";
    private static final String TAG_I18N = "\u00e0\u00e2\u00e6\u00e7\u00e9\u00e8\u00ea\u00eb\u00ee\u00ef\u00f4\u0153\u00f9\u00fb\u00fc\u00ff\u00f1";
    private static final String UPPER_TAG = "House";
    private static final String LOWER_TAG = "house";
    private static boolean init;

    protected void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new IllegalStateException("There should not be any transactions when starting test: " + AlfrescoTransactionSupport.getTransactionId() + " started at " + new Date(AlfrescoTransactionSupport.getTransactionStartTime()));
        }
        this.taggingService = (TaggingService)ctx.getBean("TaggingService");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.copyService = (CopyService)ctx.getBean("CopyService");
        this.checkOutCheckInService = (CheckOutCheckInService)ctx.getBean("CheckoutCheckinService");
        this.actionService = (ActionService)ctx.getBean("ActionService");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.auditService = (AuditService)ctx.getBean("auditService");
        this.scriptService = (ScriptService)ctx.getBean("scriptService");
        this.actionTrackingService = (ActionTrackingService)ctx.getBean("actionTrackingService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        if (!init) {
            UserTransaction tx = this.transactionService.getNonPropagatingUserTransaction();
            tx.begin();
            this.authenticationComponent.setSystemUserAsCurrentUser();
            storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
            rootNode = this.nodeService.getRootNode(storeRef);
            NodeRef catContainer = this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryContainer"), ContentModel.TYPE_CONTAINER).getChildRef();
            NodeRef catRoot = this.nodeService.createNode(catContainer, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryRoot"), ContentModel.TYPE_CATEGORYROOT).getChildRef();
            this.nodeService.createNode(catRoot, ContentModel.ASSOC_CATEGORIES, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CATEGORY).getChildRef();
            init = true;
            tx.commit();
        }
        this.asyncOccurs = new AsyncOccurs();
        ((PolicyComponent)ctx.getBean("policyComponent")).bindClassBehaviour(AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute.QNAME, ActionModel.TYPE_ACTION, (Behaviour)new JavaBehaviour(this.asyncOccurs, "onAsyncActionExecute", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.createTestDocumentsAndFolders();
    }

    protected void tearDown() throws Exception {
        this.removeTestDocumentsAndFolders();
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            TaggingServiceImplTest.fail((String)"Test is not transaction-safe.  Fix up transaction handling and re-test.");
        }
    }

    private void createTestDocumentsAndFolders() throws Exception {
        UserTransaction tx = this.transactionService.getNonPropagatingUserTransaction();
        tx.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        String guid = GUID.generate();
        HashMap<QName, String> folderProps = new HashMap<QName, String>(1);
        folderProps.put(ContentModel.PROP_NAME, "testFolder" + guid);
        this.folder = this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testFolder" + guid)), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
        HashMap<QName, String> docProps = new HashMap<QName, String>(1);
        docProps.put(ContentModel.PROP_NAME, "testDocument" + guid + ".txt");
        this.document = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testDocument" + guid + ".txt")), ContentModel.TYPE_CONTENT, docProps).getChildRef();
        HashMap<QName, String> props = new HashMap<QName, String>(1);
        props.put(ContentModel.PROP_NAME, "subFolder" + guid);
        this.subFolder = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("subFolder" + guid)), ContentModel.TYPE_FOLDER, props).getChildRef();
        props = new HashMap(1);
        props.put(ContentModel.PROP_NAME, "subDocument" + guid + ".txt");
        this.subDocument = this.nodeService.createNode(this.subFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("subDocument" + guid + ".txt")), ContentModel.TYPE_CONTENT, props).getChildRef();
        tx.commit();
    }

    private void removeTestDocumentsAndFolders() throws Exception {
        NodeRef[] nodes;
        UserTransaction tx = this.transactionService.getNonPropagatingUserTransaction();
        tx.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        for (NodeRef nodeRef : nodes = new NodeRef[]{this.subDocument, this.subFolder, this.document, this.folder}) {
            if (!this.taggingService.isTagScope(nodeRef)) continue;
            this.taggingService.removeTagScope(nodeRef);
        }
        for (NodeRef nodeRef : nodes) {
            this.nodeService.deleteNode(nodeRef);
        }
        this.auditService.clearAudit("Alfresco Tagging Service", 0L, System.currentTimeMillis() + 1L);
        tx.commit();
    }

    public void testTagCRUD() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        List<String> tags = this.taggingService.getTags(storeRef);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)0, (int)tags.size());
        this.taggingService.createTag(storeRef, TAG_1);
        this.taggingService.createTag(storeRef, UPPER_TAG);
        tx.commit();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        tags = this.taggingService.getTags(storeRef);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)2, (int)tags.size());
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(LOWER_TAG));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.isTag(storeRef, TAG_2));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, UPPER_TAG));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, LOWER_TAG));
        this.taggingService.deleteTag(storeRef, UPPER_TAG);
        tx.commit();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        tags = this.taggingService.getTags(storeRef);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertFalse((boolean)tags.contains(LOWER_TAG));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.isTag(storeRef, TAG_2));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, TAG_1));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.isTag(storeRef, UPPER_TAG));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.isTag(storeRef, LOWER_TAG));
        tx.commit();
    }

    public void testAddRemoveTag() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        List<String> tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertTrue((boolean)tags.isEmpty());
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.hasTag(this.document, TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, TAG_1));
        this.taggingService.addTag(this.document, TAG_1);
        tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.hasTag(this.document, TAG_1));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.isTag(storeRef, TAG_2));
        this.taggingService.addTag(this.document, TAG_2);
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTag(storeRef, TAG_2));
        tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)2, (int)tags.size());
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_2));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.hasTag(this.document, TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.hasTag(this.document, TAG_2));
        this.taggingService.removeTag(this.document, TAG_1);
        tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
        TaggingServiceImplTest.assertFalse((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertFalse((boolean)this.taggingService.hasTag(this.document, TAG_1));
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_2));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.hasTag(this.document, TAG_2));
        ArrayList<String> setTags = new ArrayList<String>(2);
        setTags.add(TAG_3);
        setTags.add(TAG_1);
        this.taggingService.setTags(this.document, setTags);
        tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)2, (int)tags.size());
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_1));
        TaggingServiceImplTest.assertFalse((boolean)tags.contains(TAG_2));
        TaggingServiceImplTest.assertTrue((boolean)tags.contains(TAG_3.toLowerCase()));
        this.taggingService.clearTags(this.document);
        tags = this.taggingService.getTags(this.document);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertTrue((boolean)tags.isEmpty());
        tx.commit();
    }

    public void testTagScopeFindAddRemove() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        TagScope tagScope = this.taggingService.findTagScope(this.subDocument);
        TaggingServiceImplTest.assertNull((Object)tagScope);
        List<TagScope> tagScopes = this.taggingService.findAllTagScopes(this.subDocument);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)0, (int)tagScopes.size());
        this.taggingService.addTagScope(this.folder);
        this.taggingService.addTagScope(this.subFolder);
        tagScope = this.taggingService.findTagScope(this.subDocument);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.subDocument);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)2, (int)tagScopes.size());
        tagScope = this.taggingService.findTagScope(this.subFolder);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.subFolder);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)2, (int)tagScopes.size());
        tagScope = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.folder);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)1, (int)tagScopes.size());
        this.taggingService.removeTagScope(this.folder);
        tagScope = this.taggingService.findTagScope(this.subDocument);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.subDocument);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)1, (int)tagScopes.size());
        tagScope = this.taggingService.findTagScope(this.subFolder);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.subFolder);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)1, (int)tagScopes.size());
        tagScope = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertNull((Object)tagScope);
        tagScopes = this.taggingService.findAllTagScopes(this.folder);
        TaggingServiceImplTest.assertNotNull(tagScopes);
        TaggingServiceImplTest.assertEquals((int)0, (int)tagScopes.size());
        tx.commit();
    }

    public void testTagScope() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        this.taggingService.addTagScope(this.folder);
        this.taggingService.addTagScope(this.subFolder);
        this.taggingService.addTag(this.subDocument, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subDocument, TAG_2);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subDocument, TAG_3);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subFolder, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subFolder, TAG_2);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.folder, TAG_2);
        tx = this.asyncOccurs.awaitExecution(tx);
        TagScope ts1 = this.taggingService.findTagScope(this.subDocument);
        TagScope ts2 = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertEquals((String)("Wrong tags on sub folder: " + ts1.getTags()), (int)3, (int)ts1.getTags().size());
        TaggingServiceImplTest.assertEquals((String)("Wrong tags on main folder: " + ts2.getTags()), (int)3, (int)ts2.getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts1.getTags().get(0).getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts1.getTags().get(1).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTags().get(2).getCount());
        TaggingServiceImplTest.assertEquals((String)TAG_1, (String)ts1.getTags().get(0).getName());
        TaggingServiceImplTest.assertEquals((String)TAG_2, (String)ts1.getTags().get(1).getName());
        TaggingServiceImplTest.assertEquals((String)TAG_3.toLowerCase(), (String)ts1.getTags().get(2).getName());
        TaggingServiceImplTest.assertEquals((int)3, (int)ts2.getTags().get(0).getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts2.getTags().get(1).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts2.getTags().get(2).getCount());
        TaggingServiceImplTest.assertEquals((String)TAG_2, (String)ts2.getTags().get(0).getName());
        TaggingServiceImplTest.assertEquals((String)TAG_1, (String)ts2.getTags().get(1).getName());
        TaggingServiceImplTest.assertEquals((String)TAG_3.toLowerCase(), (String)ts2.getTags().get(2).getName());
        this.taggingService.removeTag(this.folder, TAG_2);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.removeTag(this.subFolder, TAG_2);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.removeTag(this.subFolder, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.removeTag(this.subDocument, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.folder, TAG_3);
        tx = this.asyncOccurs.awaitExecution(tx);
        ts1 = this.taggingService.findTagScope(this.subDocument);
        ts2 = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertEquals((String)("Wrong tags on sub folder: " + ts1.getTags()), (int)2, (int)ts1.getTags().size());
        TaggingServiceImplTest.assertEquals((String)("Wrong tags on main folder: " + ts2.getTags()), (int)2, (int)ts2.getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTags().get(0).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTags().get(1).getCount());
        TaggingServiceImplTest.assertEquals((String)TAG_2, (String)ts1.getTags().get(0).getName());
        TaggingServiceImplTest.assertEquals((String)TAG_3.toLowerCase(), (String)ts1.getTags().get(1).getName());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts2.getTags().get(0).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts2.getTags().get(1).getCount());
        TaggingServiceImplTest.assertEquals((String)TAG_3.toLowerCase(), (String)ts2.getTags().get(0).getName());
        TaggingServiceImplTest.assertEquals((String)TAG_2, (String)ts2.getTags().get(1).getName());
        tx.commit();
    }

    public void testTagScopeRefresh() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        this.taggingService.addTag(this.subDocument, TAG_1);
        this.taggingService.addTag(this.subDocument, TAG_2);
        this.taggingService.addTag(this.subDocument, TAG_3);
        this.taggingService.addTag(this.subFolder, TAG_1);
        this.taggingService.addTag(this.subFolder, TAG_2);
        this.taggingService.addTag(this.folder, TAG_2);
        tx.commit();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        this.taggingService.addTagScope(this.folder);
        tx.commit();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        TagScope tagScope = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        TaggingServiceImplTest.assertEquals((int)3, (int)tagScope.getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)tagScope.getTag(TAG_2).getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)tagScope.getTag(TAG_1).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)tagScope.getTag(TAG_3.toLowerCase()).getCount());
        tx.commit();
    }

    public void testTagScopeSetUpdate() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        this.taggingService.addTagScope(this.folder);
        this.taggingService.addTag(this.folder, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.document, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.document, TAG_2);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subDocument, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subDocument, TAG_2);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subDocument, TAG_3);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subFolder, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        TagScope ts1 = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)3, (int)ts1.getTags().size());
        TaggingServiceImplTest.assertEquals((int)4, (int)ts1.getTag(TAG_1).getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts1.getTag(TAG_2).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTag(TAG_3.toLowerCase()).getCount());
        ArrayList<String> tags = new ArrayList<String>(3);
        tags.add(TAG_2);
        tags.add(TAG_3);
        tags.add(TAG_4);
        this.taggingService.setTags(this.subDocument, tags);
        tx = this.asyncOccurs.awaitExecution(tx);
        ts1 = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertEquals((int)3, (int)ts1.getTag(TAG_1).getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts1.getTag(TAG_2).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTag(TAG_3.toLowerCase()).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTag(TAG_4).getCount());
        tx.commit();
    }

    public void testETHREEOH_220() throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                TaggingServiceImplTest.this.taggingService.addTagScope(TaggingServiceImplTest.this.folder);
                TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, TaggingServiceImplTest.TAG_I18N);
                return null;
            }
        }, false, true);
        UserTransaction tx = this.asyncOccurs.awaitExecution(null);
        List<String> tags = this.taggingService.getTags(this.folder);
        TaggingServiceImplTest.assertNotNull(tags);
        TaggingServiceImplTest.assertEquals((int)1, (int)tags.size());
        TaggingServiceImplTest.assertEquals((String)TAG_I18N, (String)tags.get(0));
        TagScope tagScope = this.taggingService.findTagScope(this.folder);
        TaggingServiceImplTest.assertNotNull((Object)tagScope);
        TaggingServiceImplTest.assertEquals((int)1, (int)tagScope.getTags().size());
        TagDetails tagDetails = tagScope.getTag(TAG_I18N);
        TaggingServiceImplTest.assertNotNull((Object)tagDetails);
        TaggingServiceImplTest.assertEquals((String)TAG_I18N, (String)tagDetails.getName());
        TaggingServiceImplTest.assertEquals((int)1, (int)tagDetails.getCount());
        tx.commit();
    }

    public void testTagScopeUpdateViaNodePolicies() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        NodeRef tagFoo1 = this.taggingService.createTag(this.folder.getStoreRef(), "Foo1");
        NodeRef tagFoo2 = this.taggingService.createTag(this.folder.getStoreRef(), "Foo2");
        NodeRef tagFoo3 = this.taggingService.createTag(this.folder.getStoreRef(), "Foo3");
        NodeRef tagBar = this.taggingService.createTag(this.folder.getStoreRef(), "Bar");
        ArrayList<NodeRef> tagsList = new ArrayList<NodeRef>();
        HashMap<QName, String> container1Props = new HashMap<QName, String>(1);
        container1Props.put(ContentModel.PROP_NAME, "Container1");
        NodeRef container1 = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, container1Props).getChildRef();
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container1).size());
        HashMap container2Props = new HashMap(1);
        container1Props.put(ContentModel.PROP_NAME, "Container2");
        NodeRef container2 = this.nodeService.createNode(this.folder, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, container2Props).getChildRef();
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container2).size());
        this.taggingService.addTagScope(container1);
        this.taggingService.addTagScope(container2);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(container1));
        TaggingServiceImplTest.assertTrue((boolean)this.taggingService.isTagScope(container2));
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        HashMap<QName, Object> taggedFolderProps = new HashMap<QName, Object>(1);
        taggedFolderProps.put(ContentModel.PROP_NAME, "Folder");
        NodeRef taggedFolder = this.nodeService.createNode(container1, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, taggedFolderProps).getChildRef();
        tx.commit();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        taggedFolderProps.clear();
        tagsList.clear();
        tagsList.add(tagFoo1);
        tagsList.add(tagFoo3);
        taggedFolderProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
        this.nodeService.addProperties(taggedFolder, taggedFolderProps);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((String)("Unexpected tags " + this.taggingService.findTagScope(container1).getTags()), (int)2, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((String)("Unexpected tags " + this.taggingService.findTagScope(container2).getTags()), (int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        tagsList.clear();
        tagsList.add(tagFoo1);
        tagsList.add(tagFoo2);
        HashMap<QName, Object> taggedDocProps = new HashMap<QName, Object>(1);
        taggedDocProps.put(ContentModel.PROP_NAME, "Document");
        taggedDocProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
        NodeRef taggedDoc = this.nodeService.createNode(taggedFolder, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CONTENT, taggedDocProps).getChildRef();
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(taggedFolder).size());
        NodeRef checkedOutDoc = this.checkOutCheckInService.checkout(taggedDoc);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.nodeService.getChildAssocs(taggedFolder).size());
        this.checkOutCheckInService.checkin(checkedOutDoc, null);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(taggedFolder).size());
        taggedDocProps.clear();
        taggedDocProps.put(ContentModel.PROP_NAME, "CopyDoc");
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container2).size());
        NodeRef taggedDoc2 = this.nodeService.createNode(container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CONTENT, taggedDocProps).getChildRef();
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container2).size());
        this.copyService.copy(taggedDoc, taggedDoc2);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.nodeService.getPrimaryParent(taggedDoc2).getParentRef());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.taggingService.findTagScope(taggedDoc2).getNodeRef());
        NodeRef taggedFolder2 = this.copyService.copy(taggedFolder, container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CHILDREN, true);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(taggedFolder2).size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        tagsList.clear();
        tagsList.add(tagBar);
        taggedDocProps.clear();
        taggedDocProps.put(ContentModel.ASPECT_TAGGABLE, tagsList);
        taggedDocProps.put(ContentModel.PROP_NAME, "UpdatedDocument");
        this.nodeService.addProperties(taggedDoc, taggedDocProps);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("bar").getCount());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        taggedDoc = this.nodeService.moveNode(taggedDoc, container2, ContentModel.ASSOC_CONTAINS, ContentModel.ASPECT_TAGGABLE).getChildRef();
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)4, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("bar").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.nodeService.getPrimaryParent(taggedDoc).getParentRef());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.taggingService.findTagScope(taggedDoc).getNodeRef());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.nodeService.getPrimaryParent(taggedDoc2).getParentRef());
        TaggingServiceImplTest.assertEquals((Object)container2, (Object)this.taggingService.findTagScope(taggedDoc2).getNodeRef());
        this.nodeService.deleteNode(taggedDoc);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals(null, (Object)this.taggingService.findTagScope(container2).getTag("bar"));
        this.nodeService.deleteNode(taggedDoc2);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container1).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        TaggingServiceImplTest.assertEquals(null, (Object)this.taggingService.findTagScope(container2).getTag("bar"));
        this.nodeService.deleteNode(taggedFolder);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)3, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(container2).size());
        TaggingServiceImplTest.assertEquals((int)2, (int)this.taggingService.findTagScope(container2).getTag("foo1").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo2").getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)this.taggingService.findTagScope(container2).getTag("foo3").getCount());
        this.nodeService.deleteNode(taggedFolder2);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container1).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.taggingService.findTagScope(container2).getTags().size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container1).size());
        TaggingServiceImplTest.assertEquals((int)0, (int)this.nodeService.getChildAssocs(container2).size());
        tx.commit();
    }

    public void testJSAPI() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        HashMap<String, Object> model = new HashMap<String, Object>(0);
        model.put("folder", this.folder);
        model.put("subFolder", this.subFolder);
        model.put("document", this.document);
        model.put("subDocument", this.subDocument);
        model.put("tagScopeTest", false);
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/tagging/script/test_taggingService.js");
        this.scriptService.executeScript(location, model);
        tx = this.asyncOccurs.awaitExecution(tx);
        tx.commit();
    }

    public void testJSTagScope() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        this.taggingService.createTag(storeRef, "alpha");
        this.taggingService.createTag(storeRef, "alpha double");
        this.taggingService.createTag(storeRef, "beta");
        this.taggingService.createTag(storeRef, "gamma");
        this.taggingService.createTag(storeRef, "delta");
        this.taggingService.addTagScope(this.folder);
        this.taggingService.addTagScope(this.subFolder);
        this.taggingService.addTag(this.subDocument, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subDocument, TAG_2);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subDocument, TAG_3);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subFolder, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.subFolder, TAG_2);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.document, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.document, TAG_2);
        tx = this.asyncOccurs.awaitExecution(tx);
        this.taggingService.addTag(this.folder, TAG_1);
        tx = this.asyncOccurs.awaitExecution(tx);
        HashMap<String, Object> model = new HashMap<String, Object>(0);
        model.put("folder", this.folder);
        model.put("subFolder", this.subFolder);
        model.put("document", this.document);
        model.put("subDocument", this.subDocument);
        model.put("tagScopeTest", true);
        model.put("store", storeRef.toString());
        ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/tagging/script/test_taggingService.js");
        this.scriptService.executeScript(location, model);
        tx = this.asyncOccurs.awaitExecution(tx);
        tx.commit();
    }

    public void testOnStartupJob() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        UpdateTagScopesActionExecuter updateTagsAction = (UpdateTagScopesActionExecuter)ctx.getBean("update-tagscope");
        TaggingServiceImplTest.assertEquals((int)0, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
        String lockF = updateTagsAction.lockTagScope(this.folder);
        String lockSF = updateTagsAction.lockTagScope(this.subFolder);
        this.taggingService.addTagScope(this.folder);
        this.taggingService.addTagScope(this.subFolder);
        this.taggingService.addTag(this.subDocument, TAG_1);
        this.taggingService.addTag(this.subDocument, TAG_2);
        this.taggingService.addTag(this.subFolder, TAG_1);
        this.taggingService.addTag(this.document, TAG_1);
        this.taggingService.addTag(this.folder, TAG_1);
        this.taggingService.addTag(this.folder, TAG_3);
        tx = this.asyncOccurs.awaitExecution(tx);
        TagScope ts1 = this.taggingService.findTagScope(this.folder);
        TagScope ts2 = this.taggingService.findTagScope(this.subFolder);
        TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)0, (int)ts1.getTags().size());
        TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)0, (int)ts2.getTags().size());
        TaggingServiceImplTest.assertEquals((int)2, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
        List<NodeRef> pendingScopes = updateTagsAction.searchForTagScopesPendingUpdates();
        TaggingServiceImplTest.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(this.folder));
        TaggingServiceImplTest.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(this.subFolder));
        UpdateTagScopesQuartzJob job = new UpdateTagScopesQuartzJob();
        job.execute(this.actionService, updateTagsAction);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)2, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
        pendingScopes = updateTagsAction.searchForTagScopesPendingUpdates();
        TaggingServiceImplTest.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(this.folder));
        TaggingServiceImplTest.assertTrue((String)("Not found in " + pendingScopes), (boolean)pendingScopes.contains(this.subFolder));
        updateTagsAction.unlockTagScope(this.folder, lockF);
        updateTagsAction.unlockTagScope(this.subFolder, lockSF);
        job = new UpdateTagScopesQuartzJob();
        job.execute(this.actionService, updateTagsAction);
        tx = this.asyncOccurs.awaitExecution(tx);
        TaggingServiceImplTest.assertEquals((int)0, (int)updateTagsAction.searchForTagScopesPendingUpdates().size());
        ts1 = this.taggingService.findTagScope(this.folder);
        ts2 = this.taggingService.findTagScope(this.subFolder);
        TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)3, (int)ts1.getTags().size());
        TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)2, (int)ts2.getTags().size());
        TaggingServiceImplTest.assertEquals((int)4, (int)ts1.getTag(TAG_1).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTag(TAG_2).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts1.getTag(TAG_3.toLowerCase()).getCount());
        TaggingServiceImplTest.assertEquals((int)2, (int)ts2.getTag(TAG_1).getCount());
        TaggingServiceImplTest.assertEquals((int)1, (int)ts2.getTag(TAG_2).getCount());
        tx.commit();
    }

    public void DISABLEtestMultiThreaded() throws Exception {
        String[] tags;
        UserTransaction tx = this.transactionService.getNonPropagatingUserTransaction();
        tx.begin();
        this.taggingService.addTagScope(this.folder);
        this.taggingService.addTagScope(this.subFolder);
        tx.commit();
        this.asyncOccurs.wantedActionsCount = 0;
        ArrayList<Thread> threads = new ArrayList<Thread>();
        String[] arr$ = tags = new String[]{TAG_1, TAG_2, TAG_3, TAG_4, TAG_5};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String tmpTag;
            final String tag = tmpTag = arr$[i$];
            Thread t = new Thread(new Runnable(){

                public synchronized void run() {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println(Thread.currentThread() + " - About to start tagging for " + tag);
                    AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                    TaggingServiceImplTest.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.folder, tag);
                            TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subFolder, tag);
                            TaggingServiceImplTest.this.taggingService.addTag(TaggingServiceImplTest.this.subDocument, tag);
                            System.out.println(Thread.currentThread() + " - Tagging for " + tag);
                            return null;
                        }
                    }, false, true);
                    System.out.println(Thread.currentThread() + " - Done tagging for " + tag);
                    try {
                        Thread.sleep(150L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            threads.add(t);
            t.start();
        }
        System.out.println("Releasing tagging threads");
        for (Thread t : threads) {
            t.interrupt();
        }
        for (Thread t : threads) {
            t.join();
        }
        System.out.println("All threads should have finished");
        Thread.sleep(150L);
        for (int i = 0; i < 600; ++i) {
            try {
                if (this.asyncOccurs.wantedActionsCount < 5) {
                    Thread.sleep(100L);
                    continue;
                }
                if (this.actionTrackingService.getAllExecutingActions().size() <= 0) break;
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        Thread.sleep(175L);
        System.out.println("Done waiting for tagging, now checking");
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        TagScope ts1 = this.taggingService.findTagScope(this.folder);
        TagScope ts2 = this.taggingService.findTagScope(this.subFolder);
        TaggingServiceImplTest.assertEquals((String)("Wrong tags on folder tagscope: " + ts1.getTags()), (int)5, (int)ts1.getTags().size());
        TaggingServiceImplTest.assertEquals((String)("Wrong tags on subfolder tagscope: " + ts2.getTags()), (int)5, (int)ts2.getTags().size());
        for (String tag : tags) {
            TaggingServiceImplTest.assertEquals((int)3, (int)ts1.getTag(tag.toLowerCase()).getCount());
            TaggingServiceImplTest.assertEquals((int)2, (int)ts2.getTag(tag.toLowerCase()).getCount());
        }
        tx.commit();
    }

    static {
        init = false;
    }

    public class AsyncOccurs
    implements AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute {
        private Object waitForExecutionLock = new Object();
        private static final long waitTime = 3500L;
        private static final String ACTION_TYPE = "update-tagscope";
        private int wantedActionsCount = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAsyncActionExecute(Action action, NodeRef actionedUponNodeRef) {
            if (action.getActionDefinitionName().equals(ACTION_TYPE)) {
                ++this.wantedActionsCount;
                Object object = this.waitForExecutionLock;
                synchronized (object) {
                    try {
                        this.waitForExecutionLock.notify();
                    }
                    catch (IllegalMonitorStateException e) {
                        // empty catch block
                    }
                }
            }
            System.out.println("Ignoring unexpected async action:" + action);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UserTransaction awaitExecution(UserTransaction tx) throws Exception {
            Object object = this.waitForExecutionLock;
            synchronized (object) {
                if (tx != null) {
                    tx.commit();
                }
                this.waitForExecutionLock.wait(25L);
                if (TaggingServiceImplTest.this.actionTrackingService.getExecutingActions(ACTION_TYPE).size() > 0) {
                    long now = System.currentTimeMillis();
                    this.waitForExecutionLock.wait(3500L);
                    if (System.currentTimeMillis() - now >= 3500L) {
                        System.err.println("Warning - trigger wasn't received");
                    }
                }
            }
            for (int i = 0; i < 50 && TaggingServiceImplTest.this.actionTrackingService.getExecutingActions(ACTION_TYPE).size() != 0; ++i) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            tx = TaggingServiceImplTest.this.transactionService.getUserTransaction();
            tx.begin();
            return tx;
        }
    }
}

