/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.alfresco.repo.jscript.CategoryTemplateNode;
import org.alfresco.repo.template.BaseTemplateProcessorExtension;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Classification
extends BaseTemplateProcessorExtension {
    private ServiceRegistry services;
    private StoreRef storeRef;

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    public List<CategoryTemplateNode> getAllCategoryNodes(String aspect) {
        return this.buildCategoryNodes(this.services.getCategoryService().getCategories(this.storeRef, this.createQName(aspect), CategoryService.Depth.ANY));
    }

    public List<CategoryTemplateNode> getAllCategoryNodes(QName aspect) {
        return this.buildCategoryNodes(this.services.getCategoryService().getCategories(this.storeRef, aspect, CategoryService.Depth.ANY));
    }

    public List<QName> getAllClassificationAspects() {
        Collection<QName> aspects = this.services.getCategoryService().getClassificationAspects();
        ArrayList<QName> answer = new ArrayList<QName>(aspects.size());
        answer.addAll(aspects);
        return answer;
    }

    public List<CategoryTemplateNode> getRootCategories(String aspect) {
        return this.buildCategoryNodes(this.services.getCategoryService().getRootCategories(this.storeRef, this.createQName(aspect)));
    }

    private List<CategoryTemplateNode> buildCategoryNodes(Collection<ChildAssociationRef> cars) {
        ArrayList<CategoryTemplateNode> categoryNodes = new ArrayList<CategoryTemplateNode>(cars.size());
        for (ChildAssociationRef car : cars) {
            categoryNodes.add(new CategoryTemplateNode(car.getChildRef(), this.services, this.getTemplateImageResolver()));
        }
        return categoryNodes;
    }

    private QName createQName(String s) {
        QName qname = s.indexOf(123) != -1 ? QName.createQName((String)s) : QName.createQName((String)s, (NamespacePrefixResolver)this.services.getNamespaceService());
        return qname;
    }
}

