/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.processor.ProcessorExtension;
import org.alfresco.repo.processor.BaseProcessor;
import org.alfresco.repo.template.AVMTemplateNode;
import org.alfresco.repo.template.ClassPathRepoTemplateLoader;
import org.alfresco.repo.template.QNameAwareObjectWrapper;
import org.alfresco.repo.template.TemplateAssociation;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.repository.TemplateProcessor;
import org.alfresco.service.cmr.repository.TemplateProcessorExtension;
import org.alfresco.service.cmr.repository.TemplateValueConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreeMarkerProcessor
extends BaseProcessor
implements TemplateProcessor,
TemplateValueConverter {
    private static final String MSG_ERROR_NO_TEMPLATE = "error_no_template";
    private static final String MSG_ERROR_TEMPLATE_FAIL = "error_template_fail";
    private static final String MSG_ERROR_TEMPLATE_IO = "error_template_io";
    private static final Log logger = LogFactory.getLog(FreeMarkerProcessor.class);
    private static final String PATH = "string://fixed";
    private Configuration config;
    private String defaultEncoding;

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    protected synchronized Configuration getConfig() {
        if (this.config == null) {
            this.config = new Configuration();
            this.config.setCacheStorage((CacheStorage)new MruCacheStorage(32, 32));
            this.config.setTemplateLoader((TemplateLoader)new ClassPathRepoTemplateLoader(this.services.getNodeService(), this.services.getContentService(), this.defaultEncoding));
            this.config.setObjectWrapper((ObjectWrapper)new QNameAwareObjectWrapper());
            this.config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            this.config.setLocalizedLookup(false);
            if (this.defaultEncoding != null) {
                this.config.setDefaultEncoding(this.defaultEncoding);
            }
        }
        return this.config;
    }

    protected Configuration getStringConfig(String path, String template) {
        Configuration config = new Configuration();
        config.setCacheStorage((CacheStorage)new MruCacheStorage(2, 0));
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate(path, template);
        config.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        config.setObjectWrapper((ObjectWrapper)new QNameAwareObjectWrapper());
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        if (this.defaultEncoding != null) {
            config.setDefaultEncoding(this.defaultEncoding);
        }
        return config;
    }

    public void process(String template, Object model, Writer out) {
        if (template == null || template.length() == 0) {
            throw new IllegalArgumentException("Template name is mandatory.");
        }
        if (model == null) {
            throw new IllegalArgumentException("Model is mandatory.");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output Writer is mandatory.");
        }
        try {
            Template t;
            long startTime = 0L;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing template: " + template));
                startTime = System.currentTimeMillis();
            }
            if ((t = this.getConfig().getTemplate(template)) != null) {
                try {
                    Object freeMarkerModel = this.convertToFreeMarkerModel(model);
                    t.process(freeMarkerModel, out);
                }
                catch (Throwable err) {
                    throw new TemplateException(MSG_ERROR_TEMPLATE_FAIL, new Object[]{err.getMessage()}, err);
                }
            } else {
                throw new TemplateException(MSG_ERROR_NO_TEMPLATE, new Object[]{template});
            }
            if (logger.isDebugEnabled()) {
                long endTime = System.currentTimeMillis();
                logger.debug((Object)("Time to execute template: " + (endTime - startTime) + "ms"));
            }
        }
        catch (IOException ioerr) {
            throw new TemplateException(MSG_ERROR_TEMPLATE_IO, new Object[]{template}, ioerr);
        }
    }

    public void processString(String template, Object model, Writer out) {
        block10: {
            if (template == null || template.length() == 0) {
                throw new IllegalArgumentException("Template is mandatory.");
            }
            if (model == null) {
                throw new IllegalArgumentException("Model is mandatory.");
            }
            if (out == null) {
                throw new IllegalArgumentException("Output Writer is mandatory.");
            }
            try {
                Template t;
                long startTime = 0L;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing template: " + template));
                    startTime = System.currentTimeMillis();
                }
                if ((t = this.getStringConfig(PATH, template).getTemplate(PATH)) != null) {
                    try {
                        Object freeMarkerModel = this.convertToFreeMarkerModel(model);
                        t.process(freeMarkerModel, out);
                        if (logger.isDebugEnabled()) {
                            long endTime = System.currentTimeMillis();
                            logger.debug((Object)("Time to execute template: " + (endTime - startTime) + "ms"));
                        }
                        break block10;
                    }
                    catch (Throwable err) {
                        throw new TemplateException(MSG_ERROR_TEMPLATE_FAIL, new Object[]{err.getMessage()}, err);
                    }
                }
                throw new TemplateException(MSG_ERROR_NO_TEMPLATE, new Object[]{template});
            }
            catch (IOException ioerr) {
                throw new TemplateException(MSG_ERROR_TEMPLATE_IO, new Object[]{template}, ioerr);
            }
        }
    }

    private Object convertToFreeMarkerModel(Object model) {
        if (model instanceof Map) {
            HashMap<String, ProcessorExtension> freeMarkerModel = new HashMap<String, ProcessorExtension>(((Map)model).size());
            TemplateImageResolver imageResolver = (TemplateImageResolver)((Map)model).get("imageresolver");
            for (ProcessorExtension ext : this.processorExtensions.values()) {
                if (ext instanceof TemplateProcessorExtension) {
                    ((TemplateProcessorExtension)ext).setTemplateImageResolver(imageResolver);
                }
                freeMarkerModel.put(ext.getExtensionName(), ext);
            }
            Map value = (Map)this.convertValue(model, imageResolver);
            freeMarkerModel.putAll(value);
            return freeMarkerModel;
        }
        return this.convertValue(model, null);
    }

    public Object convertValue(Object value, TemplateImageResolver imageResolver) {
        if (value instanceof NodeRef) {
            NodeRef ref = (NodeRef)value;
            if ("avm".equals(ref.getStoreRef().getProtocol())) {
                return new AVMTemplateNode((NodeRef)value, this.services, imageResolver);
            }
            return new TemplateNode((NodeRef)value, this.services, imageResolver);
        }
        if (value instanceof AssociationRef) {
            return new TemplateAssociation((AssociationRef)value, this.services, imageResolver);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            HashMap<String, Object> convertedMap = new HashMap<String, Object>(map.size());
            for (Object key : map.keySet()) {
                String strKey = key.toString();
                if (strKey.equals("imageresolver")) continue;
                Object mapValue = map.get(key);
                convertedMap.put(strKey, this.convertValue(mapValue, imageResolver));
            }
            return convertedMap;
        }
        if (value instanceof List) {
            List list = (List)value;
            ArrayList<Object> convertedList = new ArrayList<Object>(list.size());
            for (Object listVal : list) {
                convertedList.add(this.convertValue(listVal, imageResolver));
            }
            return convertedList;
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            Object[] convertedArray = new Object[array.length];
            int i = 0;
            for (Object item : array) {
                convertedArray[i++] = this.convertValue(item, imageResolver);
            }
            return convertedArray;
        }
        return value;
    }
}

