/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.content.transform.swf.SWFTransformationOptions;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.thumbnail.ThumbnailException;
import org.alfresco.service.cmr.thumbnail.ThumbnailParentAssociationDetails;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbnailServiceImpl
implements ThumbnailService {
    private static Log logger = LogFactory.getLog(ThumbnailServiceImpl.class);
    private static final String ERR_DUPLICATE_NAME = "Thumbnail could not be created because of a duplicate name";
    private static final String ERR_NO_PARENT = "Thumbnail has no parent so update cannot take place.";
    private static final String SUBTYPES_POSTFIX = "/*";
    private NodeService nodeService;
    private ThumbnailRegistry thumbnailRegistry;
    private RenditionService renditionService;

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setThumbnailRegistry(ThumbnailRegistry thumbnailRegistry) {
        this.thumbnailRegistry = thumbnailRegistry;
    }

    @Override
    public ThumbnailRegistry getThumbnailRegistry() {
        return this.thumbnailRegistry;
    }

    @Override
    public NodeRef createThumbnail(NodeRef node, QName contentProperty, String mimetype, TransformationOptions transformationOptions, String thumbnailName) {
        return this.createThumbnail(node, contentProperty, mimetype, transformationOptions, thumbnailName, null);
    }

    @Override
    public NodeRef createThumbnail(final NodeRef node, final QName contentProperty, final String mimetype, final TransformationOptions transformationOptions, final String thumbnailName, final ThumbnailParentAssociationDetails assocDetails) {
        ParameterCheck.mandatory((String)"node", (Object)node);
        ParameterCheck.mandatory((String)"contentProperty", (Object)contentProperty);
        ParameterCheck.mandatoryString((String)"mimetype", (String)mimetype);
        ParameterCheck.mandatory((String)"transformationOptions", (Object)transformationOptions);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating thumbnail (node=" + node.toString() + "; contentProperty=" + contentProperty.toString() + "; mimetype=" + mimetype));
        }
        this.checkThumbnailNameIsUnique(node, thumbnailName, contentProperty, mimetype);
        return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                return ThumbnailServiceImpl.this.createThumbnailNode(node, contentProperty, mimetype, transformationOptions, thumbnailName, assocDetails);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void checkThumbnailNameIsUnique(NodeRef node, String thumbnailName, QName contentProperty, String mimetype) {
        if (thumbnailName != null && this.getThumbnailByName(node, contentProperty, thumbnailName) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating thumbnail: There is already a thumbnail with the name '" + thumbnailName + "' (node=" + node.toString() + "; contentProperty=" + contentProperty.toString() + "; mimetype=" + mimetype));
            }
            throw new ThumbnailException(ERR_DUPLICATE_NAME);
        }
    }

    private QName getThumbnailQName(String localThumbnailName) {
        if (localThumbnailName == null || localThumbnailName.length() == 0) {
            localThumbnailName = GUID.generate();
        }
        QName thumbnailQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)localThumbnailName);
        return thumbnailQName;
    }

    private String getRenderingEngineNameFor(TransformationOptions options) {
        if (options instanceof ImageTransformationOptions) {
            return "imageRenderingEngine";
        }
        if (options instanceof SWFTransformationOptions) {
            return "reformat";
        }
        return "";
    }

    public NodeRef getThumbnailNode(ChildAssociationRef thumbnailRef) {
        return thumbnailRef.getChildRef();
    }

    @Override
    public void updateThumbnail(NodeRef thumbnail, TransformationOptions transformationOptions) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating thumbnail (thumbnail=" + thumbnail.toString() + ")"));
        }
        if (this.renditionService.isRendition(thumbnail)) {
            ChildAssociationRef parentAssoc = this.renditionService.getSourceNode(thumbnail);
            if (parentAssoc == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updating thumbnail: The thumbnails parent cannot be found (thumbnail=" + thumbnail.toString() + ")"));
                }
                throw new ThumbnailException(ERR_NO_PARENT);
            }
            QName renditionAssociationName = parentAssoc.getQName();
            NodeRef sourceNode = parentAssoc.getParentRef();
            QName contentProperty = (QName)this.nodeService.getProperty(thumbnail, ContentModel.PROP_CONTENT_PROPERTY_NAME);
            transformationOptions.setSourceNodeRef(sourceNode);
            transformationOptions.setSourceContentProperty(contentProperty);
            transformationOptions.setTargetContentProperty(ContentModel.PROP_CONTENT);
            RenditionDefinition rendDefn = this.renditionService.loadRenditionDefinition(renditionAssociationName);
            if (rendDefn == null) {
                String renderingEngineName = this.getRenderingEngineNameFor(transformationOptions);
                rendDefn = this.renditionService.createRenditionDefinition(parentAssoc.getQName(), renderingEngineName);
            }
            Map<String, Serializable> params = this.thumbnailRegistry.getThumbnailRenditionConvertor().convert(transformationOptions, null);
            for (String key : params.keySet()) {
                rendDefn.setParameterValue(key, params.get(key));
            }
            this.renditionService.render(sourceNode, rendDefn);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating thumbnail: cannot update a thumbnail node that isn't the correct thumbnail type (thumbnail=" + thumbnail.toString() + ")"));
        }
    }

    @Override
    public NodeRef getThumbnailByName(NodeRef node, QName contentProperty, String thumbnailName) {
        NodeRef child;
        Serializable contentPropertyName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting thumbnail by name (nodeRef=" + node.toString() + "; contentProperty=" + contentProperty.toString() + "; thumbnailName=" + thumbnailName + ")"));
        }
        QName namespacedThumbnailName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)thumbnailName);
        ChildAssociationRef existingRendition = this.renditionService.getRenditionByName(node, namespacedThumbnailName);
        NodeRef thumbnail = null;
        if (existingRendition != null && contentProperty.equals((Object)(contentPropertyName = this.nodeService.getProperty(child = existingRendition.getChildRef(), ContentModel.PROP_CONTENT_PROPERTY_NAME)))) {
            thumbnail = child;
        }
        return thumbnail;
    }

    @Override
    public List<NodeRef> getThumbnails(NodeRef node, QName contentProperty, String mimetype, TransformationOptions options) {
        ArrayList<NodeRef> thumbnails = new ArrayList<NodeRef>(5);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting thumbnails (nodeRef=" + node.toString() + "; contentProperty=" + contentProperty.toString() + "; mimetype=" + mimetype + ")"));
        }
        List<ChildAssociationRef> renditions = this.renditionService.getRenditions(node);
        for (ChildAssociationRef assoc : renditions) {
            NodeRef child = assoc.getChildRef();
            if (!contentProperty.equals((Object)this.nodeService.getProperty(child, ContentModel.PROP_CONTENT_PROPERTY_NAME)) || !this.matchMimetypeOptions(child, mimetype, options)) continue;
            thumbnails.add(child);
        }
        return thumbnails;
    }

    private boolean matchMimetypeOptions(NodeRef thumbnail, String mimetype, TransformationOptions options) {
        boolean result = true;
        if (mimetype != null) {
            String thumbnailMimetype = ((ContentData)this.nodeService.getProperty(thumbnail, ContentModel.PROP_CONTENT)).getMimetype();
            if (mimetype.endsWith(SUBTYPES_POSTFIX)) {
                String baseMimetype = mimetype.substring(0, mimetype.length() - SUBTYPES_POSTFIX.length());
                if (thumbnailMimetype == null || !thumbnailMimetype.startsWith(baseMimetype)) {
                    result = false;
                }
            } else if (!mimetype.equals(thumbnailMimetype)) {
                result = false;
            }
        }
        if (!result || options != null) {
            // empty if block
        }
        return result;
    }

    private RenditionDefinition createRawRenditionDefinition(QName thumbnailQName, TransformationOptions transformationOptions) {
        String renderingEngineName = this.getRenderingEngineNameFor(transformationOptions);
        RenditionDefinition definition = this.renditionService.createRenditionDefinition(thumbnailQName, renderingEngineName);
        return definition;
    }

    private RenditionDefinition createRenditionDefinition(QName contentProperty, String mimetype, TransformationOptions transformationOptions, QName thumbnailQName, ThumbnailParentAssociationDetails assocDetails) {
        RenditionDefinition definition = this.createRawRenditionDefinition(thumbnailQName, transformationOptions);
        Map<String, Serializable> params = this.thumbnailRegistry.getThumbnailRenditionConvertor().convert(transformationOptions, assocDetails);
        params.put("sourceContentProperty", (Serializable)contentProperty);
        params.put("mime-type", (Serializable)((Object)mimetype));
        definition.addParameterValues(params);
        return definition;
    }

    private NodeRef createThumbnailNode(NodeRef node, QName contentProperty, String mimetype, TransformationOptions transformationOptions, String thumbnailName, ThumbnailParentAssociationDetails assocDetails) {
        QName thumbnailQName = this.getThumbnailQName(thumbnailName);
        RenditionDefinition definition = this.createRenditionDefinition(contentProperty, mimetype, transformationOptions, thumbnailQName, assocDetails);
        try {
            ChildAssociationRef thumbnailAssoc = this.renditionService.render(node, definition);
            NodeRef thumbnail = this.getThumbnailNode(thumbnailAssoc);
            this.setThumbnailNameProperty(thumbnail, thumbnailName);
            return thumbnail;
        }
        catch (RenditionServiceException rsx) {
            throw new ThumbnailException(rsx.getMessage(), (Throwable)((Object)rsx));
        }
    }

    private void setThumbnailNameProperty(NodeRef thumbnail, String thumbnailName) {
        if (thumbnailName != null && thumbnailName.length() > 0 && ContentModel.TYPE_THUMBNAIL.equals((Object)this.nodeService.getType(thumbnail))) {
            this.nodeService.setProperty(thumbnail, ContentModel.PROP_THUMBNAIL_NAME, (Serializable)((Object)thumbnailName));
        }
    }
}

