/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.alfresco.repo.transfer.ContentChunkProcessor;
import org.alfresco.repo.transfer.ContentChunker;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.transfer.TransferException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentChunkerImpl
implements ContentChunker {
    private static Log logger = LogFactory.getLog(ContentChunkerImpl.class);
    private long chunkSize = 1000000L;
    private ContentChunkProcessor handler;
    private Set<ContentData> buffer = new HashSet<ContentData>();

    public void addContent(ContentData data) throws TransferException {
        logger.debug((Object)("add content size:" + data.getSize()));
        this.buffer.add(data);
        Iterator<ContentData> iter = this.buffer.iterator();
        long totalContentSize = 0L;
        while (iter.hasNext()) {
            ContentData x = iter.next();
            totalContentSize += x.getSize();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("elements " + this.buffer.size() + ", totalContentSize:" + totalContentSize));
        }
        if (totalContentSize >= this.chunkSize) {
            this.flush();
        }
    }

    public void flush() throws TransferException {
        logger.debug((Object)("flush number of contents:" + this.buffer.size()));
        if (this.buffer.size() > 0) {
            this.handler.processChunk(this.buffer);
        }
        this.buffer.clear();
        logger.debug((Object)"buffer empty");
    }

    public void setChunkSize(long chunkSize) {
        this.chunkSize = chunkSize;
    }

    public long getChunkSize() {
        return this.chunkSize;
    }

    public void setHandler(ContentChunkProcessor handler) {
        this.handler = handler;
    }

    public ContentChunkProcessor getHandler() {
        return this.handler;
    }
}

