/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.usage;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.usage.ContentUsageService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageQuotaProtector
implements NodeServicePolicies.OnUpdatePropertiesPolicy {
    private AuthorityService authorityService;
    private PolicyComponent policyComponent;
    private ContentUsageService contentUsageService;

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setContentUsageService(ContentUsageService contentUsageService) {
        this.contentUsageService = contentUsageService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void init() {
        if (this.contentUsageService.getEnabled()) {
            this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        }
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        Long sizeCurrentBefore = (Long)before.get(ContentModel.PROP_SIZE_CURRENT);
        Long sizeCurrentAfter = (Long)after.get(ContentModel.PROP_SIZE_CURRENT);
        Long sizeQuotaBefore = (Long)before.get(ContentModel.PROP_SIZE_QUOTA);
        Long sizeQuotaAfter = (Long)after.get(ContentModel.PROP_SIZE_QUOTA);
        if (sizeCurrentBefore != sizeCurrentAfter && sizeCurrentBefore != null && !this.authorityService.hasAdminAuthority() && !AuthenticationUtil.isRunAsUserTheSystemUser()) {
            throw new AlfrescoRuntimeException("Update failed: protected property 'sizeCurrent'");
        }
        if (sizeQuotaBefore != sizeQuotaAfter && sizeQuotaBefore != null && !this.authorityService.hasAdminAuthority() && !AuthenticationUtil.isRunAsUserTheSystemUser()) {
            throw new AlfrescoRuntimeException("Update failed: protected property 'sizeQuota'");
        }
    }
}

