/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.MLPropertyInterceptor;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.repo.version.common.AbstractVersionServiceImpl;
import org.alfresco.repo.version.common.VersionHistoryImpl;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.version.ReservedVersionNameException;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionServiceImpl
extends AbstractVersionServiceImpl
implements VersionService,
VersionModel {
    private static Log logger = LogFactory.getLog(VersionServiceImpl.class);
    protected static final String MSGID_ERR_NOT_FOUND = "version_service.err_not_found";
    protected static final String MSGID_ERR_NO_BRANCHES = "version_service.err_unsupported";
    protected static final String MSGID_ERR_RESTORE_EXISTS = "version_service.err_restore_exists";
    protected static final String MSGID_ERR_ONE_PRECEEDING = "version_service.err_one_preceeding";
    protected static final String MSGID_ERR_RESTORE_NO_VERSION = "version_service.err_restore_no_version";
    protected static final String MSGID_ERR_REVERT_MISMATCH = "version_service.err_revert_mismatch";
    protected NodeService dbNodeService;
    protected BehaviourFilter policyBehaviourFilter;
    protected SearchService searcher;

    public void setDbNodeService(NodeService nodeService) {
        this.dbNodeService = nodeService;
    }

    public void setSearcher(SearchService searcher) {
        this.searcher = searcher;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    @Override
    public void registerVersionLabelPolicy(QName typeQName, VersionServicePolicies.CalculateVersionLabelPolicy policy) {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"calculateVersionLabel"), typeQName, (Behaviour)new JavaBehaviour(policy, "calculateVersionLabel"));
    }

    @Override
    public void initialise() {
        super.initialise();
    }

    protected void initialiseWithoutBind() {
        super.initialise();
    }

    @Override
    public StoreRef getVersionStoreReference() {
        return new StoreRef("workspace", "lightWeightVersionStore");
    }

    @Override
    public Version createVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties) throws ReservedVersionNameException, AspectMissingException {
        long startTime = System.currentTimeMillis();
        int versionNumber = 0;
        Version version = this.createVersion(nodeRef, versionProperties, versionNumber);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("created version (" + VersionUtil.convertNodeRef(version.getFrozenStateNodeRef()) + ") in " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return version;
    }

    @Override
    public Collection<Version> createVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties, boolean versionChildren) throws ReservedVersionNameException, AspectMissingException {
        long startTime = System.currentTimeMillis();
        int versionNumber = 0;
        Collection<Version> versions = this.createVersion(nodeRef, versionProperties, versionChildren, versionNumber);
        if (logger.isDebugEnabled()) {
            Version[] versionsArray = versions.toArray(new Version[0]);
            Version version = versionsArray[versionsArray.length - 1];
            logger.debug((Object)("created version (" + VersionUtil.convertNodeRef(version.getFrozenStateNodeRef()) + ") in " + (System.currentTimeMillis() - startTime) + " ms " + (versionChildren ? "(with " + (versions.size() - 1) + " children)" : "")));
        }
        return versions;
    }

    private Collection<Version> createVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties, boolean versionChildren, int versionNumber) throws ReservedVersionNameException, AspectMissingException {
        ArrayList<Version> result = new ArrayList<Version>();
        if (versionChildren) {
            List children = this.dbNodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssoc : children) {
                Collection<Version> childVersions = this.createVersion(childAssoc.getChildRef(), versionProperties, versionChildren, versionNumber);
                result.addAll(childVersions);
            }
        }
        result.add(this.createVersion(nodeRef, versionProperties, versionNumber));
        return result;
    }

    @Override
    public Collection<Version> createVersion(Collection<NodeRef> nodeRefs, Map<String, Serializable> versionProperties) throws ReservedVersionNameException, AspectMissingException {
        long startTime = System.currentTimeMillis();
        ArrayList<Version> result = new ArrayList<Version>(nodeRefs.size());
        int versionNumber = 0;
        for (NodeRef nodeRef : nodeRefs) {
            result.add(this.createVersion(nodeRef, versionProperties, versionNumber));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("created version list (" + this.getVersionStoreReference() + ") in " + (System.currentTimeMillis() - startTime) + " ms (with " + nodeRefs.size() + " nodes)"));
        }
        return result;
    }

    protected Version createVersion(NodeRef nodeRef, Map<String, Serializable> origVersionProperties, int versionNumber) throws ReservedVersionNameException {
        long startTime = System.currentTimeMillis();
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        if (origVersionProperties != null) {
            versionProperties.putAll(origVersionProperties);
        }
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        }
        this.invokeBeforeCreateVersion(nodeRef);
        VersionUtil.checkVersionPropertyNames(versionProperties.keySet());
        NodeRef versionHistoryRef = this.getVersionHistoryNodeRef(nodeRef);
        NodeRef currentVersionRef = null;
        if (versionHistoryRef == null) {
            versionHistoryRef = this.createVersionHistory(nodeRef);
        } else {
            Version currentVersion;
            currentVersionRef = this.getCurrentVersionNodeRef(versionHistoryRef, nodeRef);
            if (currentVersionRef == null) {
                throw new VersionServiceException(MSGID_ERR_NOT_FOUND);
            }
            VersionHistory versionHistory = this.buildVersionHistory(versionHistoryRef, nodeRef);
            if (versionHistory.getSuccessors(currentVersion = this.getVersion(currentVersionRef)).size() != 0) {
                throw new VersionServiceException(MSGID_ERR_NO_BRANCHES);
            }
        }
        QName classRef = this.nodeService.getType(nodeRef);
        PolicyScope nodeDetails = new PolicyScope(classRef);
        this.invokeOnCreateVersion(nodeRef, versionProperties, nodeDetails);
        NodeRef newVersionRef = this.createNewVersion(nodeRef, versionHistoryRef, this.getStandardVersionProperties(versionProperties, nodeRef, currentVersionRef, versionNumber), versionProperties, nodeDetails);
        if (currentVersionRef == null) {
            this.dbNodeService.createAssociation(versionHistoryRef, newVersionRef, ASSOC_ROOT_VERSION);
        } else {
            this.dbNodeService.createAssociation(currentVersionRef, newVersionRef, ASSOC_SUCCESSOR);
        }
        Version version = this.getVersion(newVersionRef);
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)version.getVersionLabel()));
        HashMap<QName, Serializable> versionLabelAsMap = new HashMap<QName, Serializable>(1);
        versionLabelAsMap.put(ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)version.getVersionLabel()));
        this.freezeProperties(newVersionRef, versionLabelAsMap);
        this.invokeAfterCreateVersion(nodeRef, version);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("created Version (" + this.getVersionStoreReference() + ") " + nodeRef + " in " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return version;
    }

    private NodeRef createVersionHistory(NodeRef nodeRef) {
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, nodeRef.getId());
        props.put(PROP_QNAME_VERSIONED_NODE_ID, nodeRef.getId());
        ChildAssociationRef childAssocRef = this.dbNodeService.createNode(this.getRootNode(), CHILD_QNAME_VERSION_HISTORIES, QName.createQName((String)"http://www.alfresco.org/model/versionstore/1.0", (String)nodeRef.getId()), TYPE_QNAME_VERSION_HISTORY, props);
        return childAssocRef.getChildRef();
    }

    @Override
    public VersionHistory getVersionHistory(NodeRef nodeRef) {
        NodeRef versionHistoryRef;
        VersionHistory versionHistory = null;
        if (this.nodeService.exists(nodeRef) && (versionHistoryRef = this.getVersionHistoryNodeRef(nodeRef)) != null) {
            versionHistory = this.buildVersionHistory(versionHistoryRef, nodeRef);
        }
        return versionHistory;
    }

    @Override
    public Version getCurrentVersion(NodeRef nodeRef) {
        VersionHistory versionHistory;
        Version version = null;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && (versionHistory = this.getVersionHistory(nodeRef)) != null) {
            String versionLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
            version = versionHistory.getVersion(versionLabel);
        }
        return version;
    }

    private Map<QName, Serializable> getStandardVersionProperties(Map<String, Serializable> versionProperties, NodeRef nodeRef, NodeRef preceedingNodeRef, int versionNumber) {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>(10);
        result.put(VersionModel.PROP_QNAME_FROZEN_NODE_ID, (Serializable)((Object)nodeRef.getId()));
        result.put(VersionModel.PROP_QNAME_FROZEN_NODE_STORE_PROTOCOL, (Serializable)((Object)nodeRef.getStoreRef().getProtocol()));
        result.put(VersionModel.PROP_QNAME_FROZEN_NODE_STORE_ID, (Serializable)((Object)nodeRef.getStoreRef().getIdentifier()));
        QName nodeType = this.nodeService.getType(nodeRef);
        result.put(VersionModel.PROP_QNAME_FROZEN_NODE_TYPE, (Serializable)nodeType);
        Set aspects = this.nodeService.getAspects(nodeRef);
        result.put(VersionModel.PROP_QNAME_FROZEN_ASPECTS, (Serializable)((Object)aspects));
        QName classRef = this.nodeService.getType(nodeRef);
        Version preceedingVersion = this.getVersion(preceedingNodeRef);
        String versionLabel = this.invokeCalculateVersionLabel(classRef, preceedingVersion, versionNumber, versionProperties);
        result.put(VersionModel.PROP_QNAME_VERSION_LABEL, (Serializable)((Object)versionLabel));
        return result;
    }

    private NodeRef createNewVersion(NodeRef versionableNodeRef, NodeRef versionHistoryRef, Map<QName, Serializable> standardVersionProperties, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        ChildAssociationRef childAssocRef = this.dbNodeService.createNode(versionHistoryRef, CHILD_QNAME_VERSIONS, CHILD_QNAME_VERSIONS, TYPE_QNAME_VERSION, standardVersionProperties);
        NodeRef versionNodeRef = childAssocRef.getChildRef();
        this.storeVersionMetaData(versionNodeRef, versionProperties);
        this.freezeProperties(versionNodeRef, nodeDetails.getProperties());
        this.freezeChildAssociations(versionNodeRef, nodeDetails.getChildAssociations());
        this.freezeAssociations(versionNodeRef, nodeDetails.getAssociations());
        this.freezeAspects(nodeDetails, versionNodeRef, nodeDetails.getAspects());
        return versionNodeRef;
    }

    private void storeVersionMetaData(NodeRef versionNodeRef, Map<String, Serializable> versionProperties) {
        for (Map.Entry<String, Serializable> entry : versionProperties.entrySet()) {
            HashMap<QName, Object> properties = new HashMap<QName, Object>();
            properties.put(PROP_QNAME_META_DATA_NAME, entry.getKey());
            properties.put(PROP_QNAME_META_DATA_VALUE, entry.getValue());
            this.dbNodeService.createNode(versionNodeRef, CHILD_QNAME_VERSION_META_DATA, CHILD_QNAME_VERSION_META_DATA, TYPE_QNAME_VERSION_META_DATA_VALUE, properties);
        }
    }

    protected Map<String, Serializable> getVersionMetaData(NodeRef versionNodeRef) {
        List metaData = this.dbNodeService.getChildAssocs(versionNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)CHILD_QNAME_VERSION_META_DATA);
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(metaData.size());
        for (ChildAssociationRef ref : metaData) {
            NodeRef metaDataValue = ref.getChildRef();
            String name = (String)((Object)this.dbNodeService.getProperty(metaDataValue, PROP_QNAME_META_DATA_NAME));
            Serializable value = this.dbNodeService.getProperty(metaDataValue, PROP_QNAME_META_DATA_VALUE);
            versionProperties.put(name, value);
        }
        return versionProperties;
    }

    private void freezeAspects(PolicyScope nodeDetails, NodeRef versionNodeRef, Set<QName> aspects) {
        for (QName aspect : aspects) {
            this.freezeProperties(versionNodeRef, nodeDetails.getProperties(aspect));
            this.freezeChildAssociations(versionNodeRef, nodeDetails.getChildAssociations(aspect));
            this.freezeAssociations(versionNodeRef, nodeDetails.getAssociations(aspect));
        }
    }

    private void freezeAssociations(NodeRef versionNodeRef, List<AssociationRef> associations) {
        for (AssociationRef targetAssoc : associations) {
            HashMap<QName, Object> properties = new HashMap<QName, Object>();
            properties.put(PROP_QNAME_ASSOC_TYPE_QNAME, targetAssoc.getTypeQName());
            properties.put(ContentModel.PROP_REFERENCE, targetAssoc.getTargetRef());
            this.dbNodeService.createNode(versionNodeRef, CHILD_QNAME_VERSIONED_ASSOCS, CHILD_QNAME_VERSIONED_ASSOCS, TYPE_QNAME_VERSIONED_ASSOC, properties);
        }
    }

    private void freezeChildAssociations(NodeRef versionNodeRef, List<ChildAssociationRef> childAssociations) {
        for (ChildAssociationRef childAssocRef : childAssociations) {
            HashMap<QName, Object> properties = new HashMap<QName, Object>();
            properties.put(PROP_QNAME_ASSOC_QNAME, childAssocRef.getQName());
            properties.put(PROP_QNAME_ASSOC_TYPE_QNAME, childAssocRef.getTypeQName());
            properties.put(PROP_QNAME_IS_PRIMARY, childAssocRef.isPrimary());
            properties.put(PROP_QNAME_NTH_SIBLING, childAssocRef.getNthSibling());
            properties.put(ContentModel.PROP_REFERENCE, childAssocRef.getChildRef());
            this.dbNodeService.createNode(versionNodeRef, CHILD_QNAME_VERSIONED_CHILD_ASSOCS, CHILD_QNAME_VERSIONED_CHILD_ASSOCS, TYPE_QNAME_VERSIONED_CHILD_ASSOC, properties);
        }
    }

    private void freezeProperties(NodeRef versionNodeRef, Map<QName, Serializable> properties) {
        for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
            HashMap<QName, Object> props = new HashMap<QName, Object>();
            props.put(PROP_QNAME_QNAME, entry.getKey());
            if (entry.getValue() instanceof Collection) {
                props.put(PROP_QNAME_MULTI_VALUE, entry.getValue());
                props.put(PROP_QNAME_IS_MULTI_VALUE, true);
            } else {
                props.put(PROP_QNAME_VALUE, entry.getValue());
                props.put(PROP_QNAME_IS_MULTI_VALUE, false);
            }
            this.dbNodeService.createNode(versionNodeRef, CHILD_QNAME_VERSIONED_ATTRIBUTES, CHILD_QNAME_VERSIONED_ATTRIBUTES, TYPE_QNAME_VERSIONED_PROPERTY, props);
        }
    }

    protected NodeRef getRootNode() {
        return this.dbNodeService.getRootNode(this.getVersionStoreReference());
    }

    protected VersionHistory buildVersionHistory(NodeRef versionHistoryRef, NodeRef nodeRef) {
        VersionHistoryImpl versionHistory = null;
        ArrayList<NodeRef> versionHistoryNodeRefs = new ArrayList<NodeRef>();
        NodeRef currentVersion = this.nodeService.exists(nodeRef) ? this.getCurrentVersionNodeRef(versionHistoryRef, nodeRef) : VersionUtil.convertNodeRef(this.getLatestVersion(nodeRef).getFrozenStateNodeRef());
        while (currentVersion != null) {
            AssociationRef preceedingVersion = null;
            versionHistoryNodeRefs.add(0, currentVersion);
            List preceedingVersions = this.dbNodeService.getSourceAssocs(currentVersion, (QNamePattern)VersionModel.ASSOC_SUCCESSOR);
            if (preceedingVersions.size() == 1) {
                preceedingVersion = (AssociationRef)preceedingVersions.toArray()[0];
                currentVersion = preceedingVersion.getSourceRef();
                continue;
            }
            if (preceedingVersions.size() > 1) {
                throw new VersionServiceException(MSGID_ERR_ONE_PRECEEDING);
            }
            currentVersion = null;
        }
        boolean isRoot = true;
        Version preceeding = null;
        for (NodeRef versionRef : versionHistoryNodeRefs) {
            Version version = this.getVersion(versionRef);
            if (isRoot) {
                versionHistory = new VersionHistoryImpl(version);
                isRoot = false;
            } else {
                ((VersionHistoryImpl)versionHistory).addVersion(version, preceeding);
            }
            preceeding = version;
        }
        return versionHistory;
    }

    protected Version getVersion(NodeRef versionRef) {
        if (versionRef == null) {
            return null;
        }
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        Map nodeProperties = this.dbNodeService.getProperties(versionRef);
        for (QName key : nodeProperties.keySet()) {
            Serializable value = (Serializable)nodeProperties.get(key);
            versionProperties.put(key.getLocalName(), value);
        }
        Map<String, Serializable> versionMetaDataProperties = this.getVersionMetaData(versionRef);
        versionProperties.putAll(versionMetaDataProperties);
        NodeRef newNodeRef = new NodeRef(new StoreRef("versionStore", "lightWeightVersionStore"), versionRef.getId());
        VersionImpl result = new VersionImpl(versionProperties, newNodeRef);
        return result;
    }

    protected NodeRef getVersionHistoryNodeRef(NodeRef nodeRef) {
        if (this.nodeService.exists(nodeRef)) {
            return this.dbNodeService.getChildByName(this.getRootNode(), CHILD_QNAME_VERSION_HISTORIES, (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_UUID)));
        }
        return this.dbNodeService.getChildByName(this.getRootNode(), CHILD_QNAME_VERSION_HISTORIES, nodeRef.getId());
    }

    private NodeRef getCurrentVersionNodeRef(NodeRef versionHistory, NodeRef nodeRef) {
        NodeRef result = null;
        String versionLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
        List versions = this.dbNodeService.getChildAssocs(versionHistory);
        for (ChildAssociationRef version : versions) {
            String tempLabel = (String)((Object)this.dbNodeService.getProperty(version.getChildRef(), VersionModel.PROP_QNAME_VERSION_LABEL));
            if (tempLabel == null || !tempLabel.equals(versionLabel)) continue;
            result = version.getChildRef();
            break;
        }
        return result;
    }

    @Override
    public void revert(NodeRef nodeRef) {
        this.revert(nodeRef, this.getCurrentVersion(nodeRef), true);
    }

    @Override
    public void revert(NodeRef nodeRef, boolean deep) {
        this.revert(nodeRef, this.getCurrentVersion(nodeRef), deep);
    }

    @Override
    public void revert(NodeRef nodeRef, Version version) {
        this.revert(nodeRef, version, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(NodeRef nodeRef, Version version, boolean deep) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"version", (Object)version);
        if (!nodeRef.getId().equals(version.getVersionProperty("frozenNodeId"))) {
            throw new VersionServiceException(MSGID_ERR_REVERT_MISMATCH);
        }
        this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
        try {
            String currentVersionLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
            NodeRef versionNodeRef = version.getFrozenStateNodeRef();
            this.nodeService.setProperties(nodeRef, this.nodeService.getProperties(versionNodeRef));
            HashSet aspects = new HashSet(this.nodeService.getAspects(nodeRef));
            for (QName versionAspect : this.nodeService.getAspects(versionNodeRef)) {
                if (!aspects.contains(versionAspect)) {
                    this.nodeService.addAspect(nodeRef, versionAspect, null);
                    continue;
                }
                aspects.remove(versionAspect);
            }
            for (QName aspect : aspects) {
                this.nodeService.removeAspect(nodeRef, aspect);
            }
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
            }
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)currentVersionLabel));
            ArrayList children = new ArrayList(this.nodeService.getChildAssocs(nodeRef));
            for (ChildAssociationRef versionedChild : this.nodeService.getChildAssocs(versionNodeRef)) {
                if (!children.contains(versionedChild)) {
                    if (this.nodeService.exists(versionedChild.getChildRef())) {
                        this.nodeService.addChild(nodeRef, versionedChild.getChildRef(), versionedChild.getTypeQName(), versionedChild.getQName());
                        continue;
                    }
                    if (!versionedChild.isPrimary() || !deep || this.getVersionHistoryNodeRef(versionedChild.getChildRef()) == null) continue;
                    this.restore(versionedChild.getChildRef(), nodeRef, versionedChild.getTypeQName(), versionedChild.getQName());
                    continue;
                }
                children.remove(versionedChild);
            }
            for (ChildAssociationRef ref : children) {
                this.nodeService.removeChild(nodeRef, ref.getChildRef());
            }
            for (AssociationRef assocRef : this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL)) {
                this.nodeService.removeAssociation(assocRef.getSourceRef(), assocRef.getTargetRef(), assocRef.getTypeQName());
            }
            for (AssociationRef versionedAssoc : this.nodeService.getTargetAssocs(versionNodeRef, RegexQNamePattern.MATCH_ALL)) {
                if (!this.nodeService.exists(versionedAssoc.getTargetRef())) continue;
                this.nodeService.createAssociation(nodeRef, versionedAssoc.getTargetRef(), versionedAssoc.getTypeQName());
            }
            Object var11_10 = null;
            this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
            throw throwable;
        }
    }

    @Override
    public NodeRef restore(NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName) {
        return this.restore(nodeRef, parentNodeRef, assocTypeQName, assocQName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef restore(NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName, boolean deep) {
        NodeRef restoredNodeRef = null;
        if (this.nodeService.exists(nodeRef)) {
            throw new VersionServiceException(MSGID_ERR_RESTORE_EXISTS, new Object[]{nodeRef.toString()});
        }
        Version version = this.getHeadVersion(nodeRef);
        if (version == null) {
            throw new VersionServiceException(MSGID_ERR_RESTORE_NO_VERSION, new Object[]{nodeRef.toString()});
        }
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
        props.put(ContentModel.PROP_NODE_UUID, version.getVersionProperty("frozenNodeId"));
        QName type = (QName)version.getVersionProperty("frozenNodeType");
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        try {
            restoredNodeRef = this.nodeService.createNode(parentNodeRef, assocTypeQName, assocQName, type, props).getChildRef();
            Object var11_10 = null;
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
            throw throwable;
        }
        this.revert(restoredNodeRef, version, deep);
        return restoredNodeRef;
    }

    private Version getHeadVersion(NodeRef nodeRef) {
        Version version = null;
        StoreRef storeRef = nodeRef.getStoreRef();
        NodeRef versionHistoryNodeRef = this.getVersionHistoryNodeRef(nodeRef);
        if (versionHistoryNodeRef != null) {
            List versionsAssoc = this.dbNodeService.getChildAssocs(versionHistoryNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)VersionModel.CHILD_QNAME_VERSIONS);
            for (ChildAssociationRef versionAssoc : versionsAssoc) {
                String storeId;
                String storeProtocol;
                StoreRef versionStoreRef;
                NodeRef versionNodeRef = versionAssoc.getChildRef();
                List successors = this.dbNodeService.getTargetAssocs(versionNodeRef, (QNamePattern)VersionModel.ASSOC_SUCCESSOR);
                if (successors.size() != 0 || !storeRef.equals((Object)(versionStoreRef = new StoreRef(storeProtocol = (String)((Object)this.dbNodeService.getProperty(versionNodeRef, QName.createQName((String)"http://www.alfresco.org/model/versionstore/1.0", (String)"frozenNodeStoreProtocol"))), storeId = (String)((Object)this.dbNodeService.getProperty(versionNodeRef, QName.createQName((String)"http://www.alfresco.org/model/versionstore/1.0", (String)"frozenNodeStoreId"))))))) continue;
                version = this.getVersion(versionNodeRef);
            }
        }
        return version;
    }

    private Version getLatestVersion(NodeRef nodeRef) {
        Version version = null;
        StoreRef storeRef = nodeRef.getStoreRef();
        NodeRef versionHistoryNodeRef = this.getVersionHistoryNodeRef(nodeRef);
        if (versionHistoryNodeRef != null) {
            List versionsAssoc = this.dbNodeService.getChildAssocs(versionHistoryNodeRef, RegexQNamePattern.MATCH_ALL, (QNamePattern)VersionModel.CHILD_QNAME_VERSIONS);
            for (ChildAssociationRef versionAssoc : versionsAssoc) {
                String storeId;
                String storeProtocol;
                StoreRef versionStoreRef;
                NodeRef versionNodeRef = versionAssoc.getChildRef();
                List predecessors = this.dbNodeService.getSourceAssocs(versionNodeRef, (QNamePattern)VersionModel.ASSOC_SUCCESSOR);
                if (predecessors.size() != 0 || !storeRef.equals((Object)(versionStoreRef = new StoreRef(storeProtocol = (String)((Object)this.dbNodeService.getProperty(versionNodeRef, QName.createQName((String)"http://www.alfresco.org/model/versionstore/1.0", (String)"frozenNodeStoreProtocol"))), storeId = (String)((Object)this.dbNodeService.getProperty(versionNodeRef, QName.createQName((String)"http://www.alfresco.org/model/versionstore/1.0", (String)"frozenNodeStoreId"))))))) continue;
                version = this.getVersion(versionNodeRef);
            }
        }
        return version;
    }

    @Override
    public void deleteVersionHistory(NodeRef nodeRef) throws AspectMissingException {
        NodeRef versionHistoryNodeRef = this.getVersionHistoryNodeRef(nodeRef);
        if (versionHistoryNodeRef != null) {
            this.dbNodeService.deleteNode(versionHistoryNodeRef);
            if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, null);
            }
        }
    }

    @Override
    public void deleteVersion(NodeRef nodeRef, Version version) {
        throw new UnsupportedOperationException("Delete version is unsupported by the old (deprecated) version store implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void defaultOnCreateVersion(QName classRef, NodeRef nodeRef, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        ClassDefinition classDefinition = this.dictionaryService.getClass(classRef);
        if (classDefinition != null) {
            boolean wasMLAware = MLPropertyInterceptor.setMLAware(true);
            try {
                Map propertyDefinitions = classDefinition.getProperties();
                for (QName propertyName : propertyDefinitions.keySet()) {
                    Serializable propValue = this.nodeService.getProperty(nodeRef, propertyName);
                    nodeDetails.addProperty(classRef, propertyName, propValue);
                }
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                MLPropertyInterceptor.setMLAware(wasMLAware);
                throw throwable;
            }
            MLPropertyInterceptor.setMLAware(wasMLAware);
            Map assocDefs = classDefinition.getAssociations();
            if (classDefinition.isContainer()) {
                List childAssocRefs = this.nodeService.getChildAssocs(nodeRef);
                for (ChildAssociationRef childAssocRef : childAssocRefs) {
                    if (!assocDefs.containsKey(childAssocRef.getTypeQName())) continue;
                    nodeDetails.addChildAssociation(classDefinition.getName(), childAssocRef);
                }
            }
            List nodeAssocRefs = this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
            for (AssociationRef nodeAssocRef : nodeAssocRefs) {
                if (!assocDefs.containsKey(nodeAssocRef.getTypeQName())) continue;
                nodeDetails.addAssociation(classDefinition.getName(), nodeAssocRef);
            }
        }
    }
}

