/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.importer.ImporterBootstrap;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowPackageComponent;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.workflow.WorkflowException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.springframework.extensions.surf.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowPackageImpl
implements WorkflowPackageComponent {
    private static final String PACKAGE_FOLDER = "packages";
    private ImporterBootstrap bootstrap;
    private SearchService searchService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private PermissionService permissionService;
    private NodeRef systemWorkflowContainer = null;
    private TenantService tenantService;

    public void setImporterBootstrap(ImporterBootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    @Override
    public NodeRef createPackage(NodeRef container) {
        boolean isSystemPackage = false;
        if (container == null) {
            container = this.makePackageContainer();
            isSystemPackage = true;
        }
        if (this.nodeService.hasAspect(container, WorkflowModel.ASPECT_WORKFLOW_PACKAGE)) {
            String msg = "Container '" + container + "' is already a workflow package.";
            throw new WorkflowException(msg);
        }
        this.nodeService.addAspect(container, WorkflowModel.ASPECT_WORKFLOW_PACKAGE, null);
        this.nodeService.setProperty(container, WorkflowModel.PROP_IS_SYSTEM_PACKAGE, (Serializable)Boolean.valueOf(isSystemPackage));
        return container;
    }

    private NodeRef makePackageContainer() {
        NodeRef packages = this.findOrCreatePackagesFolder();
        String packageId = "pkg_" + GUID.generate();
        QName packageName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)packageId);
        ChildAssociationRef packageAssoc = this.nodeService.createNode(packages, ContentModel.ASSOC_CONTAINS, packageName, WorkflowModel.TYPE_PACKAGE);
        NodeRef packageContainer = packageAssoc.getChildRef();
        this.permissionService.setPermission(packageContainer, "GROUP_EVERYONE", "All", true);
        return packageContainer;
    }

    private NodeRef findOrCreatePackagesFolder() {
        NodeRef system = this.getSystemWorkflowContainer();
        List packageFolders = this.searchService.selectNodes(system, "./cm:packages", null, (NamespacePrefixResolver)this.namespaceService, false);
        if (packageFolders.size() > 0) {
            return (NodeRef)packageFolders.get(0);
        }
        QName packageFolderName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)PACKAGE_FOLDER);
        ChildAssociationRef packageFolderAssoc = this.nodeService.createNode(system, ContentModel.ASSOC_CHILDREN, packageFolderName, ContentModel.TYPE_SYSTEM_FOLDER);
        return packageFolderAssoc.getChildRef();
    }

    @Override
    public void deletePackage(NodeRef container) {
        if (container != null && this.nodeService.exists(container) && this.nodeService.hasAspect(container, WorkflowModel.ASPECT_WORKFLOW_PACKAGE)) {
            Boolean isSystemPackage = (Boolean)this.nodeService.getProperty(container, WorkflowModel.PROP_IS_SYSTEM_PACKAGE);
            if (isSystemPackage != null && isSystemPackage.booleanValue()) {
                this.nodeService.deleteNode(container);
            } else {
                this.nodeService.removeAspect(container, WorkflowModel.ASPECT_WORKFLOW_PACKAGE);
            }
        }
    }

    @Override
    public List<String> getWorkflowIdsForContent(NodeRef packageItem) {
        ParameterCheck.mandatory((String)"packageItem", (Object)packageItem);
        ArrayList<String> workflowIds = new ArrayList<String>();
        if (this.nodeService.exists(packageItem)) {
            List parentAssocs = this.nodeService.getParentAssocs(packageItem);
            for (ChildAssociationRef parentAssoc : parentAssocs) {
                String workflowInstance;
                NodeRef parentRef = parentAssoc.getParentRef();
                if (!this.nodeService.hasAspect(parentRef, WorkflowModel.ASPECT_WORKFLOW_PACKAGE) || this.nodeService.hasAspect(parentRef, ContentModel.ASPECT_ARCHIVED) || (workflowInstance = (String)((Object)this.nodeService.getProperty(parentRef, WorkflowModel.PROP_WORKFLOW_INSTANCE_ID))) == null || workflowInstance.length() <= 0) continue;
                workflowIds.add(workflowInstance);
            }
        }
        return workflowIds;
    }

    private NodeRef getSystemWorkflowContainer() {
        if (this.tenantService.isEnabled()) {
            NodeRef systemContainer = this.findSystemContainer();
            NodeRef tenantSystemWorkflowContainer = this.findSystemWorkflowContainer(systemContainer);
            if (tenantSystemWorkflowContainer == null) {
                throw new WorkflowException("Unable to find system workflow folder - does not exist.");
            }
            return tenantSystemWorkflowContainer;
        }
        if (this.systemWorkflowContainer == null) {
            NodeRef systemContainer = this.findSystemContainer();
            this.systemWorkflowContainer = this.findSystemWorkflowContainer(systemContainer);
            if (this.systemWorkflowContainer == null) {
                throw new WorkflowException("Unable to find system workflow folder - does not exist.");
            }
        }
        return this.systemWorkflowContainer;
    }

    private NodeRef findSystemWorkflowContainer(NodeRef systemContainer) {
        String path = this.bootstrap.getConfiguration().getProperty("system.workflow_container.childname");
        if (path == null) {
            throw new WorkflowException("Unable to locate workflow system container - path not specified");
        }
        List nodeRefs = this.searchService.selectNodes(systemContainer, path, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (this.tenantService.isEnabled()) {
            NodeRef tenantSystemWorkflowContainer = null;
            if (nodeRefs != null && nodeRefs.size() > 0) {
                tenantSystemWorkflowContainer = (NodeRef)nodeRefs.get(0);
            }
            return tenantSystemWorkflowContainer;
        }
        if (nodeRefs != null && nodeRefs.size() > 0) {
            this.systemWorkflowContainer = (NodeRef)nodeRefs.get(0);
        }
        return this.systemWorkflowContainer;
    }

    private NodeRef findSystemContainer() {
        String path = this.bootstrap.getConfiguration().getProperty("system.system_container.childname");
        if (path == null) {
            throw new WorkflowException("Unable to locate system container - path not specified");
        }
        NodeRef root = this.nodeService.getRootNode(this.bootstrap.getStoreRef());
        List nodeRefs = this.searchService.selectNodes(root, path, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs == null || nodeRefs.size() == 0) {
            throw new WorkflowException("Unable to locate system container - path not found");
        }
        return (NodeRef)nodeRefs.get(0);
    }

    public NodeRef createSystemWorkflowContainer() {
        NodeRef systemContainer = this.findSystemContainer();
        NodeRef systemWorkflowContainer = this.findSystemWorkflowContainer(systemContainer);
        if (systemWorkflowContainer == null) {
            String name = this.bootstrap.getConfiguration().getProperty("system.workflow_container.childname");
            QName qname = QName.createQName((String)name, (NamespacePrefixResolver)this.namespaceService);
            ChildAssociationRef childRef = this.nodeService.createNode(systemContainer, ContentModel.ASSOC_CHILDREN, qname, ContentModel.TYPE_CONTAINER);
            systemWorkflowContainer = childRef.getChildRef();
        }
        return systemWorkflowContainer;
    }
}

