/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.avm.deploy;

import java.io.Serializable;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentEvent
implements Serializable {
    private static final long serialVersionUID = 2696116904379321786L;
    private Type fType;
    private Pair<Integer, String> fSource;
    private String fDestination;
    private String fMessage;

    public DeploymentEvent(Type type, Pair<Integer, String> source, String destination) {
        this.fType = type;
        this.fSource = source;
        this.fDestination = destination;
    }

    public DeploymentEvent(Type type, Pair<Integer, String> source, String destination, String message) {
        this(type, source, destination);
        this.fMessage = message;
    }

    public Type getType() {
        return this.fType;
    }

    public Pair<Integer, String> getSource() {
        return this.fSource;
    }

    public String getDestination() {
        return this.fDestination;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public String toString() {
        String str = this.fType + ": " + this.fSource + " -> " + this.fDestination;
        if (this.fMessage != null) {
            str = str + " (" + this.fMessage + ")";
        }
        return str;
    }

    public int hashCode() {
        return (this.fType.toString() + this.fDestination).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DeploymentEvent) {
            DeploymentEvent other = (DeploymentEvent)obj;
            if (this.getType() == other.getType() && this.getDestination().equals(other.getDestination())) {
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type implements Serializable
    {
        CREATED,
        UPDATED,
        DELETED,
        START,
        END,
        FAILED;

    }
}

