/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.avmsync;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AVMDifference
implements Serializable,
Comparable<AVMDifference> {
    private static final long serialVersionUID = -589722861571724954L;
    public static final int NEWER = 0;
    public static final int OLDER = 1;
    public static final int CONFLICT = 2;
    public static final int DIRECTORY = 3;
    public static final int SAME = 4;
    private int fSourceVersion;
    private String fSourcePath;
    private int fDestVersion;
    private String fDestPath;
    private int fDiffCode;

    public AVMDifference(int srcVersion, String srcPath, int dstVersion, String dstPath, int diffCode) {
        this.fSourceVersion = srcVersion;
        this.fSourcePath = srcPath;
        this.fDestVersion = dstVersion;
        this.fDestPath = dstPath;
        this.fDiffCode = diffCode;
    }

    public int getSourceVersion() {
        return this.fSourceVersion;
    }

    public String getSourcePath() {
        return this.fSourcePath;
    }

    public int getDestinationVersion() {
        return this.fDestVersion;
    }

    public String getDestinationPath() {
        return this.fDestPath;
    }

    public int getDifferenceCode() {
        return this.fDiffCode;
    }

    public boolean isValid() {
        return this.fSourcePath != null && this.fDestPath != null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.fSourcePath);
        builder.append("[");
        builder.append(this.fSourceVersion);
        builder.append("] ");
        switch (this.fDiffCode) {
            case 4: {
                builder.append("= ");
                break;
            }
            case 0: {
                builder.append("> ");
                break;
            }
            case 1: {
                builder.append("< ");
                break;
            }
            case 2: {
                builder.append("<> ");
                break;
            }
            case 3: {
                builder.append("| ");
                break;
            }
            default: {
                builder.append("? ");
            }
        }
        builder.append(this.fDestPath);
        builder.append("[");
        builder.append(this.fDestVersion);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int compareTo(AVMDifference other) {
        return this.getOrderValue() - other.getOrderValue();
    }

    public int getOrderValue() {
        switch (this.fDiffCode) {
            case 2: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return 100;
    }
}

