/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.regex.Pattern;

public class FileNameValidator {
    public static final String FILENAME_ILLEGAL_REGEX = "[\\\"\\*\\\\\\>\\<\\?\\/\\:\\|]";
    private static final Pattern FILENAME_ILLEGAL_PATTERN_REPLACE = Pattern.compile("[\\\"\\*\\\\\\>\\<\\?\\/\\:\\|]");

    public static boolean isValid(String name) {
        return !FILENAME_ILLEGAL_PATTERN_REPLACE.matcher(name).find();
    }

    public static String getValidFileName(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("File name cannot be corrected if it is null or empty.");
        }
        return FILENAME_ILLEGAL_PATTERN_REPLACE.matcher(fileName).replaceAll("_");
    }
}

