/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemadump;

import java.io.File;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.sql.DataSource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.util.PropertyCheck;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.Oracle8iDialect;
import org.hibernate.dialect.TypeNames;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Main {
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private final Map<String, Integer> reverseTypeMap = new TreeMap<String, Integer>();
    private boolean scaleCharacters;
    private DataSource dataSource;

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage:");
            System.out.println("java " + Main.class.getName() + " <context.xml> <output.xml>");
            System.exit(1);
        }
        File outputFile = new File(args[1]);
        new Main(args[0]).execute(outputFile);
    }

    public Main(String contextPath) throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{"file:" + contextPath});
        this.dataSource = (DataSource)context.getBean("dataSource");
        Properties hibProps = (Properties)context.getBean("hibernateConfigProperties");
        Dialect dialect = (Dialect)Class.forName(hibProps.getProperty("hibernate.dialect")).newInstance();
        this.init(dialect);
    }

    public Main(DataSource dataSource, Dialect dialect) throws Exception {
        this.dataSource = dataSource;
        this.init(dialect);
    }

    private void init(Dialect dialect) throws Exception {
        this.scaleCharacters = dialect instanceof Oracle8iDialect;
        Field typeNamesField = Dialect.class.getDeclaredField("typeNames");
        typeNamesField.setAccessible(true);
        TypeNames typeNames = (TypeNames)typeNamesField.get(dialect);
        Field defaultsField = TypeNames.class.getDeclaredField("defaults");
        defaultsField.setAccessible(true);
        Map forwardMap2 = (Map)defaultsField.get(typeNames);
        for (Map.Entry e : forwardMap2.entrySet()) {
            this.reverseTypeMap.put((String)e.getValue(), (Integer)e.getKey());
        }
        Field weightedField = TypeNames.class.getDeclaredField("weighted");
        weightedField.setAccessible(true);
        Map forwardMap1 = (Map)weightedField.get(typeNames);
        for (Map.Entry e : forwardMap1.entrySet()) {
            for (String type : ((Map)e.getValue()).values()) {
                this.reverseTypeMap.put(type, (Integer)e.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(File outputFile) throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"dataSource", (Object)this.dataSource);
        Connection connection = this.dataSource.getConnection();
        NamedElementCollection result = null;
        try {
            connection.setAutoCommit(false);
            result = this.execute(connection);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                connection.close();
            }
            catch (Throwable e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            connection.close();
        }
        catch (Throwable e) {}
        SAXTransformerFactory stf = (SAXTransformerFactory)TransformerFactory.newInstance();
        TransformerHandler xmlOut = stf.newTransformerHandler();
        Transformer t = xmlOut.getTransformer();
        try {
            t.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        t.setOutputProperty("indent", "yes");
        xmlOut.setResult(new StreamResult(outputFile));
        xmlOut.startDocument();
        result.output(xmlOut);
        xmlOut.endDocument();
    }

    private NamedElementCollection execute(Connection con) throws Exception {
        NamedElementCollection schemaCol = new NamedElementCollection("schema", "table");
        DatabaseMetaData dbmd = con.getMetaData();
        String schema = null;
        ResultSet schemas = dbmd.getSchemas();
        while (schemas.next()) {
            String thisSchema = schemas.getString("TABLE_SCHEM");
            if (!thisSchema.equals(dbmd.getUserName()) && !thisSchema.equalsIgnoreCase("dbo")) continue;
            schema = thisSchema;
            break;
        }
        schemas.close();
        ResultSet tables = dbmd.getTables(null, schema, "%", new String[]{"TABLE", "VIEW"});
        while (tables.next()) {
            String tableName = tables.getString("TABLE_NAME");
            if (tableName.startsWith("BIN$")) continue;
            NamedElement tableEl = schemaCol.addNamedElement(tableName);
            NamedElementCollection columnsCol = tableEl.addCollection("columns", "column");
            ResultSet columns = dbmd.getColumns(null, tables.getString("TABLE_SCHEM"), tableName, "%");
            while (columns.next()) {
                NamedElement columnEl = columnsCol.addNamedElement(columns.getString("COLUMN_NAME"));
                columnEl.addAttribute("seq", String.valueOf(columns.getInt("ORDINAL_POSITION")));
                columnEl.addAttribute("type", this.convertToTypeName(columns.getString("TYPE_NAME"), columns.getInt("COLUMN_SIZE"), columns.getInt("DECIMAL_DIGITS"), columns.getInt("DATA_TYPE")));
                columnEl.addAttribute("nullable", columns.getString("IS_NULLABLE"));
            }
            columns.close();
            ResultSet primarykeycols = dbmd.getPrimaryKeys(null, tables.getString("TABLE_SCHEM"), tableName);
            String primaryKeyName = null;
            NamedElementCollection primaryKey = null;
            while (primarykeycols.next()) {
                if (primaryKey == null) {
                    primaryKeyName = primarykeycols.getString("PK_NAME");
                    primaryKey = tableEl.addCollection("primarykey", "column");
                }
                NamedElement pkCol = primaryKey.addNamedElement(primarykeycols.getString("COLUMN_NAME"));
                pkCol.addAttribute("seq", primarykeycols.getString("KEY_SEQ"));
            }
            primarykeycols.close();
            NamedElementCollection indexCol = tableEl.addCollection("indexes", "index");
            ResultSet indexes = dbmd.getIndexInfo(null, tables.getString("TABLE_SCHEM"), tableName, false, true);
            String lastIndexName = "";
            NamedElementCollection indexCols = null;
            while (indexes.next()) {
                String indexName = indexes.getString("INDEX_NAME");
                if (indexName == null || indexName.equals(primaryKeyName)) continue;
                if (!indexName.equals(lastIndexName)) {
                    NamedElement index = indexCol.addNamedElement(indexName);
                    index.addAttribute("unique", String.valueOf(!indexes.getBoolean("NON_UNIQUE")));
                    indexCols = index.addCollection("columns", "column");
                    lastIndexName = indexName;
                }
                indexCols.addNamedElement(indexes.getString("COLUMN_NAME"));
            }
            indexes.close();
            NamedElementCollection foreignKeyCol = tableEl.addCollection("foreignkeys", "key");
            ResultSet foreignkeys = dbmd.getImportedKeys(null, tables.getString("TABLE_SCHEM"), tableName);
            String lastKeyName = "";
            NamedElementCollection foreignKeyCols = null;
            while (foreignkeys.next()) {
                String keyName = foreignkeys.getString("FK_NAME");
                if (!keyName.equals(lastKeyName)) {
                    NamedElement key = foreignKeyCol.addNamedElement(keyName);
                    foreignKeyCols = key.addCollection("columns", "column");
                    lastKeyName = keyName;
                }
                NamedElement fkCol = foreignKeyCols.addNamedElement(foreignkeys.getString("FKCOLUMN_NAME"));
                fkCol.addAttribute("table", foreignkeys.getString("PKTABLE_NAME").toUpperCase());
                fkCol.addAttribute("column", foreignkeys.getString("PKCOLUMN_NAME").toUpperCase());
            }
            foreignkeys.close();
        }
        tables.close();
        return schemaCol;
    }

    private String convertToTypeName(String dbType, int size, int digits, int sqlType) throws IllegalArgumentException, IllegalAccessException {
        String dbName = dbType.toLowerCase() + "(" + size + "," + digits + ")";
        if (this.reverseTypeMap.containsKey(dbName)) {
            sqlType = this.reverseTypeMap.get(dbName);
        } else {
            dbName = dbType.toLowerCase();
            if (this.reverseTypeMap.containsKey(dbName)) {
                sqlType = this.reverseTypeMap.get(dbName);
            }
        }
        Field[] fields = Types.class.getFields();
        int modifiers = 9;
        for (Field field : fields) {
            if (!field.getType().equals(Integer.TYPE) || (field.getModifiers() & 9) != 9 || field.getInt(null) != sqlType) continue;
            if (size == 0 || this.reverseTypeMap.containsKey(dbName) || sqlType == 93 || sqlType == 4) {
                return field.getName();
            }
            if (this.scaleCharacters && (sqlType == 1 || sqlType == 12 || sqlType == 2005)) {
                size /= 4;
            }
            return field.getName() + "(" + size + ")";
        }
        return String.valueOf(sqlType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NamedElement
    implements Comparable<NamedElement> {
        private final String name;
        private final List<String[]> attributes = new LinkedList<String[]>();
        private final List<NamedElementCollection> collections = new LinkedList<NamedElementCollection>();

        public NamedElement(String name) {
            this.name = name.toUpperCase();
        }

        public void addAttribute(String name, String value) {
            this.attributes.add(new String[]{name, value});
        }

        public NamedElementCollection addCollection(String collectionName, String elementName) {
            NamedElementCollection retVal = new NamedElementCollection(collectionName, elementName);
            this.collections.add(retVal);
            return retVal;
        }

        public void output(ContentHandler xmlOut, String elementName) throws SAXException {
            AttributesImpl attribs = new AttributesImpl();
            attribs.addAttribute("", "", "name", "CDATA", this.name);
            xmlOut.startElement("", "", elementName, attribs);
            for (String[] attrib : this.attributes) {
                xmlOut.startElement("", "", attrib[0], EMPTY_ATTRIBUTES);
                char[] chars = attrib[1].toCharArray();
                xmlOut.characters(chars, 0, chars.length);
                xmlOut.endElement("", "", attrib[0]);
            }
            for (NamedElementCollection coll : this.collections) {
                coll.output(xmlOut);
            }
            xmlOut.endElement("", "", elementName);
        }

        @Override
        public int compareTo(NamedElement o) {
            return this.name.compareTo(o.name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NamedElement)) {
                return false;
            }
            return this.name.equals(((NamedElement)obj).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private class NamedElementCollection {
        private final String collectionName;
        private final String elementName;
        private final AttributesImpl attributes = new AttributesImpl();
        private final List<NamedElement> items = new ArrayList<NamedElement>(100);

        public NamedElementCollection(String collectionName, String elementName) {
            this.collectionName = collectionName;
            this.elementName = elementName;
        }

        public NamedElement addNamedElement(String name) {
            NamedElement retVal = new NamedElement(name);
            this.items.add(retVal);
            return retVal;
        }

        public void output(ContentHandler xmlOut) throws SAXException {
            xmlOut.startElement("", "", this.collectionName, this.attributes);
            Collections.sort(this.items);
            for (NamedElement item : this.items) {
                item.output(xmlOut, this.elementName);
            }
            xmlOut.endElement("", "", this.collectionName);
        }
    }
}

