/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.sandbox;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.wcm.AbstractWCMServiceImplTest;
import org.alfresco.wcm.actions.WCMSandboxRevertSnapshotAction;
import org.alfresco.wcm.actions.WCMSandboxSubmitAction;
import org.alfresco.wcm.actions.WCMSandboxUndoAction;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.sandbox.SandboxVersion;
import org.alfresco.wcm.webproject.WebProjectInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SandboxServiceImplTest
extends AbstractWCMServiceImplTest {
    private static Log logger = LogFactory.getLog(SandboxServiceImplTest.class);
    private static final String TEST_SANDBOX = TEST_WEBPROJ_DNS + "-sandbox";
    private static final int SCALE_USERS = 5;
    private static final int SCALE_WEBPROJECTS = 2;
    private AVMService avmService;

    protected void setUp() throws Exception {
        super.setUp();
        this.avmService = (AVMService)ctx.getBean("AVMService");
    }

    protected void tearDown() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.deleteUser(USER_ONE);
        this.deleteUser(USER_TWO);
        this.deleteUser(USER_THREE);
        this.deleteUser(USER_FOUR);
        super.tearDown();
    }

    public void testSimple() {
        int storeCnt = this.avmService.getStores().size();
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-sandboxSimple", TEST_WEBPROJ_NAME + "-sandboxSimple", "This is my title", "This is my description", "ROOT", false, null);
        String wpStoreId = wpInfo.getStoreId();
        SandboxServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreId).size());
        SandboxServiceImplTest.assertEquals((int)(storeCnt + 4), (int)this.avmService.getStores().size());
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        SandboxServiceImplTest.assertNotNull((Object)sbInfo);
        sbInfo = this.sbService.getStagingSandbox(wpStoreId);
        SandboxServiceImplTest.assertNotNull((Object)sbInfo);
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentPublisher", false);
        SandboxServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreId).size());
        sbInfo = this.sbService.createAuthorSandbox(wpStoreId, USER_TWO);
        SandboxServiceImplTest.assertEquals((int)3, (int)this.sbService.listSandboxes(wpStoreId).size());
        sbInfo = this.sbService.getSandbox(sbInfo.getSandboxId());
        this.sbService.deleteSandbox(sbInfo.getSandboxId());
        SandboxServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreId).size());
        this.sbService.deleteSandbox(this.sbService.getAuthorSandbox(wpStoreId).getSandboxId());
        SandboxServiceImplTest.assertEquals((int)1, (int)this.sbService.listSandboxes(wpStoreId).size());
        this.wpService.deleteWebProject(wpStoreId);
        SandboxServiceImplTest.assertEquals((int)storeCnt, (int)this.avmService.getStores().size());
    }

    public void testCreateAuthorSandbox() {
        WebProjectInfo wpInfo1 = this.wpService.createWebProject(TEST_SANDBOX + "-create-author", TEST_WEBPROJ_NAME + "-author", "This is my title", "This is my description", "ROOT", false, null);
        String expectedUserSandboxId = TEST_SANDBOX + "-create-author" + "--" + AuthenticationUtil.getAdminUserName();
        SandboxInfo sbInfo1 = this.sbService.getAuthorSandbox(wpInfo1.getStoreId());
        this.checkSandboxInfo(sbInfo1, expectedUserSandboxId, AuthenticationUtil.getAdminUserName(), AuthenticationUtil.getAdminUserName(), expectedUserSandboxId, SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
        sbInfo1 = this.sbService.getAuthorSandbox(wpInfo1.getStoreId(), USER_ONE);
        SandboxServiceImplTest.assertNull((Object)sbInfo1);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        sbInfo1 = this.sbService.getAuthorSandbox(wpInfo1.getStoreId());
        SandboxServiceImplTest.assertNull((Object)sbInfo1);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.wpService.inviteWebUser(wpInfo1.getStoreId(), USER_ONE, "ContentManager");
        sbInfo1 = this.sbService.createAuthorSandbox(wpInfo1.getStoreId(), USER_ONE);
        expectedUserSandboxId = TEST_SANDBOX + "-create-author" + "--" + USER_ONE;
        sbInfo1 = this.sbService.getAuthorSandbox(wpInfo1.getStoreId(), USER_ONE);
        this.checkSandboxInfo(sbInfo1, expectedUserSandboxId, USER_ONE, AuthenticationUtil.getAdminUserName(), expectedUserSandboxId, SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        sbInfo1 = this.sbService.getAuthorSandbox(wpInfo1.getStoreId());
        this.checkSandboxInfo(sbInfo1, expectedUserSandboxId, USER_ONE, AuthenticationUtil.getAdminUserName(), expectedUserSandboxId, SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
        String userSandboxId = sbInfo1.getSandboxId();
        sbInfo1 = this.sbService.getSandbox(userSandboxId);
        this.checkSandboxInfo(sbInfo1, expectedUserSandboxId, USER_ONE, AuthenticationUtil.getAdminUserName(), expectedUserSandboxId, SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
        sbInfo1 = this.sbService.createAuthorSandbox(wpInfo1.getStoreId());
        this.checkSandboxInfo(sbInfo1, expectedUserSandboxId, USER_ONE, AuthenticationUtil.getAdminUserName(), expectedUserSandboxId, SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        try {
            this.sbService.createAuthorSandbox(wpInfo1.getStoreId());
            SandboxServiceImplTest.fail((String)"Shouldn't be able to create author store since not a web user");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.wpService.inviteWebUser(wpInfo1.getStoreId(), USER_TWO, "ContentReviewer");
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        sbInfo1 = this.sbService.getAuthorSandbox(wpInfo1.getStoreId());
        SandboxServiceImplTest.assertNull((Object)sbInfo1);
        expectedUserSandboxId = TEST_SANDBOX + "-create-author" + "--" + USER_TWO;
        sbInfo1 = this.sbService.createAuthorSandbox(wpInfo1.getStoreId());
        this.checkSandboxInfo(sbInfo1, expectedUserSandboxId, USER_TWO, USER_TWO, expectedUserSandboxId, SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
    }

    private void checkSandboxInfo(SandboxInfo sbInfo, String expectedStoreId, String expectedName, String expectedCreator, String expectedMainStoreName, QName expectedSandboxType) {
        SandboxServiceImplTest.assertNotNull((Object)sbInfo);
        SandboxServiceImplTest.assertEquals((String)expectedStoreId, (String)sbInfo.getSandboxId());
        SandboxServiceImplTest.assertEquals((String)expectedName, (String)sbInfo.getName());
        SandboxServiceImplTest.assertEquals((String)expectedCreator, (String)sbInfo.getCreator());
        SandboxServiceImplTest.assertNotNull((Object)sbInfo.getCreatedDate());
        SandboxServiceImplTest.assertEquals((String)expectedMainStoreName, (String)sbInfo.getMainStoreName());
        SandboxServiceImplTest.assertEquals((Object)expectedSandboxType, (Object)sbInfo.getSandboxType());
    }

    public void testListSandboxes() throws Exception {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-list", TEST_WEBPROJ_NAME + " list", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        WebProjectInfo wpAnoInfo = this.wpService.createWebProject(TEST_SANDBOX + "-list ano", TEST_WEBPROJ_NAME + " list ano", "This is my title", "This is my description");
        String wpStoreAnoId = wpAnoInfo.getStoreId();
        List<SandboxInfo> sbInfos = this.sbService.listSandboxes(wpStoreId);
        SandboxServiceImplTest.assertEquals((int)2, (int)sbInfos.size());
        SandboxServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreAnoId).size());
        String expectedUserSandboxId = TEST_SANDBOX + "-list" + "--" + AuthenticationUtil.getAdminUserName();
        for (SandboxInfo sbInfo : sbInfos) {
            QName sbType = sbInfo.getSandboxType();
            if (sbType.equals((Object)SandboxConstants.PROP_SANDBOX_STAGING_MAIN)) {
                this.checkSandboxInfo(sbInfo, TEST_SANDBOX + "-list", TEST_SANDBOX + "-list", AuthenticationUtil.getAdminUserName(), TEST_SANDBOX + "-list", SandboxConstants.PROP_SANDBOX_STAGING_MAIN);
                continue;
            }
            if (sbType.equals((Object)SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN)) {
                this.checkSandboxInfo(sbInfo, expectedUserSandboxId, AuthenticationUtil.getAdminUserName(), AuthenticationUtil.getAdminUserName(), expectedUserSandboxId, SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
                continue;
            }
            SandboxServiceImplTest.fail((String)("The sandbox store id " + sbInfo.getSandboxId() + " is not recognised"));
        }
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentManager", true);
        this.wpService.inviteWebUser(wpStoreId, USER_TWO, "ContentPublisher", true);
        this.wpService.inviteWebUser(wpStoreId, USER_THREE, "ContentReviewer", true);
        this.wpService.inviteWebUser(wpStoreId, USER_FOUR, "ContentContributor", true);
        sbInfos = this.sbService.listSandboxes(wpInfo.getStoreId());
        SandboxServiceImplTest.assertEquals((int)6, (int)sbInfos.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        sbInfos = this.sbService.listSandboxes(wpInfo.getStoreId());
        SandboxServiceImplTest.assertEquals((int)6, (int)sbInfos.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        sbInfos = this.sbService.listSandboxes(wpInfo.getStoreId());
        SandboxServiceImplTest.assertEquals((int)6, (int)sbInfos.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_THREE);
        sbInfos = this.sbService.listSandboxes(wpInfo.getStoreId());
        SandboxServiceImplTest.assertEquals((int)2, (int)sbInfos.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_FOUR);
        sbInfos = this.sbService.listSandboxes(wpInfo.getStoreId());
        SandboxServiceImplTest.assertEquals((int)2, (int)sbInfos.size());
    }

    public void testGetSandbox() {
        SandboxInfo sbInfo = this.sbService.getSandbox(TEST_SANDBOX + "-get");
        SandboxServiceImplTest.assertNull((Object)sbInfo);
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-get", TEST_WEBPROJ_NAME + " get", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        sbInfo = this.sbService.getStagingSandbox(wpInfo.getStoreId());
        this.checkSandboxInfo(sbInfo, TEST_SANDBOX + "-get", TEST_SANDBOX + "-get", AuthenticationUtil.getAdminUserName(), TEST_SANDBOX + "-get", SandboxConstants.PROP_SANDBOX_STAGING_MAIN);
        String stagingSandboxId = wpInfo.getStagingStoreName();
        sbInfo = this.sbService.getSandbox(stagingSandboxId);
        this.checkSandboxInfo(sbInfo, TEST_SANDBOX + "-get", TEST_SANDBOX + "-get", AuthenticationUtil.getAdminUserName(), TEST_SANDBOX + "-get", SandboxConstants.PROP_SANDBOX_STAGING_MAIN);
        sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        sbInfo = this.sbService.getSandbox(sbInfo.getSandboxId());
        String userSandboxId = TEST_SANDBOX + "-get" + "--" + AuthenticationUtil.getAdminUserName();
        this.checkSandboxInfo(sbInfo, userSandboxId, AuthenticationUtil.getAdminUserName(), AuthenticationUtil.getAdminUserName(), userSandboxId, SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentManager", true);
        this.wpService.inviteWebUser(wpStoreId, USER_TWO, "ContentPublisher", true);
        this.wpService.inviteWebUser(wpStoreId, USER_THREE, "ContentReviewer", true);
        this.wpService.inviteWebUser(wpStoreId, USER_FOUR, "ContentContributor", true);
        userSandboxId = TEST_SANDBOX + "-get" + "--" + USER_THREE;
        sbInfo = this.sbService.getSandbox(userSandboxId);
        this.checkSandboxInfo(sbInfo, userSandboxId, USER_THREE, AuthenticationUtil.getAdminUserName(), userSandboxId, SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        userSandboxId = TEST_SANDBOX + "-get" + "--" + USER_THREE;
        sbInfo = this.sbService.getSandbox(userSandboxId);
        this.checkSandboxInfo(sbInfo, userSandboxId, USER_THREE, AuthenticationUtil.getAdminUserName(), userSandboxId, SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        userSandboxId = TEST_SANDBOX + "-get" + "--" + USER_THREE;
        sbInfo = this.sbService.getSandbox(userSandboxId);
        this.checkSandboxInfo(sbInfo, userSandboxId, USER_THREE, AuthenticationUtil.getAdminUserName(), userSandboxId, SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_THREE);
        try {
            userSandboxId = TEST_SANDBOX + "-get" + "--" + USER_TWO;
            sbInfo = this.sbService.getSandbox(userSandboxId);
            SandboxServiceImplTest.fail((String)"Shouldn't be able to get another author's sandbox");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_FOUR);
        try {
            userSandboxId = TEST_SANDBOX + "-get" + "--" + USER_THREE;
            sbInfo = this.sbService.getSandbox(userSandboxId);
            SandboxServiceImplTest.fail((String)"Shouldn't be able to get another author's sandbox");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
    }

    public void testIsSandboxType() {
        SandboxInfo sbInfo = this.sbService.getSandbox(TEST_SANDBOX + "-is");
        SandboxServiceImplTest.assertNull((Object)sbInfo);
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-is", TEST_WEBPROJ_NAME + " is", "This is my title", "This is my description");
        sbInfo = this.sbService.getStagingSandbox(wpInfo.getStoreId());
        SandboxServiceImplTest.assertTrue((boolean)this.sbService.isSandboxType(sbInfo.getSandboxId(), SandboxConstants.PROP_SANDBOX_STAGING_MAIN));
        SandboxServiceImplTest.assertFalse((boolean)this.sbService.isSandboxType(sbInfo.getSandboxId(), SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN));
        sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId());
        SandboxServiceImplTest.assertTrue((boolean)this.sbService.isSandboxType(sbInfo.getSandboxId(), SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN));
        SandboxServiceImplTest.assertFalse((boolean)this.sbService.isSandboxType(sbInfo.getSandboxId(), SandboxConstants.PROP_SANDBOX_STAGING_MAIN));
    }

    public void testDeleteSandbox() {
        String relPath;
        int i;
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-delete", TEST_WEBPROJ_NAME + " delete", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        WebProjectInfo wpAnoInfo = this.wpService.createWebProject(TEST_SANDBOX + "-delete ano", TEST_WEBPROJ_NAME + " delete ano", "This is my title", "This is my description");
        String wpStoreAnoId = wpAnoInfo.getStoreId();
        SandboxServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreId).size());
        SandboxServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreAnoId).size());
        SandboxInfo sbInfo = this.sbService.getStagingSandbox(wpStoreId);
        try {
            this.sbService.deleteSandbox(sbInfo.getSandboxId());
            SandboxServiceImplTest.fail((String)"Shouldn't be able to delete staging sandbox");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        try {
            this.sbService.deleteSandbox("some-random-staging-sandbox");
            SandboxServiceImplTest.fail((String)"Shouldn't be able to delete non-existant sandbox");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        this.sbService.deleteSandbox(sbInfo.getSandboxId());
        SandboxServiceImplTest.assertEquals((int)1, (int)this.sbService.listSandboxes(wpStoreId).size());
        SandboxServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreAnoId).size());
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentManager");
        this.wpService.inviteWebUser(wpStoreId, USER_TWO, "ContentPublisher");
        this.wpService.inviteWebUser(wpStoreId, USER_THREE, "ContentReviewer", true);
        SandboxServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreId).size());
        this.sbService.createAuthorSandbox(wpStoreId, USER_ONE);
        this.sbService.createAuthorSandbox(wpStoreId, USER_TWO);
        SandboxServiceImplTest.assertEquals((int)4, (int)this.sbService.listSandboxes(wpStoreId).size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        SandboxServiceImplTest.assertEquals((int)4, (int)this.sbService.listSandboxes(wpStoreId).size());
        sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        SandboxServiceImplTest.assertNotNull((Object)sbInfo);
        String defaultWebApp = wpInfo.getDefaultWebApp();
        String authorSandboxId = sbInfo.getSandboxId();
        String authorSandboxPath = sbInfo.getSandboxRootPath() + "/" + defaultWebApp;
        for (i = 1; i <= 10; ++i) {
            this.assetService.createFile(authorSandboxId, authorSandboxPath, "myFile-" + i, null);
            relPath = authorSandboxPath + "/" + "myFile-" + i;
            SandboxServiceImplTest.assertEquals((String)USER_TWO, (String)this.avmLockingService.getLockOwner(wpStoreId, relPath));
        }
        this.sbService.deleteSandbox(sbInfo.getSandboxId());
        SandboxServiceImplTest.assertNull((Object)this.sbService.getSandbox(sbInfo.getSandboxId()));
        for (i = 1; i <= 10; ++i) {
            relPath = authorSandboxPath + "/" + "myFile-" + i;
            SandboxServiceImplTest.assertNull((String)("Lock still exists: " + relPath), (Object)this.avmLockingService.getLockOwner(wpStoreId, relPath));
        }
        SandboxServiceImplTest.assertEquals((int)3, (int)this.sbService.listSandboxes(wpStoreId).size());
        sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        SandboxServiceImplTest.assertNull((Object)sbInfo);
        try {
            this.sbService.deleteSandbox(wpInfo.getStoreId() + "--" + USER_THREE);
            SandboxServiceImplTest.fail((String)"Shouldn't be able to delete another author's sandbox");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxServiceImplTest.assertEquals((int)3, (int)this.sbService.listSandboxes(wpStoreId).size());
        sbInfo = this.sbService.getAuthorSandbox(wpStoreId, USER_THREE);
        this.sbService.deleteSandbox(sbInfo.getSandboxId());
        SandboxServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreId).size());
    }

    public void testListNewItems1() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-listNewItems1", TEST_WEBPROJ_NAME + " listNewItems1", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        SandboxServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreId).size());
        String myWebApp = "myWebApp";
        this.wpService.createWebApp(wpStoreId, myWebApp, "this is my web app");
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentContributor");
        SandboxInfo sbInfo = this.sbService.createAuthorSandbox(wpStoreId, USER_ONE);
        String userOneSandboxId = sbInfo.getSandboxId();
        this.wpService.inviteWebUser(wpStoreId, USER_TWO, "ContentPublisher");
        sbInfo = this.sbService.createAuthorSandbox(wpStoreId, USER_TWO);
        String userTwoSandboxId = sbInfo.getSandboxId();
        this.wpService.inviteWebUser(wpStoreId, USER_THREE, "ContentManager");
        this.sbService.createAuthorSandbox(wpStoreId, USER_THREE);
        this.wpService.inviteWebUser(wpStoreId, USER_FOUR, "ContentReviewer", true);
        SandboxServiceImplTest.assertEquals((int)6, (int)this.sbService.listSandboxes(wpStoreId).size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxServiceImplTest.assertEquals((int)2, (int)this.sbService.listSandboxes(wpStoreId).size());
        sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String sbStoreId = sbInfo.getSandboxId();
        List<AssetInfo> assets = this.sbService.listChangedAll(sbStoreId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String authorSandboxMyWebAppRelativePath = sbInfo.getSandboxRootPath() + "/" + myWebApp;
        String authorSandboxDefaultWebAppRelativePath = sbInfo.getSandboxRootPath() + "/" + wpInfo.getDefaultWebApp();
        this.assetService.createFile(sbStoreId, authorSandboxMyWebAppRelativePath, "myFile1", null);
        assets = this.sbService.listChangedAll(sbStoreId, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        SandboxServiceImplTest.assertEquals((String)"myFile1", (String)assets.get(0).getName());
        this.assetService.createFolder(sbStoreId, authorSandboxDefaultWebAppRelativePath, "myDir1", null);
        this.assetService.createFile(sbStoreId, authorSandboxDefaultWebAppRelativePath + "/myDir1", "myFile2", null);
        this.assetService.createFolder(sbStoreId, authorSandboxDefaultWebAppRelativePath + "/myDir1", "myDir2", null);
        this.assetService.createFile(sbStoreId, authorSandboxDefaultWebAppRelativePath + "/myDir1/myDir2", "myFile3", null);
        this.assetService.createFile(sbStoreId, authorSandboxDefaultWebAppRelativePath + "/myDir1/myDir2", "myFile4", null);
        this.assetService.createFolder(sbStoreId, authorSandboxDefaultWebAppRelativePath + "/myDir1", "myDir3", null);
        assets = this.sbService.listChangedAll(sbStoreId, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        for (AssetInfo asset : assets) {
            if (asset.getName().equals("myFile1") && asset.isFile() || asset.getName().equals("myDir1") && asset.isFolder()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        assets = this.sbService.listChangedWebApp(sbStoreId, wpInfo.getDefaultWebApp(), false);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        for (AssetInfo asset : assets) {
            if (asset.getName().equals("myDir1") && asset.isFolder()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        assets = this.sbService.listChanged(sbStoreId, authorSandboxDefaultWebAppRelativePath + "/myDir1", false);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        for (AssetInfo asset : assets) {
            if (asset.getName().equals("myDir1") && asset.isFolder()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        SandboxServiceImplTest.assertEquals((int)6, (int)this.sbService.listSandboxes(wpStoreId).size());
        assets = this.sbService.listChangedAll(userOneSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_THREE);
        SandboxServiceImplTest.assertEquals((int)6, (int)this.sbService.listSandboxes(wpStoreId).size());
        assets = this.sbService.listChangedAll(userOneSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        try {
            assets = this.sbService.listChangedAll(userTwoSandboxId, true);
            SandboxServiceImplTest.fail((String)"Shouldn't be able to list another author's sandbox changes");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        assets = this.sbService.listChangedAll(userOneSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_FOUR);
        try {
            assets = this.sbService.listChangedAll(userOneSandboxId, true);
            SandboxServiceImplTest.fail((String)"Shouldn't be able to list another author's sandbox changes");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
    }

    public void testListNewItems2() {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-listNewItems2", TEST_WEBPROJ_NAME + " listNewItems2", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentContributor", true);
        this.wpService.inviteWebUser(wpStoreId, USER_TWO, "ContentContributor", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo1 = this.sbService.getAuthorSandbox(wpStoreId);
        String sbStoreId = sbInfo1.getSandboxId();
        List<AssetInfo> assets = this.sbService.listChangedAll(sbStoreId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        this.assetService.createFile(sbStoreId, sbInfo1.getSandboxRootPath(), "myFile1", null);
        assets = this.sbService.listChangedAll(sbStoreId, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        SandboxServiceImplTest.assertEquals((String)"myFile1", (String)assets.get(0).getName());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        SandboxInfo sbInfo2 = this.sbService.getAuthorSandbox(wpStoreId);
        sbStoreId = sbInfo2.getSandboxId();
        assets = this.sbService.listChangedAll(sbStoreId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        this.assetService.createFile(sbStoreId, sbInfo2.getSandboxRootPath(), "myFile2", null);
        this.assetService.createFile(sbStoreId, sbInfo2.getSandboxRootPath(), "myFile3", null);
        assets = this.sbService.listChangedAll(sbStoreId, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        for (AssetInfo asset : assets) {
            if (asset.getName().equals("myFile2") && asset.isFile() || asset.getName().equals("myFile3") && asset.isFile()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        sbInfo1 = this.sbService.getAuthorSandbox(wpStoreId, USER_ONE);
        sbInfo2 = this.sbService.getAuthorSandbox(wpStoreId, USER_TWO);
        assets = this.sbService.listChanged(sbInfo1.getSandboxId(), sbInfo1.getSandboxRootPath(), sbInfo2.getSandboxId(), sbInfo2.getSandboxRootPath(), false);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        SandboxServiceImplTest.assertEquals((String)"myFile1", (String)assets.get(0).getName());
        assets = this.sbService.listChanged(sbInfo2.getSandboxId(), sbInfo2.getSandboxRootPath(), sbInfo1.getSandboxId(), sbInfo1.getSandboxRootPath(), false);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        for (AssetInfo asset : assets) {
            if (asset.getName().equals("myFile2") && asset.isFile() || asset.getName().equals("myFile3") && asset.isFile()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
    }

    public void testSubmitNewItems1() throws InterruptedException {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-submitNewItems1", TEST_WEBPROJ_NAME + " submitNewItems1", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        String webApp = wpInfo.getDefaultWebApp();
        String stagingSandboxId = wpInfo.getStagingStoreName();
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentContributor", true);
        this.wpService.inviteWebUser(wpStoreId, USER_TWO, "ContentPublisher", true);
        this.wpService.inviteWebUser(wpStoreId, USER_THREE, "ContentManager", true);
        this.wpService.inviteWebUser(wpStoreId, USER_FOUR, "ContentReviewer", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String authorSandboxId = sbInfo.getSandboxId();
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String authorSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        this.assetService.createFile(authorSandboxId, authorSandboxPath, "myFile1", null);
        this.assetService.createFolder(authorSandboxId, authorSandboxPath, "myDir1", null);
        this.assetService.createFile(authorSandboxId, authorSandboxPath + "/myDir1", "myFile2", null);
        this.assetService.createFolder(authorSandboxId, authorSandboxPath + "/myDir1", "myDir2", null);
        this.assetService.createFile(authorSandboxId, authorSandboxPath + "/myDir1/myDir2", "myFile3", null);
        this.assetService.createFile(authorSandboxId, authorSandboxPath + "/myDir1/myDir2", "myFile4", null);
        this.assetService.createFolder(authorSandboxId, authorSandboxPath + "/myDir1", "myDir3", null);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        String stagingSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false).size());
        this.sbService.submitWebApp(authorSandboxId, webApp, "a submit label", "a submit comment");
        this.pollForSnapshotCount(stagingSandboxId, 1);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("myFile1") && asset.isFile() || asset.getName().equals("myDir1") && asset.isFolder()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        String userSandboxId = wpStoreId + "--" + USER_THREE;
        this.sbService.submitAll(userSandboxId, "my submit", null);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_THREE);
        userSandboxId = wpStoreId + "--" + USER_ONE;
        this.sbService.submitAll(userSandboxId, "my submit", null);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        try {
            userSandboxId = wpStoreId + "--" + USER_THREE;
            ArrayList<AssetInfo> noAssets = new ArrayList<AssetInfo>(0);
            this.sbService.submitListAssets(userSandboxId, noAssets, "my submit", null);
            SandboxServiceImplTest.fail((String)"Shouldn't be able to submit another author's sandbox");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        userSandboxId = wpStoreId + "--" + USER_ONE;
        this.sbService.submitAll(userSandboxId, "my submit", null);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_FOUR);
        try {
            userSandboxId = TEST_SANDBOX + "-get" + "--" + USER_THREE;
            this.sbService.submitAll(userSandboxId, "my submit", null);
            SandboxServiceImplTest.fail((String)"Shouldn't be able to submit another author's sandbox");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
    }

    public void xtestSubmitChangedAssets1() throws IOException, InterruptedException {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-submitChangedAssets1", TEST_WEBPROJ_NAME + " submitChangedAssets1", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        String webApp = wpInfo.getDefaultWebApp();
        String stagingSandboxId = wpInfo.getStagingStoreName();
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentContributor", true);
        this.wpService.inviteWebUser(wpStoreId, USER_TWO, "ContentPublisher", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String authorSandboxId = sbInfo.getSandboxId();
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String MYFILE1 = "This is myFile1";
        ContentWriter writer = this.assetService.createFileWebApp(authorSandboxId, webApp, "/", "myFile1");
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile1");
        this.assetService.createFolderWebApp(authorSandboxId, webApp, "/", "myDir1");
        String MYFILE2 = "This is myFile2";
        writer = this.assetService.createFileWebApp(authorSandboxId, webApp, "/myDir1", "myFile2");
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile2");
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        String stagingSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false).size());
        this.sbService.submitWebApp(authorSandboxId, webApp, "a submit label", "a submit comment");
        this.pollForSnapshotCount(stagingSandboxId, 1);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)listing.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        authorSandboxId = sbInfo.getSandboxId();
        assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String MYFILE1_MODIFIED = "This is myFile1 ... modified by " + USER_TWO;
        writer = this.assetService.getContentWriter(this.assetService.getAssetWebApp(authorSandboxId, webApp, "/myFile1"));
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(MYFILE1_MODIFIED);
        String MYFILE2_MODIFIED = "This is myFile2 ... modified by " + USER_TWO;
        writer = this.assetService.getContentWriter(this.assetService.getAssetWebApp(authorSandboxId, webApp, "/myDir1/myFile2"));
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(MYFILE2_MODIFIED);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        stagingSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        ContentReader reader = this.assetService.getContentReader(this.assetService.getAsset(stagingSandboxId, -1, stagingSandboxPath + "/myFile1", false));
        InputStream in = reader.getContentInputStream();
        byte[] buff = new byte[1024];
        in.read(buff);
        in.close();
        SandboxServiceImplTest.assertEquals((String)"This is myFile1", (String)new String(buff, 0, "This is myFile1".length()));
        reader = this.assetService.getContentReader(this.assetService.getAsset(stagingSandboxId, -1, stagingSandboxPath + "/myDir1/myFile2", false));
        in = reader.getContentInputStream();
        buff = new byte[1024];
        in.read(buff);
        in.close();
        SandboxServiceImplTest.assertEquals((String)"This is myFile2", (String)new String(buff, 0, "This is myFile2".length()));
        this.sbService.submitWebApp(authorSandboxId, webApp, "my label", null);
        this.pollForSnapshotCount(stagingSandboxId, 2);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        reader = this.assetService.getContentReader(this.assetService.getAsset(stagingSandboxId, -1, stagingSandboxPath + "/myFile1", false));
        in = reader.getContentInputStream();
        buff = new byte[1024];
        in.read(buff);
        in.close();
        SandboxServiceImplTest.assertEquals((String)MYFILE1_MODIFIED, (String)new String(buff, 0, MYFILE1_MODIFIED.length()));
        reader = this.assetService.getContentReader(this.assetService.getAsset(stagingSandboxId, -1, stagingSandboxPath + "/myDir1/myFile2", false));
        in = reader.getContentInputStream();
        buff = new byte[1024];
        in.read(buff);
        in.close();
        SandboxServiceImplTest.assertEquals((String)MYFILE2_MODIFIED, (String)new String(buff, 0, MYFILE1_MODIFIED.length()));
    }

    public void testSubmitChangedAssets2() throws IOException, InterruptedException {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-submitChangedAssets1", TEST_WEBPROJ_NAME + " submitChangedAssets1", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        String stagingSandboxId = wpInfo.getStagingStoreName();
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String authorSandboxId = sbInfo.getSandboxId();
        String rootPath = sbInfo.getSandboxRootPath();
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        this.assetService.createFolder(authorSandboxId, rootPath, "a", null);
        this.assetService.createFolder(authorSandboxId, rootPath + "/a", "b", null);
        this.assetService.createFolder(authorSandboxId, rootPath + "/a/b", "c", null);
        String MYFILE1 = "This is foo";
        ContentWriter writer = this.assetService.createFile(authorSandboxId, rootPath + "/a/b/c", "foo", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is foo");
        String MYFILE2 = "This is bar";
        writer = this.assetService.createFile(authorSandboxId, rootPath + "/a/b/c", "bar", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is bar");
        assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(stagingSandboxId, -1, rootPath, false).size());
        this.sbService.submitAll(authorSandboxId, "a submit label", "a submit comment");
        this.pollForSnapshotCount(stagingSandboxId, 1);
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxId, -1, rootPath, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)listing.size());
        assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String MYFILE3 = "This is figs";
        writer = this.assetService.createFile(authorSandboxId, rootPath, "figs", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is figs");
        String MYFILE1_MODIFIED = "This is foo ... modified";
        writer = this.assetService.getContentWriter(this.assetService.getAsset(authorSandboxId, rootPath + "/a/b/c/foo"));
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is foo ... modified");
        this.assetService.deleteAsset(this.assetService.getAsset(authorSandboxId, rootPath + "/a/b/c/bar"));
        assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)3, (int)assets.size());
        listing = this.assetService.listAssets(stagingSandboxId, -1, rootPath, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)listing.size());
        this.sbService.submitAll(authorSandboxId, "my label", null);
        this.pollForSnapshotCount(stagingSandboxId, 2);
        assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        listing = this.assetService.listAssets(stagingSandboxId, -1, rootPath, false);
        SandboxServiceImplTest.assertEquals((int)3, (int)listing.size());
    }

    public void testSubmitDeletedItems1() throws IOException, InterruptedException {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-submitDeletedItems1", TEST_WEBPROJ_NAME + " submitDeletedItems1", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        String webApp = wpInfo.getDefaultWebApp();
        String stagingSandboxId = wpInfo.getStagingStoreName();
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentContributor", true);
        this.wpService.inviteWebUser(wpStoreId, USER_TWO, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String authorSandboxId = sbInfo.getSandboxId();
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String authorSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        String MYFILE1 = "This is myFile1";
        ContentWriter writer = this.assetService.createFile(authorSandboxId, authorSandboxPath, "myFile1", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile1");
        this.assetService.createFolder(authorSandboxId, authorSandboxPath, "myDir1", null);
        this.assetService.createFolder(authorSandboxId, authorSandboxPath + "/myDir1", "myDir2", null);
        String MYFILE2 = "This is myFile2";
        writer = this.assetService.createFile(authorSandboxId, authorSandboxPath + "/myDir1", "myFile2", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile2");
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        String stagingSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false).size());
        this.sbService.submitWebApp(authorSandboxId, webApp, "a submit label", "a submit comment");
        this.pollForSnapshotCount(stagingSandboxId, 1);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)listing.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        authorSandboxId = sbInfo.getSandboxId();
        assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        this.assetService.deleteAsset(this.assetService.getAssetWebApp(authorSandboxId, webApp, "myFile1"));
        this.assetService.deleteAsset(this.assetService.getAssetWebApp(authorSandboxId, webApp, "/myDir1/myDir2"));
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, true);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        SandboxServiceImplTest.assertNotNull((Object)this.assetService.getAssetWebApp(stagingSandboxId, webApp, "/myFile1"));
        SandboxServiceImplTest.assertNotNull((Object)this.assetService.getAssetWebApp(stagingSandboxId, webApp, "/myDir1"));
        SandboxServiceImplTest.assertNotNull((Object)this.assetService.getAssetWebApp(stagingSandboxId, webApp, "/myDir1/myDir2"));
        SandboxServiceImplTest.assertNotNull((Object)this.assetService.getAssetWebApp(stagingSandboxId, webApp, "/myDir1/myFile2"));
        this.sbService.submitWebApp(authorSandboxId, webApp, "my label", null);
        this.pollForSnapshotCount(stagingSandboxId, 2);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        SandboxServiceImplTest.assertNull((Object)this.assetService.getAssetWebApp(stagingSandboxId, webApp, "/myFile1"));
        SandboxServiceImplTest.assertNull((Object)this.assetService.getAssetWebApp(stagingSandboxId, webApp, "/myDir1/myDir2"));
        SandboxServiceImplTest.assertNotNull((Object)this.assetService.getAssetWebApp(stagingSandboxId, webApp, "/myDir1"));
        SandboxServiceImplTest.assertNotNull((Object)this.assetService.getAssetWebApp(stagingSandboxId, webApp, "/myDir1/myFile2"));
    }

    public void testSubmitDeletedItemsWithLD() throws IOException, InterruptedException {
        WebProjectInfo wpInfoA = this.wpService.createWebProject(TEST_SANDBOX + "-A", TEST_WEBPROJ_NAME + " A", "This is my title", "This is my description");
        String wpStoreIdA = wpInfoA.getStoreId();
        String webAppA = wpInfoA.getDefaultWebApp();
        String stagingSandboxIdA = wpInfoA.getStagingStoreName();
        SandboxInfo sbInfoA = this.sbService.getAuthorSandbox(wpStoreIdA);
        String authorSandboxIdA = sbInfoA.getSandboxId();
        String stagingSandboxPathA = sbInfoA.getSandboxRootPath() + "/" + webAppA;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false).size());
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxIdA, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String authorSandboxPathA = sbInfoA.getSandboxRootPath() + "/" + webAppA;
        this.assetService.createFolder(authorSandboxIdA, authorSandboxPathA, "test", null);
        String MYFILE = "This is testfile.txt in AAA";
        ContentWriter writer = this.assetService.createFile(authorSandboxIdA, authorSandboxPathA + "/test", "testfile.txt", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is testfile.txt in AAA");
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(authorSandboxIdA, -1, authorSandboxPathA, false).size());
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(authorSandboxIdA, -1, authorSandboxPathA + "/test", false).size());
        assets = this.sbService.listChangedWebApp(authorSandboxIdA, webAppA, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false).size());
        this.sbService.submitWebApp(authorSandboxIdA, webAppA, "A1", "A1");
        this.pollForSnapshotCount(stagingSandboxIdA, 1);
        assets = this.sbService.listChangedWebApp(authorSandboxIdA, webAppA, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)listing.size());
        listing = this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA + "/test", false);
        SandboxServiceImplTest.assertEquals((int)1, (int)listing.size());
        WebProjectInfo wpInfoB = this.wpService.createWebProject(TEST_SANDBOX + "-B", TEST_WEBPROJ_NAME + " B", "This is my title", "This is my description");
        String wpStoreIdB = wpInfoB.getStoreId();
        String webAppB = wpInfoB.getDefaultWebApp();
        String stagingSandboxIdB = wpInfoB.getStagingStoreName();
        SandboxInfo sbInfoB = this.sbService.getAuthorSandbox(wpStoreIdB);
        String authorSandboxIdB = sbInfoB.getSandboxId();
        String stagingSandboxPathB = sbInfoB.getSandboxRootPath() + "/" + webAppB;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdB, -1, stagingSandboxPathB, false).size());
        assets = this.sbService.listChangedAll(authorSandboxIdB, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        this.avmService.createLayeredDirectory(wpStoreIdA + ":" + stagingSandboxPathA + "/test", wpStoreIdB + ":" + stagingSandboxPathB, "test");
        String authorSandboxPathB = sbInfoB.getSandboxRootPath() + "/" + webAppB;
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(authorSandboxIdB, -1, authorSandboxPathB, false).size());
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(authorSandboxIdB, -1, authorSandboxPathB + "/test", false).size());
        String MYFILE_MODIFIED = "This is testfile.txt modified in BBB";
        writer = this.assetService.getContentWriter(this.assetService.getAssetWebApp(authorSandboxIdB, webAppB + "/test", "/testfile.txt"));
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is testfile.txt modified in BBB");
        this.sbService.submitWebApp(authorSandboxIdB, webAppB, "B1", "B1");
        this.pollForSnapshotCount(stagingSandboxIdB, 1);
        this.assetService.deleteAsset(this.assetService.getAssetWebApp(authorSandboxIdA, webAppA, "test"));
        this.sbService.submitWebApp(authorSandboxIdA, webAppA, "A2", "A2");
        this.pollForSnapshotCount(stagingSandboxIdA, 2);
        this.assetService.deleteAsset(this.assetService.getAssetWebApp(authorSandboxIdB, webAppB + "/test", "testfile.txt"));
        this.sbService.submitWebApp(authorSandboxIdB, webAppB, "B2", "B2");
        this.pollForSnapshotCount(stagingSandboxIdB, 2);
    }

    public void testSubmitUpdatedItemWithLF() throws IOException, InterruptedException {
        WebProjectInfo wpInfoA = this.wpService.createWebProject(TEST_SANDBOX + "-A", TEST_WEBPROJ_NAME + " A", "This is my title", "This is my description");
        String wpStoreIdA = wpInfoA.getStoreId();
        String webAppA = wpInfoA.getDefaultWebApp();
        String stagingSandboxIdA = wpInfoA.getStagingStoreName();
        SandboxInfo sbInfoA = this.sbService.getAuthorSandbox(wpStoreIdA);
        String authorSandboxIdA = sbInfoA.getSandboxId();
        String stagingSandboxPathA = sbInfoA.getSandboxRootPath() + "/" + webAppA;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false).size());
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxIdA, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String authorSandboxPathA = sbInfoA.getSandboxRootPath() + "/" + webAppA;
        String MYFILE = "This is testfile.txt in AAA";
        ContentWriter writer = this.assetService.createFile(authorSandboxIdA, authorSandboxPathA + "/", "testfile.txt", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is testfile.txt in AAA");
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(authorSandboxIdA, -1, authorSandboxPathA, false).size());
        assets = this.sbService.listChangedWebApp(authorSandboxIdA, webAppA, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false).size());
        this.sbService.submitWebApp(authorSandboxIdA, webAppA, "A1", "A1");
        this.pollForSnapshotCount(stagingSandboxIdA, 1);
        assets = this.sbService.listChangedWebApp(authorSandboxIdA, webAppA, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)listing.size());
        WebProjectInfo wpInfoB = this.wpService.createWebProject(TEST_SANDBOX + "-B", TEST_WEBPROJ_NAME + " B", "This is my title", "This is my description");
        String wpStoreIdB = wpInfoB.getStoreId();
        String webAppB = wpInfoB.getDefaultWebApp();
        String stagingSandboxIdB = wpInfoB.getStagingStoreName();
        SandboxInfo sbInfoB = this.sbService.getAuthorSandbox(wpStoreIdB);
        String authorSandboxIdB = sbInfoB.getSandboxId();
        String stagingSandboxPathB = sbInfoB.getSandboxRootPath() + "/" + webAppB;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdB, -1, stagingSandboxPathB, false).size());
        assets = this.sbService.listChangedAll(authorSandboxIdB, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        this.avmService.createLayeredFile(wpStoreIdA + ":" + stagingSandboxPathA + "/testfile.txt", wpStoreIdB + ":" + stagingSandboxPathB, "testfile.txt");
        String authorSandboxPathB = sbInfoB.getSandboxRootPath() + "/" + webAppB;
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(authorSandboxIdB, -1, authorSandboxPathB, false).size());
        assets = this.sbService.listChangedWebApp(authorSandboxIdB, webAppB, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String MYFILE_MODIFIED = "This is testfile.txt modified in BBB";
        writer = this.assetService.getContentWriter(this.assetService.getAssetWebApp(authorSandboxIdB, webAppB + "/", "/testfile.txt"));
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is testfile.txt modified in BBB");
        assets = this.sbService.listChangedWebApp(authorSandboxIdB, webAppB, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.get(0).getDiffCode());
        this.sbService.submitWebApp(authorSandboxIdB, webAppB, "B1", "B1");
        this.pollForSnapshotCount(stagingSandboxIdB, 1);
        assets = this.sbService.listChangedWebApp(authorSandboxIdB, webAppB, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
    }

    public void testSubmitDeletedItemsWithLF1() throws IOException, InterruptedException {
        WebProjectInfo wpInfoA = this.wpService.createWebProject(TEST_SANDBOX + "-A", TEST_WEBPROJ_NAME + " A", "This is my title", "This is my description");
        String wpStoreIdA = wpInfoA.getStoreId();
        String webAppA = wpInfoA.getDefaultWebApp();
        String stagingSandboxIdA = wpInfoA.getStagingStoreName();
        SandboxInfo sbInfoA = this.sbService.getAuthorSandbox(wpStoreIdA);
        String authorSandboxIdA = sbInfoA.getSandboxId();
        String stagingSandboxPathA = sbInfoA.getSandboxRootPath() + "/" + webAppA;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false).size());
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxIdA, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String authorSandboxPathA = sbInfoA.getSandboxRootPath() + "/" + webAppA;
        String MYFILE_A = "This is a.txt in A";
        ContentWriter writer = this.assetService.createFile(authorSandboxIdA, authorSandboxPathA, "a.txt", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is a.txt in A");
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(authorSandboxIdA, -1, authorSandboxPathA, false).size());
        assets = this.sbService.listChangedWebApp(authorSandboxIdA, webAppA, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false).size());
        this.sbService.submitWebApp(authorSandboxIdA, webAppA, "A1", "A1");
        this.pollForSnapshotCount(stagingSandboxIdA, 1);
        assets = this.sbService.listChangedWebApp(authorSandboxIdA, webAppA, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)listing.size());
        listing = this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)listing.size());
        WebProjectInfo wpInfoB = this.wpService.createWebProject(TEST_SANDBOX + "-B", TEST_WEBPROJ_NAME + " B", "This is my title", "This is my description");
        String wpStoreIdB = wpInfoB.getStoreId();
        String webAppB = wpInfoB.getDefaultWebApp();
        String stagingSandboxIdB = wpInfoB.getStagingStoreName();
        SandboxInfo sbInfoB = this.sbService.getAuthorSandbox(wpStoreIdB);
        String authorSandboxIdB = sbInfoB.getSandboxId();
        String stagingSandboxPathB = sbInfoB.getSandboxRootPath() + "/" + webAppB;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdB, -1, stagingSandboxPathB, false).size());
        assets = this.sbService.listChangedAll(authorSandboxIdB, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        this.avmService.createLayeredFile(wpStoreIdA + ":" + stagingSandboxPathA + "/a.txt", wpStoreIdB + ":" + stagingSandboxPathB, "a.txt");
        String authorSandboxPathB = sbInfoB.getSandboxRootPath() + "/" + webAppB;
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(authorSandboxIdB, -1, authorSandboxPathB, false).size());
        this.assetService.deleteAsset(this.assetService.getAssetWebApp(authorSandboxIdB, webAppB, "a.txt"));
        SandboxServiceImplTest.assertEquals((int)1, (int)this.sbService.listChangedAll(authorSandboxIdB, true).size());
        this.sbService.submitWebApp(authorSandboxIdB, webAppB, "B2", "B2");
        this.pollForSnapshotCount(stagingSandboxIdB, 1);
        SandboxServiceImplTest.assertEquals((int)0, (int)this.sbService.listChangedAll(authorSandboxIdB, true).size());
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdB, -1, stagingSandboxPathB, false).size());
    }

    public void testSubmitDeletedItemsWithLF2() throws IOException, InterruptedException {
        WebProjectInfo wpInfoA = this.wpService.createWebProject(TEST_SANDBOX + "-A", TEST_WEBPROJ_NAME + " A", "This is my title", "This is my description");
        String wpStoreIdA = wpInfoA.getStoreId();
        String webAppA = wpInfoA.getDefaultWebApp();
        String stagingSandboxIdA = wpInfoA.getStagingStoreName();
        SandboxInfo sbInfoA = this.sbService.getAuthorSandbox(wpStoreIdA);
        String authorSandboxIdA = sbInfoA.getSandboxId();
        String stagingSandboxPathA = sbInfoA.getSandboxRootPath() + "/" + webAppA;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false).size());
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxIdA, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String authorSandboxPathA = sbInfoA.getSandboxRootPath() + "/" + webAppA;
        String MYFILE_A = "This is a.txt in A";
        ContentWriter writer = this.assetService.createFile(authorSandboxIdA, authorSandboxPathA, "a.txt", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is a.txt in A");
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(authorSandboxIdA, -1, authorSandboxPathA, false).size());
        assets = this.sbService.listChangedWebApp(authorSandboxIdA, webAppA, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false).size());
        this.sbService.submitWebApp(authorSandboxIdA, webAppA, "A1", "A1");
        this.pollForSnapshotCount(stagingSandboxIdA, 1);
        assets = this.sbService.listChangedWebApp(authorSandboxIdA, webAppA, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)listing.size());
        listing = this.assetService.listAssets(stagingSandboxIdA, -1, stagingSandboxPathA, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)listing.size());
        WebProjectInfo wpInfoB = this.wpService.createWebProject(TEST_SANDBOX + "-B", TEST_WEBPROJ_NAME + " B", "This is my title", "This is my description");
        String wpStoreIdB = wpInfoB.getStoreId();
        String webAppB = wpInfoB.getDefaultWebApp();
        String stagingSandboxIdB = wpInfoB.getStagingStoreName();
        SandboxInfo sbInfoB = this.sbService.getAuthorSandbox(wpStoreIdB);
        String authorSandboxIdB = sbInfoB.getSandboxId();
        String stagingSandboxPathB = sbInfoB.getSandboxRootPath() + "/" + webAppB;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxIdB, -1, stagingSandboxPathB, false).size());
        assets = this.sbService.listChangedAll(authorSandboxIdB, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        this.avmService.createLayeredFile(wpStoreIdA + ":" + stagingSandboxPathA + "/a.txt", wpStoreIdB + ":" + stagingSandboxPathB, "a.txt");
        String authorSandboxPathB = sbInfoB.getSandboxRootPath() + "/" + webAppB;
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(authorSandboxIdB, -1, authorSandboxPathB, false).size());
        String MYFILE_B = "This is b.txt in B";
        writer = this.assetService.createFile(authorSandboxIdB, authorSandboxPathB, "b.txt", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is b.txt in B");
        logger.debug((Object)"created file b.txt in B admin sandbox");
        this.recursiveList(stagingSandboxIdA);
        this.recursiveList(stagingSandboxIdB);
        this.recursiveList(authorSandboxIdB);
        this.sbService.submitWebApp(authorSandboxIdB, webAppB, "B1", "B1");
        logger.debug((Object)"submit initiated: created file b.txt in B staging sandbox");
        this.recursiveList(stagingSandboxIdA);
        this.recursiveList(stagingSandboxIdB);
        this.recursiveList(authorSandboxIdB);
        this.pollForSnapshotCount(stagingSandboxIdB, 1);
        logger.debug((Object)"submit completed: created file b.txt in B staging sandbox");
        this.recursiveList(stagingSandboxIdA);
        this.recursiveList(stagingSandboxIdB);
        this.recursiveList(authorSandboxIdB);
        SandboxServiceImplTest.assertEquals((int)2, (int)this.assetService.listAssets(stagingSandboxIdB, -1, stagingSandboxPathB, false).size());
        this.assetService.deleteAsset(this.assetService.getAssetWebApp(authorSandboxIdB, webAppB, "a.txt"));
        logger.debug((Object)"deleted file a.txt from B admin sandbox");
        this.recursiveList(stagingSandboxIdA);
        this.recursiveList(stagingSandboxIdB);
        this.recursiveList(authorSandboxIdB);
        SandboxServiceImplTest.assertEquals((int)1, (int)this.sbService.listChangedAll(authorSandboxIdB, true).size());
        this.sbService.submitWebApp(authorSandboxIdB, webAppB, "B2", "B2");
        logger.debug((Object)"submit initiated: deleted file a.txt in B staging sandbox");
        this.recursiveList(stagingSandboxIdA);
        this.recursiveList(stagingSandboxIdB);
        this.recursiveList(authorSandboxIdB);
        this.pollForSnapshotCount(stagingSandboxIdB, 2);
        logger.debug((Object)"submit completed: deleted file a.txt in B staging sandbox");
        this.recursiveList(stagingSandboxIdA);
        this.recursiveList(stagingSandboxIdB);
        this.recursiveList(authorSandboxIdB);
        SandboxServiceImplTest.assertEquals((int)0, (int)this.sbService.listChangedAll(authorSandboxIdB, true).size());
        SandboxServiceImplTest.assertEquals((int)1, (int)this.assetService.listAssets(stagingSandboxIdB, -1, stagingSandboxPathB, false).size());
    }

    public void testUndo() throws IOException, InterruptedException {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-revertChangedAssets", TEST_WEBPROJ_NAME + " revertChangedAssets", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        String webApp = wpInfo.getDefaultWebApp();
        String stagingSandboxId = wpInfo.getStagingStoreName();
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentContributor", true);
        this.wpService.inviteWebUser(wpStoreId, USER_TWO, "ContentPublisher", true);
        this.wpService.inviteWebUser(wpStoreId, USER_THREE, "ContentManager", true);
        this.wpService.inviteWebUser(wpStoreId, USER_FOUR, "ContentReviewer", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String authorSandboxId = sbInfo.getSandboxId();
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String authorSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        String MYFILE1 = "This is myFile1";
        ContentWriter writer = this.assetService.createFile(authorSandboxId, authorSandboxPath, "myFile1", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile1");
        this.assetService.createFolder(authorSandboxId, authorSandboxPath, "myDir1", null);
        String MYFILE2 = "This is myFile2";
        writer = this.assetService.createFile(authorSandboxId, authorSandboxPath + "/myDir1", "myFile2", null);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent("This is myFile2");
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        String stagingSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false).size());
        this.sbService.submitWebApp(authorSandboxId, webApp, "a submit label", "a submit comment");
        this.pollForSnapshotCount(stagingSandboxId, 1);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)listing.size());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        authorSandboxId = sbInfo.getSandboxId();
        assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String MYFILE1_MODIFIED = "This is myFile1 ... modified by " + USER_TWO;
        writer = this.assetService.getContentWriter(this.assetService.getAssetWebApp(authorSandboxId, webApp, "/myFile1"));
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(MYFILE1_MODIFIED);
        String MYFILE2_MODIFIED = "This is myFile2 ... modified by " + USER_TWO;
        writer = this.assetService.getContentWriter(this.assetService.getAssetWebApp(authorSandboxId, webApp, "/myDir1/myFile2"));
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(MYFILE2_MODIFIED);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)assets.size());
        stagingSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        ContentReader reader = this.assetService.getContentReader(this.assetService.getAsset(stagingSandboxId, -1, stagingSandboxPath + "/myFile1", false));
        InputStream in = reader.getContentInputStream();
        byte[] buff = new byte[1024];
        in.read(buff);
        in.close();
        SandboxServiceImplTest.assertEquals((String)"This is myFile1", (String)new String(buff, 0, "This is myFile1".length()));
        reader = this.assetService.getContentReader(this.assetService.getAsset(stagingSandboxId, -1, stagingSandboxPath + "/myDir1/myFile2", false));
        in = reader.getContentInputStream();
        buff = new byte[1024];
        in.read(buff);
        in.close();
        SandboxServiceImplTest.assertEquals((String)"This is myFile2", (String)new String(buff, 0, "This is myFile2".length()));
        this.sbService.revertWebApp(authorSandboxId, webApp);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        reader = this.assetService.getContentReader(this.assetService.getAsset(stagingSandboxId, -1, stagingSandboxPath + "/myFile1", false));
        in = reader.getContentInputStream();
        buff = new byte[1024];
        in.read(buff);
        in.close();
        SandboxServiceImplTest.assertEquals((String)"This is myFile1", (String)new String(buff, 0, "This is myFile1".length()));
        reader = this.assetService.getContentReader(this.assetService.getAsset(stagingSandboxId, -1, stagingSandboxPath + "/myDir1/myFile2", false));
        in = reader.getContentInputStream();
        buff = new byte[1024];
        in.read(buff);
        in.close();
        SandboxServiceImplTest.assertEquals((String)"This is myFile2", (String)new String(buff, 0, "This is myFile2".length()));
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        String userSandboxId = wpStoreId + "--" + USER_THREE;
        this.sbService.revertAll(userSandboxId);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_THREE);
        userSandboxId = wpStoreId + "--" + USER_ONE;
        this.sbService.revertAll(userSandboxId);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        try {
            userSandboxId = wpStoreId + "--" + USER_THREE;
            ArrayList<AssetInfo> noAssets = new ArrayList<AssetInfo>(0);
            this.sbService.revertListAssets(userSandboxId, noAssets);
            SandboxServiceImplTest.fail((String)"Shouldn't be able to revert another author's sandbox");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_TWO);
        userSandboxId = wpStoreId + "--" + USER_ONE;
        this.sbService.revertAll(userSandboxId);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_FOUR);
        try {
            userSandboxId = TEST_SANDBOX + "-get" + "--" + USER_THREE;
            this.sbService.revertAll(userSandboxId);
            SandboxServiceImplTest.fail((String)"Shouldn't be able to revert another author's sandbox");
        }
        catch (AccessDeniedException exception) {
            // empty catch block
        }
    }

    public void testListSnapshots() throws IOException, InterruptedException {
        Date fromDate = new Date();
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-listSnapshots", TEST_WEBPROJ_NAME + " listSnapshots", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        String webApp = wpInfo.getDefaultWebApp();
        String stagingSandboxId = wpInfo.getStagingStoreName();
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String authorSandboxId = sbInfo.getSandboxId();
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        this.assetService.createFolderWebApp(authorSandboxId, webApp, "/", "myDir1");
        this.assetService.createFolderWebApp(authorSandboxId, webApp, "/", "myDir2");
        this.assetService.createFolderWebApp(authorSandboxId, webApp, "/", "myDir3");
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)3, (int)assets.size());
        String stagingSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false).size());
        List<SandboxVersion> sbVersions = this.sbService.listSnapshots(stagingSandboxId, fromDate, new Date(), false);
        SandboxServiceImplTest.assertEquals((int)0, (int)sbVersions.size());
        this.sbService.submitWebApp(authorSandboxId, webApp, "a submit label", "a submit comment");
        this.pollForSnapshotCount(stagingSandboxId, 1);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)3, (int)listing.size());
        sbVersions = this.sbService.listSnapshots(stagingSandboxId, fromDate, new Date(), false);
        SandboxServiceImplTest.assertEquals((int)1, (int)sbVersions.size());
        this.assetService.createFolderWebApp(authorSandboxId, webApp, "/", "myDir4");
        this.sbService.submitWebApp(authorSandboxId, webApp, "a submit label", "a submit comment");
        this.pollForSnapshotCount(stagingSandboxId, 2);
        listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)4, (int)listing.size());
        sbVersions = this.sbService.listSnapshots(stagingSandboxId, fromDate, new Date(), false);
        SandboxServiceImplTest.assertEquals((int)2, (int)sbVersions.size());
    }

    public void testRevertSnapshot1() throws IOException, InterruptedException {
        Date fromDate = new Date();
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-revertSnapshot", TEST_WEBPROJ_NAME + " revertSnapshot", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        String webApp = wpInfo.getDefaultWebApp();
        String stagingSandboxId = wpInfo.getStagingStoreName();
        this.wpService.inviteWebUser(wpStoreId, USER_ONE, "ContentManager", true);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ONE);
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String authorSandboxId = sbInfo.getSandboxId();
        List<AssetInfo> assets = this.sbService.listChangedAll(authorSandboxId, true);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        String authorSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        this.assetService.createFolder(authorSandboxId, authorSandboxPath, "myDir1", null);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)assets.size());
        String stagingSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        SandboxServiceImplTest.assertEquals((int)0, (int)this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false).size());
        List<SandboxVersion> sbVersions = this.sbService.listSnapshots(stagingSandboxId, fromDate, new Date(), false);
        SandboxServiceImplTest.assertEquals((int)0, (int)sbVersions.size());
        this.sbService.submitWebApp(authorSandboxId, webApp, "a submit label", "a submit comment");
        this.pollForSnapshotCount(stagingSandboxId, 1);
        assets = this.sbService.listChangedWebApp(authorSandboxId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)0, (int)assets.size());
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("myDir1") && asset.isFolder()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        sbVersions = this.sbService.listSnapshots(stagingSandboxId, fromDate, new Date(), false);
        SandboxServiceImplTest.assertEquals((int)1, (int)sbVersions.size());
        this.assetService.createFolder(authorSandboxId, authorSandboxPath, "myDir2", null);
        this.sbService.submitWebApp(authorSandboxId, webApp, "a submit label", "a submit comment");
        this.pollForSnapshotCount(stagingSandboxId, 2);
        listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("myDir1") && asset.isFolder() || asset.getName().equals("myDir2") && asset.isFolder()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        sbVersions = this.sbService.listSnapshots(stagingSandboxId, fromDate, new Date(), false);
        SandboxServiceImplTest.assertEquals((int)2, (int)sbVersions.size());
        this.assetService.createFolderWebApp(authorSandboxId, webApp, "/", "myDir3");
        this.sbService.submitWebApp(authorSandboxId, webApp, "a submit label", "a submit comment");
        this.pollForSnapshotCount(stagingSandboxId, 3);
        listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)3, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("myDir1") && asset.isFolder() || asset.getName().equals("myDir2") && asset.isFolder() || asset.getName().equals("myDir3") && asset.isFolder()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        sbVersions = this.sbService.listSnapshots(stagingSandboxId, fromDate, new Date(), false);
        SandboxServiceImplTest.assertEquals((int)3, (int)sbVersions.size());
        SandboxVersion version = sbVersions.get(1);
        int versionId = version.getVersion();
        this.sbService.revertSnapshot(stagingSandboxId, versionId);
        sbVersions = this.sbService.listSnapshots(stagingSandboxId, fromDate, new Date(), false);
        SandboxServiceImplTest.assertEquals((int)4, (int)sbVersions.size());
        listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("myDir1") && asset.isFolder() || asset.getName().equals("myDir2") && asset.isFolder()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
    }

    public void testRevertSnapshot2() throws IOException, InterruptedException {
        Date fromDate = new Date();
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-revertSnapshot2", TEST_WEBPROJ_NAME + " revertSnapshot2", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        String webApp = wpInfo.getDefaultWebApp();
        String stagingSandboxId = wpInfo.getStagingStoreName();
        SandboxInfo sbInfo = this.sbService.getStagingSandbox(wpStoreId);
        String stagingSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String authorSandboxId = sbInfo.getSandboxId();
        String authorSandboxPath = sbInfo.getSandboxRootPath() + "/" + webApp;
        List<SandboxVersion> sbVersions = this.sbService.listSnapshots(stagingSandboxId, fromDate, new Date(), false);
        SandboxServiceImplTest.assertEquals((int)0, (int)sbVersions.size());
        this.assetService.createFile(authorSandboxId, authorSandboxPath, "c1.txt", null);
        this.sbService.submitWebApp(authorSandboxId, webApp, "s1", "s1");
        this.pollForSnapshotCount(stagingSandboxId, 1);
        List<AssetInfo> listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("c1.txt") && asset.isFile()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        this.assetService.createFile(authorSandboxId, authorSandboxPath, "c2.txt", null);
        this.sbService.submitWebApp(authorSandboxId, webApp, "s2", "s2");
        this.pollForSnapshotCount(stagingSandboxId, 2);
        listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("c1.txt") && asset.isFile() || asset.getName().equals("c2.txt") && asset.isFile()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        sbVersions = this.sbService.listSnapshots(stagingSandboxId, fromDate, new Date(), false);
        int snapshotVersionId2 = sbVersions.get(0).getVersion();
        this.assetService.createFile(authorSandboxId, authorSandboxPath, "c3.txt", null);
        this.sbService.submitWebApp(authorSandboxId, webApp, "s3", "s3");
        this.pollForSnapshotCount(stagingSandboxId, 3);
        listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)3, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("c1.txt") && asset.isFile() || asset.getName().equals("c2.txt") && asset.isFile() || asset.getName().equals("c3.txt") && asset.isFile()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        sbVersions = this.sbService.listSnapshots(stagingSandboxId, fromDate, new Date(), false);
        int snapshotVersionId3 = sbVersions.get(0).getVersion();
        this.assetService.createFile(authorSandboxId, authorSandboxPath, "c4.txt", null);
        this.sbService.submitWebApp(authorSandboxId, webApp, "s4", "s4");
        this.pollForSnapshotCount(stagingSandboxId, 4);
        listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)4, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("c1.txt") && asset.isFile() || asset.getName().equals("c2.txt") && asset.isFile() || asset.getName().equals("c3.txt") && asset.isFile() || asset.getName().equals("c4.txt") && asset.isFile()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        AssetInfo file = this.assetService.getAsset(authorSandboxId, authorSandboxPath + "/c2.txt");
        this.assetService.deleteAsset(file);
        this.sbService.submitWebApp(authorSandboxId, webApp, "s5", "s5");
        this.pollForSnapshotCount(stagingSandboxId, 5);
        listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)3, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("c1.txt") && asset.isFile() || asset.getName().equals("c3.txt") && asset.isFile() || asset.getName().equals("c4.txt") && asset.isFile()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        this.sbService.revertSnapshot(stagingSandboxId, snapshotVersionId2);
        listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("c1.txt") && asset.isFile() || asset.getName().equals("c2.txt") && asset.isFile()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
        this.sbService.revertSnapshot(stagingSandboxId, snapshotVersionId3);
        listing = this.assetService.listAssets(stagingSandboxId, -1, stagingSandboxPath, false);
        SandboxServiceImplTest.assertEquals((int)3, (int)listing.size());
        for (AssetInfo asset : listing) {
            if (asset.getName().equals("c1.txt") && asset.isFile() || asset.getName().equals("c2.txt") && asset.isFile() || asset.getName().equals("c3.txt") && asset.isFile()) continue;
            SandboxServiceImplTest.fail((String)("The asset '" + asset.getName() + "' is not recognised"));
        }
    }

    public void testSubmitAction() throws Exception {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-submitAction", TEST_WEBPROJ_NAME + " submitAction", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        String webApp = wpInfo.getDefaultWebApp();
        String stagingSandboxId = wpInfo.getStagingStoreName();
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String sbStoreId = sbInfo.getSandboxId();
        this.assetService.createFolderWebApp(sbStoreId, webApp, "/", "a");
        this.assetService.createFolderWebApp(sbStoreId, webApp, "/a", "b");
        this.assetService.createFolderWebApp(sbStoreId, webApp, "/a/b", "c");
        this.assetService.createFileWebApp(sbStoreId, webApp, "/a/b/c", "foo");
        this.assetService.createFileWebApp(sbStoreId, webApp, "/a/b/c", "bar");
        List<AssetInfo> changedAssets = this.sbService.listChangedWebApp(sbStoreId, webApp, false);
        SandboxServiceImplTest.assertEquals((int)1, (int)changedAssets.size());
        SandboxServiceImplTest.assertEquals((String)(sbInfo.getSandboxRootPath() + "/" + webApp + "/a"), (String)changedAssets.get(0).getPath());
        final ActionImpl action = new ActionImpl(null, GUID.generate(), WCMSandboxSubmitAction.NAME);
        action.setParameterValue("sandbox-id", (Serializable)((Object)sbStoreId));
        action.setParameterValue("path-list", null);
        final WCMSandboxSubmitAction submit = (WCMSandboxSubmitAction)ctx.getBean(WCMSandboxSubmitAction.NAME);
        TransactionService transactionService = (TransactionService)ctx.getBean("transactionService");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TxnWork
        implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
            TxnWork() {
            }

            @Override
            public Object execute() throws Exception {
                submit.execute(action, null);
                return null;
            }
        }
        transactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
        this.pollForSnapshotCount(stagingSandboxId, 1);
        this.assetService.createFile(sbStoreId, "www", "figs", null);
        AssetInfo fileAsset = this.assetService.getAssetWebApp(sbStoreId, webApp, "/a/b/c/foo");
        this.assetService.getContentWriter(fileAsset).getContentOutputStream().close();
        fileAsset = this.assetService.getAssetWebApp(sbStoreId, webApp, "/a/b/c/bar");
        this.assetService.deleteAsset(fileAsset);
        changedAssets = this.sbService.listChanged(sbStoreId, "www", true);
        SandboxServiceImplTest.assertEquals((int)3, (int)changedAssets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.get(0).getDiffCode());
        SandboxServiceImplTest.assertEquals((String)(sbInfo.getSandboxRootPath() + "/" + webApp + "/a/b/c/bar"), (String)changedAssets.get(0).getPath());
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.get(1).getDiffCode());
        SandboxServiceImplTest.assertEquals((String)(sbInfo.getSandboxRootPath() + "/" + webApp + "/a/b/c/foo"), (String)changedAssets.get(1).getPath());
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.get(2).getDiffCode());
        SandboxServiceImplTest.assertEquals((String)"/www/figs", (String)changedAssets.get(2).getPath());
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(changedAssets.get(0).getPath());
        paths.add(changedAssets.get(1).getPath());
        paths.add(changedAssets.get(2).getPath());
        action.setParameterValue("path-list", paths);
        action.setParameterValue("sandbox-id", (Serializable)((Object)sbStoreId));
        transactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
        this.pollForSnapshotCount(stagingSandboxId, 2);
        changedAssets = this.sbService.listChanged(sbStoreId, "www", true);
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.size());
    }

    public void testUndoAction() throws Exception {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-revertListAction", TEST_WEBPROJ_NAME + " revertListAction", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        String webApp = wpInfo.getDefaultWebApp();
        String stagingSandboxId = wpInfo.getStagingStoreName();
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String sbStoreId = sbInfo.getSandboxId();
        this.assetService.createFolderWebApp(sbStoreId, webApp, "/", "a");
        this.assetService.createFolderWebApp(sbStoreId, webApp, "/a", "b");
        this.assetService.createFolderWebApp(sbStoreId, webApp, "/a/b", "c");
        List<AssetInfo> changedAssets = this.sbService.listChanged(sbStoreId, "www", true);
        SandboxServiceImplTest.assertEquals((int)1, (int)changedAssets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.get(0).getDiffCode());
        SandboxServiceImplTest.assertEquals((String)(sbInfo.getSandboxRootPath() + "/" + webApp + "/a"), (String)changedAssets.get(0).getPath());
        this.sbService.submitWebApp(sbStoreId, webApp, "submitLabel", "submitDescription");
        this.pollForSnapshotCount(stagingSandboxId, 1);
        this.assetService.createFileWebApp(sbStoreId, webApp, "/a/b/c", "foo");
        changedAssets = this.sbService.listChanged(sbStoreId, "www", true);
        SandboxServiceImplTest.assertEquals((int)1, (int)changedAssets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.get(0).getDiffCode());
        SandboxServiceImplTest.assertEquals((String)(sbInfo.getSandboxRootPath() + "/" + webApp + "/a/b/c/foo"), (String)changedAssets.get(0).getPath());
        this.sbService.submitWebApp(sbStoreId, webApp, "submitLabel", "submitDescription");
        this.pollForSnapshotCount(stagingSandboxId, 2);
        this.assetService.createFileWebApp(sbStoreId, webApp, "/a/b/c", "bar");
        SandboxServiceImplTest.assertNotNull((Object)this.assetService.getAssetWebApp(sbStoreId, webApp, "/a/b/c/bar"));
        changedAssets = this.sbService.listChanged(sbStoreId, "www", true);
        SandboxServiceImplTest.assertEquals((int)1, (int)changedAssets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.get(0).getDiffCode());
        SandboxServiceImplTest.assertEquals((String)(sbInfo.getSandboxRootPath() + "/" + webApp + "/a/b/c/bar"), (String)changedAssets.get(0).getPath());
        List<SandboxVersion> snapshotVersions = this.sbService.listSnapshots(sbStoreId, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)snapshotVersions.size());
        final ActionImpl action = new ActionImpl(null, GUID.generate(), "wcm-undo");
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(sbInfo.getSandboxRootPath() + "/" + webApp + "/a/b/c/bar");
        action.setParameterValue("path-list", paths);
        action.setParameterValue("sandbox-id", (Serializable)((Object)sbStoreId));
        final WCMSandboxUndoAction revertList = (WCMSandboxUndoAction)ctx.getBean("wcm-undo");
        TransactionService transactionService = (TransactionService)ctx.getBean("transactionService");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TxnWork
        implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
            TxnWork() {
            }

            @Override
            public Object execute() throws Exception {
                revertList.execute(action, null);
                return null;
            }
        }
        transactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
        this.pollForSnapshotCount(stagingSandboxId, 2);
        snapshotVersions = this.sbService.listSnapshots(sbStoreId, false);
        SandboxServiceImplTest.assertEquals((int)2, (int)snapshotVersions.size());
        changedAssets = this.sbService.listChanged(sbStoreId, "www", true);
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.size());
        SandboxServiceImplTest.assertNotNull((Object)this.assetService.getAssetWebApp(sbStoreId, webApp, "/a/b/c/foo"));
        SandboxServiceImplTest.assertNull((Object)this.assetService.getAssetWebApp(sbStoreId, webApp, "/a/b/c/bar"));
    }

    public void testRevertSnapshotAction() throws Exception {
        WebProjectInfo wpInfo = this.wpService.createWebProject(TEST_SANDBOX + "-revertSnapshotAction", TEST_WEBPROJ_NAME + " revertSnapshotAction", "This is my title", "This is my description");
        String wpStoreId = wpInfo.getStoreId();
        String webApp = wpInfo.getDefaultWebApp();
        final String stagingStoreId = wpInfo.getStagingStoreName();
        SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpStoreId);
        String sbStoreId = sbInfo.getSandboxId();
        this.assetService.createFolderWebApp(sbStoreId, webApp, "/", "a");
        this.assetService.createFolderWebApp(sbStoreId, webApp, "/a", "b");
        this.assetService.createFolderWebApp(sbStoreId, webApp, "/a/b", "c");
        List<AssetInfo> changedAssets = this.sbService.listChanged(sbStoreId, "www", true);
        SandboxServiceImplTest.assertEquals((int)1, (int)changedAssets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.get(0).getDiffCode());
        SandboxServiceImplTest.assertEquals((String)(sbInfo.getSandboxRootPath() + "/" + webApp + "/a"), (String)changedAssets.get(0).getPath());
        this.sbService.submitWebApp(sbStoreId, webApp, "submitLabel", "submitDescription");
        this.pollForSnapshotCount(stagingStoreId, 1);
        this.assetService.createFileWebApp(sbStoreId, webApp, "/a/b/c", "foo");
        changedAssets = this.sbService.listChanged(sbStoreId, "www", true);
        SandboxServiceImplTest.assertEquals((int)1, (int)changedAssets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.get(0).getDiffCode());
        SandboxServiceImplTest.assertEquals((String)(sbInfo.getSandboxRootPath() + "/" + webApp + "/a/b/c/foo"), (String)changedAssets.get(0).getPath());
        this.sbService.submitWebApp(sbStoreId, webApp, "submitLabel", "submitDescription");
        this.pollForSnapshotCount(stagingStoreId, 2);
        this.assetService.createFileWebApp(sbStoreId, webApp, "/a/b/c", "bar");
        changedAssets = this.sbService.listChanged(sbStoreId, "www", true);
        SandboxServiceImplTest.assertEquals((int)1, (int)changedAssets.size());
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.get(0).getDiffCode());
        SandboxServiceImplTest.assertEquals((String)(sbInfo.getSandboxRootPath() + "/" + webApp + "/a/b/c/bar"), (String)changedAssets.get(0).getPath());
        this.sbService.submitWebApp(sbStoreId, webApp, "submitLabel", "submitDescription");
        this.pollForSnapshotCount(stagingStoreId, 3);
        List<SandboxVersion> snapshotVersions = this.sbService.listSnapshots(stagingStoreId, false);
        SandboxServiceImplTest.assertEquals((int)3, (int)snapshotVersions.size());
        SandboxServiceImplTest.assertNotNull((Object)this.assetService.getAssetWebApp(sbStoreId, webApp, "/a/b/c/foo"));
        SandboxServiceImplTest.assertNotNull((Object)this.assetService.getAssetWebApp(sbStoreId, webApp, "/a/b/c/bar"));
        final ActionImpl action = new ActionImpl(null, GUID.generate(), "wcm-revert-snapshot");
        action.setParameterValue("version", Integer.valueOf(snapshotVersions.get(2).getVersion()));
        final WCMSandboxRevertSnapshotAction revertSnapshot = (WCMSandboxRevertSnapshotAction)ctx.getBean("wcm-revert-snapshot");
        TransactionService transactionService = (TransactionService)ctx.getBean("transactionService");
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TxnWork
        implements RetryingTransactionHelper.RetryingTransactionCallback<Object> {
            TxnWork() {
            }

            @Override
            public Object execute() throws Exception {
                revertSnapshot.execute(action, AVMNodeConverter.ToNodeRef(-1, stagingStoreId + ":/"));
                return null;
            }
        }
        transactionService.getRetryingTransactionHelper().doInTransaction(new TxnWork());
        this.pollForSnapshotCount(stagingStoreId, 4);
        snapshotVersions = this.sbService.listSnapshots(stagingStoreId, false);
        SandboxServiceImplTest.assertEquals((int)4, (int)snapshotVersions.size());
        changedAssets = this.sbService.listChanged(sbStoreId, "www", true);
        SandboxServiceImplTest.assertEquals((int)0, (int)changedAssets.size());
        SandboxServiceImplTest.assertNull((Object)this.assetService.getAssetWebApp(sbStoreId, webApp, "/a/b/c/foo"));
        SandboxServiceImplTest.assertNull((Object)this.assetService.getAssetWebApp(sbStoreId, webApp, "/a/b/c/bar"));
    }

    public void testPseudoScaleTest() {
        WebProjectInfo wpInfo;
        int i;
        long start;
        long split = start = System.currentTimeMillis();
        for (i = 1; i <= 5; ++i) {
            this.createUser(TEST_USER + "-" + i);
        }
        System.out.println("testPseudoScaleTest: created 5 users in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 2; ++i) {
            this.wpService.createWebProject(TEST_SANDBOX + "-" + i, TEST_WEBPROJ_NAME + "-" + i, "This is my title", "This is my description");
        }
        System.out.println("testPseudoScaleTest: created 2 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 2; ++i) {
            wpInfo = this.wpService.getWebProject(TEST_SANDBOX + "-" + i);
            HashMap<String, String> userRoles = new HashMap<String, String>(5);
            for (int j = 1; j <= 5; ++j) {
                userRoles.put(TEST_USER + "-" + j, "ContentManager");
            }
            this.wpService.inviteWebUsersGroups(wpInfo.getNodeRef(), userRoles, true);
        }
        System.out.println("testPseudoScaleTest: invited 5 content managers (and created user sandboxes) to each of 2 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 2; ++i) {
            wpInfo = this.wpService.getWebProject(TEST_SANDBOX + "-" + i);
            SandboxServiceImplTest.assertEquals((int)7, (int)this.sbService.listSandboxes(wpInfo.getStoreId()).size());
        }
        System.out.println("testPseudoScaleTest: list sandboxes for admin for each of 2 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 2; ++i) {
            wpInfo = this.wpService.getWebProject(TEST_SANDBOX + "-" + i);
            SandboxServiceImplTest.assertEquals((int)6, (int)this.wpService.listWebUsers(wpInfo.getStoreId()).size());
        }
        System.out.println("testPseudoScaleTest: list web users for admin for each of 2 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 2; ++i) {
            wpInfo = this.wpService.getWebProject(TEST_SANDBOX + "-" + i);
            for (int j = 1; j <= 5; ++j) {
                AuthenticationUtil.setFullyAuthenticatedUser((String)(TEST_USER + "-" + j));
                SandboxServiceImplTest.assertEquals((int)7, (int)this.sbService.listSandboxes(wpInfo.getStoreId()).size());
            }
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        }
        System.out.println("testPseudoScaleTest: list sandboxes for 5 content managers for each of 2 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 2; ++i) {
            wpInfo = this.wpService.getWebProject(TEST_SANDBOX + "-" + i);
            for (int j = 1; j <= 5; ++j) {
                AuthenticationUtil.setFullyAuthenticatedUser((String)(TEST_USER + "-" + j));
                SandboxServiceImplTest.assertEquals((int)6, (int)this.wpService.listWebUsers(wpInfo.getStoreId()).size());
            }
            AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        }
        System.out.println("testPseudoScaleTest: list web users for 5 content managers for each of 2 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 2; ++i) {
            wpInfo = this.wpService.getWebProject(TEST_SANDBOX + "-" + i);
            for (int j = 1; j <= 5; ++j) {
                SandboxInfo sbInfo = this.sbService.getAuthorSandbox(wpInfo.getStoreId(), TEST_USER + "-" + j);
                this.sbService.deleteSandbox(sbInfo.getSandboxId());
            }
        }
        System.out.println("testPseudoScaleTest: deleted 5 author sandboxes for each of 2 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 2; ++i) {
            wpInfo = this.wpService.getWebProject(TEST_SANDBOX + "-" + i);
            this.wpService.deleteWebProject(wpInfo.getNodeRef());
        }
        System.out.println("testPseudoScaleTest: deleted 2 web projects in " + (System.currentTimeMillis() - split) + " msecs");
        split = System.currentTimeMillis();
        for (i = 1; i <= 5; ++i) {
            this.deleteUser(TEST_USER + "-" + i);
        }
        System.out.println("testPseudoScaleTest: deleted 5 users in " + (System.currentTimeMillis() - split) + " msecs");
    }

    protected void recursiveList(String store) {
        String list = this.recursiveList(store, -1, true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(store + ":"));
            logger.debug((Object)list);
        }
    }

    protected String recursiveList(String repoName, int version, boolean followLinks) {
        return this.recursiveList(repoName + ":/", version, 0, followLinks);
    }

    protected String recursiveList(String path, int version, int indent, boolean followLinks) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            builder.append(' ');
        }
        builder.append(path.substring(path.lastIndexOf(47) + 1));
        builder.append(' ');
        AVMNodeDescriptor desc = this.avmService.lookup(version, path, true);
        builder.append(desc.toString());
        builder.append('\n');
        if (desc.getType() == 2 || desc.getType() == 3 && followLinks) {
            String basename = path.endsWith("/") ? path : path + "/";
            SortedMap<String, AVMNodeDescriptor> listing = this.avmService.getDirectoryListing(version, path);
            for (String name : listing.keySet()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)name);
                }
                builder.append(this.recursiveList(basename + name, version, indent + 2, followLinks));
            }
        }
        return builder.toString();
    }
}

