/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.sandbox.script;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.asset.AssetService;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.sandbox.script.Asset;
import org.alfresco.wcm.webproject.script.WebProject;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class Sandbox
implements Serializable {
    private static final long serialVersionUID = -9176488061624800911L;
    private SandboxInfo si;
    private WebProject webproject;

    public Sandbox(WebProject webproject, SandboxInfo si) {
        this.webproject = webproject;
        this.si = si;
    }

    public void setName(String name) {
    }

    public String getName() {
        return this.si.getName();
    }

    public void setSandboxRef(String sandboxRef) {
    }

    public void submitAll(String submitLabel, String submitComment) {
        this.getSandboxService().submitAll(this.getSandboxRef(), submitLabel, submitComment);
    }

    public void revertAssets(Asset[] files) {
        ArrayList<String> items = new ArrayList<String>(files.length);
        for (int i = 0; i < files.length; ++i) {
            items.add(i, files[i].getPath());
        }
        this.getSandboxService().revertList(this.getSandboxRef(), items);
    }

    public void revert(String[] files) {
        ArrayList<String> items = new ArrayList<String>(files.length);
        for (int i = 0; i < files.length; ++i) {
            items.add(i, files[i]);
        }
        this.getSandboxService().revertList(this.getSandboxRef(), items);
    }

    public void submitAssets(Asset[] files, String submitLabel, String submitComment) {
        ArrayList<String> items = new ArrayList<String>(files.length);
        for (int i = 0; i < files.length; ++i) {
            items.add(i, files[i].getPath());
        }
        this.getSandboxService().submitList(this.getSandboxRef(), items, submitLabel, submitComment);
    }

    public void submit(String[] files, String submitLabel, String submitComment) {
        ArrayList<String> items = new ArrayList<String>(files.length);
        for (int i = 0; i < files.length; ++i) {
            items.add(i, files[i]);
        }
        this.getSandboxService().submitList(this.getSandboxRef(), items, submitLabel, submitComment);
    }

    public void submitAllWebApp(String webApp, String submitLabel, String submitComment) {
        this.getSandboxService().submitWebApp(this.getSandboxRef(), webApp, submitLabel, submitComment);
    }

    public void revertAll() {
        this.getSandboxService().revertAll(this.getSandboxRef());
    }

    public void revertAllWebApp(String webApp) {
        this.getSandboxService().revertWebApp(this.getSandboxRef(), webApp);
    }

    public String getSandboxRef() {
        return this.si.getSandboxId();
    }

    public String getCreator() {
        return this.si.getCreator();
    }

    public Date getCreatedDate() {
        return this.si.getCreatedDate();
    }

    public String getCreatedDateAsISO8601() {
        return ISO8601DateFormat.format((Date)this.si.getCreatedDate());
    }

    public void deleteSandbox() {
        this.getSandboxService().deleteSandbox(this.getSandboxRef());
    }

    public void save() {
    }

    public String[] getStoreNames() {
        return this.si.getStoreNames();
    }

    public boolean isAuthorSandbox() {
        return this.si.getSandboxType().equals((Object)SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN);
    }

    public boolean isStagingSandbox() {
        return this.si.getSandboxType().equals((Object)SandboxConstants.PROP_SANDBOX_STAGING_MAIN);
    }

    public Asset[] getModifiedAssets() {
        List<AssetInfo> items = this.getSandboxService().listChangedAll(this.getSandboxRef(), true);
        Asset[] ret = new Asset[items.size()];
        int i = 0;
        for (AssetInfo item : items) {
            ret[i++] = new Asset(this, item);
        }
        return ret;
    }

    public Asset getAsset(String path) {
        AssetService as = this.getAssetService();
        AssetInfo item = as.getAsset(this.getSandboxRef(), path);
        if (item != null) {
            Asset newAsset = new Asset(this, item);
            return newAsset;
        }
        return null;
    }

    public Asset getAssetWebApp(String webApp, String path) {
        AssetService as = this.getAssetService();
        AssetInfo item = as.getAssetWebApp(this.getSandboxRef(), webApp, path);
        if (item != null) {
            Asset newAsset = new Asset(this, item);
            return newAsset;
        }
        return null;
    }

    public Asset[] getModifiedAssetsWebApp(String webApp) {
        List<AssetInfo> items = this.getSandboxService().listChangedWebApp(this.getSandboxRef(), webApp, true);
        Asset[] ret = new Asset[items.size()];
        int i = 0;
        for (AssetInfo item : items) {
            ret[i++] = new Asset(this, item);
        }
        return ret;
    }

    public WebProject getWebproject() {
        return this.webproject;
    }

    private SandboxService getSandboxService() {
        return this.webproject.getWebProjects().getSandboxService();
    }

    private AssetService getAssetService() {
        return this.webproject.getWebProjects().getAssetService();
    }
}

