/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.impl.server;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.deployment.DeploymentTarget;
import org.alfresco.deployment.impl.server.DeploymentState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentTracker {
    private DeploymentTarget target;
    private Date lastActivity;
    private Date startDeployment;
    private Date endDeployment;
    private DeploymentState fState;
    private Set<String> tokens = Collections.synchronizedSet(new HashSet());

    public DeploymentTracker(DeploymentTarget target) {
        this.lastActivity = new Date();
        this.startDeployment = new Date();
        this.target = target;
    }

    DeploymentTarget getTarget() {
        return this.target;
    }

    public void addToken(String token) {
        this.lastActivity = new Date();
        this.tokens.add(token);
    }

    public void removeToken(String token) {
        this.lastActivity = new Date();
        this.tokens.remove(token);
    }

    public Set<String> getTokens() {
        return this.tokens;
    }

    public void updateLastAccess() {
        this.lastActivity = new Date();
    }
}

