/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.web.config.forms.ConstraintHandlerDefinition;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.element.ConfigElementAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintHandlersConfigElement
extends ConfigElementAdapter {
    private static final long serialVersionUID = 2266042608444782740L;
    public static final String CONFIG_ELEMENT_ID = "constraint-handlers";
    private Map<String, ConstraintHandlerDefinition> items = new LinkedHashMap<String, ConstraintHandlerDefinition>();

    public ConstraintHandlersConfigElement() {
        super(CONFIG_ELEMENT_ID);
    }

    public ConstraintHandlersConfigElement(String name) {
        super(name);
    }

    public List<ConfigElement> getChildren() {
        throw new ConfigException("Reading the constraint-handlers config via the generic interfaces is not supported");
    }

    public ConfigElement combine(ConfigElement configElement) {
        String nextEvent;
        String nextMessageId;
        String nextMessage;
        String nextValidationHandler;
        if (configElement == null) {
            return this;
        }
        ConstraintHandlersConfigElement otherCHCElement = (ConstraintHandlersConfigElement)configElement;
        ConstraintHandlersConfigElement result = new ConstraintHandlersConfigElement();
        for (String nextType : this.items.keySet()) {
            nextValidationHandler = this.getValidationHandlerFor(nextType);
            nextMessage = this.getMessageFor(nextType);
            nextMessageId = this.getMessageIdFor(nextType);
            nextEvent = this.getEventFor(nextType);
            result.addDataMapping(nextType, nextValidationHandler, nextMessage, nextMessageId, nextEvent);
        }
        for (String nextType : otherCHCElement.items.keySet()) {
            nextValidationHandler = otherCHCElement.getValidationHandlerFor(nextType);
            nextMessage = otherCHCElement.getMessageFor(nextType);
            nextMessageId = otherCHCElement.getMessageIdFor(nextType);
            nextEvent = otherCHCElement.getEventFor(nextType);
            result.addDataMapping(nextType, nextValidationHandler, nextMessage, nextMessageId, nextEvent);
        }
        return result;
    }

    void addDataMapping(String type, String validationHandler, String message, String messageID, String event) {
        this.items.put(type, new ConstraintHandlerDefinition(type, validationHandler, message, messageID, event));
    }

    String[] getConstraintTypes() {
        return this.getConstraintTypesAsList().toArray(new String[0]);
    }

    List<String> getConstraintTypesAsList() {
        Set<String> result = this.items.keySet();
        ArrayList<String> listResult = new ArrayList<String>(result);
        return Collections.unmodifiableList(listResult);
    }

    String getValidationHandlerFor(String type) {
        return this.items.get(type).getValidationHandler();
    }

    String getMessageFor(String type) {
        return this.items.get(type).getMessage();
    }

    String getMessageIdFor(String type) {
        return this.items.get(type).getMessageId();
    }

    String getEventFor(String type) {
        return this.items.get(type).getEvent();
    }

    public String[] getItemNames() {
        return this.getItemNamesAsList().toArray(new String[0]);
    }

    public List<String> getItemNamesAsList() {
        return this.getConstraintTypesAsList();
    }

    public Map<String, ConstraintHandlerDefinition> getItems() {
        return Collections.unmodifiableMap(this.items);
    }
}

