/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.web.config.forms.ServiceBasedEvaluator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.surf.exception.ConnectorServiceException;

public class TaskTypeEvaluator
extends ServiceBasedEvaluator {
    protected static final String JSON_DATA = "data";
    protected static final String JSON_DEFINITION = "definition";
    protected static final String JSON_TYPE = "type";
    protected static final String JSON_NAME = "name";
    protected static final Pattern taskIdPattern = Pattern.compile(".+\\$[0-9]+");
    private static Log logger = LogFactory.getLog(TaskTypeEvaluator.class);

    protected Log getLogger() {
        return logger;
    }

    public boolean applies(Object obj, String condition) {
        boolean result;
        block11: {
            String taskId;
            Matcher m;
            result = false;
            if (obj instanceof String && (m = taskIdPattern.matcher(taskId = (String)obj)).matches()) {
                try {
                    String type = null;
                    String jsonResponseString = this.callService("/api/task-instances/" + taskId);
                    if (jsonResponseString != null) {
                        JSONObject typeObj;
                        JSONObject defObj;
                        JSONObject dataObj;
                        JSONObject json = new JSONObject(new JSONTokener(jsonResponseString));
                        if (json.has(JSON_DATA) && (dataObj = json.getJSONObject(JSON_DATA)).has(JSON_DEFINITION) && (defObj = dataObj.getJSONObject(JSON_DEFINITION)).has(JSON_TYPE) && (typeObj = defObj.getJSONObject(JSON_TYPE)).has(JSON_NAME)) {
                            type = dataObj.getString(JSON_NAME);
                            result = condition.equals(type);
                        }
                        if (type == null && this.getLogger().isWarnEnabled()) {
                            this.getLogger().warn((Object)("Failed to find task type for '" + taskId + "' in JSON response from task instances service"));
                        }
                    } else if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn((Object)("Task instances service response appears to be null for '" + taskId + "'"));
                    }
                }
                catch (ServiceBasedEvaluator.NotAuthenticatedException ne) {
                }
                catch (ConnectorServiceException e) {
                    if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn((Object)"Failed to connect to task instances service.", (Throwable)e);
                    }
                }
                catch (JSONException je) {
                    if (!this.getLogger().isWarnEnabled()) break block11;
                    this.getLogger().warn((Object)("Failed to find task type for '" + taskId + "' in JSON response from task instances service."), (Throwable)je);
                }
            }
        }
        return result;
    }
}

