/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import com.simontuffs.onejar.IProperties;
import com.simontuffs.onejar.JarClassLoader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class Boot {
    public static final String BOOT_CLASS = "Boot-Class";
    public static final String ONE_JAR_MAIN_CLASS = "One-Jar-Main-Class";
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    public static final String MAIN_JAR = "main/main.jar";
    public static final String WRAP_CLASS_LOADER = "Wrap-Class-Loader";
    public static final String WRAP_DIR = "wrap";
    public static final String WRAP_JAR = "/wrap/wraploader.jar";
    public static final String PROPERTY_PREFIX = "one-jar.";
    public static final String P_MAIN_CLASS = "one-jar.main-class";
    public static final String P_RECORD = "one-jar.record";
    public static final String P_JARNAMES = "one-jar.jar-names";
    public static final String P_VERBOSE = "one-jar.verbose";
    public static final String P_INFO = "one-jar.info";
    public static final String HELP = "--one-jar-help";
    public static final String VERSION = "--one-jar-version";
    public static final String[] HELP_PROPERTIES = new String[]{"one-jar.main-class", "Specifies the name of the class which should be executed (via public static void main(String[])", "one-jar.record", "true:  Enables recording of the classes loaded by the application", "one-jar.jar-names", "true:  Recorded classes are kept in directories corresponding to their jar names.\nfalse: Recorded classes are flattened into a single directory.  Duplicates are ignored (first wins)", "one-jar.verbose", "true:  Print verbose classloading information", "one-jar.info", "true:  Print informative classloading information"};
    public static final String[] HELP_ARGUMENTS = new String[]{"--one-jar-help", "Shows this message, then exits.", "--one-jar-version", "Shows the version of One-JAR, then exits."};
    protected static boolean info;
    protected static boolean verbose;
    protected static String myJarPath;
    private static JarClassLoader loader;
    static /* synthetic */ Class class$com$simontuffs$onejar$Boot;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static synchronized JarClassLoader getClassLoader() {
        return loader;
    }

    public static synchronized void setClassLoader(JarClassLoader $loader) {
        if (loader != null) {
            throw new RuntimeException("Attempt to set a second Boot loader");
        }
        loader = $loader;
        Boot.setProperties(loader);
    }

    protected static void VERBOSE(String message) {
        if (verbose) {
            System.out.println("Boot: " + message);
        }
    }

    protected static void WARNING(String message) {
        System.err.println("Boot: Warning: " + message);
    }

    protected static void INFO(String message) {
        if (info) {
            System.out.println("Boot: Info: " + message);
        }
    }

    public static void main(String[] args) throws Exception {
        Boot.run(args);
    }

    public static void run(String[] args) throws Exception {
        URL url;
        String jar;
        JarFile jarFile;
        Manifest manifest;
        Attributes attributes;
        Boot.processArgs(args);
        String mainClass = null;
        Properties properties = new Properties();
        String props = "/one-jar.properties";
        InputStream is = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getResourceAsStream(props);
        if (is != null) {
            Boot.INFO("loading properties from " + props);
            properties.load(is);
        }
        if ((is = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getResourceAsStream(props = "file:one-jar.properties")) != null) {
            Boot.INFO("loading properties from " + props);
            properties.load(is);
        }
        Enumeration<?> _enum = properties.propertyNames();
        while (_enum.hasMoreElements()) {
            String name = (String)_enum.nextElement();
            if (System.getProperty(name) != null) continue;
            System.setProperty(name, properties.getProperty(name));
        }
        mainClass = System.getProperty(P_MAIN_CLASS);
        if (mainClass == null && (mainClass = (attributes = (manifest = (jarFile = new JarFile(jar = Boot.getMyJarPath())).getManifest()).getMainAttributes()).getValue(ONE_JAR_MAIN_CLASS)) == null && (mainClass = attributes.getValue(BOOT_CLASS)) != null) {
            Boot.WARNING("The manifest attribute Boot-Class is deprecated in favor of the attribute One-Jar-Main-Class");
        }
        if (mainClass == null) {
            InputStream is2 = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getResourceAsStream("/main/main.jar");
            if (is2 != null) {
                JarInputStream jis = new JarInputStream(is2);
                manifest = jis.getManifest();
                jis.close();
                attributes = manifest.getMainAttributes();
                mainClass = attributes.getValue(Attributes.Name.MAIN_CLASS);
            } else {
                Boot.WARNING("Unable to locate main/main.jar in the JAR file " + Boot.getMyJarPath());
            }
        }
        if ((url = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getResource(WRAP_JAR)) != null) {
            JarClassLoader bootLoader = (JarClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new JarClassLoader(Boot.WRAP_DIR);
                }
            });
            Boot.setProperties(bootLoader);
            bootLoader.load(null);
            is = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getResourceAsStream(WRAP_JAR);
            if (is != null) {
                JarInputStream jis = new JarInputStream(is);
                String wrapLoader = jis.getManifest().getMainAttributes().getValue(WRAP_CLASS_LOADER);
                jis.close();
                if (wrapLoader == null) {
                    Boot.WARNING(url + " did not contain a " + WRAP_CLASS_LOADER + " attribute, unable to load wrapping classloader");
                } else {
                    Boot.INFO("using " + wrapLoader);
                    Class<?> jarLoaderClass = bootLoader.loadClass(wrapLoader);
                    Constructor<?> ctor = jarLoaderClass.getConstructor(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Boot.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader);
                    Boot.setClassLoader((JarClassLoader)ctor.newInstance(bootLoader));
                }
            }
        } else {
            Boot.INFO("using JarClassLoader");
            Boot.setClassLoader((JarClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new JarClassLoader((class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getClassLoader());
                }
            }));
        }
        Boot.setProperties(loader);
        mainClass = loader.load(mainClass);
        if (mainClass == null && !loader.isExpanding()) {
            throw new Exception(Boot.getMyJarName() + " main class was not found (fix: add main/main.jar with a Main-Class manifest attribute, or specify -D" + P_MAIN_CLASS + "=<your.class.name>), or use " + ONE_JAR_MAIN_CLASS + " in the manifest");
        }
        if (mainClass != null) {
            String bootClass = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getName();
            if (bootClass.equals(mainClass)) {
                throw new Exception(Boot.getMyJarName() + " main class (" + mainClass + ") would cause infinite recursion: check main.jar/META-INF/MANIFEST.MF/Main-Class attribute: " + mainClass);
            }
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> cls = loader.loadClass(mainClass);
            Method main = cls.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Boot.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            main.invoke(null, new Object[]{args});
        }
    }

    public static void setProperties(IProperties jarloader) {
        Boot.INFO("setProperties(" + jarloader + ")");
        if (Boot.getProperty(P_RECORD)) {
            jarloader.setRecord(true);
            jarloader.setRecording(System.getProperty(P_RECORD));
        }
        if (Boot.getProperty(P_JARNAMES)) {
            jarloader.setRecord(true);
            jarloader.setFlatten(false);
        }
        if (Boot.getProperty(P_VERBOSE)) {
            jarloader.setVerbose(true);
            jarloader.setInfo(true);
        }
        if (Boot.getProperty(P_INFO)) {
            jarloader.setInfo(true);
        }
    }

    public static boolean getProperty(String key) {
        return Boolean.valueOf(System.getProperty(key, "false"));
    }

    public static String getMyJarName() {
        String name = Boot.getMyJarPath();
        int last = name.lastIndexOf("/");
        if (last >= 0) {
            name = name.substring(last + 1);
        }
        return name;
    }

    public static String getMyJarPath() {
        if (myJarPath != null) {
            return myJarPath;
        }
        myJarPath = System.getProperty("one-jar.jarname");
        if (myJarPath == null) {
            try {
                String jarname = System.getProperty("java.class.path");
                String[] jars = jarname.split(System.getProperty("path.separator"));
                for (int i = 0; i < jars.length; ++i) {
                    jarname = jars[i];
                    InputStream is = null;
                    try {
                        is = new URL(jarname).openStream();
                    }
                    catch (MalformedURLException mux) {
                        try {
                            is = new FileInputStream(jarname);
                        }
                        catch (IOException iox) {
                            continue;
                        }
                    }
                    JarEntry entry = Boot.findJarEntry(new JarInputStream(is), (class$com$simontuffs$onejar$Boot == null ? Boot.class$("com.simontuffs.onejar.Boot") : class$com$simontuffs$onejar$Boot).getName().replace('.', '/') + ".class");
                    if (entry == null) continue;
                    myJarPath = jarname;
                    break;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                Boot.WARNING("jar=" + myJarPath + " loaded from " + "java.class.path" + " (" + System.getProperty("java.class.path") + ")");
            }
        }
        myJarPath = myJarPath.replace('\\', '/');
        return myJarPath;
    }

    public static JarEntry findJarEntry(JarInputStream jis, String name) throws IOException {
        JarEntry entry;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public static int firstWidth(String[] table) {
        int width = 0;
        for (int i = 0; i < table.length; i += 2) {
            if (table[i].length() <= width) continue;
            width = table[i].length();
        }
        return width;
    }

    public static String pad(String indent, String string, int width) {
        StringBuffer buf = new StringBuffer();
        buf.append(indent);
        buf.append(string);
        for (int i = 0; i < width - string.length(); ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String wrap(String indent, String string, int width) {
        String padding = Boot.pad(indent, "", width);
        string = string.replaceAll("\n", "\n" + padding);
        return string;
    }

    public static void processArgs(String[] args) throws Exception {
        HashSet<String> arguments = new HashSet<String>(Arrays.asList(args));
        if (arguments.contains(HELP)) {
            int i;
            int width = Boot.firstWidth(HELP_ARGUMENTS);
            System.out.println("One-Jar uses the following command-line arguments");
            for (i = 0; i < HELP_ARGUMENTS.length; ++i) {
                System.out.print(Boot.pad("    ", HELP_ARGUMENTS[i++], width + 1));
                System.out.println(Boot.wrap("    ", HELP_ARGUMENTS[i], width + 1));
            }
            System.out.println();
            width = Boot.firstWidth(HELP_PROPERTIES);
            System.out.println("One-Jar uses the following VM properties (-D<property>=<true|false|string>)");
            for (i = 0; i < HELP_PROPERTIES.length; ++i) {
                System.out.print(Boot.pad("    ", HELP_PROPERTIES[i++], width + 1));
                System.out.println(Boot.wrap("    ", HELP_PROPERTIES[i], width + 1));
            }
            System.out.println();
            System.exit(0);
        } else if (arguments.contains(VERSION)) {
            InputStream is = (class$com$simontuffs$onejar$Boot == null ? (class$com$simontuffs$onejar$Boot = Boot.class$("com.simontuffs.onejar.Boot")) : class$com$simontuffs$onejar$Boot).getResourceAsStream("/.version");
            if (is != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String version = br.readLine();
                br.close();
                System.out.println("One-JAR version " + version);
            } else {
                System.out.println("Unable to determine One-JAR version (missing /.version resource in One-JAR archive)");
            }
            System.exit(0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        loader = null;
    }
}

