/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import com.simontuffs.onejar.Boot;
import com.simontuffs.onejar.Handler;
import com.simontuffs.onejar.IProperties;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JarClassLoader
extends ClassLoader
implements IProperties {
    public static final String JAVA_CLASS_PATH = "java.class.path";
    public static final String LIB_PREFIX = "lib/";
    public static final String BINLIB_PREFIX = "binlib/";
    public static final String MAIN_PREFIX = "main/";
    public static final String RECORDING = "recording";
    public static final String TMP = "tmp";
    public static final String UNPACK = "unpack";
    public static final String EXPAND = "One-Jar-Expand";
    public static final String SHOW_EXPAND = "One-Jar-Show-Expand";
    public static final String CONFIRM_EXPAND = "One-Jar-Confirm-Expand";
    public static final String CLASS = ".class";
    public static final String JAVA_PROTOCOL_HANDLER = "java.protocol.handler.pkgs";
    protected String name;
    protected boolean expanded;
    protected Map byteCode = Collections.synchronizedMap(new HashMap());
    protected Map pdCache = Collections.synchronizedMap(new HashMap());
    protected Map binLibPath = Collections.synchronizedMap(new HashMap());
    protected Set jarNames = Collections.synchronizedSet(new HashSet());
    protected boolean record = false;
    protected boolean flatten = false;
    protected boolean unpackFindResource = false;
    protected boolean verbose = false;
    protected boolean info = false;
    protected String recording = "recording";
    protected String jarName;
    protected String mainJar;
    protected String wrapDir;
    protected boolean delegateToParent;
    protected boolean classPool = false;
    static /* synthetic */ Class class$com$simontuffs$onejar$JarClassLoader;

    protected String PREFIX() {
        return "JarClassLoader: ";
    }

    protected String NAME() {
        return this.name != null ? "'" + this.name + "' " : "";
    }

    protected void VERBOSE(String message) {
        if (this.verbose) {
            System.out.println(this.PREFIX() + this.NAME() + message);
        }
    }

    protected void WARNING(String message) {
        System.err.println(this.PREFIX() + "Warning: " + this.NAME() + message);
    }

    protected void INFO(String message) {
        if (this.info) {
            System.out.println(this.PREFIX() + "Info: " + this.NAME() + message);
        }
    }

    protected void PRINTLN(String message) {
        System.out.println(message);
    }

    protected void PRINT(String message) {
        System.out.print(message);
    }

    public JarClassLoader(String $wrap) {
        this.wrapDir = $wrap;
        this.delegateToParent = this.wrapDir == null;
    }

    public JarClassLoader(ClassLoader parent) {
        super(parent);
        this.delegateToParent = true;
    }

    public String load(String mainClass) {
        String jarname = Boot.getMyJarPath();
        return this.load(mainClass, jarname);
    }

    public String load(String mainClass, String jarName) {
        if (this.record) {
            new File(this.recording).mkdirs();
        }
        try {
            if (jarName == null) {
                jarName = Boot.getMyJarPath();
            }
            JarFile jarFile = new JarFile(jarName);
            Enumeration<JarEntry> _enum = jarFile.entries();
            Manifest manifest = jarFile.getManifest();
            String[] expandPaths = null;
            String expand = manifest.getMainAttributes().getValue(EXPAND);
            if (expand != null) {
                this.expanded = true;
                this.VERBOSE("One-Jar-Expand=" + expand);
                expandPaths = expand.split(",");
                boolean confirm = Boolean.TRUE.toString().equals(manifest.getMainAttributes().getValue(CONFIRM_EXPAND));
                if (confirm) {
                    this.PRINTLN("Do you want to allow '" + Boot.getMyJarName() + "' to expand files into the file-system at " + new File(".").getAbsolutePath() + "?");
                    this.PRINT("Note: Answering n (no) will terminate this application: (y/n)? ");
                    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                    String answer = br.readLine();
                    if (answer != null && answer.trim().toLowerCase().equals("n")) {
                        this.PRINTLN("exiting without expansion.");
                        System.exit(1);
                    }
                }
            }
            boolean showexpand = Boolean.TRUE.toString().equals(manifest.getMainAttributes().getValue(SHOW_EXPAND));
            while (_enum.hasMoreElements()) {
                InputStream is;
                JarEntry entry = _enum.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (expandPaths != null && JarClassLoader.shouldExpand(expandPaths, name)) {
                    String msg;
                    File dest = new File(name);
                    if (!dest.exists() || dest.lastModified() < entry.getTime()) {
                        File parent;
                        msg = "Expanding:  " + name;
                        if (showexpand) {
                            this.PRINTLN(msg);
                        } else {
                            this.INFO(msg);
                        }
                        if (dest.exists()) {
                            this.INFO("Update because lastModified=" + new Date(dest.lastModified()) + ", entry=" + new Date(entry.getTime()));
                        }
                        if ((parent = dest.getParentFile()) != null) {
                            parent.mkdirs();
                        }
                        this.VERBOSE("using jarFile.getInputStream(" + entry + ")");
                        InputStream is2 = jarFile.getInputStream(entry);
                        FileOutputStream os = new FileOutputStream(dest);
                        this.copy(is2, os);
                        is2.close();
                        os.close();
                    } else {
                        msg = "Up-to-date: " + name;
                        if (showexpand) {
                            this.PRINTLN(msg);
                        } else {
                            this.VERBOSE(msg);
                        }
                    }
                }
                String jar = entry.getName();
                if (this.wrapDir != null && jar.startsWith(this.wrapDir) || jar.startsWith(LIB_PREFIX) || jar.startsWith(MAIN_PREFIX)) {
                    if (this.wrapDir != null && !entry.getName().startsWith(this.wrapDir)) continue;
                    this.INFO("caching " + jar);
                    this.VERBOSE("using jarFile.getInputStream(" + entry + ")");
                    is = jarFile.getInputStream(entry);
                    if (is == null) {
                        throw new IOException("Unable to load resource /" + jar + " using " + this);
                    }
                    this.loadByteCode(is, jar, manifest);
                    if (!jar.startsWith(MAIN_PREFIX)) continue;
                    if (mainClass == null) {
                        JarInputStream jis = new JarInputStream(jarFile.getInputStream(entry));
                        Manifest m = jis.getManifest();
                        jis.close();
                        if (m == null) continue;
                        mainClass = jis.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                        this.mainJar = jar;
                        continue;
                    }
                    if (this.mainJar == null) continue;
                    this.WARNING("A main class is defined in multiple jar files inside main/" + this.mainJar + " and " + jar);
                    this.WARNING("The main class " + mainClass + " from " + this.mainJar + " will be used");
                    continue;
                }
                if (this.wrapDir == null && name.startsWith(UNPACK)) {
                    is = this.getClass().getResourceAsStream("/" + jar);
                    if (is == null) {
                        throw new IOException(jar);
                    }
                    File dir = new File(TMP);
                    File sentinel = new File(dir, jar.replace('/', '.'));
                    if (sentinel.exists()) continue;
                    this.INFO("unpacking " + jar + " into " + dir.getCanonicalPath());
                    this.loadByteCode(is, jar, TMP, manifest);
                    sentinel.getParentFile().mkdirs();
                    sentinel.createNewFile();
                    continue;
                }
                if (name.endsWith(CLASS)) {
                    this.loadBytes(entry, jarFile.getInputStream(entry), "/", null, manifest);
                    continue;
                }
                this.INFO("resource: " + jarFile.getName() + "!" + entry.getName());
            }
        }
        catch (IOException iox) {
            System.err.println("Unable to load resource: " + iox);
            iox.printStackTrace(System.err);
        }
        return mainClass;
    }

    public static boolean shouldExpand(String[] expandPaths, String name) {
        for (int i = 0; i < expandPaths.length; ++i) {
            if (!name.startsWith(expandPaths[i])) continue;
            return true;
        }
        return false;
    }

    protected void loadByteCode(InputStream is, String jar, Manifest man) throws IOException {
        this.loadByteCode(is, jar, null, man);
    }

    protected void loadByteCode(InputStream is, String jar, String tmp, Manifest man) throws IOException {
        JarInputStream jis = new JarInputStream(is);
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            this.loadBytes(entry, jis, jar, tmp, man);
        }
    }

    protected void loadBytes(JarEntry entry, InputStream is, String jar, String tmp, Manifest man) throws IOException {
        String packageName;
        String entryName = entry.getName().replace('/', '.');
        int index = entryName.lastIndexOf(46);
        String type = entryName.substring(index + 1);
        int index2 = entryName.lastIndexOf(46, index - 1);
        if (index2 > -1 && this.getPackage(packageName = entryName.substring(0, index2)) == null) {
            this.definePackage(packageName, "", "", "", "", "", "", null);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.copy(is, baos);
        if (tmp != null) {
            File file = new File(tmp, entry.getName());
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(baos.toByteArray());
            fos.close();
        } else if (type.equals("class")) {
            if (this.alreadyCached(entryName, jar, baos)) {
                return;
            }
            this.byteCode.put(entryName, new ByteCode(entryName, entry.getName(), baos, jar, man));
            this.VERBOSE("cached bytes for class " + entryName);
        } else {
            String localname = jar + "/" + entryName;
            this.byteCode.put(localname, new ByteCode(localname, entry.getName(), baos, jar, man));
            this.jarNames.add(jar);
            this.VERBOSE("cached bytes for local name " + localname);
            if (this.alreadyCached(entryName, jar, baos)) {
                return;
            }
            this.byteCode.put(entryName, new ByteCode(entryName, entry.getName(), baos, jar, man));
            this.VERBOSE("cached bytes for entry name " + entryName);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(name);
        if (cls != null) {
            return cls;
        }
        this.VERBOSE("findClass(" + name + ")");
        String cache = name + CLASS;
        ByteCode bytecode = (ByteCode)this.byteCode.get(cache);
        if (bytecode != null) {
            ProtectionDomain pd;
            this.VERBOSE("found " + name + " in codebase '" + bytecode.codebase + "'");
            if (this.record) {
                this.record(bytecode);
            }
            if ((pd = (ProtectionDomain)this.pdCache.get(bytecode.codebase)) == null) {
                ProtectionDomain cd = (class$com$simontuffs$onejar$JarClassLoader == null ? (class$com$simontuffs$onejar$JarClassLoader = JarClassLoader.class$("com.simontuffs.onejar.JarClassLoader")) : class$com$simontuffs$onejar$JarClassLoader).getProtectionDomain();
                URL url = cd.getCodeSource().getLocation();
                try {
                    url = new URL("jar:" + url + "!/" + bytecode.codebase);
                }
                catch (MalformedURLException mux) {
                    mux.printStackTrace(System.out);
                }
                CodeSource source = new CodeSource(url, (Certificate[])null);
                pd = new ProtectionDomain(source, null, this, null);
                this.pdCache.put(bytecode.codebase, pd);
            }
            byte[] bytes = bytecode.bytes;
            int i = name.lastIndexOf(46);
            if (i != -1) {
                String pkgname = name.substring(0, i);
                Package pkg = this.getPackage(pkgname);
                Manifest man = bytecode.manifest;
                if (pkg != null) {
                    if (pkg.isSealed()) {
                        if (!pkg.isSealed()) {
                            throw new SecurityException("sealing violation: package " + pkgname + " is sealed");
                        }
                    } else if (man != null && this.isSealed(pkgname, man)) {
                        throw new SecurityException("sealing violation: can't seal package " + pkgname + ": already loaded");
                    }
                } else if (man != null) {
                    this.definePackage(pkgname, man);
                } else {
                    this.definePackage(pkgname, null, null, null, null, null, null, null);
                }
            }
            return this.defineClass(name, bytes, pd);
        }
        this.VERBOSE(name + " not found");
        throw new ClassNotFoundException(name);
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected Package definePackage(String name, Manifest man) throws IllegalArgumentException {
        String path = name.replace('.', '/').concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if (sealed != null) {
            try {
                sealBase = new URL(sealed);
            }
            catch (MalformedURLException mux) {
                throw new RuntimeException("Error in " + Attributes.Name.SEALED + " manifest attribute: " + sealed, mux);
            }
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    protected Class defineClass(String name, byte[] bytes, ProtectionDomain pd) throws ClassFormatError {
        return this.defineClass(name, bytes, 0, bytes.length, pd);
    }

    protected void record(ByteCode bytecode) {
        String fileName;
        File dir = new File(this.recording, this.flatten ? "" : bytecode.codebase);
        File file = new File(dir, fileName = bytecode.original);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            this.VERBOSE("" + file);
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(bytecode.bytes);
                fos.close();
            }
            catch (IOException iox) {
                System.err.println(this.PREFIX() + "unable to record " + file + ": " + iox);
            }
        }
    }

    public InputStream getByteStream(String resource) {
        InputStream result = null;
        ByteCode bytecode = (ByteCode)this.byteCode.get(resource);
        if (bytecode == null) {
            bytecode = (ByteCode)this.byteCode.get(this.resolve(resource));
        }
        if (bytecode != null) {
            result = new ByteArrayInputStream(bytecode.bytes);
        }
        if (result == null && this.delegateToParent) {
            result = ((JarClassLoader)this.getParent()).getByteStream(resource);
        }
        this.VERBOSE("getByteStream(" + resource + ") -> " + result);
        return result;
    }

    protected String resolve(String $resource) {
        String tmp;
        if ($resource.startsWith("/")) {
            $resource = $resource.substring(1);
        }
        $resource = $resource.replace('/', '.');
        String resource = null;
        String caller = this.getCaller();
        ByteCode callerCode = (ByteCode)this.byteCode.get(caller + CLASS);
        if (callerCode != null && this.byteCode.get(tmp = callerCode.codebase + "/" + $resource) != null) {
            resource = tmp;
        }
        if (resource == null) {
            resource = this.byteCode.get($resource) == null ? null : $resource;
        }
        this.VERBOSE("resource " + $resource + " resolved to " + resource);
        return resource;
    }

    protected boolean alreadyCached(String name, String jar, ByteArrayOutputStream baos) {
        byte[] bytes = baos.toByteArray();
        ByteCode existing = (ByteCode)this.byteCode.get(name);
        if (existing != null) {
            if (!Arrays.equals(existing.bytes, bytes) && !name.startsWith("/META-INF")) {
                this.INFO(existing.name + " in " + jar + " is hidden by " + existing.codebase + " (with different bytecode)");
            } else {
                this.VERBOSE(existing.name + " in " + jar + " is hidden by " + existing.codebase + " (with same bytecode)");
            }
            return true;
        }
        return false;
    }

    protected String getCaller() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String caller = null;
        for (int i = 0; i < stack.length; ++i) {
            if (this.byteCode.get(stack[i].getClassName() + CLASS) == null) continue;
            caller = stack[i].getClassName();
            break;
        }
        return caller;
    }

    public void setRecording(String $recording) {
        this.recording = $recording;
        if (this.recording == null) {
            this.recording = RECORDING;
        }
    }

    public String getRecording() {
        return this.recording;
    }

    public void setRecord(boolean $record) {
        this.record = $record;
    }

    public boolean getRecord() {
        return this.record;
    }

    public void setFlatten(boolean $flatten) {
        this.flatten = $flatten;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setVerbose(boolean $verbose) {
        this.verbose = $verbose;
        if (this.verbose) {
            this.info = true;
        }
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setInfo(boolean $info) {
        this.info = $info;
    }

    public boolean getInfo() {
        return this.info;
    }

    protected URL findResource(String $resource) {
        try {
            this.INFO("findResource(" + $resource + ")");
            String resource = this.resolve($resource);
            if (resource != null) {
                this.INFO("findResource() found: " + $resource);
                return new URL(Handler.PROTOCOL + ":" + resource);
            }
            this.INFO("findResource(): unable to locate " + $resource);
            return null;
        }
        catch (MalformedURLException mux) {
            this.WARNING("unable to locate " + $resource + " due to " + mux);
            return null;
        }
    }

    public Enumeration findResources(String name) throws IOException {
        this.INFO("findResources(" + name + ")");
        this.INFO("findResources: looking in " + this.jarNames);
        Iterator iter = this.jarNames.iterator();
        ArrayList<URL> resources = new ArrayList<URL>();
        name = name.replace('/', '.');
        while (iter.hasNext()) {
            String resource = iter.next().toString() + "/" + name;
            if (!this.byteCode.containsKey(resource)) continue;
            resources.add(new URL(Handler.PROTOCOL + ":" + resource));
        }
        final Iterator ri = resources.iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return ri.hasNext();
            }

            public Object nextElement() {
                return ri.next();
            }
        };
    }

    protected void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    public String toString() {
        return super.toString() + (this.name != null ? "(" + this.name + ")" : "");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected String findLibrary(String name) {
        String result = null;
        String resourcePath = BINLIB_PREFIX + System.mapLibraryName(name);
        if (this.binLibPath.get(resourcePath) != null) {
            result = (String)this.binLibPath.get(resourcePath);
        } else {
            try {
                int lastdot = resourcePath.lastIndexOf(46);
                String suffix = null;
                if (lastdot >= 0) {
                    suffix = resourcePath.substring(lastdot);
                }
                InputStream is = this.getClass().getResourceAsStream("/" + resourcePath);
                File tempNativeLib = File.createTempFile(name + "-", suffix);
                FileOutputStream os = new FileOutputStream(tempNativeLib);
                this.copy(is, os);
                os.close();
                this.VERBOSE("Stored native library " + name + " at " + tempNativeLib);
                tempNativeLib.deleteOnExit();
                this.binLibPath.put(resourcePath, tempNativeLib.getPath());
                result = tempNativeLib.getPath();
                if (result != null) {
                    this.VERBOSE("Found " + result + " in native binary library " + resourcePath);
                }
            }
            catch (Throwable e) {
                this.WARNING("Unable to load native library: " + e);
            }
        }
        return result;
    }

    public boolean isExpanding() {
        return this.expanded;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        String handlerPackage = System.getProperty(JAVA_PROTOCOL_HANDLER);
        if (handlerPackage == null) {
            handlerPackage = "";
        }
        if (handlerPackage.length() > 0) {
            handlerPackage = "|" + handlerPackage;
        }
        handlerPackage = "com.simontuffs" + handlerPackage;
        System.setProperty(JAVA_PROTOCOL_HANDLER, handlerPackage);
    }

    protected static class ByteCode {
        public byte[] bytes;
        public String name;
        public String original;
        public String codebase;
        public Manifest manifest;

        public ByteCode(String $name, String $original, ByteArrayOutputStream baos, String $codebase, Manifest $manifest) {
            this.name = $name;
            this.original = $original;
            this.bytes = baos.toByteArray();
            this.codebase = $codebase;
            this.manifest = $manifest;
        }
    }
}

