/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.transformers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import junit.framework.TestCase;
import org.alfresco.deployment.transformers.CompressionTransformer;

public class CompressionTransformerTest
extends TestCase {
    private Random randomNumber = new Random(System.currentTimeMillis());

    public CompressionTransformerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddFilter() {
        CompressionTransformer transformer = new CompressionTransformer();
        String path = "wibble";
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        OutputStream out = null;
        out = transformer.addFilter(compressed, path, null, null);
        CompressionTransformerTest.assertNotNull((String)"null output stream returned", (Object)compressed);
        String clearText = "hello world, <head>sample</head>";
        try {
            out.write(clearText.getBytes());
        }
        catch (IOException ie) {
            CompressionTransformerTest.fail((String)("unexpected exception thrown" + ie.toString()));
        }
        try {
            out.flush();
            out.close();
        }
        catch (IOException ie) {
            CompressionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        assert (compressed.size() > 0);
        InputStream decompress = null;
        ByteArrayInputStream compressedStream = new ByteArrayInputStream(compressed.toByteArray());
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        decompress = transformer.addFilter(compressedStream, "wibble", null, null);
        try {
            int readLen;
            byte[] readBuffer = new byte[1002];
            while ((readLen = decompress.read(readBuffer)) > 0) {
                result.write(readBuffer, 0, readLen);
            }
        }
        catch (IOException ie) {
            CompressionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        CompressionTransformerTest.assertTrue((boolean)result.toString().equalsIgnoreCase(clearText));
    }

    public void testCompressDecompressBigMessage() {
        String sampleData = "Ring-a-ring a roses, a pocket full of posies, atishoo, atishoo, we all fall down. ";
        CompressionTransformer transformer = new CompressionTransformer();
        String path = "wibble";
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        OutputStream out = transformer.addFilter(compressed, path, null, null);
        CompressionTransformerTest.assertNotNull((String)"null output stream returned", (Object)out);
        StringBuffer clearText = new StringBuffer();
        for (int i = 0; i < 1000; ++i) {
            String random = this.randomString();
            clearText.append(sampleData);
            clearText.append(random);
        }
        try {
            out.write(clearText.toString().getBytes());
        }
        catch (IOException ie) {
            CompressionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        try {
            out.flush();
            out.close();
        }
        catch (IOException ie) {
            CompressionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        InputStream decompress = null;
        ByteArrayInputStream compressedStream = new ByteArrayInputStream(compressed.toByteArray());
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        decompress = transformer.addFilter(compressedStream, "wibble", null, null);
        try {
            int readLen;
            byte[] readBuffer = new byte[1002];
            while ((readLen = decompress.read(readBuffer)) > 0) {
                result.write(readBuffer, 0, readLen);
            }
        }
        catch (IOException ie) {
            CompressionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        String resultStr = result.toString();
        CompressionTransformerTest.assertTrue((resultStr.length() == clearText.length() ? 1 : 0) != 0);
        CompressionTransformerTest.assertTrue((boolean)resultStr.toString().equalsIgnoreCase(clearText.toString()));
    }

    public void testCompressDecompressManySends() {
        String sampleData = "Ring-a-ring a roses, a pocket full of posies, atishoo, atishoo, we all fall down.";
        CompressionTransformer transformer = new CompressionTransformer();
        String path = "wibble";
        int numberOfSends = 137;
        ByteArrayOutputStream compressed = new ByteArrayOutputStream();
        OutputStream out = transformer.addFilter(compressed, path, null, null);
        CompressionTransformerTest.assertNotNull((String)"null output stream returned", (Object)out);
        StringBuffer clearText = new StringBuffer();
        for (int i = 0; i < numberOfSends; ++i) {
            String randomText = this.randomString() + sampleData;
            clearText.append(randomText);
            try {
                out.write(randomText.toString().getBytes());
                continue;
            }
            catch (IOException ie) {
                CompressionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
            }
        }
        try {
            out.flush();
            out.close();
        }
        catch (IOException ie) {
            CompressionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        ByteArrayInputStream compressedStream = new ByteArrayInputStream(compressed.toByteArray());
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        InputStream decompress = transformer.addFilter(compressedStream, "wibble", null, null);
        try {
            int readLen;
            byte[] readBuffer = new byte[509];
            while ((readLen = decompress.read(readBuffer)) > 0) {
                result.write(readBuffer, 0, readLen);
            }
        }
        catch (IOException ie) {
            CompressionTransformerTest.fail((String)("unexpected exception thrown, " + ie.toString()));
        }
        String resultStr = result.toString();
        CompressionTransformerTest.assertTrue((clearText.length() > 0 ? 1 : 0) != 0);
        CompressionTransformerTest.assertTrue((resultStr.length() == clearText.length() ? 1 : 0) != 0);
        CompressionTransformerTest.assertTrue((boolean)resultStr.toString().equalsIgnoreCase(clearText.toString()));
    }

    private String randomString() {
        StringBuffer clearText = new StringBuffer();
        for (int i = 0; i < 100; ++i) {
            char c = (char)this.randomNumber.nextInt(100);
            if (!Character.isLetterOrDigit(c)) continue;
            clearText.append(c);
        }
        return clearText.toString();
    }
}

