/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis;

import java.util.Arrays;
import java.util.List;
import org.alfresco.cmis.CMISFilterNotValidException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFilter {
    public static final String MATCH_ALL_FILTER = "*";
    public static final String PROPERTY_NAME_TOKENS_DELIMITER = ",";
    private static final char[] PROPERTY_INVALID_CHARS = new char[]{' ', ',', '\"', '\'', '\\', '.', ',', '(', ')'};
    private final List<String> properties;

    public PropertyFilter(String filter) throws CMISFilterNotValidException {
        this.properties = PropertyFilter.validateFilter(filter);
    }

    private static List<String> validateFilter(String filter) throws CMISFilterNotValidException {
        if (filter != null) {
            if (!filter.equals(MATCH_ALL_FILTER)) {
                String[] tokens = filter.split(PROPERTY_NAME_TOKENS_DELIMITER);
                for (int i = 0; i < tokens.length; ++i) {
                    String token = tokens[i].trim();
                    if (token.isEmpty() || token.indexOf(42) != -1 || !PropertyFilter.isValidToken(token)) {
                        throw new CMISFilterNotValidException("Property filter \"" + filter + "\" is invalid");
                    }
                    tokens[i] = token;
                }
                return Arrays.asList(tokens);
            }
            return null;
        }
        return null;
    }

    private static boolean isValidToken(String token) {
        if (token == null) {
            return false;
        }
        boolean result = true;
        for (char invalidChar : PROPERTY_INVALID_CHARS) {
            if (token.indexOf(invalidChar) == -1) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean allow(String property) {
        return this.properties == null || this.properties.contains(property);
    }
}

