/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.acl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.cmis.CMISAccessControlEntry;
import org.alfresco.cmis.CMISAccessControlReport;
import org.alfresco.cmis.CMISAccessControlService;
import org.alfresco.cmis.CMISAclCapabilityEnum;
import org.alfresco.cmis.CMISAclPropagationEnum;
import org.alfresco.cmis.CMISAclSupportedPermissionEnum;
import org.alfresco.cmis.CMISAllowedActionEnum;
import org.alfresco.cmis.CMISConstraintException;
import org.alfresco.cmis.CMISDictionaryService;
import org.alfresco.cmis.CMISPermissionDefinition;
import org.alfresco.cmis.CMISPermissionMapping;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.acl.CMISAccessControlEntryImpl;
import org.alfresco.cmis.acl.CMISAccessControlReportImpl;
import org.alfresco.cmis.acl.CMISPermissionDefinitionImpl;
import org.alfresco.cmis.acl.CMISPermissionMappingImpl;
import org.alfresco.cmis.mapping.CMISMapping;
import org.alfresco.opencmis.CMISAccessControlFormatEnum;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.AccessPermissionImpl;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMISAccessControlServiceImpl
implements CMISAccessControlService {
    private CMISAclCapabilityEnum aclCapabilityEnum;
    private CMISAclSupportedPermissionEnum aclSupportedPermissionEnum;
    private CMISAclPropagationEnum aclPropagationEnum;
    private ModelDAO permissionModelDao;
    private PermissionService permissionService;
    private CMISMapping cmisMapping;
    private NodeService nodeService;
    private CMISDictionaryService cmisDictionaryService;

    public void setAclCapabilityEnum(CMISAclCapabilityEnum aclCapabilityEnum) {
        this.aclCapabilityEnum = aclCapabilityEnum;
    }

    public void setAclSupportedPermissionEnum(CMISAclSupportedPermissionEnum aclSupportedPermissionEnum) {
        this.aclSupportedPermissionEnum = aclSupportedPermissionEnum;
    }

    public void setAclPropagationEnum(CMISAclPropagationEnum aclPropagationEnum) {
        this.aclPropagationEnum = aclPropagationEnum;
    }

    public void setPermissionModelDao(ModelDAO permissionModelDao) {
        this.permissionModelDao = permissionModelDao;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setCMISMapping(CMISMapping cmisMapping) {
        this.cmisMapping = cmisMapping;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setCMISDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    @Override
    public CMISAccessControlReport applyAcl(NodeRef nodeRef, List<CMISAccessControlEntry> acesToApply) throws CMISConstraintException {
        LinkedHashSet<CMISAccessControlEntry> acesToAdd = new LinkedHashSet<CMISAccessControlEntry>(acesToApply);
        List<? extends CMISAccessControlEntry> acesExisting = this.getAcl(nodeRef, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS).getAccessControlEntries();
        ArrayList<CMISAccessControlEntry> acesToRemove = new ArrayList<CMISAccessControlEntry>(acesExisting.size());
        for (CMISAccessControlEntry cMISAccessControlEntry : acesExisting) {
            if (!cMISAccessControlEntry.getDirect() || acesToAdd.remove(cMISAccessControlEntry)) continue;
            acesToRemove.add(cMISAccessControlEntry);
        }
        return this.applyAcl(nodeRef, acesToRemove, new ArrayList<CMISAccessControlEntry>(acesToAdd), CMISAclPropagationEnum.PROPAGATE, CMISAccessControlFormatEnum.REPOSITORY_SPECIFIC_PERMISSIONS);
    }

    @Override
    public CMISAccessControlReport applyAcl(NodeRef nodeRef, List<CMISAccessControlEntry> acesToRemove, List<CMISAccessControlEntry> acesToAdd, CMISAclPropagationEnum propagation, CMISAccessControlFormatEnum format) throws CMISConstraintException {
        if (propagation == CMISAclPropagationEnum.OBJECT_ONLY) {
            throw new CMISConstraintException("Unsupported ACL propagation mode: " + (Object)((Object)propagation));
        }
        QName type = this.nodeService.getType(nodeRef);
        CMISTypeDefinition cmisType = this.cmisDictionaryService.findTypeForClass(type, new CMISScope[0]);
        if (!cmisType.isControllableACL()) {
            throw new CMISConstraintException("ACLs are not supported for type: " + cmisType.getDisplayName());
        }
        if (acesToRemove != null) {
            Set permissions = this.permissionService.getAllSetPermissions(nodeRef);
            for (CMISAccessControlEntry entry : acesToRemove) {
                String alfrescoPermission = this.cmisMapping.getSetPermission(this.compressPermission(entry.getPermission()));
                AccessPermissionImpl toCheck = new AccessPermissionImpl(alfrescoPermission, AccessStatus.ALLOWED, entry.getPrincipalId(), 0);
                if (!permissions.contains(toCheck)) {
                    throw new CMISConstraintException("No matching ACE found to delete");
                }
                this.permissionService.deletePermission(nodeRef, entry.getPrincipalId(), alfrescoPermission);
            }
        }
        if (acesToAdd != null) {
            for (CMISAccessControlEntry entry : acesToAdd) {
                String alfrescoPermission = this.cmisMapping.getSetPermission(this.compressPermission(entry.getPermission()));
                this.permissionService.setPermission(nodeRef, entry.getPrincipalId(), alfrescoPermission, true);
            }
        }
        return this.getAcl(nodeRef, format);
    }

    @Override
    public CMISAccessControlReport getAcl(NodeRef nodeRef, CMISAccessControlFormatEnum format) {
        CMISAccessControlReportImpl merge = new CMISAccessControlReportImpl();
        Set permissions = this.permissionService.getAllSetPermissions(nodeRef);
        ArrayList<AccessPermission> ordered = new ArrayList<AccessPermission>();
        AccessPermissionComparator comparator = new AccessPermissionComparator();
        for (AccessPermission current : permissions) {
            int index = Collections.binarySearch(ordered, current, comparator);
            if (index >= 0) continue;
            ordered.add(-index - 1, current);
        }
        for (AccessPermission entry : ordered) {
            if (entry.getAccessStatus() == AccessStatus.ALLOWED) {
                merge.addEntry(new CMISAccessControlEntryImpl(entry.getAuthority(), entry.getPermission(), entry.getPosition()));
                continue;
            }
            if (entry.getAccessStatus() != AccessStatus.DENIED) continue;
            merge.removeEntry(new CMISAccessControlEntryImpl(entry.getAuthority(), entry.getPermission(), entry.getPosition()));
        }
        CMISAccessControlReportImpl answer = new CMISAccessControlReportImpl();
        for (CMISAccessControlEntry entry : merge.getAccessControlEntries()) {
            CMISAccessControlEntryImpl impl = (CMISAccessControlEntryImpl)entry;
            PermissionReference permissionReference = this.permissionModelDao.getPermissionReference(null, impl.getPermission());
            Set<PermissionReference> longForms = this.permissionModelDao.getGranteePermissions(permissionReference);
            HashSet<String> shortForms = new HashSet<String>();
            for (PermissionReference permissionReference2 : longForms) {
                shortForms.add(this.getPermission(permissionReference2));
            }
            for (Pair pair : this.cmisMapping.getReportedPermissions(impl.getPermission(), shortForms, this.permissionModelDao.hasFull(permissionReference), impl.getDirect(), format)) {
                answer.addEntry(new CMISAccessControlEntryImpl(impl.getPrincipalId(), this.expandPermission((String)pair.getFirst()), impl.getPosition(), (Boolean)pair.getSecond()));
            }
        }
        return answer;
    }

    private String getPermission(PermissionReference permissionReference) {
        if (this.permissionModelDao.isUnique(permissionReference)) {
            return permissionReference.getName();
        }
        return permissionReference.toString();
    }

    private String expandPermission(String permission) {
        if (permission.equals("cmis:all")) {
            return permission;
        }
        if (permission.equals("cmis:read")) {
            return permission;
        }
        if (permission.equals("cmis:write")) {
            return permission;
        }
        if (permission.startsWith("{")) {
            return permission;
        }
        PermissionReference permissionReference = this.permissionModelDao.getPermissionReference(null, permission);
        return permissionReference.toString();
    }

    private String compressPermission(String permission) {
        int sepIndex;
        if (permission.equals("cmis:all") || permission.equals("cmis:read") || permission.equals("cmis:write") || !permission.startsWith("{") || (sepIndex = permission.lastIndexOf(46)) == -1) {
            return permission;
        }
        return permission.substring(sepIndex + 1);
    }

    @Override
    public CMISAclCapabilityEnum getAclCapability() {
        return this.aclCapabilityEnum;
    }

    public void setAclCapability(CMISAclCapabilityEnum aclCapabilityEnum) {
        this.aclCapabilityEnum = aclCapabilityEnum;
    }

    @Override
    public CMISAclSupportedPermissionEnum getSupportedPermissions() {
        return this.aclSupportedPermissionEnum;
    }

    public void setSupportedPermissions(CMISAclSupportedPermissionEnum aclSupportedPermissionEnum) {
        this.aclSupportedPermissionEnum = aclSupportedPermissionEnum;
    }

    @Override
    public CMISAclPropagationEnum getAclPropagation() {
        return this.aclPropagationEnum;
    }

    public void setAclPropagation(CMISAclPropagationEnum aclPropagationEnum) {
        this.aclPropagationEnum = aclPropagationEnum;
    }

    @Override
    public List<? extends CMISPermissionMapping> getPermissionMappings() {
        ArrayList<CMISPermissionMappingImpl> mappings = new ArrayList<CMISPermissionMappingImpl>();
        for (CMISAllowedActionEnum e : EnumSet.allOf(CMISAllowedActionEnum.class)) {
            Map<String, List<String>> enumMappings = e.getPermissionMapping();
            for (String key : enumMappings.keySet()) {
                List<String> list = enumMappings.get(key);
                CMISPermissionMappingImpl mapping = new CMISPermissionMappingImpl(key, list);
                mappings.add(mapping);
            }
        }
        return mappings;
    }

    @Override
    public List<CMISPermissionDefinition> getRepositoryPermissions() {
        ArrayList<CMISPermissionDefinition> answer = new ArrayList<CMISPermissionDefinition>();
        PermissionReference allPermission = this.permissionModelDao.getPermissionReference(null, "All");
        Set<PermissionReference> all = this.permissionModelDao.getAllExposedPermissions();
        for (PermissionReference pr : all) {
            this.addPermissionDefinition(answer, pr);
        }
        this.addPermissionDefinition(answer, allPermission);
        answer.add(new CMISPermissionDefinitionImpl("cmis:all"));
        answer.add(new CMISPermissionDefinitionImpl("cmis:read"));
        answer.add(new CMISPermissionDefinitionImpl("cmis:write"));
        return answer;
    }

    @Override
    public String getPrincipalAnonymous() {
        return AuthenticationUtil.getGuestUserName();
    }

    @Override
    public String getPrincipalAnyone() {
        return "GROUP_EVERYONE";
    }

    private void addPermissionDefinition(ArrayList<CMISPermissionDefinition> list, PermissionReference pr) {
        CMISPermissionDefinitionImpl def = new CMISPermissionDefinitionImpl(this.getPermissionString(pr));
        list.add(def);
    }

    private String getPermissionString(PermissionReference pr) {
        StringBuilder builder = new StringBuilder();
        builder.append(pr.getQName().toString());
        builder.append(".");
        builder.append(pr.getName());
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AccessPermissionComparator
    implements Comparator<AccessPermission> {
        @Override
        public int compare(AccessPermission left, AccessPermission right) {
            if (left.getPosition() != right.getPosition()) {
                return right.getPosition() - left.getPosition();
            }
            if (left.getAccessStatus() != right.getAccessStatus()) {
                return left.getAccessStatus() == AccessStatus.DENIED ? -1 : 1;
            }
            int compare = left.getAuthority().compareTo(right.getAuthority());
            if (compare != 0) {
                return compare;
            }
            return left.getPermission().compareTo(right.getPermission());
        }
    }
}

