/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.cmis.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.alfresco.cmis.CMISQueryException;
import org.alfresco.cmis.CMISScope;
import org.alfresco.cmis.CMISTypeDefinition;
import org.alfresco.cmis.mapping.AbstractProperty;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.lucene.LuceneFunction;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.QName;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeIdProperty
extends AbstractProperty {
    public ObjectTypeIdProperty(ServiceRegistry serviceRegistry) {
        super(serviceRegistry, "cmis:objectTypeId");
    }

    @Override
    public Serializable getValue(NodeRef nodeRef) {
        QName type = this.getServiceRegistry().getNodeService().getType(nodeRef);
        return this.getServiceRegistry().getCMISDictionaryService().findTypeForClass(type, new CMISScope[0]).getTypeId().getId();
    }

    @Override
    public Serializable getValue(AssociationRef assocRef) {
        QName type = assocRef.getTypeQName();
        return this.getServiceRegistry().getCMISDictionaryService().findTypeForClass(type, CMISScope.RELATIONSHIP).getTypeId().getId();
    }

    @Override
    public String getLuceneFieldName() {
        return "EXACTTYPE";
    }

    private String getValueAsString(Serializable value) {
        String asString = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)value);
        return asString;
    }

    @Override
    public Query buildLuceneEquality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        CMISTypeDefinition type = this.getServiceRegistry().getCMISDictionaryService().findType(stringValue);
        return lqp.getFieldQuery(field, type.getTypeId().getQName().toString(), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneExists(AbstractLuceneQueryParser lqp, Boolean not) throws ParseException {
        if (not.booleanValue()) {
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        return new MatchAllDocsQuery();
    }

    @Override
    public Query buildLuceneGreaterThan(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CMISQueryException("Property " + this.getName() + " can not be used in a 'greater than' comparison");
    }

    @Override
    public Query buildLuceneGreaterThanOrEquals(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CMISQueryException("Property " + this.getName() + " can not be used in a 'greater than or equals' comparison");
    }

    @Override
    public Query buildLuceneIn(AbstractLuceneQueryParser lqp, Collection<Serializable> values, Boolean not, PredicateMode mode) throws ParseException {
        String field = this.getLuceneFieldName();
        ArrayList<String> asStrings = new ArrayList<String>(values.size());
        for (Serializable value : values) {
            String stringValue = this.getValueAsString(value);
            CMISTypeDefinition type = this.getServiceRegistry().getCMISDictionaryService().findType(stringValue);
            asStrings.add(type.getTypeId().getQName().toString());
        }
        if (asStrings.size() == 0) {
            if (not.booleanValue()) {
                return new MatchAllDocsQuery();
            }
            return new TermQuery(new Term("NO_TOKENS", "__"));
        }
        if (asStrings.size() == 1) {
            String value = (String)asStrings.iterator().next();
            if (not.booleanValue()) {
                return lqp.getDoesNotMatchFieldQuery(field, value, AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            }
            return lqp.getFieldQuery(field, value, AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
        }
        BooleanQuery booleanQuery = new BooleanQuery();
        if (not.booleanValue()) {
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        }
        for (String value : asStrings) {
            Query any = lqp.getFieldQuery(field, value, AnalysisMode.IDENTIFIER, LuceneFunction.FIELD);
            if (not.booleanValue()) {
                booleanQuery.add(any, BooleanClause.Occur.MUST_NOT);
                continue;
            }
            booleanQuery.add(any, BooleanClause.Occur.SHOULD);
        }
        return booleanQuery;
    }

    @Override
    public Query buildLuceneInequality(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        CMISTypeDefinition type = this.getServiceRegistry().getCMISDictionaryService().findType(stringValue);
        return lqp.getDoesNotMatchFieldQuery(field, type.getTypeId().getQName().toString(), AnalysisMode.IDENTIFIER, luceneFunction);
    }

    @Override
    public Query buildLuceneLessThan(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CMISQueryException("Property " + this.getName() + " can not be used in a 'less than' comparison");
    }

    @Override
    public Query buildLuceneLessThanOrEquals(AbstractLuceneQueryParser lqp, Serializable value, PredicateMode mode, LuceneFunction luceneFunction) throws ParseException {
        throw new CMISQueryException("Property " + this.getName() + " can not be used in a 'less than or equals' comparison");
    }

    @Override
    public Query buildLuceneLike(AbstractLuceneQueryParser lqp, Serializable value, Boolean not) throws ParseException {
        String field = this.getLuceneFieldName();
        String stringValue = this.getValueAsString(value);
        CMISTypeDefinition type = this.getServiceRegistry().getCMISDictionaryService().findType(stringValue);
        String typeQName = type.getTypeId().getQName().toString();
        if (not.booleanValue()) {
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            booleanQuery.add(lqp.getLikeQuery(field, typeQName, AnalysisMode.IDENTIFIER), BooleanClause.Occur.MUST_NOT);
            return booleanQuery;
        }
        return lqp.getLikeQuery(field, typeQName, AnalysisMode.IDENTIFIER);
    }

    @Override
    public String getLuceneSortField(AbstractLuceneQueryParser lqp) {
        return this.getLuceneFieldName();
    }
}

