/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server.handler;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import org.alfresco.email.server.handler.EmailMessageHandler;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.encoding.ContentCharsetFinder;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.email.EmailMessage;
import org.alfresco.service.cmr.email.EmailMessagePart;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractEmailMessageHandler
implements EmailMessageHandler {
    private static final Log log = LogFactory.getLog(EmailMessageHandler.class);
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private ContentService contentService;
    private MimetypeService mimetypeService;
    private static Log logger = LogFactory.getLog(AbstractEmailMessageHandler.class);

    protected ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    protected NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected MimetypeService getMimetypeService() {
        return this.mimetypeService;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    protected void writeContent(NodeRef nodeRef, String content, String mimetype) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes("UTF-8"));
            this.writeContent(nodeRef, inputStream, mimetype, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AlfrescoRuntimeException("Failed to write content", (Throwable)e);
        }
    }

    protected void writeContent(NodeRef nodeRef, InputStream content, String mimetype, String encoding) {
        BufferedInputStream bis = new BufferedInputStream(content, 4092);
        if (encoding == null) {
            if (this.mimetypeService.isText(mimetype)) {
                ContentCharsetFinder charsetFinder = this.mimetypeService.getContentCharsetFinder();
                encoding = charsetFinder.getCharset((InputStream)bis, mimetype).name();
            } else {
                encoding = "UTF-8";
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Write content (MimeType=\"" + mimetype + "\", Encoding=\"" + encoding + "\""));
        }
        ContentService contentService = this.getContentService();
        ContentWriter writer = contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype(mimetype);
        writer.setEncoding(encoding);
        writer.putContent((InputStream)bis);
    }

    protected void addEmailedAspect(NodeRef nodeRef, EmailMessage message) {
        HashMap<QName, Object> emailProps = new HashMap<QName, Object>();
        emailProps.put(ContentModel.PROP_SENTDATE, message.getSentDate());
        emailProps.put(ContentModel.PROP_ORIGINATOR, message.getFrom());
        emailProps.put(ContentModel.PROP_ADDRESSEE, message.getTo());
        emailProps.put(ContentModel.PROP_ADDRESSEES, (Serializable)((Object)message.getCC()));
        emailProps.put(ContentModel.PROP_SUBJECT, message.getSubject());
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_EMAILED, emailProps);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Emailed aspect has been added.");
        }
    }

    protected NodeRef addContentNode(NodeService nodeService, NodeRef parent, String name, QName assocType, boolean overwrite) {
        NodeRef childNodeRef = null;
        String workingName = name;
        String baseName = FilenameUtils.getBaseName((String)name);
        String extension = FilenameUtils.getExtension((String)name);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("addContentNode name:" + name));
        }
        for (int counter = 1; counter < 10000; ++counter) {
            QName safeQName = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/content/1.0", (String)workingName);
            List childNodeRefs = nodeService.getChildAssocs(parent, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)safeQName);
            if (childNodeRefs.size() > 0) {
                if (overwrite) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("overwriting existing node :" + name));
                    }
                    childNodeRef = ((ChildAssociationRef)childNodeRefs.get(0)).getChildRef();
                    nodeService.setProperty(childNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)baseName));
                    return childNodeRef;
                }
                String postFix = "(" + counter + ")";
                workingName = baseName.length() + extension.length() + postFix.length() > 100 ? baseName.substring(0, 100 - postFix.length() - extension.length() - 1) + postFix : baseName + postFix;
                if (extension.length() <= 0) continue;
                workingName = workingName + "." + extension;
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("child node ref does not already exist :" + workingName));
            }
            HashMap<QName, String> contentProps = new HashMap<QName, String>();
            contentProps.put(ContentModel.PROP_NAME, workingName);
            ChildAssociationRef associationRef = nodeService.createNode(parent, assocType, safeQName, ContentModel.TYPE_CONTENT, contentProps);
            childNodeRef = associationRef.getChildRef();
            return childNodeRef;
        }
        throw new AlfrescoRuntimeException("Unable to add new file");
    }

    protected NodeRef addContentNode(NodeService nodeService, NodeRef parent, String name, boolean overwrite) {
        return this.addContentNode(nodeService, parent, name, ContentModel.ASSOC_CONTAINS, overwrite);
    }

    protected NodeRef addAttachment(NodeService nodeService, NodeRef folder, NodeRef mainContentNode, String fileName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding attachment node (name=" + fileName + ")."));
        }
        NodeRef attachmentNode = this.addContentNode(nodeService, folder, fileName, false);
        nodeService.addAspect(mainContentNode, ContentModel.ASPECT_ATTACHABLE, null);
        nodeService.createAssociation(mainContentNode, attachmentNode, ContentModel.ASSOC_ATTACHMENTS);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Attachment has been added.");
        }
        return attachmentNode;
    }

    private String getAppropriateNodeName(NodeRef parent, String name, QName assocType) {
        if (this.nodeService.getChildByName(parent, assocType, name) != null) {
            name = name + "(1)";
            while (this.nodeService.getChildByName(parent, assocType, name) != null) {
                int index = name.lastIndexOf("(");
                if (index <= 0 || name.charAt(name.length() - 1) != ')') continue;
                String posibleNumber = name.substring(index + 1, name.length() - 1);
                long num = Long.parseLong(posibleNumber) + 1L;
                name = name.substring(0, index) + "(" + num + ")";
            }
        }
        return name;
    }

    protected void addAttachments(NodeRef spaceNodeRef, NodeRef nodeRef, EmailMessage message) {
        EmailMessagePart[] attachments;
        for (EmailMessagePart attachment : attachments = message.getAttachments()) {
            String fileName = attachment.getFileName();
            InputStream contentIs = attachment.getContent();
            MimetypeService mimetypeService = this.getMimetypeService();
            String mimetype = mimetypeService.guessMimetype(fileName);
            String encoding = attachment.getEncoding();
            NodeRef attachmentNode = this.addAttachment(this.getNodeService(), spaceNodeRef, nodeRef, fileName);
            this.writeContent(attachmentNode, contentIs, mimetype, encoding);
        }
    }
}

