/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.email.server.handler;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.alfresco.email.server.handler.AbstractEmailMessageHandler;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.email.EmailMessage;
import org.alfresco.service.cmr.email.EmailMessageException;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class FolderEmailMessageHandler
extends AbstractEmailMessageHandler {
    private static final String MSG_RECEIVED_BY_SMTP = "email.server.msg.received_by_smtp";
    private static final String MSG_DEFAULT_SUBJECT = "email.server.msg.default_subject";
    private static final String ERR_MAIL_READ_ERROR = "email.server.err.mail_read_error";
    private static final Log log = LogFactory.getLog(FolderEmailMessageHandler.class);
    private boolean overwriteDuplicates = false;

    public void processMessage(NodeRef nodeRef, EmailMessage message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Message is processing by FolderMailMessageHandler");
        }
        try {
            QName nodeTypeQName = this.getNodeService().getType(nodeRef);
            if (!this.getDictionaryService().isSubClass(nodeTypeQName, ContentModel.TYPE_FOLDER)) {
                throw new AlfrescoRuntimeException("\nMessage handler " + this.getClass().getName() + " cannot handle type " + nodeTypeQName + ".\n" + "Check the message handler mappings.");
            }
            this.addAlfrescoContent(nodeRef, message);
        }
        catch (IOException ex) {
            throw new EmailMessageException(ERR_MAIL_READ_ERROR, ex.getMessage());
        }
    }

    public void addAlfrescoContent(NodeRef spaceNodeRef, EmailMessage message) throws IOException {
        String messageFrom;
        String messageSubject = message.getSubject();
        if (messageSubject == null || messageSubject.length() == 0) {
            Date now = new Date();
            messageSubject = I18NUtil.getMessage((String)MSG_DEFAULT_SUBJECT, (Object[])new Object[]{new SimpleDateFormat("dd-MM-yyyy-hh-mm-ss").format(now)});
        }
        if ((messageFrom = message.getFrom()) == null) {
            messageFrom = "";
        }
        NodeRef contentNodeRef = this.addContentNode(this.getNodeService(), spaceNodeRef, messageSubject, this.overwriteDuplicates);
        this.addTitledAspect(contentNodeRef, messageSubject, messageFrom);
        this.addEmailedAspect(contentNodeRef, message);
        if (message.getBody() != null) {
            if (message.getBody().getSize() == -1) {
                this.writeSpace(contentNodeRef);
            } else {
                InputStream contentIs = message.getBody().getContent();
                MimetypeService mimetypeService = this.getMimetypeService();
                String mimetype = mimetypeService.guessMimetype(messageSubject);
                if (mimetype.equals("application/octet-stream")) {
                    mimetype = "text/plain";
                }
                String encoding = message.getBody().getEncoding();
                this.writeContent(contentNodeRef, contentIs, mimetype, encoding);
            }
        }
        this.addAttachments(spaceNodeRef, contentNodeRef, message);
    }

    private void writeSpace(NodeRef nodeRef) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write space string");
        }
        ContentService contentService = this.getContentService();
        ContentWriter writer = contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF-8");
        writer.putContent(" ");
    }

    private void addTitledAspect(NodeRef nodeRef, String title, String from) {
        HashMap<QName, String> titledProps = new HashMap<QName, String>();
        titledProps.put(ContentModel.PROP_TITLE, title);
        titledProps.put(ContentModel.PROP_DESCRIPTION, I18NUtil.getMessage((String)MSG_RECEIVED_BY_SMTP, (Object[])new Object[]{from}));
        this.getNodeService().addAspect(nodeRef, ContentModel.ASPECT_TITLED, titledProps);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Titled aspect has been added.");
        }
    }

    public void setOverwriteDuplicates(boolean overwriteDuplicates) {
        this.overwriteDuplicates = overwriteDuplicates;
    }

    public boolean isOverwriteDuplicates() {
        return this.overwriteDuplicates;
    }
}

