/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.oncrpc.nfs.NFSServer;
import org.alfresco.jlan.oncrpc.nfs.ShareDetails;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NfsServerNodeMonitor
implements NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.BeforeDeleteNodePolicy,
NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnDeleteChildAssociationPolicy,
NodeServicePolicies.OnDeleteNodePolicy,
InitializingBean {
    private static final Logger LOGGER = Logger.getLogger(NfsServerNodeMonitor.class);
    public static final char NIX_SEPARATOR = '/';
    public static final String NIX_SEPARATOR_STR = "/";
    private Boolean enabled;
    private String targetDeviceName;
    private StoreRef targetStoreRef;
    private List<DeviceContext> filesystemContexts;
    private NodeService nodeService;
    private PolicyComponent policyComponent;
    private PermissionService permissionService;
    private NFSServer nfsServer;
    private Map<NodeRef, Integer> cachedNodes = new HashMap<NodeRef, Integer>();

    public void setEnabled(boolean enabled) {
        Boolean previousState = this.enabled;
        this.enabled = enabled;
        if (null != previousState) {
            this.initialize();
        }
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setTargetDeviceName(String targetDeviceName) {
        this.targetDeviceName = targetDeviceName;
    }

    public String getTargetDeviceName() {
        return this.targetDeviceName;
    }

    public void setFilesystemContexts(List<DeviceContext> filesystemContexts) {
        this.filesystemContexts = filesystemContexts;
    }

    public StoreRef getTargetStoreRef() {
        return this.targetStoreRef;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setNfsServer(NFSServer nfsServer) {
        this.nfsServer = nfsServer;
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    private void initialize() {
        if (this.enabled.booleanValue()) {
            if (null == this.filesystemContexts) {
                throw new AlfrescoRuntimeException("'filesystemContexts' property is not configured");
            }
            for (DeviceContext context : this.filesystemContexts) {
                if (!(context instanceof ContentContext) || null == context.getDeviceName() || !context.getDeviceName().equals(this.targetDeviceName)) continue;
                ContentContext targetContext = (ContentContext)context;
                if (null == targetContext.getStoreName()) break;
                this.targetStoreRef = new StoreRef(targetContext.getStoreName());
                break;
            }
            if (null == this.targetStoreRef) {
                throw new AlfrescoRuntimeException("Target Store Reference can't be found for '" + this.targetDeviceName + "' device name. Check correctness of 'targetDeviceName' and 'filesystemContexts' properties configurations");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("StoreRef='" + this.targetStoreRef + "' was found for '" + this.targetDeviceName + "' device name"));
            }
            this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onCreateChildAssociation"));
            this.policyComponent.bindAssociationBehaviour(NodeServicePolicies.OnDeleteChildAssociationPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onDeleteChildAssociation"));
            this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnDeleteNodePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onDeleteNode"));
            this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
            this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onUpdateProperties"));
        } else {
            LOGGER.warn((Object)"NodeMonitor for NFS server is not enabled! Cache of NFS server will be never synchronized with target filesystem");
        }
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.enabled.booleanValue() && null != this.nfsServer && this.targetStoreRef.equals((Object)nodeRef.getStoreRef())) {
            int dbId = DefaultTypeConverter.INSTANCE.intValue((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID));
            if (null == this.findShareDetailsForId(dbId)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Node with nodeRef='" + nodeRef + "' and dbId='" + dbId + "' is not in NFS server cache"));
                }
                return;
            }
            this.cachedNodes.put(nodeRef, dbId);
            String oldName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)before.get(ContentModel.PROP_NAME));
            String newName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)after.get(ContentModel.PROP_NAME));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("oldName='" + oldName + "', newName='" + newName + "'"));
            }
            if (null == oldName && null != newName || null != oldName && !oldName.equals(newName)) {
                this.updateNfsCache(nodeRef, null);
            }
        }
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
        if (this.enabled.booleanValue() && null != this.nfsServer && null != nodeRef && this.targetStoreRef.equals((Object)nodeRef.getStoreRef())) {
            int dbId = DefaultTypeConverter.INSTANCE.intValue((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID));
            this.cachedNodes.put(nodeRef, dbId);
        }
    }

    @Override
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        this.updateNfsCache(childAssocRef.getChildRef(), null);
    }

    @Override
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean isNewNode) {
        this.updateNfsCache(childAssocRef.getChildRef(), null);
    }

    @Override
    public void onDeleteChildAssociation(ChildAssociationRef childAssocRef) {
        this.updateNfsCache(childAssocRef.getChildRef(), null);
    }

    private ShareDetails findShareDetailsForId(int fileId) {
        if (null == this.nfsServer || null == this.nfsServer.getShareDetails()) {
            return null;
        }
        Hashtable details = this.nfsServer.getShareDetails().getShareDetails();
        for (Integer key : details.keySet()) {
            ShareDetails shareDetails = (ShareDetails)details.get(key);
            if (null == shareDetails.getFileIdCache().findPath(fileId)) continue;
            return shareDetails;
        }
        return null;
    }

    private void updateNfsCache(NodeRef nodeRef, String newPath) {
        if (!this.enabled.booleanValue() || this.nfsServer == null || !this.targetStoreRef.equals((Object)nodeRef.getStoreRef())) {
            return;
        }
        int dbId = -1;
        if (this.cachedNodes.containsKey(nodeRef)) {
            dbId = null != this.cachedNodes.get(nodeRef) ? this.cachedNodes.get(nodeRef) : -1;
            this.cachedNodes.remove(nodeRef);
        } else if (this.nodeService.exists(nodeRef)) {
            dbId = DefaultTypeConverter.INSTANCE.intValue((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID));
        }
        ShareDetails shareDetails = this.findShareDetailsForId(dbId);
        if (null != shareDetails) {
            if (null != newPath) {
                shareDetails.getFileIdCache().addPath(dbId, newPath);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Path='" + newPath + "' in cache was set for NodeRef='" + nodeRef + "', dbId ='" + dbId + "'"));
                }
            } else {
                shareDetails.getFileIdCache().deletePath(dbId);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Cache field for node with NodeRef='" + nodeRef + "', dbId='" + dbId + "' was removed"));
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof NfsServerNodeMonitor) {
            NfsServerNodeMonitor converted = (NfsServerNodeMonitor)obj;
            return this.areEqual(this.targetDeviceName, converted.getTargetDeviceName()) && this.areEqual(this.targetStoreRef, converted.getTargetStoreRef());
        }
        return false;
    }

    private boolean areEqual(Object left, Object right) {
        return null != left ? left.equals(right) : null == right;
    }

    public int hashCode() {
        int result = null != this.targetDeviceName ? this.targetDeviceName.hashCode() : 31;
        return result * 37 + (null != this.targetStoreRef ? this.targetStoreRef.hashCode() : 43);
    }
}

