/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.avm;

import java.util.Enumeration;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.avm.AVMContext;
import org.alfresco.filesys.avm.AVMDiskDriver;
import org.alfresco.filesys.config.ServerConfigurationBean;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.InvalidDeviceInterfaceException;
import org.alfresco.jlan.server.core.ShareMapper;
import org.alfresco.jlan.server.core.ShareType;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.core.SharedDeviceList;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.jlan.util.StringList;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMWrongTypeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.extensions.config.ConfigElement;

public class AVMShareMapper
implements ShareMapper,
InitializingBean {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.smb.protocol");
    private static final String AVM_SHAREPATTERN = "[a-zA-Z0-9-]*_[0-9]+";
    private ServerConfiguration m_config;
    private FilesystemsConfigSection m_filesysConfig;
    private StringList m_avmShareNames;
    private AVMDiskDriver m_driver;
    private boolean m_debug;

    public void setServerConfiguration(ServerConfiguration config) {
        this.m_config = config;
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public void initializeMapper(ServerConfiguration config, ConfigElement params) throws InvalidConfigurationException {
        this.setServerConfiguration(config);
        if (params != null && params.getChild("debug") != null) {
            this.setDebug(true);
        }
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        this.m_filesysConfig = (FilesystemsConfigSection)this.m_config.getConfigSection("Filesystems");
        this.m_avmShareNames = new StringList();
        SharedDeviceList shrList = this.m_filesysConfig.getShares();
        Enumeration shrEnum = shrList.enumerateShares();
        while (shrEnum.hasMoreElements()) {
            SharedDevice curShare = (SharedDevice)shrEnum.nextElement();
            try {
                if (!(curShare.getInterface() instanceof AVMDiskDriver)) continue;
                this.m_avmShareNames.addString(curShare.getName());
                if (this.m_driver != null) continue;
                this.m_driver = (AVMDiskDriver)curShare.getInterface();
            }
            catch (InvalidDeviceInterfaceException ex) {}
        }
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public SharedDeviceList getShareList(String host, SrvSession sess, boolean allShares) {
        SharedDeviceList shrList = new SharedDeviceList(this.m_filesysConfig.getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShareList());
        }
        if (!allShares) {
            shrList.removeUnavailableShares();
        }
        return shrList;
    }

    public SharedDevice findShare(String tohost, String name, int typ, SrvSession sess, boolean create) throws Exception {
        SharedDevice share;
        block17: {
            share = this.m_filesysConfig.getShares().findShare(name, typ, false);
            if (share == null) {
                share = this.m_filesysConfig.getShares().findShare(name, typ, true);
            }
            if (share == null && (typ == 0 || typ == -1)) {
                if (sess.hasDynamicShares()) {
                    share = sess.getDynamicShareList().findShare(name, typ, false);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("  Reusing existing dynamic share for " + name));
                    }
                }
                if (share == null && create && name.matches(AVM_SHAREPATTERN)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Map dynamic share " + name + ", type=" + ShareType.TypeAsString((int)typ)));
                    }
                    int pos = name.indexOf(95);
                    String storePath = name.substring(0, pos) + ":/";
                    int storeVersion = -1;
                    try {
                        String storeVer = name.substring(pos + 1);
                        storeVersion = Integer.parseInt(storeVer);
                        if (storeVersion < 0) {
                            storeVersion = -1;
                        }
                    }
                    catch (NumberFormatException ex) {
                        logger.error((Object)("Invalid store version id, name=" + name));
                    }
                    if (storePath.length() > 0 && storeVersion != -1) {
                        AVMService avmService = this.m_driver.getAvmService();
                        this.m_driver.beginReadTransaction(sess);
                        try {
                            avmService.lookup(storeVersion, storePath);
                            AVMContext avmCtx = new AVMContext(name, storePath, storeVersion);
                            if (!(this.m_config instanceof ServerConfigurationBean)) {
                                throw new AlfrescoRuntimeException("configuration error, unknown configuration bean");
                            }
                            ServerConfigurationBean config = (ServerConfigurationBean)this.m_config;
                            config.initialiseRuntimeContext(avmCtx);
                            DiskSharedDevice diskShare = new DiskSharedDevice(name, (DeviceInterface)this.m_driver, (DiskDeviceContext)avmCtx, 8);
                            sess.addDynamicShare((SharedDevice)diskShare);
                            share = diskShare;
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("  Mapped share " + name + " - " + diskShare));
                            }
                        }
                        catch (AVMNotFoundException ex) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Failed to map share to " + name + ", not such store/version"));
                            }
                        }
                        catch (AVMWrongTypeException ex) {
                            if (!logger.isDebugEnabled()) break block17;
                            logger.debug((Object)("Failed to map share to " + name + ", wrong type"));
                        }
                    }
                }
            }
        }
        if (share != null && share.getContext() != null && !share.getContext().isAvailable()) {
            share = null;
        }
        return share;
    }

    public void deleteShares(SrvSession sess) {
        if (!sess.hasDynamicShares()) {
            return;
        }
        SharedDeviceList shares = sess.getDynamicShareList();
        Enumeration enm = shares.enumerateShares();
        while (enm.hasMoreElements()) {
            SharedDevice shr = (SharedDevice)enm.nextElement();
            shr.getContext().CloseContext();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Deleted dynamic share " + shr));
        }
        shares.removeAllShares();
    }

    public void closeMapper() {
    }
}

