/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.avm;

import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileName;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFile;
import org.alfresco.jlan.server.filesys.pseudo.PseudoFolderNetworkFile;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;

public class StorePseudoFile
extends PseudoFile {
    private int m_storeType = 0;
    private String m_webProject;
    private String m_userName;

    public StorePseudoFile(AVMStoreDescriptor storeDesc, String relPath, int storeType) {
        super(storeDesc.getName(), 17);
        FileInfo fInfo = new FileInfo(storeDesc.getName(), 0L, 17);
        fInfo.setCreationDateTime(storeDesc.getCreateDate());
        fInfo.setModifyDateTime(storeDesc.getCreateDate());
        fInfo.setAccessDateTime(storeDesc.getCreateDate());
        fInfo.setChangeDateTime(storeDesc.getCreateDate());
        fInfo.setPath(relPath);
        fInfo.setFileId(relPath.hashCode());
        this.setFileInfo(fInfo);
        this.setStoreType(storeType);
    }

    public StorePseudoFile(String storeName, String relPath) {
        super(storeName, 17);
        FileInfo fInfo = new FileInfo(storeName, 0L, 17);
        long timeNow = System.currentTimeMillis();
        fInfo.setCreationDateTime(timeNow);
        fInfo.setModifyDateTime(timeNow);
        fInfo.setAccessDateTime(timeNow);
        fInfo.setChangeDateTime(timeNow);
        fInfo.setPath(relPath);
        fInfo.setFileId(relPath.hashCode());
        this.setFileInfo(fInfo);
    }

    public NetworkFile getFile(String netPath) {
        String[] paths = FileName.splitPath((String)netPath);
        return new PseudoFolderNetworkFile(paths[1], netPath);
    }

    public FileInfo getFileInfo() {
        return this.getInfo();
    }

    public final int isStoreType() {
        return this.m_storeType;
    }

    public final boolean hasWebProject() {
        return this.m_webProject != null;
    }

    public final String getWebProject() {
        return this.m_webProject;
    }

    public final void setWebProject(String webProject) {
        this.m_webProject = webProject;
    }

    public final boolean hasUserName() {
        return this.m_userName != null;
    }

    public final String getUserName() {
        return this.m_userName;
    }

    public final void setUserName(String userName) {
        this.m_userName = userName;
    }

    public final void setStoreType(int storeType) {
        this.m_storeType = storeType;
    }
}

