/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentFileInfo;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskInterface;
import org.alfresco.jlan.server.filesys.DiskSizeInterface;
import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.IOControlNotImplementedException;
import org.alfresco.jlan.server.filesys.IOCtlInterface;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.SrvDiskInfo;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.jlan.server.filesys.cache.FileState;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.server.locking.FileLockingInterface;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockInterface;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.util.DataBuffer;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedContentDiskDriver
implements ExtendedDiskInterface,
DiskInterface,
DiskSizeInterface,
IOCtlInterface,
OpLockInterface,
FileLockingInterface,
NodeServicePolicies.OnDeleteNodePolicy,
NodeServicePolicies.OnMoveNodePolicy {
    private static final Log logger = LogFactory.getLog(BufferedContentDiskDriver.class);
    private ExtendedDiskInterface diskInterface;
    private DiskSizeInterface diskSizeInterface;
    private IOCtlInterface ioctlInterface;
    private OpLockInterface opLockInterface;
    private FileLockingInterface fileLockingInterface;
    private PolicyComponent policyComponent;
    private SimpleCache<Serializable, FileInfo> fileInfoCache;

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"diskInterface", (Object)this.diskInterface);
        PropertyCheck.mandatory((Object)this, (String)"diskSizeInterface", (Object)this.diskSizeInterface);
        PropertyCheck.mandatory((Object)this, (String)"ioctltInterface", (Object)this.ioctlInterface);
        PropertyCheck.mandatory((Object)this, (String)"fileInfoCache", this.fileInfoCache);
        PropertyCheck.mandatory((Object)this, (String)"fileLockingInterface", (Object)this.getFileLockingInterface());
        PropertyCheck.mandatory((Object)this, (String)"opLockInterface", (Object)this.getOpLockInterface());
        PropertyCheck.mandatory((Object)this, (String)"fileLockingInterface", (Object)this.fileLockingInterface);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.getPolicyComponent());
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.OnDeleteNodePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onDeleteNode"));
        this.getPolicyComponent().bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, this, (Behaviour)new JavaBehaviour(this, "onMoveNode"));
    }

    public void setFileInfoCache(SimpleCache<Serializable, FileInfo> cache) {
        this.fileInfoCache = cache;
    }

    private FileInfo getFileInformationInternal(SrvSession sess, TreeConnection tree, String path) throws IOException {
        String userName = AuthenticationUtil.getFullyAuthenticatedUser();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getFileInformation userName:" + userName + ", path:" + path));
        }
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        FileInfoKey key = new FileInfoKey(userName, path);
        FileInfo fromCache = (FileInfo)this.fileInfoCache.get((Serializable)key);
        if (fromCache != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"returning FileInfo from cache");
            }
            return fromCache;
        }
        FileInfo info = this.diskInterface.getFileInformation(sess, tree, path);
        if (info != null && !info.isDirectory()) {
            this.fileInfoCache.put((Serializable)key, (Object)info);
        }
        if (info instanceof ContentFileInfo) {
            ContentFileInfo cinfo = (ContentFileInfo)info;
            this.fileInfoCache.put((Serializable)cinfo.getNodeRef(), (Object)info);
        }
        return info;
    }

    public FileInfo getFileInformation(SrvSession sess, TreeConnection tree, String path) throws IOException {
        FileStateCache cache;
        FileState fstate;
        ContentContext tctx = (ContentContext)tree.getContext();
        FileInfo info = this.getFileInformationInternal(sess, tree, path);
        if (tctx.hasStateCache() && (fstate = (cache = tctx.getStateCache()).findFileState(path, false)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("state cache available - overwriting from state cache: isDirectory=" + info.isDirectory()));
            }
            FileInfo finfo = new FileInfo();
            finfo.copyFrom(info);
            if (!info.isDirectory()) {
                if (fstate.hasFileSize()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("replace file size " + info.getSize() + " with " + fstate.getFileSize()));
                    }
                    finfo.setFileSize(fstate.getFileSize());
                }
                if (fstate.hasAccessDateTime()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("replace access date " + new Date(finfo.getAccessDateTime()) + " with " + new Date(fstate.getAccessDateTime())));
                    }
                    finfo.setAccessDateTime(fstate.getAccessDateTime());
                }
                if (fstate.hasChangeDateTime()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("replace change date " + new Date(finfo.getChangeDateTime()) + " with " + new Date(fstate.getChangeDateTime())));
                    }
                    finfo.setChangeDateTime(fstate.getChangeDateTime());
                }
                if (fstate.hasModifyDateTime()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("replace modified date " + new Date(finfo.getModifyDateTime()) + " with " + new Date(fstate.getModifyDateTime())));
                    }
                    finfo.setModifyDateTime(fstate.getModifyDateTime());
                }
                if (fstate.hasAllocationSize()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("replace allocation size" + finfo.getAllocationSize() + " with " + fstate.getAllocationSize()));
                    }
                    finfo.setAllocationSize(fstate.getAllocationSize());
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Return getFileInformation, path: " + path + ", returning:" + finfo + ", readOnly:" + finfo.isReadOnly() + ", fileId:" + finfo.getFileId() + ", fileSize:" + finfo.getSize() + ", directoryId:" + finfo.getDirectoryId() + ", createdDate: " + finfo.getCreationDateTime() + ", accessDate:" + new Date(finfo.getAccessDateTime()) + ", modifiedDate:" + new Date(finfo.getModifyDateTime()) + ", changeDate:" + new Date(finfo.getChangeDateTime()) + ", fileAttributes: 0x" + Integer.toHexString(info.getFileAttributes()) + ", mode: 0x" + Integer.toHexString(finfo.getMode())));
            }
            return finfo;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getFileInformation Return:" + path + " returning" + info));
        }
        return info;
    }

    public int fileExists(SrvSession sess, TreeConnection tree, String path) {
        FileInfoKey key;
        FileInfo fromCache;
        String userName = AuthenticationUtil.getFullyAuthenticatedUser();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("fileExists userName:" + userName + ", path:" + path));
        }
        if ((fromCache = (FileInfo)this.fileInfoCache.get((Serializable)(key = new FileInfoKey(userName, path)))) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"fileExists found FileInfo in cache");
            }
            if (fromCache.isDirectory()) {
                return 2;
            }
            return 1;
        }
        try {
            FileInfo lookup = this.getFileInformationInternal(sess, tree, path);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"fileExists obtained file information");
            }
            if (lookup.isDirectory()) {
                return 2;
            }
            return 1;
        }
        catch (IOException ie) {
            return 0;
        }
    }

    public DeviceContext createContext(String shareName, ConfigElement args) throws DeviceContextException {
        return this.diskInterface.createContext(shareName, args);
    }

    public void treeOpened(SrvSession sess, TreeConnection tree) {
        this.diskInterface.treeOpened(sess, tree);
    }

    public void treeClosed(SrvSession sess, TreeConnection tree) {
        this.diskInterface.treeClosed(sess, tree);
    }

    public DataBuffer processIOControl(SrvSession sess, TreeConnection tree, int ctrlCode, int fid, DataBuffer dataBuf, boolean isFSCtrl, int filter) throws IOControlNotImplementedException, SMBException {
        return this.ioctlInterface.processIOControl(sess, tree, ctrlCode, fid, dataBuf, isFSCtrl, filter);
    }

    public void getDiskInformation(DiskDeviceContext ctx, SrvDiskInfo diskDev) throws IOException {
        this.diskSizeInterface.getDiskInformation(ctx, diskDev);
    }

    public void closeFile(SrvSession sess, TreeConnection tree, NetworkFile param) throws IOException {
        this.diskInterface.closeFile(sess, tree, param);
        if (!param.isDirectory() && !param.isReadOnly()) {
            this.fileInfoCache.clear();
        }
    }

    public void createDirectory(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        this.diskInterface.createDirectory(sess, tree, params);
    }

    public NetworkFile createFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        return this.diskInterface.createFile(sess, tree, params);
    }

    public void deleteDirectory(SrvSession sess, TreeConnection tree, String dir) throws IOException {
        this.fileInfoCache.remove((Serializable)((Object)dir));
        this.diskInterface.deleteDirectory(sess, tree, dir);
    }

    public void deleteFile(SrvSession sess, TreeConnection tree, String name) throws IOException {
        this.fileInfoCache.remove((Serializable)((Object)name));
        this.diskInterface.deleteFile(sess, tree, name);
    }

    public void flushFile(SrvSession sess, TreeConnection tree, NetworkFile file) throws IOException {
        this.diskInterface.flushFile(sess, tree, file);
    }

    public boolean isReadOnly(SrvSession sess, DeviceContext ctx) throws IOException {
        return this.diskInterface.isReadOnly(sess, ctx);
    }

    public NetworkFile openFile(SrvSession sess, TreeConnection tree, FileOpenParams params) throws IOException {
        return this.diskInterface.openFile(sess, tree, params);
    }

    public int readFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufPos, int siz, long filePos) throws IOException {
        return this.diskInterface.readFile(sess, tree, file, buf, bufPos, siz, filePos);
    }

    public void renameFile(SrvSession sess, TreeConnection tree, String oldName, String newName) throws IOException {
        this.diskInterface.renameFile(sess, tree, oldName, newName);
    }

    public long seekFile(SrvSession sess, TreeConnection tree, NetworkFile file, long pos, int typ) throws IOException {
        return this.diskInterface.seekFile(sess, tree, file, pos, typ);
    }

    public void setFileInformation(SrvSession sess, TreeConnection tree, String name, FileInfo info) throws IOException {
        this.diskInterface.setFileInformation(sess, tree, name, info);
    }

    public SearchContext startSearch(SrvSession sess, TreeConnection tree, String searchPath, int attrib) throws FileNotFoundException {
        return this.diskInterface.startSearch(sess, tree, searchPath, attrib);
    }

    public void truncateFile(SrvSession sess, TreeConnection tree, NetworkFile file, long siz) throws IOException {
        this.diskInterface.truncateFile(sess, tree, file, siz);
    }

    public int writeFile(SrvSession sess, TreeConnection tree, NetworkFile file, byte[] buf, int bufoff, int siz, long fileoff) throws IOException {
        return this.diskInterface.writeFile(sess, tree, file, buf, bufoff, siz, fileoff);
    }

    @Override
    public void registerContext(DeviceContext ctx) throws DeviceContextException {
        this.diskInterface.registerContext(ctx);
    }

    public void setDiskInterface(ExtendedDiskInterface diskInterface) {
        this.diskInterface = diskInterface;
    }

    public ExtendedDiskInterface getDiskInterface() {
        return this.diskInterface;
    }

    public void setDiskSizeInterface(DiskSizeInterface diskSizeInterface) {
        this.diskSizeInterface = diskSizeInterface;
    }

    public DiskSizeInterface getDiskSizeInterface() {
        return this.diskSizeInterface;
    }

    public void setIoctlInterface(IOCtlInterface iocltlInterface) {
        this.ioctlInterface = iocltlInterface;
    }

    public IOCtlInterface getIoctlInterface() {
        return this.ioctlInterface;
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        if (this.fileInfoCache.contains((Serializable)oldChildAssocRef.getChildRef())) {
            logger.debug((Object)"cached node moved - clear the cache");
            this.fileInfoCache.clear();
        }
    }

    @Override
    public void onDeleteNode(ChildAssociationRef oldChildAssocRef, boolean isArchived) {
        if (this.fileInfoCache.contains((Serializable)oldChildAssocRef.getChildRef())) {
            logger.debug((Object)"cached node deleted - clear the cache");
            this.fileInfoCache.clear();
        }
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public PolicyComponent getPolicyComponent() {
        return this.policyComponent;
    }

    public void setOpLockInterface(OpLockInterface opLockInterface) {
        this.opLockInterface = opLockInterface;
    }

    public OpLockInterface getOpLockInterface() {
        return this.opLockInterface;
    }

    public OpLockManager getOpLockManager(SrvSession sess, TreeConnection tree) {
        return this.opLockInterface.getOpLockManager(sess, tree);
    }

    public boolean isOpLocksEnabled(SrvSession sess, TreeConnection tree) {
        return this.opLockInterface.isOpLocksEnabled(sess, tree);
    }

    public LockManager getLockManager(SrvSession sess, TreeConnection tree) {
        return this.getFileLockingInterface().getLockManager(sess, tree);
    }

    public void setFileLockingInterface(FileLockingInterface fileLockingInterface) {
        this.fileLockingInterface = fileLockingInterface;
    }

    public FileLockingInterface getFileLockingInterface() {
        return this.fileLockingInterface;
    }

    private class FileInfoKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String path;
        String user;
        int hashCode;

        public FileInfoKey(String user, String path) {
            this.path = path;
            this.user = user;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !(other instanceof FileInfoKey)) {
                return false;
            }
            FileInfoKey o = (FileInfoKey)other;
            return this.path.equals(o.path) && this.user.equals(o.user);
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = (this.user + this.path).hashCode();
            }
            return this.hashCode;
        }
    }
}

