/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.File;
import java.io.FileOutputStream;
import junit.framework.TestCase;
import org.alfresco.filesys.repo.CIFSContentComparator;
import org.alfresco.filesys.repo.ContentDiskDriverTest;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;

public class CIFSContentComparatorTest
extends TestCase {
    private static Log logger = LogFactory.getLog(ContentDiskDriverTest.class);

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testPlainTextCompareContent() throws Exception {
        CIFSContentComparator contentComparator = new CIFSContentComparator();
        contentComparator.init();
        File file1 = TempFileProvider.createTempFile((String)"testCIFSContentComparator", (String)"txt");
        File file2 = TempFileProvider.createTempFile((String)"testCIFSContentComparator", (String)"txt");
        FileContentReader existingContent = new FileContentReader(file1);
        boolean result = contentComparator.isContentEqual(existingContent, file1);
        CIFSContentComparatorTest.assertTrue((String)"compare the same empty file, should be equal", (boolean)result);
        FileContentReader reader = new FileContentReader(file2);
        result = contentComparator.isContentEqual(reader, file1);
        CIFSContentComparatorTest.assertTrue((String)"compare two empty files, should be equal", (boolean)result);
        FileOutputStream os1 = new FileOutputStream(file1);
        os1.write("The quick brown fox".getBytes("UTF-8"));
        os1.close();
        FileContentReader reader2 = new FileContentReader(file1);
        reader2.setMimetype("text/plain");
        reader2.setEncoding("UTF-8");
        boolean result2 = contentComparator.isContentEqual(reader2, file1);
        CIFSContentComparatorTest.assertTrue((String)"compare plain text file, should be equal", (boolean)result2);
        reader = new FileContentReader(file1);
        reader.setMimetype("text/plain");
        reader.setEncoding("UTF-8");
        result = contentComparator.isContentEqual(reader, file2);
        CIFSContentComparatorTest.assertTrue((String)"compare plain text file, should not be equal", (!result ? 1 : 0) != 0);
        FileOutputStream os2 = new FileOutputStream(file2);
        os2.write("The quick fox brown".getBytes("UTF-8"));
        os2.close();
        CIFSContentComparatorTest.assertTrue((String)"test error test files different length", (file1.length() == file2.length() ? 1 : 0) != 0);
        reader = new FileContentReader(file1);
        reader.setMimetype("text/plain");
        reader.setEncoding("UTF-8");
        result2 = contentComparator.isContentEqual(reader, file2);
        CIFSContentComparatorTest.assertTrue((String)"compare different text file, should not be equal", (!result2 ? 1 : 0) != 0);
    }

    public void testProjectFiles() throws Exception {
        CIFSContentComparator contentComparator = new CIFSContentComparator();
        contentComparator.init();
        ClassPathResource file0Resource = new ClassPathResource("filesys/ContentComparatorTest0.mpp");
        CIFSContentComparatorTest.assertNotNull((String)"unable to find test resource filesys/filesys/ContentComparatorTest0.mpp", (Object)file0Resource);
        ClassPathResource file1Resource = new ClassPathResource("filesys/ContentComparatorTest1.mpp");
        CIFSContentComparatorTest.assertNotNull((String)"unable to find test resource filesys/filesys/ContentComparatorTest1.mpp", (Object)file1Resource);
        ClassPathResource file2Resource = new ClassPathResource("filesys/ContentComparatorTest2.mpp");
        CIFSContentComparatorTest.assertNotNull((String)"unable to find test resource filesys/filesys/ContentComparatorTest2.mpp", (Object)file1Resource);
        File textFile = TempFileProvider.createTempFile((String)"testCIFSContentComparator", (String)"txt");
        FileOutputStream os1 = new FileOutputStream(textFile);
        os1.write("The quick brown fox".getBytes("UTF-8"));
        os1.close();
        File file1 = file1Resource.getFile();
        FileContentReader reader = new FileContentReader(file1);
        reader.setMimetype("application/vnd.ms-project");
        reader.setEncoding("UTF-8");
        boolean result = contentComparator.isContentEqual(reader, file1);
        CIFSContentComparatorTest.assertTrue((String)"compare same project file, should be equal", (boolean)result);
        file1 = file1Resource.getFile();
        reader = new FileContentReader(file1);
        reader.setMimetype("application/vnd.ms-project");
        reader.setEncoding("UTF-8");
        result = contentComparator.isContentEqual(reader, textFile);
        CIFSContentComparatorTest.assertTrue((String)"compare project file with text file, should not be equal", (!result ? 1 : 0) != 0);
        file1 = file1Resource.getFile();
        File file2 = file2Resource.getFile();
        FileContentReader reader2 = new FileContentReader(file1);
        reader2.setMimetype("application/vnd.ms-project");
        reader2.setEncoding("UTF-8");
        boolean result2 = contentComparator.isContentEqual(reader2, file2);
        CIFSContentComparatorTest.assertTrue((String)"compare different project file, should not be equal", (!result2 ? 1 : 0) != 0);
    }

    public void testProjectTrivialDiffProjectFiles() throws Exception {
        CIFSContentComparator contentComparator = new CIFSContentComparator();
        contentComparator.init();
        ClassPathResource file0Resource = new ClassPathResource("filesys/ContentComparatorTest0.mpp");
        CIFSContentComparatorTest.assertNotNull((String)"unable to find test resource filesys/filesys/ContentComparatorTest0.mpp", (Object)file0Resource);
        ClassPathResource file1Resource = new ClassPathResource("filesys/ContentComparatorTest1.mpp");
        CIFSContentComparatorTest.assertNotNull((String)"unable to find test resource filesys/filesys/ContentComparatorTest1.mpp", (Object)file1Resource);
        File file0 = file0Resource.getFile();
        File file1 = file1Resource.getFile();
        FileContentReader reader = new FileContentReader(file0);
        reader.setMimetype("application/vnd.ms-project");
        reader.setEncoding("UTF-8");
        boolean result = contentComparator.isContentEqual(reader, file1);
        CIFSContentComparatorTest.assertTrue((String)"compare trivially different project file, should be equal", (boolean)result);
    }
}

