/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.transaction.UserTransaction;
import javax.xml.ws.Holder;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.repo.CifsHelper;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.auth.ClientInfo;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.filesys.AccessDeniedException;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FileExistsException;
import org.alfresco.jlan.server.filesys.FileOpenParams;
import org.alfresco.jlan.server.filesys.NetworkFile;
import org.alfresco.jlan.server.filesys.NetworkFileServer;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.TreeConnection;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transfer.TransferModel;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionCondition;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.CompositeAction;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDiskDriverTest
extends TestCase {
    private static final String TEST_PROTOTYPE_NAME = "test";
    private static final String TEST_REMOTE_NAME = "remoteName";
    private static final String TEST_SERVER_NAME = "testServer";
    private static final String TEST_USER_AUTHORITY = "userx";
    private Repository repositoryHelper;
    private CifsHelper cifsHelper;
    private ExtendedDiskInterface driver;
    private NodeService mlAwareNodeService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private ContentService contentService;
    private RuleService ruleService;
    private ActionService actionService;
    private PersonService personService;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;
    private OwnableService ownableService;
    private FileFolderService fileFolderService;
    private CheckOutCheckInService checkOutCheckInService;
    private static Log logger = LogFactory.getLog(ContentDiskDriverTest.class);
    final String SHARE_NAME = "test";
    final String STORE_NAME = "workspace://SpacesStore";
    final String ROOT_PATH = "/app:company_home";
    private ApplicationContext applicationContext;
    private final String TEST_ROOT_PATH = "ContentDiskDriverTest";
    private final String TEST_ROOT_DOS_PATH = "\\ContentDiskDriverTest";

    protected void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext();
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        ApplicationContextFactory fileServers = (ApplicationContextFactory)this.applicationContext.getBean("fileServers");
        this.cifsHelper = (CifsHelper)fileServers.getApplicationContext().getBean("cifsHelper");
        this.driver = (ExtendedDiskInterface)this.applicationContext.getBean("contentDiskDriver");
        this.mlAwareNodeService = (NodeService)this.applicationContext.getBean("mlAwareNodeService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.ruleService = (RuleService)this.applicationContext.getBean("ruleService");
        this.actionService = (ActionService)this.applicationContext.getBean("actionService");
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        this.ownableService = (OwnableService)this.applicationContext.getBean("ownableService");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("fileFolderService");
        this.checkOutCheckInService = (CheckOutCheckInService)this.applicationContext.getBean("checkOutCheckInService");
        ContentDiskDriverTest.assertNotNull((String)"content disk driver is null", (Object)this.driver);
        ContentDiskDriverTest.assertNotNull((String)"repositoryHelper is null", (Object)this.repositoryHelper);
        ContentDiskDriverTest.assertNotNull((String)"mlAwareNodeService is null", (Object)this.mlAwareNodeService);
        ContentDiskDriverTest.assertNotNull((String)"nodeService is null", (Object)this.nodeService);
        ContentDiskDriverTest.assertNotNull((String)"transactionService is null", (Object)this.transactionService);
        ContentDiskDriverTest.assertNotNull((String)"contentService is null", (Object)this.contentService);
        ContentDiskDriverTest.assertNotNull((String)"ruleService is null", (Object)this.ruleService);
        ContentDiskDriverTest.assertNotNull((String)"actionService is null", (Object)this.actionService);
        ContentDiskDriverTest.assertNotNull((String)"cifsHelper", (Object)this.cifsHelper);
        ContentDiskDriverTest.assertNotNull((String)"checkOutCheckInService", (Object)this.checkOutCheckInService);
        AuthenticationUtil.setRunAsUserSystem();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> removeRootCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                NodeRef rootNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "ContentDiskDriverTest");
                if (rootNode != null) {
                    logger.debug((Object)"Clean up test root node");
                    ContentDiskDriverTest.this.nodeService.deleteNode(rootNode);
                }
                return null;
            }
        };
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        tran.doInTransaction(removeRootCB, false, true);
    }

    protected void tearDown() throws Exception {
    }

    private DiskSharedDevice getDiskSharedDevice() throws DeviceContextException {
        ContentContext ctx = new ContentContext("testContext", "workspace://SpacesStore", "/app:company_home", this.repositoryHelper.getCompanyHome());
        DiskSharedDevice share = new DiskSharedDevice(TEST_PROTOTYPE_NAME, (DeviceInterface)this.driver, (DiskDeviceContext)ctx);
        return share;
    }

    public void testGetFileInformation() throws Exception {
        logger.debug((Object)"testGetFileInformation");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        TestContext testContext = new TestContext();
        org.alfresco.jlan.server.filesys.FileInfo finfo = this.driver.getFileInformation(testSession, testConnection, "");
        ContentDiskDriverTest.assertNotNull((String)"root info is null", (Object)finfo);
        ContentDiskDriverTest.assertEquals((String)"root has a unexpected file name", (String)"", (String)finfo.getFileName());
    }

    public void testCreateFile() throws Exception {
        logger.debug((Object)"testCreatedFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        int openAction = 16;
        String FILE_NAME = "testCreateFileA.new";
        String FILE_PATH = "\\testCreateFileA.new";
        FileOpenParams params = new FileOpenParams("\\testCreateFileA.new", openAction, 2, 128, 0);
        final NetworkFile file = this.driver.createFile(testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeStuffCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, file, stuff, 0, stuff.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                return null;
            }
        };
        tran.doInTransaction(writeStuffCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                NodeRef newNode;
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                testContext.testNodeRef = newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testCreateFileA.new");
                Assert.assertNotNull((String)"can't find new node", (Object)newNode);
                Serializable content = ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"content is null", (Object)content);
                return null;
            }
        };
        tran.doInTransaction(validateCB);
        org.alfresco.jlan.server.filesys.FileInfo info = this.driver.getFileInformation(testSession, testConnection, "\\testCreateFileA.new");
        ContentDiskDriverTest.assertNotNull((String)"info is null", (Object)info);
        NodeRef n2 = this.getNodeForPath(testConnection, "\\testCreateFileA.new");
        ContentDiskDriverTest.assertEquals((String)"get Node For Path returned different node", (Object)testContext.testNodeRef, (Object)n2);
        try {
            this.driver.createFile(testSession, testConnection, params);
            ContentDiskDriverTest.fail((String)"File exists not detected");
        }
        catch (FileExistsException fe) {
            // empty catch block
        }
        this.driver.deleteFile(testSession, testConnection, "\\testCreateFileA.new");
        String FILE2_PATH = "\\ContentDiskDriverTest\\testCreateFileA.new";
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", openAction, 0, 16, 0);
        this.driver.createDirectory(testSession, testConnection, dirParams);
        FileOpenParams file2Params = new FileOpenParams(FILE2_PATH, openAction, 0, 128, 0);
        NetworkFile file2 = this.driver.createFile(testSession, testConnection, file2Params);
        this.driver.deleteFile(testSession, testConnection, FILE2_PATH);
    }

    public void testDeleteFile() throws Exception {
        logger.debug((Object)"testDeleteFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        int openAction = 16;
        String FILE_PATH = "\\testDeleteFileX.new";
        FileOpenParams params = new FileOpenParams(FILE_PATH, openAction, 2, 128, 0);
        final NetworkFile file = this.driver.createFile(testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeStuffCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                file.writeFile(stuff, stuff.length, 0, 0L);
                file.close();
                return null;
            }
        };
        tran.doInTransaction(writeStuffCB);
        this.driver.deleteFile(testSession, testConnection, FILE_PATH);
        try {
            this.driver.deleteFile(testSession, testConnection, FILE_PATH);
            ContentDiskDriverTest.fail((String)"delete a non existent file");
        }
        catch (IOException fe) {
            // empty catch block
        }
    }

    public void testSetFileInfo() throws Exception {
        logger.debug((Object)"testSetFileInfo");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        Date now = new Date();
        final Date CREATED = new Date(now.getTime() - 21600000L);
        final Date MODIFIED = new Date(now.getTime() - 3600000L);
        class TestContext {
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        int openAction = 16;
        String FILE_NAME = "testSetFileInfo.txt";
        String FILE_PATH = "\\testSetFileInfo.txt";
        try {
            this.driver.deleteFile(testSession, testConnection, "\\testSetFileInfo.txt");
        }
        catch (IOException ie) {
            // empty catch block
        }
        final FileOpenParams params = new FileOpenParams("\\testSetFileInfo.txt", openAction, 2, 128, 0);
        final NetworkFile file = this.driver.createFile(testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeStuffCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, file, stuff, 0, stuff.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                org.alfresco.jlan.server.filesys.FileInfo info = ContentDiskDriverTest.this.driver.getFileInformation(testSession, testConnection, "\\testSetFileInfo.txt");
                info.setFileInformationFlags(8);
                info.setModifyDateTime(MODIFIED.getTime());
                ContentDiskDriverTest.this.driver.setFileInformation(testSession, testConnection, "\\testSetFileInfo.txt", info);
                return null;
            }
        };
        tran.doInTransaction(writeStuffCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                NodeRef newNode;
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                testContext.testNodeRef = newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testSetFileInfo.txt");
                Assert.assertNotNull((String)"can't find new node", (Object)newNode);
                Serializable content = ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"content is null", (Object)content);
                Date modified = (Date)ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_MODIFIED);
                Assert.assertEquals((String)"modified time not set correctly", (Object)MODIFIED, (Object)modified);
                return null;
            }
        };
        tran.doInTransaction(validateCB);
        logger.debug((Object)"Step 2: Change the created date");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> changeCreatedCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                org.alfresco.jlan.server.filesys.FileInfo info = ContentDiskDriverTest.this.driver.getFileInformation(testSession, testConnection, "\\testSetFileInfo.txt");
                info.setFileInformationFlags(16);
                info.setCreationDateTime(CREATED.getTime());
                ContentDiskDriverTest.this.driver.setFileInformation(testSession, testConnection, "\\testSetFileInfo.txt", info);
                return null;
            }
        };
        tran.doInTransaction(changeCreatedCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCreatedCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                NodeRef newNode;
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                testContext.testNodeRef = newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testSetFileInfo.txt");
                Assert.assertNotNull((String)"can't find new node", (Object)newNode);
                Serializable content = ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"content is null", (Object)content);
                Date created = (Date)ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_CREATED);
                Assert.assertEquals((String)"created time not set correctly", (Object)CREATED, (Object)created);
                return null;
            }
        };
        tran.doInTransaction(validateCreatedCB);
        logger.debug((Object)"Step 3: test deleteOnClose");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOnCloseCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NetworkFile f2 = ContentDiskDriverTest.this.driver.openFile(testSession, testConnection, params);
                org.alfresco.jlan.server.filesys.FileInfo info = ContentDiskDriverTest.this.driver.getFileInformation(testSession, testConnection, "\\testSetFileInfo.txt");
                info.setFileInformationFlags(1024);
                ContentDiskDriverTest.this.driver.setFileInformation(testSession, testConnection, "\\testSetFileInfo.txt", info);
                file.setDeleteOnClose(true);
                byte[] stuff = "Update".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, file, stuff, 0, stuff.length, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                return null;
            }
        };
        tran.doInTransaction(deleteOnCloseCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateDeleteOnCloseCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                NodeRef newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testSetFileInfo.txt");
                Assert.assertNull((String)"can still find new node", (Object)newNode);
                return null;
            }
        };
        tran.doInTransaction(validateDeleteOnCloseCB);
    }

    public void testOpenFile() throws Exception {
        logger.debug((Object)"testOpenFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            NodeRef testDirNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String FILE_NAME = "testOpenFile.txt";
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory(testSession, testConnection, dirParams);
        testContext.testDirNodeRef = this.getNodeForPath(testConnection, "\\ContentDiskDriverTest");
        String FILE_PATH = "\\ContentDiskDriverTest\\testOpenFile.txt";
        FileOpenParams params = new FileOpenParams("\\ContentDiskDriverTest\\testOpenFile.txt", 16, 2, 128, 0);
        try {
            NetworkFile file = this.driver.openFile(testSession, testConnection, params);
            ContentDiskDriverTest.fail((String)"managed to open non existant file!");
        }
        catch (IOException ie) {
            // empty catch block
        }
        logger.debug((Object)"Step 2) Open file created by node service");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                ChildAssociationRef ref = ContentDiskDriverTest.this.nodeService.createNode(testContext.testDirNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testOpenFile.txt"), ContentModel.TYPE_CONTENT);
                ContentDiskDriverTest.this.nodeService.setProperty(ref.getChildRef(), ContentModel.PROP_NAME, (Serializable)((Object)"testOpenFile.txt"));
                return null;
            }
        };
        tran.doInTransaction(createFileCB, false, true);
        NetworkFile file = this.driver.openFile(testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((Object)file);
        logger.debug((Object)"Step 3) Open the root directory");
        FileOpenParams rootParams = new FileOpenParams("\\", 16, 2, 128, 0);
        NetworkFile file3 = this.driver.openFile(testSession, testConnection, rootParams);
        ContentDiskDriverTest.assertNotNull((Object)file3);
    }

    public void testFileExists() throws Exception {
        logger.debug((Object)"testFileExists");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        String FILE_PATH = "\\ContentDiskDriverTest\\testFileExists.new";
        class TestContext {
            TestContext() {
            }
        }
        TestContext testContext = new TestContext();
        logger.debug((Object)"Step 1, negative test dir does not exist");
        int status = this.driver.fileExists(testSession, testConnection, "\\ContentDiskDriverTest");
        ContentDiskDriverTest.assertEquals((int)status, (int)0);
        logger.debug((Object)"Step 2, negative test file does not exist");
        status = this.driver.fileExists(testSession, testConnection, "\\ContentDiskDriverTest\\testFileExists.new");
        ContentDiskDriverTest.assertEquals((int)status, (int)0);
        int openAction = 16;
        FileOpenParams params = new FileOpenParams("\\ContentDiskDriverTest\\testFileExists.new", openAction, 2, 128, 0);
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory(testSession, testConnection, dirParams);
        final NetworkFile file = this.driver.createFile(testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                file.writeFile(stuff, stuff.length, 0, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                return null;
            }
        };
        tran.doInTransaction(createFileCB, false, true);
        status = this.driver.fileExists(testSession, testConnection, "\\ContentDiskDriverTest\\testFileExists.new");
        ContentDiskDriverTest.assertEquals((int)status, (int)1);
        logger.debug((Object)"Step 4, successfully delete node");
        this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testFileExists.new");
        status = this.driver.fileExists(testSession, testConnection, "\\ContentDiskDriverTest\\testFileExists.new");
        ContentDiskDriverTest.assertEquals((int)status, (int)0);
    }

    public void testRenameFile() throws Exception {
        logger.debug((Object)"testRenameFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        String FILE_PATH1 = "\\ContentDiskDriverTest\\SourceFile1.new";
        String FILE_NAME2 = "SourceFile2.new";
        String FILE_PATH2 = "\\ContentDiskDriverTest\\SourceFile2.new";
        String FILE_PATH3 = "\\ContentDiskDriverTest\\SourceFile3.new";
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory(testSession, testConnection, dirParams);
        FileOpenParams params1 = new FileOpenParams("\\ContentDiskDriverTest\\SourceFile1.new", 0, 2, 128, 0);
        NetworkFile file1 = this.driver.createFile(testSession, testConnection, params1);
        FileOpenParams params3 = new FileOpenParams("\\ContentDiskDriverTest\\SourceFile3.new", 0, 2, 128, 0);
        NetworkFile file3 = this.driver.createFile(testSession, testConnection, params3);
        try {
            this.driver.renameFile(testSession, testConnection, "\\Wibble\\wobble", "\\ContentDiskDriverTest\\SourceFile1.new");
            ContentDiskDriverTest.fail((String)"rename did not detect missing file");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\SourceFile1.new", "\\wibble\\wobble");
            ContentDiskDriverTest.fail((String)"rename did not detect missing file");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\SourceFile1.new", "\\ContentDiskDriverTest\\SourceFile3.new");
            ContentDiskDriverTest.fail((String)"rename did not detect missing file");
        }
        catch (IOException e) {
            // empty catch block
        }
        String LAST_NAME = "Bloggs";
        RetryingTransactionHelper.RetryingTransactionCallback<Void> setPropertiesCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\SourceFile1.new");
                Assert.assertNotNull((String)"node ref not found", (Object)file1NodeRef);
                ContentDiskDriverTest.this.nodeService.setProperty(file1NodeRef, ContentModel.PROP_LASTNAME, (Serializable)((Object)"Bloggs"));
                return null;
            }
        };
        tran.doInTransaction(setPropertiesCB, false, true);
        this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\SourceFile1.new", "\\ContentDiskDriverTest\\SourceFile2.new");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef file2NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\SourceFile2.new");
                Assert.assertEquals((Object)ContentDiskDriverTest.this.nodeService.getProperty(file2NodeRef, ContentModel.PROP_LASTNAME), (Object)"Bloggs");
                ChildAssociationRef parentRef = ContentDiskDriverTest.this.nodeService.getPrimaryParent(file2NodeRef);
                Assert.assertTrue((String)"file has wrong assoc local name", (boolean)parentRef.getQName().getLocalName().equals("SourceFile2.new"));
                Assert.assertTrue((String)"not primary assoc", (boolean)parentRef.isPrimary());
                return null;
            }
        };
        tran.doInTransaction(validateCB, false, true);
        String DIR_NEW_PATH = "\\ContentDiskDriverTest\\NewDir";
        String NEW_PATH = DIR_NEW_PATH + "\\File2";
        FileOpenParams params5 = new FileOpenParams(DIR_NEW_PATH, 0, 2, 128, 0);
        this.driver.createDirectory(testSession, testConnection, params5);
        NodeRef newDirNodeRef = this.getNodeForPath(testConnection, DIR_NEW_PATH);
        this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\SourceFile2.new", NEW_PATH);
        NodeRef file5NodeRef = this.getNodeForPath(testConnection, NEW_PATH);
        ChildAssociationRef parentRef5 = this.nodeService.getPrimaryParent(file5NodeRef);
        ContentDiskDriverTest.assertTrue((boolean)parentRef5.getParentRef().equals((Object)newDirNodeRef));
    }

    public void testScenarioRenameVersionableFile() throws Exception {
        logger.debug((Object)"testScenarioRenameVersionableFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        String FILE_PATH1 = "\\ContentDiskDriverTest\\SourceFile1.new";
        String FILE_PATH2 = "\\ContentDiskDriverTest\\SourceFile2.new";
        class TestContext {
            TestContext() {
            }
        }
        TestContext testContext = new TestContext();
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory(testSession, testConnection, dirParams);
        FileOpenParams params1 = new FileOpenParams("\\ContentDiskDriverTest\\SourceFile1.new", 0, 2, 128, 0);
        NetworkFile file1 = this.driver.createFile(testSession, testConnection, params1);
        String LAST_NAME = "Bloggs";
        RetryingTransactionHelper.RetryingTransactionCallback<Void> makeVersionableCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\SourceFile1.new");
                ContentDiskDriverTest.this.nodeService.addAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentWriter contentWriter2 = ContentDiskDriverTest.this.contentService.getWriter(file1NodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent("test rename versionable");
                ContentDiskDriverTest.this.nodeService.setProperty(file1NodeRef, ContentModel.PROP_LASTNAME, (Serializable)((Object)"Bloggs"));
                ContentDiskDriverTest.this.nodeService.setProperty(file1NodeRef, TransferModel.PROP_ENDPOINT_PROTOCOL, (Serializable)((Object)"http"));
                return null;
            }
        };
        tran.doInTransaction(makeVersionableCB, false, true);
        this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\SourceFile1.new", "\\ContentDiskDriverTest\\SourceFile2.new");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateVersionableCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef file2NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\SourceFile2.new");
                Assert.assertNotNull((String)"file2 node ref is null", (Object)file2NodeRef);
                Assert.assertTrue((String)"does not have versionable aspect", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(file2NodeRef, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertTrue((String)"sample property is null", (ContentDiskDriverTest.this.nodeService.getProperty(file2NodeRef, TransferModel.PROP_ENDPOINT_PROTOCOL) != null ? 1 : 0) != 0);
                return null;
            }
        };
        tran.doInTransaction(validateVersionableCB, false, true);
    }

    public void testScenarioMSWord2003SaveShuffle() throws Exception {
        logger.debug((Object)"testScenarioMSWord2003SaveShuffle");
        String FILE_NAME = "TEST.DOC";
        String FILE_TITLE = "Test document";
        String FILE_DESCRIPTION = "This is a test document to test CIFS shuffle";
        String FILE_OLD_TEMP = "~WRL0002.TMP";
        String FILE_NEW_TEMP = "~WRD0002.TMP";
        final QName RESIDUAL_MTTEXT = QName.createQName((String)"{gsxhjsx}", (String)"whatever");
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NetworkFile oldFileHandle;
            NodeRef testNodeRef;
            Serializable testCreatedDate;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String TEST_DIR = "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle";
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC");
                return null;
            }
        };
        try {
            tran.doInTransaction(deleteGarbageFileCB);
        }
        catch (Exception e) {
            // empty catch block
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_ADDRESSEE, (Serializable)((Object)"Fred"));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"Test document"));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"This is a test document to test CIFS shuffle"));
                MLText mltext = new MLText();
                mltext.addValue(Locale.FRENCH, "Bonjour");
                mltext.addValue(Locale.ENGLISH, "Hello");
                mltext.addValue(Locale.ITALY, "Buongiorno");
                ContentDiskDriverTest.this.mlAwareNodeService.setProperty(testContext.testNodeRef, RESIDUAL_MTTEXT, (Serializable)mltext);
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_CLASSIFIABLE, null);
                return null;
            }
        };
        tran.doInTransaction(createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                String testContent = "MS Word 2003 shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                testContext.testCreatedDate = ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_CREATED);
                MLText multi = (MLText)ContentDiskDriverTest.this.mlAwareNodeService.getProperty(testContext.testNodeRef, RESIDUAL_MTTEXT);
                multi.getValues();
                return null;
            }
        };
        tran.doInTransaction(writeFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\~WRD0002.TMP", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "MS Word 2003 shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction(saveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\~WRL0002.TMP");
                return null;
            }
        };
        tran.doInTransaction(renameOldFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateOldFileGoneCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                try {
                    ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
        tran.doInTransaction(validateOldFileGoneCB, false, true);
        logger.debug((Object)"Shuffle step next");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\~WRD0002.TMP", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC");
                return null;
            }
        };
        tran.doInTransaction(moveNewFileCB, false, true);
        logger.debug((Object)"end of shuffle step");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\TEST.DOC");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                Assert.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                Assert.assertTrue((boolean)props.containsKey(RESIDUAL_MTTEXT));
                Assert.assertEquals((String)"name wrong", (Object)"TEST.DOC", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                Assert.assertEquals((String)"title wrong", (Object)"Test document", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_TITLE));
                Assert.assertEquals((String)"description wrong", (Object)"This is a test document to test CIFS shuffle", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_DESCRIPTION));
                Map mlProps = ContentDiskDriverTest.this.mlAwareNodeService.getProperties(shuffledNodeRef);
                MLText multi = (MLText)ContentDiskDriverTest.this.mlAwareNodeService.getProperty(shuffledNodeRef, RESIDUAL_MTTEXT);
                Assert.assertTrue((String)"MLText has lost values", (multi.getValues().size() > 2 ? 1 : 0) != 0);
                Assert.assertEquals((String)"creation date not preserved", (long)((Date)testContext.testCreatedDate).getTime(), (long)((Date)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_CREATED)).getTime());
                Assert.assertEquals((String)"ADDRESSEE PROPERTY Not copied", (Object)"Fred", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_ADDRESSEE));
                Assert.assertTrue((String)"CLASSIFIABLE aspect not present", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_CLASSIFIABLE));
                Assert.assertEquals((String)"noderef changed", (Object)testContext.testNodeRef, (Object)shuffledNodeRef);
                return null;
            }
        };
        tran.doInTransaction(validateCB, true, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffle\\~WRL0002.TMP");
                return null;
            }
        };
        tran.doInTransaction(deleteOldFileCB, false, true);
    }

    public void testScenarioMSWord2003SaveShuffleWithBackup() throws Exception {
        logger.debug((Object)"testScenarioMSWord2003SaveShuffleWithBackup");
        String FILE_NAME = "TEST.DOC";
        String FILE_OLD_TEMP = "Backup of TEST.DOC";
        String FILE_NEW_TEMP = "~WRD0002.TMP";
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String TEST_ROOT_DIR = "\\ContentDiskDriverTest";
        String TEST_DIR = "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup";
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, ContentModel.PROP_ADDRESSEE, (Serializable)((Object)"Fred"));
                ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_CREATED);
                ContentDiskDriverTest.this.nodeService.addAspect(testContext.testNodeRef, ContentModel.ASPECT_CLASSIFIABLE, null);
                return null;
            }
        };
        tran.doInTransaction(createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                String testContent = "MS Word 2003 shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction(writeFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\~WRD0002.TMP", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "MS Word 2003 shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction(saveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\Backup of TEST.DOC");
                return null;
            }
        };
        tran.doInTransaction(renameOldFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateOldFileGoneCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                try {
                    ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
        tran.doInTransaction(validateOldFileGoneCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\~WRD0002.TMP", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC");
                return null;
            }
        };
        tran.doInTransaction(moveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveShuffleWithBackup\\TEST.DOC");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                Assert.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                Assert.assertEquals((String)"name wrong", (Object)"TEST.DOC", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                return null;
            }
        };
        tran.doInTransaction(validateCB, false, true);
    }

    public void testScenarioMSWord2007Save() throws Exception {
        logger.debug((Object)"testScenarioMSWord2007SaveShuffle");
        String FILE_NAME = "TEST.DOCX";
        String FILE_OLD_TEMP = "788A1D3D.tmp";
        String FILE_NEW_TEMP = "19ECA1A.tmp";
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String TEST_ROOT_DIR = "\\ContentDiskDriverTest";
        String TEST_DIR = "\\ContentDiskDriverTest\\testScenarioMSWord2007Save";
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2007Save", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\TEST.DOCX", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\TEST.DOCX");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                return null;
            }
        };
        tran.doInTransaction(createFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                String testContent = "MS Word 2007 shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction(writeFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\19ECA1A.tmp", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "MS Word 2007 shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction(saveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\TEST.DOCX", "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\788A1D3D.tmp");
                return null;
            }
        };
        tran.doInTransaction(renameOldFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\19ECA1A.tmp", "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\TEST.DOCX");
                return null;
            }
        };
        tran.doInTransaction(moveNewFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\788A1D3D.tmp");
                return null;
            }
        };
        tran.doInTransaction(deleteOldFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2007Save\\TEST.DOCX");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                Assert.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                Assert.assertEquals((String)"name wrong", (Object)"TEST.DOCX", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                return null;
            }
        };
        tran.doInTransaction(validateCB, false, true);
    }

    public void DISABLED_testScenarioEmacsSave() throws Exception {
        logger.debug((Object)"testScenarioEmacsSave");
        String FILE_NAME = "emacsTest.txt";
        String FILE_OLD_TEMP = "emacsTest.txt~";
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String TEST_ROOT_DIR = "\\ContentDiskDriverTest";
        String TEST_DIR = "\\ContentDiskDriverTest\\testScenarioEmacsSave";
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioEmacsSave", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                return null;
            }
        };
        tran.doInTransaction(createFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                String testContent = "Emacs shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction(writeFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt", "\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt~");
                return null;
            }
        };
        tran.doInTransaction(renameOldFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "EMACS shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction(saveNewFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioEmacsSave\\emacsTest.txt");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                Assert.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                return null;
            }
        };
        tran.doInTransaction(validateCB);
    }

    public void testScenarioViSave() throws Exception {
        logger.debug((Object)"testScenarioViSave");
        String FILE_NAME = "viTest.txt";
        String FILE_OLD_TEMP = "viTest.txt~";
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String TEST_ROOT_DIR = "\\ContentDiskDriverTest";
        String TEST_DIR = "\\ContentDiskDriverTest\\testScenarioViSave";
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioViSave", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                return null;
            }
        };
        tran.doInTransaction(createFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                String testContent = "Emacs shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction(writeFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt", "\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt~");
                return null;
            }
        };
        tran.doInTransaction(renameOldFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "Vi shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.newFileHandle);
                logger.debug((Object)"delete temporary file - which will trigger shuffle");
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt~");
                return null;
            }
        };
        tran.doInTransaction(saveNewFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioViSave\\viTest.txt");
                Assert.assertNotNull((String)"shuffledNodeRef is null", (Object)shuffledNodeRef);
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                Assert.assertEquals((String)"name wrong", (Object)"viTest.txt", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                Assert.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                return null;
            }
        };
        tran.doInTransaction(validateCB);
    }

    public void DISABLED_testScenarioSmultronSave() throws Exception {
        logger.debug((Object)"testScenarioSmultronSave");
        String FILE_NAME = "smultronTest.txt";
        String FILE_NEW_TEMP = ".dat04cd.004";
        class TestContext {
            NetworkFile firstFileHandle;
            NetworkFile newFileHandle;
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String TEST_ROOT_DIR = "\\ContentDiskDriverTest";
        String TEST_DIR = "\\ContentDiskDriverTest\\testScenarioSmultronSave";
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioSmultronSave", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioSmultronSave\\smultronTest.txt", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioSmultronSave\\smultronTest.txt");
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                return null;
            }
        };
        tran.doInTransaction(createFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                String testContent = "Smultron shuffle test";
                byte[] testContentBytes = testContent.getBytes();
                testContext.firstFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.firstFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction(writeFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> saveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioSmultronSave\\.dat04cd.004", 0, 2, 128, 0);
                testContext.newFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.newFileHandle);
                String testContent = "Smultron shuffle test This is new content";
                byte[] testContentBytes = testContent.getBytes();
                testContext.newFileHandle.writeFile(testContentBytes, testContentBytes.length, 0, 0L);
                testContext.newFileHandle.close();
                return null;
            }
        };
        tran.doInTransaction(saveNewFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioSmultronSave\\smultronTest.txt");
                return null;
            }
        };
        tran.doInTransaction(deleteOldFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioSmultronSave\\.dat04cd.004", "\\ContentDiskDriverTest\\testScenarioSmultronSave\\smultronTest.txt");
                return null;
            }
        };
        tran.doInTransaction(moveNewFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioSmultronSave\\smultronTest.txt");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                Assert.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                Assert.assertEquals((String)"name wrong", (Object)"smultronTest.txt", (Object)ContentDiskDriverTest.this.nodeService.getProperty(shuffledNodeRef, ContentModel.PROP_NAME));
                return null;
            }
        };
        tran.doInTransaction(validateCB);
    }

    public void testScenarioDeleteViaNodeService() throws Exception {
        logger.debug((Object)"testScenarioDeleteViaNodeService");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        int openAction = 16;
        String FILE_NAME = "testDeleteFileViaNodeService.new";
        String FILE_PATH = "\\testDeleteFileViaNodeService.new";
        FileOpenParams params = new FileOpenParams("\\testDeleteFileViaNodeService.new", openAction, 2, 128, 0);
        final NetworkFile file = this.driver.createFile(testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                file.writeFile(stuff, stuff.length, 0, 0L);
                file.close();
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                NodeRef newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testDeleteFileViaNodeService.new");
                Assert.assertNotNull((String)"can't find new node", (Object)newNode);
                return null;
            }
        };
        tran.doInTransaction(writeFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteNodeCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                NodeRef newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testDeleteFileViaNodeService.new");
                Assert.assertNotNull((String)"can't find new node", (Object)newNode);
                ContentDiskDriverTest.this.nodeService.deleteNode(newNode);
                return null;
            }
        };
        tran.doInTransaction(deleteNodeCB, false, true);
        try {
            this.getNodeForPath(testConnection, "\\testDeleteFileViaNodeService.new");
            ContentDiskDriverTest.fail((String)"getNode for path unexpectedly succeeded");
        }
        catch (IOException ie) {
            // empty catch block
        }
        try {
            this.driver.deleteFile(testSession, testConnection, "\\testDeleteFileViaNodeService.new");
            ContentDiskDriverTest.fail((String)"delete unexpectedly succeeded");
        }
        catch (IOException ie) {
            // empty catch block
        }
    }

    public void testMetadataExtraction() throws Exception {
        logger.debug((Object)"testMetadataExtraction");
        String FILE_NAME = "ContentDiskDriver.docx";
        String FILE_OLD_TEMP = "~WRL0003.TMP";
        String FILE_NEW_TEMP = "~WRD0003.TMP";
        class TestContext {
            NodeRef testDirNodeRef;
            NodeRef testNodeRef;
            NetworkFile firstFileHandle;
            NetworkFile secondFileHandle;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String TEST_DIR = "\\ContentDiskDriverTest\\testMetadataExtraction";
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteDirectory(testSession, testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction");
                return null;
            }
        };
        try {
            tran.doInTransaction(deleteGarbageDirCB);
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.debug((Object)"create Test directory\\ContentDiskDriverTest\\testMetadataExtraction");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testMetadataExtraction", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                testContext.testDirNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction");
                Assert.assertNotNull((String)"testDirNodeRef is null", (Object)testContext.testDirNodeRef);
                UserTransaction txn = ContentDiskDriverTest.this.transactionService.getUserTransaction();
                return null;
            }
        };
        tran.doInTransaction(createTestDirCB);
        logger.debug((Object)"Create rule on test dir");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createRuleCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Rule rule = new Rule();
                rule.setRuleType("inbound");
                rule.applyToChildren(true);
                rule.setRuleDisabled(false);
                rule.setTitle("Extract Metadata from content");
                rule.setDescription("ContentDiskDriverTest");
                HashMap<String, Serializable> props = new HashMap<String, Serializable>(1);
                Action extractAction = ContentDiskDriverTest.this.actionService.createAction("extract-metadata", props);
                ActionCondition noCondition1 = ContentDiskDriverTest.this.actionService.createActionCondition("no-condition");
                extractAction.addActionCondition(noCondition1);
                ActionCondition noCondition2 = ContentDiskDriverTest.this.actionService.createActionCondition("no-condition");
                CompositeAction compAction = ContentDiskDriverTest.this.actionService.createCompositeAction();
                compAction.setTitle("Extract Metadata");
                compAction.setDescription("Content Disk Driver Test - Extract Metadata");
                compAction.addAction(extractAction);
                compAction.addActionCondition(noCondition2);
                rule.setAction(compAction);
                ContentDiskDriverTest.this.ruleService.saveRule(testContext.testDirNodeRef, rule);
                logger.debug((Object)"rule created");
                return null;
            }
        };
        tran.doInTransaction(createRuleCB, false, true);
        logger.debug((Object)"create test file in test directory");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx");
                Assert.assertNotNull((String)"testContext.testNodeRef is null", (Object)testContext.testNodeRef);
                ContentDiskDriverTest.this.nodeService.setProperty(testContext.testNodeRef, TransferModel.PROP_ENABLED, (Serializable)Boolean.valueOf(true));
                return null;
            }
        };
        tran.doInTransaction(createFileCB, false, true);
        logger.debug((Object)"step b: write content to test file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest1.docx");
                Assert.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest1.docx", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.firstFileHandle);
                logger.debug((Object)"close the file, firstFileHandle");
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction(writeFileCB, false, true);
        logger.debug((Object)"Step c: validate metadata has been extracted.");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateFirstExtractionCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(testContext.testNodeRef);
                Assert.assertTrue((String)"Enabled property has been lost", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                Assert.assertEquals((String)"size is wrong", (long)11302L, (long)data.getSize());
                Assert.assertEquals((String)"mimeType is wrong", (String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (String)data.getMimetype());
                Assert.assertEquals((String)"description is not correct", (Object)"This is a test file", (Object)ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_DESCRIPTION));
                Assert.assertEquals((String)"title is not correct", (Object)"ContentDiskDriverTest", (Object)ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_TITLE));
                Assert.assertEquals((String)"author is not correct", (Object)"mrogers", (Object)ContentDiskDriverTest.this.nodeService.getProperty(testContext.testNodeRef, ContentModel.PROP_AUTHOR));
                return null;
            }
        };
        tran.doInTransaction(validateFirstExtractionCB, false, true);
        logger.debug((Object)"Step d: create update file in test directory ~WRD0003.TMP");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createUpdateFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testMetadataExtraction\\~WRD0003.TMP", 0, 2, 128, 0);
                testContext.secondFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.secondFileHandle);
                return null;
            }
        };
        tran.doInTransaction(createUpdateFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFile2CB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute() throws Throwable {
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest2.docx");
                Assert.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest2.docx", (Object)fileResource);
                byte[] buffer = new byte[1000];
                InputStream is = fileResource.getInputStream();
                try {
                    long offset = 0L;
                    int i = is.read(buffer, 0, buffer.length);
                    while (i > 0) {
                        testContext.secondFileHandle.writeFile(buffer, i, 0, offset);
                        offset += (long)i;
                        i = is.read(buffer, 0, buffer.length);
                    }
                }
                finally {
                    is.close();
                }
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.secondFileHandle);
                return null;
            }
        };
        tran.doInTransaction(writeFile2CB, false, true);
        logger.debug((Object)"move old file out of the way.");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx", "\\ContentDiskDriverTest\\testMetadataExtraction\\~WRL0003.TMP");
                return null;
            }
        };
        tran.doInTransaction(renameOldFileCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateOldFileGoneCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                try {
                    ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        };
        tran.doInTransaction(validateOldFileGoneCB, false, true);
        logger.debug((Object)"move new file into place.");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction\\~WRD0003.TMP", "\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx");
                return null;
            }
        };
        tran.doInTransaction(moveNewFileCB, false, true);
        logger.debug((Object)"validate update has run correctly.");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateUpdateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testMetadataExtraction\\ContentDiskDriver.docx");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                Assert.assertTrue((String)"node does not contain shuffled ENABLED property", (boolean)props.containsKey(TransferModel.PROP_ENABLED));
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                Assert.assertEquals((String)"mimeType is wrong", (String)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (String)data.getMimetype());
                Assert.assertEquals((String)"size is wrong", (long)11265L, (long)data.getSize());
                return null;
            }
        };
        tran.doInTransaction(validateUpdateCB, true, true);
    }

    public void testDirListing() throws Exception {
        logger.debug((Object)"testDirListing");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        final String FOLDER_NAME = "parentFolder" + System.currentTimeMillis();
        final String HIDDEN_FOLDER_NAME = "hiddenFolder" + System.currentTimeMillis();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createNodesCB = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                NodeRef parentNode = ContentDiskDriverTest.this.nodeService.createNode(companyHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)FOLDER_NAME), ContentModel.TYPE_FOLDER).getChildRef();
                ContentDiskDriverTest.this.nodeService.setProperty(parentNode, ContentModel.PROP_NAME, (Serializable)((Object)FOLDER_NAME));
                NodeRef hiddenNode = ContentDiskDriverTest.this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)HIDDEN_FOLDER_NAME), ForumModel.TYPE_FORUM).getChildRef();
                ContentDiskDriverTest.this.nodeService.setProperty(hiddenNode, ContentModel.PROP_NAME, (Serializable)((Object)HIDDEN_FOLDER_NAME));
                return parentNode;
            }
        };
        final NodeRef parentFolder = tran.doInTransaction(createNodesCB);
        ArrayList<String> excludedTypes = new ArrayList<String>();
        excludedTypes.add(ForumModel.TYPE_FORUM.toString());
        this.cifsHelper.setExcludedTypes(excludedTypes);
        SearchContext result = this.driver.startSearch(testSession, testConnection, "\\" + FOLDER_NAME + "\\*", 0);
        while (result.hasMoreFiles()) {
            if (!result.nextFileName().equals(HIDDEN_FOLDER_NAME)) continue;
            ContentDiskDriverTest.fail((String)"Exluded types mustn't be shown in cifs");
        }
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteNodeCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.nodeService.deleteNode(parentFolder);
                return null;
            }
        };
        tran.doInTransaction(deleteNodeCB, false, true);
    }

    public void testFileInformationUpdatingByEditorUserForAlf8808() throws Exception {
        final Holder editorFolder = new Holder();
        final Holder testFile = new Holder();
        ServerConfiguration config = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer server = new TestServer(TEST_SERVER_NAME, config);
        DiskSharedDevice device = this.getDiskSharedDevice();
        final TreeConnection treeConnection = server.getTreeConnection((SharedDevice)device);
        final ExtendedDiskInterface deviceInterface = (ExtendedDiskInterface)treeConnection.getInterface();
        final TestSrvSession session = new TestSrvSession(13, (NetworkServer)server, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute() throws Throwable {
                try {
                    NodeRef rootNode = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                    ContentDiskDriverTest.this.createUser(ContentDiskDriverTest.TEST_USER_AUTHORITY, ContentDiskDriverTest.TEST_USER_AUTHORITY, rootNode);
                    editorFolder.value = ContentDiskDriverTest.this.getOrCreateNode(rootNode, "Editor", ContentModel.TYPE_FOLDER).getFirst();
                    testFile.value = ContentDiskDriverTest.this.getOrCreateNode(rootNode, "Test.txt", ContentModel.TYPE_CONTENT).getFirst();
                    ContentDiskDriverTest.this.permissionService.setPermission(((FileInfo)testFile.value).getNodeRef(), ContentDiskDriverTest.TEST_USER_AUTHORITY, "Editor", true);
                    try {
                        final org.alfresco.jlan.server.filesys.FileInfo updatedInfo = new org.alfresco.jlan.server.filesys.FileInfo();
                        updatedInfo.setFileName(((FileInfo)testFile.value).getName());
                        updatedInfo.setFileId(DefaultTypeConverter.INSTANCE.intValue((Object)((FileInfo)testFile.value).getProperties().get(ContentModel.PROP_NODE_DBID)));
                        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                            public Void doWork() throws Exception {
                                deviceInterface.setFileInformation(session, treeConnection, ((FileInfo)testFile.value).getName(), updatedInfo);
                                return null;
                            }
                        }, (String)ContentDiskDriverTest.TEST_USER_AUTHORITY);
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof AccessDeniedException) {
                            Assert.fail((String)("For user='userx' " + e.getCause().toString()));
                        }
                        Assert.fail((String)("Unexpected exception was caught: " + e.toString()));
                    }
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (ContentDiskDriverTest.this.authenticationService.authenticationExists(ContentDiskDriverTest.TEST_USER_AUTHORITY)) {
                        ContentDiskDriverTest.this.authenticationService.deleteAuthentication(ContentDiskDriverTest.TEST_USER_AUTHORITY);
                    }
                    if (ContentDiskDriverTest.this.personService.personExists(ContentDiskDriverTest.TEST_USER_AUTHORITY)) {
                        ContentDiskDriverTest.this.personService.deletePerson(ContentDiskDriverTest.TEST_USER_AUTHORITY);
                    }
                    try {
                        if (null != testFile.value) {
                            ContentDiskDriverTest.this.nodeService.deleteNode(((FileInfo)testFile.value).getNodeRef());
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        if (null != editorFolder.value) {
                            ContentDiskDriverTest.this.nodeService.deleteNode(((FileInfo)editorFolder.value).getNodeRef());
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                if (ContentDiskDriverTest.this.authenticationService.authenticationExists(ContentDiskDriverTest.TEST_USER_AUTHORITY)) {
                    ContentDiskDriverTest.this.authenticationService.deleteAuthentication(ContentDiskDriverTest.TEST_USER_AUTHORITY);
                }
                if (ContentDiskDriverTest.this.personService.personExists(ContentDiskDriverTest.TEST_USER_AUTHORITY)) {
                    ContentDiskDriverTest.this.personService.deletePerson(ContentDiskDriverTest.TEST_USER_AUTHORITY);
                }
                try {
                    if (null != testFile.value) {
                        ContentDiskDriverTest.this.nodeService.deleteNode(((FileInfo)testFile.value).getNodeRef());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (null != editorFolder.value) {
                        ContentDiskDriverTest.this.nodeService.deleteNode(((FileInfo)editorFolder.value).getNodeRef());
                    }
                }
                catch (Exception e) {}
                return null;
            }
        }, false, true);
    }

    private Pair<FileInfo, Boolean> getOrCreateNode(NodeRef parentRef, String name, QName type) {
        NodeRef result = this.nodeService.getChildByName(parentRef, ContentModel.ASSOC_CONTAINS, name);
        Boolean created = false;
        if (null == result) {
            result = this.nodeService.getChildByName(parentRef, ContentModel.ASSOC_CHILDREN, name);
        }
        if ((created = Boolean.valueOf(null == result)).booleanValue()) {
            result = this.fileFolderService.create(parentRef, name, type).getNodeRef();
        }
        return new Pair((Object)this.fileFolderService.getFileInfo(result), (Object)created);
    }

    private void createUser(String name, String password, NodeRef parentNodeRef) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)name));
        Pair<FileInfo, Boolean> userHome = this.getOrCreateNode(parentNodeRef, name, ContentModel.TYPE_FOLDER);
        if (((Boolean)userHome.getSecond()).booleanValue()) {
            NodeRef nodeRef = ((FileInfo)userHome.getFirst()).getNodeRef();
            this.permissionService.setPermission(nodeRef, name, this.permissionService.getAllPermission(), true);
            this.permissionService.setPermission(nodeRef, this.permissionService.getAllAuthorities(), "Consumer", true);
            this.permissionService.setPermission(nodeRef, this.permissionService.getOwnerAuthority(), this.permissionService.getAllPermission(), true);
            this.ownableService.setOwner(nodeRef, name);
            this.permissionService.setInheritParentPermissions(nodeRef, false);
            properties.put(ContentModel.PROP_HOMEFOLDER, (Serializable)nodeRef);
            if (!this.personService.personExists(name)) {
                this.personService.createPerson(properties);
            }
            if (!this.authenticationService.authenticationExists(name)) {
                this.authenticationService.createAuthentication(name, password.toCharArray());
            }
        }
    }

    public void testScenarioMSWord2003SaveAsShuffle() throws Exception {
        logger.debug((Object)"testScenarioMSWord2003SaveShuffle");
        String FILE_NAME = "SAVEAS.DOC";
        String FILE_OLD_TEMP = "SAVEAS.wbk";
        String FILE_NEW_TEMP = "~WRD0002.TMP";
        class TestContext {
            NetworkFile firstFileHandle;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String TEST_DIR = "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle";
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.DOC");
                return null;
            }
        };
        try {
            tran.doInTransaction(deleteGarbageFileCB);
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.debug((Object)"a) create new file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.DOC", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction(createFileCB, false, true);
        logger.debug((Object)"b) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\~WRD0002.TMP", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest3.doc");
                Assert.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest3.doc", (Object)fileResource);
                byte[] buffer = new byte[1000];
                InputStream is = fileResource.getInputStream();
                try {
                    long offset = 0L;
                    int i = is.read(buffer, 0, buffer.length);
                    while (i > 0) {
                        testContext.firstFileHandle.writeFile(buffer, i, 0, offset);
                        offset += (long)i;
                        i = is.read(buffer, 0, buffer.length);
                    }
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction(writeFileCB, false, true);
        logger.debug((Object)"c) rename old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.DOC", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.wbk");
                return null;
            }
        };
        tran.doInTransaction(renameOldFileCB, false, true);
        logger.debug((Object)"d) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\~WRD0002.TMP", "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.DOC");
                return null;
            }
        };
        tran.doInTransaction(moveNewFileCB, false, true);
        logger.debug((Object)"e) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003SaveAsShuffle\\SAVEAS.DOC");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"data is null", (Object)data);
                Assert.assertEquals((String)"size is wrong", (long)26112L, (long)data.getSize());
                Assert.assertEquals((String)"mimeType is wrong", (String)"application/msword", (String)data.getMimetype());
                return null;
            }
        };
        tran.doInTransaction(validateCB, true, true);
    }

    public void testScenarioOpenCloseFile() throws Exception {
        logger.debug((Object)"start of testScenarioOpenCloseFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        class TestContext {
            NodeRef testDirNodeRef;
            NodeRef targetNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String FILE_NAME = "testScenarioOpenFile.txt";
        String FILE_PATH = "\\ContentDiskDriverTest\\testScenarioOpenFile.txt";
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory(testSession, testConnection, dirParams);
        testContext.testDirNodeRef = this.getNodeForPath(testConnection, "\\ContentDiskDriverTest");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioOpenFile.txt");
                return null;
            }
        };
        try {
            tran.doInTransaction(deleteGarbageFileCB);
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.debug((Object)"Step 1) Create File and Open file created by node service");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                logger.debug((Object)"create file and close it immediatly");
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioOpenFile.txt", 0, 2, 128, 0);
                NetworkFile dummy = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, dummy);
                logger.debug((Object)"after create and close");
                return null;
            }
        };
        tran.doInTransaction(createFileCB, false, true);
        testContext.targetNodeRef = this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioOpenFile.txt");
        FileOpenParams openRO = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioOpenFile.txt", 16, 0, 128, 0);
        FileOpenParams openRW = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioOpenFile.txt", 16, 2, 128, 0);
        logger.debug((Object)"open file1 read only");
        NetworkFile file1 = this.driver.openFile(testSession, testConnection, openRO);
        ContentDiskDriverTest.assertNotNull((Object)file1);
        String testString = "Yankee doodle went to town";
        byte[] stuff = "Yankee doodle went to town".getBytes("UTF-8");
        try {
            this.driver.writeFile(testSession, testConnection, file1, stuff, 0, stuff.length, 0L);
            ContentDiskDriverTest.fail((String)"can write to a read only file!");
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.debug((Object)"open file 2 for read write");
        NetworkFile file2 = this.driver.openFile(testSession, testConnection, openRW);
        ContentDiskDriverTest.assertNotNull((Object)file2);
        this.driver.writeFile(testSession, testConnection, file2, stuff, 0, stuff.length, 0L);
        NetworkFile file3 = this.driver.openFile(testSession, testConnection, openRW);
        ContentDiskDriverTest.assertNotNull((Object)file3);
        logger.debug((Object)"first close");
        this.driver.closeFile(testSession, testConnection, file2);
        logger.debug((Object)"second close");
        this.driver.closeFile(testSession, testConnection, file3);
        logger.debug((Object)"now validate");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(testContext.targetNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"data is null", (Object)data);
                Assert.assertEquals((String)"data wrong length", (long)"Yankee doodle went to town".length(), (long)data.getSize());
                ContentReader reader = ContentDiskDriverTest.this.contentService.getReader(testContext.targetNodeRef, ContentModel.PROP_CONTENT);
                String s = reader.getContentString();
                Assert.assertEquals((String)"content not written", (String)"Yankee doodle went to town", (String)s);
                return null;
            }
        };
        tran.doInTransaction(validateCB, false, true);
    }

    public void testOpenCloseVersionableFile() throws Exception {
        logger.debug((Object)"testOpenCloseVersionableFile");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        String FILE_PATH1 = "\\ContentDiskDriverTest\\OpenCloseFile.new";
        class TestContext {
            TestContext() {
            }
        }
        TestContext testContext = new TestContext();
        FileOpenParams dirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 0, 16, 0);
        this.driver.createDirectory(testSession, testConnection, dirParams);
        FileOpenParams params1 = new FileOpenParams("\\ContentDiskDriverTest\\OpenCloseFile.new", 0, 2, 128, 0);
        NetworkFile file1 = this.driver.createFile(testSession, testConnection, params1);
        this.driver.closeFile(testSession, testConnection, file1);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> makeVersionableCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\OpenCloseFile.new");
                ContentDiskDriverTest.this.nodeService.addAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                ContentWriter contentWriter2 = ContentDiskDriverTest.this.contentService.getWriter(file1NodeRef, ContentModel.PROP_CONTENT, true);
                contentWriter2.putContent("test open close versionable node");
                return null;
            }
        };
        tran.doInTransaction(makeVersionableCB, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<String> readVersionCB = new RetryingTransactionHelper.RetryingTransactionCallback<String>(){

            @Override
            public String execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\OpenCloseFile.new");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                Assert.assertTrue((String)"versionable aspect not present", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(shuffledNodeRef, ContentModel.ASPECT_VERSIONABLE));
                props.get(ContentModel.PROP_VERSION_LABEL);
                return (String)props.get(ContentModel.PROP_VERSION_LABEL);
            }
        };
        String version = tran.doInTransaction(readVersionCB, false, true);
        NetworkFile file = this.driver.openFile(testSession, testConnection, params1);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        this.driver.closeFile(testSession, testConnection, file);
        String version2 = tran.doInTransaction(readVersionCB, false, true);
        ContentDiskDriverTest.assertEquals((String)"version has incremented", (String)version, (String)version2);
        file = this.driver.openFile(testSession, testConnection, params1);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        byte[] stuff = "Hello World".getBytes();
        this.driver.writeFile(testSession, testConnection, file, stuff, 0, stuff.length, 0L);
        this.driver.closeFile(testSession, testConnection, file);
        String version3 = tran.doInTransaction(readVersionCB, false, true);
        ContentDiskDriverTest.assertFalse((String)"version not incremented", (boolean)version.equals(version3));
    }

    public void testScenarioFrameMakerShuffle() throws Exception {
        logger.debug((Object)"testScenarioFramemakerShuffle");
        String LOCK_FILE = "X.fm.lck";
        String FILE_NAME = "X.fm";
        String FILE_OLD_TEMP = "X.backup.fm";
        String FILE_NEW_TEMP = "X.fm.C29";
        class TestContext {
            NetworkFile firstFileHandle;
            String mimetype;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String TEST_DIR = "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle";
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                return null;
            }
        };
        try {
            tran.doInTransaction(deleteGarbageFileCB);
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.debug((Object)"a) create new file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioFramemakerShuffle", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.firstFileHandle);
                ClassPathResource fileResource = new ClassPathResource("filesys/X1.fm");
                Assert.assertNotNull((String)"unable to find test resource filesys/X1.fm", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                ContentDiskDriverTest.this.nodeService.addAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE, null);
                return null;
            }
        };
        tran.doInTransaction(createFileCB, false, true);
        logger.debug((Object)"b) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm.C29", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/X2.fm");
                Assert.assertNotNull((String)"unable to find test resource filesys/X2.fm", (Object)fileResource);
                ContentDiskDriverTest.this.writeResourceToNetworkFile(fileResource, testContext.firstFileHandle);
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(file1NodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"data is null", (Object)data);
                Assert.assertEquals((String)"size is wrong", (long)166912L, (long)data.getSize());
                testContext.mimetype = data.getMimetype();
                return null;
            }
        };
        tran.doInTransaction(writeFileCB, false, true);
        logger.debug((Object)"c) rename old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm", "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.backup.fm");
                return null;
            }
        };
        tran.doInTransaction(renameOldFileCB, false, true);
        logger.debug((Object)"d) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm.C29", "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                return null;
            }
        };
        tran.doInTransaction(moveNewFileCB, false, true);
        logger.debug((Object)"d) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.backup.fm");
                return null;
            }
        };
        tran.doInTransaction(deleteOldFileCB, false, true);
        logger.debug((Object)"e) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"data is null", (Object)data);
                Assert.assertEquals((String)"size is wrong", (long)123904L, (long)data.getSize());
                NodeRef file1NodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioFramemakerShuffle\\X.fm");
                Assert.assertTrue((String)"file has lost versionable aspect", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(file1NodeRef, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertEquals((String)"mimeType is wrong", (String)testContext.mimetype, (String)data.getMimetype());
                return null;
            }
        };
        tran.doInTransaction(validateCB, true, true);
    }

    public void testZeroByteRules() throws Exception {
        logger.debug((Object)"testZeroByteRules");
        String FILE_NAME_ZERO = "Zero.docx";
        String FILE_NAME_NON_ZERO = "NonZero.docx";
        class TestContext {
            NodeRef testDirNodeRef;
            NodeRef testZeroNodeRef;
            NodeRef testNonZeroNodeRef;
            NetworkFile firstFileHandle;
            NetworkFile secondFileHandle;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String TEST_DIR = "\\ContentDiskDriverTest\\testZeroByteRules";
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteDirectory(testSession, testConnection, "\\ContentDiskDriverTest\\testZeroByteRules");
                return null;
            }
        };
        try {
            tran.doInTransaction(deleteGarbageDirCB);
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.debug((Object)"create Test directory\\ContentDiskDriverTest\\testZeroByteRules");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createTestDirCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testZeroByteRules", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                testContext.testDirNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testZeroByteRules");
                Assert.assertNotNull((String)"testDirNodeRef is null", (Object)testContext.testDirNodeRef);
                return null;
            }
        };
        tran.doInTransaction(createTestDirCB);
        logger.debug((Object)"Create rule on test dir");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createRuleCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Rule rule = new Rule();
                rule.setRuleType("inbound");
                rule.applyToChildren(true);
                rule.setRuleDisabled(false);
                rule.setTitle("Make Versionable");
                rule.setDescription("ContentDiskDriverTest Test Zero Byte files");
                HashMap<String, Serializable> props = new HashMap<String, Serializable>(1);
                props.put("aspect-name", (Serializable)ContentModel.ASPECT_VERSIONABLE);
                Action addVersionable = ContentDiskDriverTest.this.actionService.createAction("add-features", props);
                ActionCondition noCondition1 = ContentDiskDriverTest.this.actionService.createActionCondition("no-condition");
                addVersionable.addActionCondition(noCondition1);
                ActionCondition noCondition2 = ContentDiskDriverTest.this.actionService.createActionCondition("no-condition");
                CompositeAction compAction = ContentDiskDriverTest.this.actionService.createCompositeAction();
                compAction.setTitle("Make Versionablea");
                compAction.setDescription("Add Aspect - Versionable");
                compAction.addAction(addVersionable);
                compAction.addActionCondition(noCondition2);
                rule.setAction(compAction);
                ContentDiskDriverTest.this.ruleService.saveRule(testContext.testDirNodeRef, rule);
                logger.debug((Object)"add aspect versionable rule created");
                return null;
            }
        };
        tran.doInTransaction(createRuleCB, false, true);
        logger.debug((Object)"create test file in test directory");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testZeroByteRules\\Zero.docx", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.firstFileHandle);
                testContext.testZeroNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testZeroByteRules\\Zero.docx");
                Assert.assertNotNull((String)"testContext.testNodeRef is null", (Object)testContext.testZeroNodeRef);
                FileOpenParams createFileParams2 = new FileOpenParams("\\ContentDiskDriverTest\\testZeroByteRules\\NonZero.docx", 0, 2, 128, 0);
                testContext.secondFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams2);
                Assert.assertNotNull((Object)testContext.secondFileHandle);
                testContext.testNonZeroNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testZeroByteRules\\NonZero.docx");
                Assert.assertNotNull((String)"testContext.testNodeRef is null", (Object)testContext.testNonZeroNodeRef);
                return null;
            }
        };
        tran.doInTransaction(createFileCB, false, true);
        logger.debug((Object)"step b: close the file with zero byte content");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                logger.debug((Object)"close the file, firstFileHandle");
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                byte[] stuff = "Hello World".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, testContext.secondFileHandle, stuff, 0, stuff.length, 0L);
                logger.debug((Object)"close the second non zero file, secondFileHandle");
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.secondFileHandle);
                return null;
            }
        };
        tran.doInTransaction(writeFileCB, false, true);
        logger.debug((Object)"Step c: validate versioble aspect has been applied.");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateFirstExtractionCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                Assert.assertTrue((String)"versionable aspect not applied to non zero file.", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(testContext.testNonZeroNodeRef, ContentModel.ASPECT_VERSIONABLE));
                Assert.assertTrue((String)"versionable aspect not applied to zero byte file.", (boolean)ContentDiskDriverTest.this.nodeService.hasAspect(testContext.testZeroNodeRef, ContentModel.ASPECT_VERSIONABLE));
                return null;
            }
        };
        tran.doInTransaction(validateFirstExtractionCB, false, true);
    }

    public void testScenarioMSWord2003SaveAsShuffleCheckedOutFile() throws Exception {
        logger.debug((Object)"testScenarioMSWord2003SaveShuffleLockedFile");
        String FILE_NAME = "TESTFILE.DOC";
        String FILE_OLD_TEMP = "SAVEAS.wbk";
        String FILE_NEW_TEMP = "~WRD0002.TMP";
        class TestContext {
            NetworkFile firstFileHandle;
            String workingFileName;
            NodeRef workingCopy;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        String TEST_DIR = "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile";
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Void> deleteGarbageFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.deleteFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\TESTFILE.DOC");
                return null;
            }
        };
        try {
            tran.doInTransaction(deleteGarbageFileCB);
        }
        catch (Exception e) {
            // empty catch block
        }
        logger.debug((Object)"a) create new file and check out");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                FileOpenParams createRootDirParams = new FileOpenParams("\\ContentDiskDriverTest", 0, 2, 128, 0);
                FileOpenParams createDirParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile", 0, 2, 128, 0);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createRootDirParams);
                ContentDiskDriverTest.this.driver.createDirectory(testSession, testConnection, createDirParams);
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\TESTFILE.DOC", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                Assert.assertNotNull((Object)testContext.firstFileHandle);
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\TESTFILE.DOC");
                NodeRef workingCopy = ContentDiskDriverTest.this.checkOutCheckInService.checkout(shuffledNodeRef);
                Assert.assertNotNull((String)"Working copy is null", (Object)workingCopy);
                testContext.workingCopy = workingCopy;
                ChildAssociationRef ref = ContentDiskDriverTest.this.nodeService.getPrimaryParent(workingCopy);
                QName name = ref.getQName();
                testContext.workingFileName = ref.getQName().getLocalName();
                Assert.assertNotNull((String)"working file name is null", (Object)testContext.workingFileName);
                return null;
            }
        };
        tran.doInTransaction(createFileCB, false, true);
        logger.debug((Object)"b) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void execute() throws Throwable {
                FileOpenParams createFileParams = new FileOpenParams("\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\~WRD0002.TMP", 0, 2, 128, 0);
                testContext.firstFileHandle = ContentDiskDriverTest.this.driver.createFile(testSession, testConnection, createFileParams);
                ClassPathResource fileResource = new ClassPathResource("filesys/ContentDiskDriverTest3.doc");
                Assert.assertNotNull((String)"unable to find test resource filesys/ContentDiskDriverTest3.doc", (Object)fileResource);
                byte[] buffer = new byte[1000];
                InputStream is = fileResource.getInputStream();
                try {
                    long offset = 0L;
                    int i = is.read(buffer, 0, buffer.length);
                    while (i > 0) {
                        testContext.firstFileHandle.writeFile(buffer, i, 0, offset);
                        offset += (long)i;
                        i = is.read(buffer, 0, buffer.length);
                    }
                    Object var9_7 = null;
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, testContext.firstFileHandle);
                return null;
            }
        };
        tran.doInTransaction(writeFileCB, false, true);
        logger.debug((Object)"c) rename old file");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> renameOldFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\" + testContext.workingFileName, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\SAVEAS.wbk");
                return null;
            }
        };
        tran.doInTransaction(renameOldFileCB, false, true);
        logger.debug((Object)"d) move new file into place");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> moveNewFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.renameFile(testSession, testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\~WRD0002.TMP", "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\" + testContext.workingFileName);
                return null;
            }
        };
        tran.doInTransaction(moveNewFileCB, false, true);
        logger.debug((Object)"e) now check in");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> checkInCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.checkOutCheckInService.checkin(testContext.workingCopy, null);
                return null;
            }
        };
        tran.doInTransaction(checkInCB, false, true);
        logger.debug((Object)"e) validate results");
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NodeRef shuffledNodeRef = ContentDiskDriverTest.this.getNodeForPath(testConnection, "\\ContentDiskDriverTest\\testScenarioMSWord2003ShuffleLockedFile\\TESTFILE.DOC");
                Map props = ContentDiskDriverTest.this.nodeService.getProperties(shuffledNodeRef);
                ContentData data = (ContentData)props.get(ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"data is null", (Object)data);
                Assert.assertEquals((String)"size is wrong", (long)26112L, (long)data.getSize());
                Assert.assertEquals((String)"mimeType is wrong", (String)"application/msword", (String)data.getMimetype());
                return null;
            }
        };
        tran.doInTransaction(validateCB, true, true);
    }

    public void testSetFileScenario() throws Exception {
        logger.debug((Object)"testSetFileInfo");
        ServerConfiguration scfg = new ServerConfiguration(TEST_SERVER_NAME);
        TestServer testServer = new TestServer(TEST_SERVER_NAME, scfg);
        final TestSrvSession testSession = new TestSrvSession(666, (NetworkServer)testServer, TEST_PROTOTYPE_NAME, TEST_REMOTE_NAME);
        DiskSharedDevice share = this.getDiskSharedDevice();
        final TreeConnection testConnection = testServer.getTreeConnection((SharedDevice)share);
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        Date now = new Date();
        Date CREATED = new Date(now.getTime() - 21600000L);
        final Date MODIFIED = new Date(now.getTime() - 3600000L);
        class TestContext {
            NodeRef testNodeRef;

            TestContext() {
            }
        }
        final TestContext testContext = new TestContext();
        int openAction = 16;
        String FILE_NAME = "testSetFileScenario.txt";
        String FILE_PATH = "\\testSetFileScenario.txt";
        try {
            this.driver.deleteFile(testSession, testConnection, "\\testSetFileScenario.txt");
        }
        catch (IOException ie) {
            // empty catch block
        }
        FileOpenParams params = new FileOpenParams("\\testSetFileScenario.txt", openAction, 2, 128, 0);
        final NetworkFile file = this.driver.createFile(testSession, testConnection, params);
        ContentDiskDriverTest.assertNotNull((String)"file is null", (Object)file);
        ContentDiskDriverTest.assertFalse((String)"file is read only, should be read-write", (boolean)file.isReadOnly());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> writeStuffCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                byte[] stuff = "Hello World".getBytes();
                ContentDiskDriverTest.this.driver.writeFile(testSession, testConnection, file, stuff, 0, stuff.length, 0L);
                org.alfresco.jlan.server.filesys.FileInfo info = ContentDiskDriverTest.this.driver.getFileInformation(testSession, testConnection, "\\testSetFileScenario.txt");
                info.setFileInformationFlags(8);
                info.setModifyDateTime(MODIFIED.getTime());
                info.setNetworkFile(file);
                ContentDiskDriverTest.this.driver.setFileInformation(testSession, testConnection, "\\testSetFileScenario.txt", info);
                return null;
            }
        };
        tran.doInTransaction(writeStuffCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> closeFileCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                ContentDiskDriverTest.this.driver.closeFile(testSession, testConnection, file);
                return null;
            }
        };
        tran.doInTransaction(closeFileCB);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> validateCB = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){
            {
            }

            @Override
            public Void execute() throws Throwable {
                NodeRef newNode;
                NodeRef companyHome = ContentDiskDriverTest.this.repositoryHelper.getCompanyHome();
                testContext.testNodeRef = newNode = ContentDiskDriverTest.this.nodeService.getChildByName(companyHome, ContentModel.ASSOC_CONTAINS, "testSetFileScenario.txt");
                Assert.assertNotNull((String)"can't find new node", (Object)newNode);
                Serializable content = ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_CONTENT);
                Assert.assertNotNull((String)"content is null", (Object)content);
                Date modified = (Date)ContentDiskDriverTest.this.nodeService.getProperty(newNode, ContentModel.PROP_MODIFIED);
                Assert.assertEquals((String)"modified time not set correctly", (Object)MODIFIED, (Object)modified);
                return null;
            }
        };
        tran.doInTransaction(validateCB);
    }

    private NodeRef getNodeForPath(TreeConnection tree, String path) throws FileNotFoundException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getNodeRefForPath:" + path));
        }
        ContentContext ctx = (ContentContext)tree.getContext();
        return this.cifsHelper.getNodeRef(ctx.getRootNode(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResourceToNetworkFile(ClassPathResource resource, NetworkFile file) throws IOException {
        byte[] buffer = new byte[1000];
        InputStream is = resource.getInputStream();
        try {
            long offset = 0L;
            int i = is.read(buffer, 0, buffer.length);
            while (i > 0) {
                file.writeFile(buffer, i, 0, offset);
                offset += (long)i;
                i = is.read(buffer, 0, buffer.length);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            is.close();
            throw throwable;
        }
        is.close();
    }

    private class TestSrvSession
    extends SrvSession {
        public TestSrvSession(int sessId, NetworkServer srv, String proto, String remName) {
            super(sessId, srv, proto, remName);
            ClientInfo cinfo = ClientInfo.createInfo((String)"fred", null);
            this.setClientInformation(cinfo);
        }

        public InetAddress getRemoteAddress() {
            return null;
        }

        public boolean useCaseSensitiveSearch() {
            return false;
        }
    }

    public class TestServer
    extends NetworkFileServer {
        public TestServer(String proto, ServerConfiguration config) {
            super(proto, config);
        }

        public void startServer() {
        }

        public void shutdownServer(boolean immediate) {
        }

        public TreeConnection getTreeConnection(SharedDevice share) {
            return new TreeConnection(share);
        }
    }
}

