/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.io.IOException;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.filesys.IOControlNotImplementedException;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class FilesystemTransactionAdvice
implements MethodInterceptor {
    private boolean readOnly = false;
    private TransactionService transactionService;

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Object invoke(final MethodInvocation methodInvocation) throws IOException, SMBException, Throwable {
        RetryingTransactionHelper tran = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                try {
                    return methodInvocation.proceed();
                }
                catch (SMBException e) {
                    throw new PropagatingException(e);
                }
                catch (IOControlNotImplementedException e) {
                    throw new PropagatingException(e);
                }
                catch (IOException e) {
                    throw new PropagatingException(e);
                }
                catch (DeviceContextException e) {
                    throw new PropagatingException(e);
                }
            }
        };
        if (this.readOnly) {
            try {
                return tran.doInTransaction(callback, true);
            }
            catch (PropagatingException pe) {
                Throwable t = pe.getCause();
                if (t != null) {
                    if (t instanceof IOException) {
                        throw (IOException)pe.getCause();
                    }
                    if (t instanceof SMBException) {
                        throw pe.getCause();
                    }
                    if (t instanceof DeviceContextException) {
                        throw pe.getCause();
                    }
                    throw t;
                }
                throw pe;
            }
        }
        try {
            return tran.doInTransaction(callback);
        }
        catch (PropagatingException pe) {
            Throwable t = pe.getCause();
            if (t != null) {
                if (t instanceof IOException) {
                    throw pe.getCause();
                }
                if (t instanceof SMBException) {
                    throw pe.getCause();
                }
                if (t instanceof DeviceContextException) {
                    throw pe.getCause();
                }
                throw t;
            }
            throw pe;
        }
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    protected static class PropagatingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PropagatingException(Throwable cause) {
            super(cause);
        }
    }
}

